<a id="section-modal-connectives"></a>9.8. <a id="c9s8"></a>Other modal connections
-----------------------------------------------------------------------------------

<a id="id-1.10.10.2.1" class="indexterm"></a>Like many Lojban grammatical constructions, sentence modal connection has both forethought and afterthought forms. (See [Chapter 14](../chapter-connectives) for a more detailed discussion of Lojban connectives.) [Section 9.7](../section-causals) exemplifies only afterthought modal connection, illustrated here by:

<div class="interlinear-gloss-example example">
<a id="example-random-id-2D4c"></a>

**Example 9.44. <a id="id-1.10.10.3.1.1" class="indexterm"></a><a id="c9e8d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>jgari</td><td>lei</td><td>djacu</td></tr><tr class="gloss"><td>I</td><td>grasp</td><td>the-mass-of</td><td>water</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.iri'abo</td><td>mi</td><td>jgari</td><td>le</td><td>kabri</td></tr><tr class="gloss"><td>with-physical-cause</td><td>I</td><td>grasp</td><td>the</td><td>cup.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Causing the mass of water to be grasped by me, I grasped the cup.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">I grasp the water because I grasp the cup.</p></td></tr></tbody></table>

</div>  

<a id="id-1.10.10.4.1" class="indexterm"></a><a id="id-1.10.10.4.2" class="indexterm"></a>An afterthought connection is one that is signaled only by a cmavo (or a compound cmavo, in this case) between the two constructs being connected. Forethought connection uses a signal both before the first construct and between the two: the use of “both” and “and” in the first half of this sentence represents a forethought connection (though not a modal one).

<a id="id-1.10.10.5.1" class="indexterm"></a><a id="id-1.10.10.5.2" class="indexterm"></a>To make forethought modal sentence connections in Lojban, place the modal plus _<a id="id-1.10.10.5.3.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_ before the first bridi, and _<a id="id-1.10.10.5.4.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_ between the two. No _<a id="id-1.10.10.5.5.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ is used within the construct. The forethought equivalent of [Example 9.44](../section-modal-connectives#example-random-id-2D4c) is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-d2b9"></a>

**Example 9.45. <a id="c9e8d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ri'agi</td><td>mi</td><td>jgari</td><td>le</td><td>kabri</td><td>gi</td></tr><tr class="gloss"><td>With-physical-cause</td><td>I</td><td>grasp</td><td>the</td><td>cup</td><td>,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>jgari</td><td>lei</td><td>djacu</td></tr><tr class="gloss"><td>I</td><td>grasp</td><td>the-mass-of</td><td>water.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Because I grasp the cup, I grasp the water.</p></td></tr></tbody></table>

</div>  

<a id="id-1.10.10.7.1" class="indexterm"></a><a id="id-1.10.10.7.2" class="indexterm"></a><a id="id-1.10.10.7.3" class="indexterm"></a>Note that the cause, the x1 of _<a id="id-1.10.10.7.5.1" class="indexterm"></a>[_rinka_](../go01#valsi-rinka)_ is now placed first. To keep the two bridi in the original order of [Example 9.44](../section-modal-connectives#example-random-id-2D4c) , we could say:

<div class="interlinear-gloss-example example">
<a id="example-random-id-rQ77"></a>

**Example 9.46. <a id="c9e8d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>seri'agi</td><td>mi</td><td>jgari</td><td>lei</td><td>djacu</td><td>gi</td></tr><tr class="gloss"><td>With-physical-effect</td><td>I</td><td>grasp</td><td>the-mass-of</td><td>water</td><td>,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>jgari</td><td>le</td><td>kabri</td></tr><tr class="gloss"><td>I</td><td>grasp</td><td>the</td><td>cup.</td></tr></tbody></table>

</div>  

In English, the sentence “Therefore I grasp the water, I grasp the cup” is ungrammatical, because “therefore” is not grammatically equivalent to “because”. In Lojban, _<a id="id-1.10.10.9.4.1" class="indexterm"></a>seri'agi_ can be used just like _<a id="id-1.10.10.9.5.1" class="indexterm"></a>ri'agi_.

<a id="id-1.10.10.10.1" class="indexterm"></a>When the two bridi joined by a modal connection have one or more elements (selbri or sumti or both) in common, there are various condensed forms that can be used in place of full modal sentence connection with both bridi completely stated.

<a id="id-1.10.10.11.1" class="indexterm"></a><a id="id-1.10.10.11.2" class="indexterm"></a>When the bridi are the same except for a single sumti, as in [Example 9.44](../section-modal-connectives#example-random-id-2D4c) through [Example 9.46](../section-modal-connectives#example-random-id-rQ77) , then a sumti modal connection may be employed:

<div class="interlinear-gloss-example example">
<a id="example-random-id-o7FG"></a>

**Example 9.47. <a id="c9e8d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>jgari</td><td>ri'agi</td><td>le</td><td>kabri</td><td>gi</td><td>lei</td><td>djacu</td></tr><tr class="gloss"><td>I</td><td>grasp</td><td>because</td><td>the</td><td>cup</td><td>,</td><td>the-mass-of</td><td>water.</td></tr></tbody></table>

</div>  

[Example 9.47](../section-modal-connectives#example-random-id-o7FG) means exactly the same as [Example 9.44](../section-modal-connectives#example-random-id-2D4c) through [Example 9.46](../section-modal-connectives#example-random-id-rQ77) , but there is no idiomatic English translation that will distinguish it from them.

<a id="id-1.10.10.14.1" class="indexterm"></a><a id="id-1.10.10.14.2" class="indexterm"></a>If the two connected bridi are different in more than one sumti, then a termset may be employed. Termsets are explained more fully in [Section 14.11](../section-termsets) , but are essentially a mechanism for creating connections between multiple sumti simultaneously.

<div class="interlinear-gloss-example example">
<a id="example-random-id-LetE"></a>

**Example 9.48. <a id="c9e8d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>dunda</td><td>le</td><td>cukta</td><td>la</td><td>.djan.</td></tr><tr class="gloss"><td>I</td><td>gave</td><td>the</td><td>book</td><td>to-that-named</td><td>John.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.imu'ibo</td><td>la</td><td>.djan.</td><td>dunda</td><td>lei</td><td>jdini</td><td>mi</td></tr><tr class="gloss"><td>Motivated-by</td><td>that-named</td><td>John</td><td>gave</td><td>the-mass-of</td><td>money</td><td>to-me.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I gave the book to John, because John gave money to me.</p></td></tr></tbody></table>

</div>  

means the same as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-tFSC"></a>

**Example 9.49. <a id="c9e8d6"></a><a id="id-1.10.10.17.1.2" class="indexterm"></a><a id="id-1.10.10.17.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>nu'i</td><td>mu'igi</td><td>la</td><td>.djan.</td><td>lei</td><td>jdini</td><td>mi</td><td>gi</td></tr><tr class="gloss"><td>[start]</td><td>because</td><td>that-named</td><td>John,</td><td>the-mass-of</td><td>money,</td><td>me</td><td>;</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>le</td><td>cukta</td><td>la</td><td>.djan.</td><td>nu'u</td><td>dunda</td></tr><tr class="gloss"><td>I,</td><td>the</td><td>book,</td><td>that-named</td><td>John</td><td>[end]</td><td>gives.</td></tr></tbody></table>

</div>  

Here there are three sumti in each half of the termset, because the two bridi share only their selbri.

<a id="id-1.10.10.19.1" class="indexterm"></a><a id="id-1.10.10.19.2" class="indexterm"></a><a id="id-1.10.10.19.3" class="indexterm"></a>There is no modal connection between selbri as such: bridi which differ only in the selbri can be modally connected using bridi-tail modal connection. The bridi-tail construct is more fully explained in [Section 14.9](../section-compound-bridi) , but essentially it consists of a selbri with optional sumti following it. [Example 9.37](../section-causals#example-random-id-qMN7) is suitable for bridi-tail connection, and could be shortened to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Do9b"></a>

**Example 9.50. <a id="c9e8d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>mu'igi</td><td>viska</td><td>le</td><td>cukta</td><td>gi</td><td>lebna</td><td>le</td><td>cukta</td></tr><tr class="gloss"><td>I,</td><td>because</td><td>saw</td><td>the</td><td>book,</td><td></td><td>took</td><td>the</td><td>book.</td></tr></tbody></table>

</div>  

Again, no straightforward English translation exists. It is even possible to shorten [Example 9.50](../section-modal-connectives#example-random-id-Do9b) further to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-YXps"></a>

**Example 9.51. <a id="c9e8d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>mu'igi</td><td>viska</td><td>gi</td><td>lebna</td><td>vau</td><td>le</td><td>cukta</td></tr><tr class="gloss"><td>I</td><td>because</td><td>saw,</td><td>therefore</td><td>took,</td><td></td><td>the</td><td>book.</td></tr></tbody></table>

</div>  

where _<a id="id-1.10.10.23.1.1" class="indexterm"></a>le cukta_ is set off by the non-elidable _<a id="id-1.10.10.23.2.1" class="indexterm"></a>[_vau_](../go01#valsi-vau)_ and is made to belong to both bridi-tails – see [Section 14.9](../section-compound-bridi) for more explanations.

<a id="id-1.10.10.24.1" class="indexterm"></a><a id="id-1.10.10.24.2" class="indexterm"></a>Since this is a chapter on rearranging sumti, it is worth pointing out that [Example 9.51](../section-modal-connectives#example-random-id-YXps) can be further rearranged to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Pxca"></a>

**Example 9.52. <a id="c9e8d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>le</td><td>cukta</td><td>mu'igi</td><td>viska</td><td>gi</td><td>lebna</td></tr><tr class="gloss"><td>I,</td><td>the</td><td>book,</td><td>because</td><td>saw,</td><td>therefore</td><td>took.</td></tr></tbody></table>

</div>  

which doesn't require the extra _<a id="id-1.10.10.26.1.1" class="indexterm"></a>[_vau_](../go01#valsi-vau)_ ; all sumti before a conjunction of bridi-tails are shared.

<a id="id-1.10.10.27.1" class="indexterm"></a><a id="id-1.10.10.27.2" class="indexterm"></a>Finally, mathematical operands can be modally connected.

<div class="interlinear-gloss-example example">
<a id="example-random-id-J2T5"></a>

**Example 9.53. <a id="c9e8d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ny.</td><td>du</td><td>li</td><td>vo</td></tr><tr class="gloss"><td>the-number</td><td>n</td><td>=</td><td>the-number</td><td>4.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ini'ibo</td><td>li</td><td>ny.</td><td>du</td><td>li</td><td>re</td><td>su'i</td><td>re</td></tr><tr class="gloss"><td>Entailed-by</td><td>the-number</td><td>n</td><td>=</td><td>the-number</td><td>2</td><td>+</td><td>2.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">n = 4 because n = 2 + 2.</p></td></tr></tbody></table>

</div>  

can be reduced to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Mfe4"></a>

**Example 9.54. <a id="c9e8d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ny.</td><td>du</td><td>li</td></tr><tr class="gloss"><td>the-number</td><td>n</td><td>=</td><td>the-number</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ni'igi</td><td>vei</td><td>re</td><td>su'i</td><td>re</td><td>[ve'o]</td><td>gi</td><td>vo</td></tr><tr class="gloss"><td>because</td><td>(</td><td>2</td><td>+</td><td>2</td><td>)</td><td>therefore</td><td>4.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">n is 2 + 2, and is thus 4.</p></td></tr></tbody></table>

</div>  

The cmavo _<a id="id-1.10.10.31.1.1" class="indexterm"></a>[_vei_](../go01#valsi-vei)_ and _<a id="id-1.10.10.31.2.1" class="indexterm"></a>[_ve'o_](../go01#valsi-veho)_ represent mathematical parentheses, and are required so that _<a id="id-1.10.10.31.3.1" class="indexterm"></a>ni'igi_ affects more than just the immediately following operand, namely the first _<a id="id-1.10.10.31.4.1" class="indexterm"></a>[_re_](../go01#valsi-re)_. (The right parenthesis, _<a id="id-1.10.10.31.5.1" class="indexterm"></a>[_ve'o_](../go01#valsi-veho)_ , is an elidable terminator.) As usual, no English translation does [Example 9.54](../section-modal-connectives#example-random-id-Mfe4) justice.

<a id="id-1.10.10.32.1" class="indexterm"></a><a id="id-1.10.10.32.2" class="indexterm"></a>Note: Due to restrictions on the Lojban parsing algorithm, it is not possible to form modal connectives using the _<a id="id-1.10.10.32.3.1" class="indexterm"></a>fi'o-_ plus-selbri form of modal. Only the predefined modals of selma'o BAI can be compounded as shown in [Section 9.7](../section-causals) and [Section 9.8](../section-modal-connectives).