<a id="section-miscellany"></a>18.21. <a id="c18s21"></a>Miscellany
-------------------------------------------------------------------

A few other points:

<a id="id-1.19.23.3.1" class="indexterm"></a><a id="id-1.19.23.3.2" class="indexterm"></a>_<a id="id-1.19.23.3.3.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ can be used to convert an operator as if it were a selbri, so that its arguments are exchanged. For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-NwYJ"></a>

**Example 18.139. <a id="c18e21d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ci</td><td>se</td><td>vu'u</td><td>vo</td><td>du</td><td>li</td><td>pa</td></tr><tr class="gloss"><td>The-number</td><td>three</td><td>(inverse)</td><td>minus</td><td>four</td><td>equals</td><td>the-number</td><td>one.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">3 subtracted from 4 equals 1.</p></td></tr></tbody></table>

</div>  

The other converters of selma'o SE can also be used on operators with more than two operands, and they can be compounded to create (probably unintelligible) operators as needed.

<a id="id-1.19.23.6.1" class="indexterm"></a><a id="id-1.19.23.6.2" class="indexterm"></a>Members of selma'o NAhE are also legal on an operator to produce a scalar negation of it. The implication is that some other operator would apply to make the bridi true:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qIPR"></a>

**Example 18.140. <a id="c18e21d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ci</td><td>na'e</td><td>su'i</td><td>vo</td><td>du</td><td>li</td><td>pare</td></tr><tr class="gloss"><td>The-number</td><td>3</td><td>non-</td><td>plus</td><td>4</td><td>equals</td><td>the-number</td><td>12.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qiqd"></a>

**Example 18.141. <a id="c18e21d3"></a><a id="id-1.19.23.8.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>ci</td><td>to'e</td><td>vu'u</td><td>re</td><td>du</td><td>li</td><td>mu</td></tr><tr class="gloss"><td>The-number</td><td>3</td><td>opposite-of-</td><td>minus</td><td>2</td><td>equals</td><td>the-number</td><td>5.</td></tr></tbody></table>

</div>  

The sense in which “plus” is the opposite of “minus” is not a mathematical but rather a linguistic one; negated operators are defined only loosely.

<a id="id-1.19.23.10.1" class="indexterm"></a><a id="id-1.19.23.10.2" class="indexterm"></a><a id="id-1.19.23.10.3" class="indexterm"></a>_<a id="id-1.19.23.10.4.1" class="indexterm"></a>[_la'e_](../go01#valsi-lahe)_ and _<a id="id-1.19.23.10.5.1" class="indexterm"></a>[_lu'e_](../go01#valsi-luhe)_ can be used on operands with the usual semantics to get the referent of or a symbol for an operand. Likewise, a member of selma'o NAhE followed by _<a id="id-1.19.23.10.6.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ serves to scalar-negate an operand, implying that some other operand would make the bridi true:

<div class="interlinear-gloss-example example">
<a id="example-random-id-3het"></a>

**Example 18.142. <a id="c18e21d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>re</td><td>su'i</td><td>re</td><td>du</td><td>li</td><td>na'ebo</td><td>mu</td></tr><tr class="gloss"><td>The-number</td><td>2</td><td>plus</td><td>2</td><td>equals</td><td>the-number</td><td>non-</td><td>5.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">2 + 2 = something other than 5.</p></td></tr></tbody></table>

</div>  

<a id="id-1.19.23.12.1" class="indexterm"></a><a id="id-1.19.23.12.2" class="indexterm"></a>The digits 0-9 have rafsi, and therefore can be used in making lujvo. Additionally, all the rafsi have CVC form and can stand alone or together as names:

<div class="interlinear-gloss-example example">
<a id="example-random-id-hvGK"></a>

**Example 18.143. <a id="c18e21d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.zel.</td><td>poi</td><td>gunta</td><td>la</td><td>.tebes.</td><td>pu</td><td>nanmu</td></tr><tr class="gloss"><td>Those-named</td><td><span class="quote">“<span class="quote">Seven</span>”</span></td><td>who</td><td>attack</td><td>that-named</td><td><span class="quote">“<span class="quote">Thebes</span>”</span></td><td>[past]</td><td>are-men.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The Seven Against Thebes were men.</p></td></tr></tbody></table>

</div>  

Of course, there is no guarantee that the name _.zel._ is connected with the number rafsi: an alternative which cannot be misconstrued is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-pf3n"></a>

**Example 18.144. <a id="c18e21d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>zemei</td><td>poi</td><td>gunta</td></tr><tr class="gloss"><td>Those-named-the</td><td>Sevensome</td><td>who</td><td>attack</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.tebes.</td><td>pu</td><td>nanmu</td></tr><tr class="gloss"><td>that-named</td><td>Thebes</td><td>[past]</td><td>are-men.</td></tr></tbody></table>

</div>  

<a id="id-1.19.23.16.1" class="indexterm"></a><a id="id-1.19.23.16.2" class="indexterm"></a>Certain other members of PA also have assigned rafsi: _<a id="id-1.19.23.16.3.1" class="indexterm"></a>[_so'a_](../go01#valsi-soha)_ , _<a id="id-1.19.23.16.4.1" class="indexterm"></a>[_so'e_](../go01#valsi-sohe)_ , _<a id="id-1.19.23.16.5.1" class="indexterm"></a>[_so'i_](../go01#valsi-sohi)_ , _<a id="id-1.19.23.16.6.1" class="indexterm"></a>[_so'o_](../go01#valsi-soho)_ , _<a id="id-1.19.23.16.7.1" class="indexterm"></a>[_so'u_](../go01#valsi-sohu)_ , _<a id="id-1.19.23.16.8.1" class="indexterm"></a>[_da'a_](../go01#valsi-daha)_ , _<a id="id-1.19.23.16.9.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_ , _<a id="id-1.19.23.16.10.1" class="indexterm"></a>[_su'e_](../go01#valsi-suhe)_ , _<a id="id-1.19.23.16.11.1" class="indexterm"></a>[_su'o_](../go01#valsi-suho)_ , _<a id="id-1.19.23.16.12.1" class="indexterm"></a>[_pi_](../go01#valsi-pi)_ , and _<a id="id-1.19.23.16.13.1" class="indexterm"></a>[_ce'i_](../go01#valsi-cehi)_. Furthermore, although the cmavo _<a id="id-1.19.23.16.14.1" class="indexterm"></a>[_fi'u_](../go01#valsi-fihu)_ does not have a rafsi as such, it is closely related to the gismu _<a id="id-1.19.23.16.15.1" class="indexterm"></a>[_frinu_](../go01#valsi-frinu)_ , meaning “fraction” ; therefore, in a context of numeric rafsi, you can use any of the rafsi for _<a id="id-1.19.23.16.17.1" class="indexterm"></a>[_frinu_](../go01#valsi-frinu)_ to indicate a fraction slash.

<a id="id-1.19.23.17.1" class="indexterm"></a>A similar convention is used for the cmavo _<a id="id-1.19.23.17.2.1" class="indexterm"></a>[_cu'o_](../go01#valsi-cuho)_ of selma'o MOI, which is closely related to _<a id="id-1.19.23.17.3.1" class="indexterm"></a>[_cunso_](../go01#valsi-cunso)_ (probability); use a rafsi for _<a id="id-1.19.23.17.4.1" class="indexterm"></a>[_cunso_](../go01#valsi-cunso)_ in order to create lujvo based on _<a id="id-1.19.23.17.5.1" class="indexterm"></a>[_cu'o_](../go01#valsi-cuho)_. The cmavo _<a id="id-1.19.23.17.6.1" class="indexterm"></a>[_mei_](../go01#valsi-mei)_ and _<a id="id-1.19.23.17.7.1" class="indexterm"></a>[_moi_](../go01#valsi-moi)_ of MOI have their own rafsi, two each in fact: _mem_ / _mei_ and _mom_ / _moi_ respectively.

<a id="id-1.19.23.18.1" class="indexterm"></a><a id="id-1.19.23.18.2" class="indexterm"></a><a id="id-1.19.23.18.3" class="indexterm"></a><a id="id-1.19.23.18.4" class="indexterm"></a><a id="id-1.19.23.18.5" class="indexterm"></a>The grammar of mekso as described so far imposes a rigid distinction between operators and operands. Some flavors of mathematics (lambda calculus, algebra of functions) blur this distinction, and Lojban must have a method of doing the same. An operator can be changed into an operand with _<a id="id-1.19.23.18.6.1" class="indexterm"></a>ni'enu'a_ , which transforms the operator into a matching selbri and then the selbri into an operand.

<a id="id-1.19.23.19.1" class="indexterm"></a><a id="id-1.19.23.19.2" class="indexterm"></a><a id="id-1.19.23.19.3" class="indexterm"></a>To change an operand into an operator, we use the cmavo _<a id="id-1.19.23.19.4.1" class="indexterm"></a>[_ma'o_](../go01#valsi-maho)_ , already introduced as a means of changing a lerfu string such as _<a id="id-1.19.23.19.5.1" class="indexterm"></a>[_fy._](../go01#valsi-fy)_ into an operator. In fact, _<a id="id-1.19.23.19.6.1" class="indexterm"></a>[_ma'o_](../go01#valsi-maho)_ can be followed by any mekso operand, using the elidable terminator _<a id="id-1.19.23.19.7.1" class="indexterm"></a>[_te'u_](../go01#valsi-tehu)_ if necessary.

<a id="id-1.19.23.20.1" class="indexterm"></a>There is a potential semantic ambiguity in _<a id="id-1.19.23.20.2.1" class="indexterm"></a>ma'o fy. \[te'u\]_ if _<a id="id-1.19.23.20.3.1" class="indexterm"></a>[_fy._](../go01#valsi-fy)_ is already in use as a variable: it comes to mean “ the function whose value is always f ”. However, mathematicians do not normally use the same lerfu words or strings as both functions and variables, so this case should not arise in practice.