<a id="section-miscellanious"></a>13.13. <a id="c13s13"></a>Miscellaneous indicators
------------------------------------------------------------------------------------

Some indicators do not fall neatly into the categories of attitudinal, evidential, or discursive. This section discusses the following miscellaneous indicators:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ki'a</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">metalinguistic confusion</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">na'i</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">metalinguistic negator</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">jo'a</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">metalinguistic affirmer</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">li'o</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">omitted text (quoted material)</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">sa'a</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">material inserted by editor/narrator</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">xu</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">true-false question</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">pau</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">question premarker</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">rhetorical question</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">pe'a</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">figurative language</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">literal language</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">bi'u</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">new information</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">old information</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ge'e</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">non-specific indicator</p></td></tr></tbody></table>

<a id="id-1.14.15.4.1" class="indexterm"></a><a id="id-1.14.15.4.2" class="indexterm"></a>The cmavo _<a id="id-1.14.15.4.3.1" class="indexterm"></a>[_ki'a_](../go01#valsi-kiha)_ is one of the most common of the miscellaneous indicators. It expresses metalinguistic confusion; i.e. confusion about what has been said, as opposed to confusion not tied to the discourse (which is _<a id="id-1.14.15.4.4.1" class="indexterm"></a>[_.uanai_](../go01#valsi-uanai)_). The confusion may be about the meaning of a word or of a grammatical construct, or about the referent of a sumti. One of the uses of English “which” corresponds to _<a id="id-1.14.15.4.6.1" class="indexterm"></a>[_ki'a_](../go01#valsi-kiha)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-gWFX"></a>

**Example 13.90. <a id="c13e13d1"></a><a id="id-1.14.15.5.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nelci</td><td>le</td><td>ctuca</td></tr><tr class="gloss"><td>I</td><td>like</td><td>the</td><td>teacher.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.i</td><td>le</td><td>ki'a</td><td>ctuca</td></tr><tr class="gloss"><td></td><td>The</td><td>which</td><td>teacher?</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Which teacher?</p></td></tr></tbody></table>

</div>  

Here, the second speaker does not understand the referent of the sumti _<a id="id-1.14.15.6.1.1" class="indexterm"></a>le ctuca_ , and so echoes back the sumti with the confusion marker.

<a id="id-1.14.15.7.1" class="indexterm"></a><a id="id-1.14.15.7.2" class="indexterm"></a>The metalinguistic negation cmavo _<a id="id-1.14.15.7.3.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ and its opposite _<a id="id-1.14.15.7.4.1" class="indexterm"></a>[_jo'a_](../go01#valsi-joha)_ are explained in full in [Chapter 15](../chapter-negation). In general, _<a id="id-1.14.15.7.6.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ indicates that there is something wrong with a piece of discourse: either an error, or a false underlying assumption, or something else of the sort. The discourse is invalid or inappropriate due to the marked word or construct.

<a id="id-1.14.15.8.1" class="indexterm"></a>Similarly, _<a id="id-1.14.15.8.2.1" class="indexterm"></a>[_jo'a_](../go01#valsi-joha)_ marks something which looks wrong but is in fact correct. These two cmavo constitute a scale, but are kept apart for two reasons: _<a id="id-1.14.15.8.3.1" class="indexterm"></a>na'inai_ means the same as _<a id="id-1.14.15.8.4.1" class="indexterm"></a>[_jo'a_](../go01#valsi-joha)_ , but would be too confusing as an affirmation; _<a id="id-1.14.15.8.5.1" class="indexterm"></a>jo'anai_ means the same as _<a id="id-1.14.15.8.6.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ , but is too long to serve as a convenient metalinguistic negator.

<a id="id-1.14.15.9.1" class="indexterm"></a><a id="id-1.14.15.9.2" class="indexterm"></a>The next two cmavo are used to assist in quoting texts written or spoken by others. It is often the case that we wish to quote only part of a text, or to supply additional material either by way of commentary or to make a fragmentary text grammatical. The cmavo _<a id="id-1.14.15.9.3.1" class="indexterm"></a>[_li'o_](../go01#valsi-liho)_ serves the former function. It indicates that words were omitted from the quotation. What remains of the quotation must be grammatical, however, as _<a id="id-1.14.15.9.4.1" class="indexterm"></a>[_li'o_](../go01#valsi-liho)_ does not serve any grammatical function. It cannot, for example, take the place of a missing selbri in a bridi, or supply the missing tail of a description sumti: _<a id="id-1.14.15.9.5.1" class="indexterm"></a>le li'o_ in isolation is not grammatical.

<a id="id-1.14.15.10.1" class="indexterm"></a><a id="id-1.14.15.10.2" class="indexterm"></a><a id="id-1.14.15.10.3" class="indexterm"></a><a id="id-1.14.15.10.4" class="indexterm"></a>The cmavo _<a id="id-1.14.15.10.5.1" class="indexterm"></a>[_sa'a_](../go01#valsi-saha)_ indicates in a quotation that the marked word or construct was not actually expressed, but is inserted for editorial, narrative, or grammatical purposes. Strictly, even a _<a id="id-1.14.15.10.6.1" class="indexterm"></a>[_li'o_](../go01#valsi-liho)_ should appear in the form _<a id="id-1.14.15.10.7.1" class="indexterm"></a>li'osa'a_ , since the _<a id="id-1.14.15.10.8.1" class="indexterm"></a>[_li'o_](../go01#valsi-liho)_ was not part of the original quotation. In practice, this and other forms which are already associated with metalinguistic expressions, such as _<a id="id-1.14.15.10.9.1" class="indexterm"></a>[_sei_](../go01#valsi-sei)_ (of selma'o SEI) or _<a id="id-1.14.15.10.10.1" class="indexterm"></a>[_to'i_](../go01#valsi-tohi)_ (of selma'o TO) need not be marked except where confusion might result.

<a id="id-1.14.15.11.1" class="indexterm"></a><a id="id-1.14.15.11.2" class="indexterm"></a>In the rare case that the quoted material already contains one or more instances of _<a id="id-1.14.15.11.3.1" class="indexterm"></a>[_sa'a_](../go01#valsi-saha)_ , they can be changed to _<a id="id-1.14.15.11.4.1" class="indexterm"></a>sa'asa'a_.

<a id="id-1.14.15.12.1" class="indexterm"></a><a id="id-1.14.15.12.2" class="indexterm"></a><a id="id-1.14.15.12.3" class="indexterm"></a>The cmavo _<a id="id-1.14.15.12.4.1" class="indexterm"></a>[_xu_](../go01#valsi-xu)_ marks truth questions, which are discussed in detail in [Section 15.8](../section-truth-questions). In general, _<a id="id-1.14.15.12.6.1" class="indexterm"></a>[_xu_](../go01#valsi-xu)_ may be translated “Is it true that ... ?” and questions whether the attached bridi is true. When _<a id="id-1.14.15.12.8.1" class="indexterm"></a>[_xu_](../go01#valsi-xu)_ is attached to a specific word or construct, it directs the focus of the question to that word or construct.

<a id="id-1.14.15.13.1" class="indexterm"></a>Lojban question words, unlike those of English, frequently do not stand at the beginning of the question. Placing the cmavo _<a id="id-1.14.15.13.2.1" class="indexterm"></a>[_pau_](../go01#valsi-pau)_ at the beginning of a bridi helps the listener realize that the bridi is a question, like the symbol at the beginning of written Spanish questions that looks like an upside-down question mark. The listener is then warned to watch for the actual question word.

<a id="id-1.14.15.14.1" class="indexterm"></a><a id="id-1.14.15.14.2" class="indexterm"></a><a id="id-1.14.15.14.3" class="indexterm"></a>Although _<a id="id-1.14.15.14.4.1" class="indexterm"></a>[_pau_](../go01#valsi-pau)_ is grammatical in any location (like all indicators), it is not really useful except at or near the beginning of a bridi. Its scalar opposite, _<a id="id-1.14.15.14.5.1" class="indexterm"></a>[_paunai_](../go01#valsi-paunai)_ , signals that a bridi is not really a question despite its form. This is what we call in English a rhetorical question: an example appears in the English text near the beginning of [Section 13.11](../section-evidentials).

<a id="id-1.14.15.15.1" class="indexterm"></a>The cmavo _<a id="id-1.14.15.15.2.1" class="indexterm"></a>[_pe'a_](../go01#valsi-peha)_ is the indicator of figurative speech, indicating that the previous word should be taken figuratively rather than literally:

<div class="interlinear-gloss-example example">
<a id="example-random-id-rXiR"></a>

**Example 13.91. <a id="c13e13d2"></a><a id="id-1.14.15.16.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>le</td><td>blanu</td><td>pe'a</td><td>zdani</td></tr><tr class="gloss"><td>I</td><td>see</td><td>the</td><td>blue</td><td>[figurative]</td><td>house.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I see the <span class="quote">“<span class="quote">blue</span>”</span> house.</p></td></tr></tbody></table>

</div>  

Here the house is not blue in the sense of color, but in some other sense, whose meaning is entirely culturally dependent. The use of _<a id="id-1.14.15.17.1.1" class="indexterm"></a>[_pe'a_](../go01#valsi-peha)_ unambiguously marks a cultural reference: _<a id="id-1.14.15.17.2.1" class="indexterm"></a>[_blanu_](../go01#valsi-blanu)_ in [Example 13.91](../section-miscellanious#example-random-id-rXiR) could mean “sad” (as in English) or something completely different.

<a id="id-1.14.15.18.1" class="indexterm"></a>The negated form, _<a id="id-1.14.15.18.2.1" class="indexterm"></a>pe'anai_ , indicates that what has been said is to be interpreted literally, in the usual way for Lojban; natural-language intuition is to be ignored.

<a id="id-1.14.15.19.1" class="indexterm"></a><a id="id-1.14.15.19.2" class="indexterm"></a><a id="id-1.14.15.19.3" class="indexterm"></a><a id="id-1.14.15.19.4" class="indexterm"></a><a id="id-1.14.15.19.5" class="indexterm"></a>Alone among the cmavo of selma'o UI, _<a id="id-1.14.15.19.6.1" class="indexterm"></a>[_pe'a_](../go01#valsi-peha)_ has a rafsi, namely _pev_. This rafsi is used in forming figurative (culturally dependent) lujvo, whose place structure need have nothing to do with the place structure of the components. Thus _risnyjelca_ (heart burn) might have a place structure like:

> x1 is the heart of x2, burning in atmosphere x3 at temperature x4

whereas _pevrisnyjelca_ , explicitly marked as figurative, might have the place structure:

> x1 is indigestion/heartburn suffered by x2

which obviously has nothing to do with the places of either _<a id="id-1.14.15.23.1.1" class="indexterm"></a>[_risna_](../go01#valsi-risna)_ or _<a id="id-1.14.15.23.2.1" class="indexterm"></a>[_jelca_](../go01#valsi-jelca)_.

<a id="id-1.14.15.24.1" class="indexterm"></a><a id="id-1.14.15.24.2" class="indexterm"></a>The uses of _<a id="id-1.14.15.24.3.1" class="indexterm"></a>[_bi'u_](../go01#valsi-bihu)_ and _<a id="id-1.14.15.24.4.1" class="indexterm"></a>[_bi'unai_](../go01#valsi-bihunai)_ correspond to one of the uses of the English articles “the” and “a/an”. An English-speaker telling a story may begin with “I saw a man who ...”. Later in the story, the same man will be referred to with the phrase “the man”. Lojban does not use its articles in the same way: both “a man” and “the man” would be translated _<a id="id-1.14.15.24.11.1" class="indexterm"></a>le nanmu_ , since the speaker has in mind a specific man. However, the first use might be marked _<a id="id-1.14.15.24.12.1" class="indexterm"></a>le bi'u nanmu_ , to indicate that this is a new man, not mentioned before. Later uses could correspondingly be tagged _<a id="id-1.14.15.24.13.1" class="indexterm"></a>le bi'unai nanmu_.

Most of the time, the distinction between _<a id="id-1.14.15.25.1.1" class="indexterm"></a>[_bi'u_](../go01#valsi-bihu)_ and _<a id="id-1.14.15.25.2.1" class="indexterm"></a>[_bi'unai_](../go01#valsi-bihunai)_ need not be made, as the listener can infer the right referent. However, if a different man were referred to still later in the story, _<a id="id-1.14.15.25.3.1" class="indexterm"></a>le bi'u nanmu_ would clearly show that this man was different from the previous one.

<a id="id-1.14.15.26.1" class="indexterm"></a>Finally, the indicator _<a id="id-1.14.15.26.2.1" class="indexterm"></a>[_ge'e_](../go01#valsi-gehe)_ has been discussed in [Section 13.8](../section-compound-attitudinals) and [Section 13.10](../section-questions-empathy-contours). It is used to express an attitude which is not covered by the existing set, or to avoid expressing any attitude.

Another use for _<a id="id-1.14.15.27.1.1" class="indexterm"></a>[_ge'e_](../go01#valsi-gehe)_ is to explicitly avoid expressing one's feeling on a given scale; in this use, it functions like a member of selma'o CAI: _<a id="id-1.14.15.27.2.1" class="indexterm"></a>.iige'e_ means roughly “I'm not telling whether I'm afraid or not.”<a id="id-1.14.15.27.4" class="indexterm"></a>

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">kau</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">indirect question</p></td></tr></tbody></table>

This cmavo is explained in detail in [Section 11.8](../section-indirect-questions). It marks the word it is attached to as the focus of an indirect question:

<div class="interlinear-gloss-example example">
<a id="example-random-id-umCQ"></a>

**Example 13.92. <a id="c13e13d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>djuno</td><td>le</td><td>du'u</td><td>dakau</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>know</td><td>the</td><td>predication-of</td><td>somebody-[indirect?]</td><td>goes</td><td>to-the</td><td>store.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I know who goes to the store.</p></td></tr></tbody></table>

</div>