<a id="section-metalinguistic-negation"></a>15.10. <a id="c15s10"></a>Metalinguistic negation forms
---------------------------------------------------------------------------------------------------

The question of truth or falsity is not entirely synonymous with negation. Consider the English sentence

<div class="example">
<a id="example-random-id-QsJ9"></a>

**Example 15.96. <a id="c15e10d1"></a>** 

I have not stopped beating my wife.

</div>  

If I never started such a heinous activity, then this sentence is neither true nor false. Such a negation simply says that something is wrong with the non-negated statement. Generally, we then use either tone of voice or else a correction to express a preferred true claim: “I never have beaten my wife.”

Negations which follow such a pattern are called “metalinguistic negations”. In natural languages, the mark of metalinguistic negation is that an indication of a correct statement always, or almost always, follows the negation. Tone of voice or emphasis may be further used to clarify the error.

Negations of every sort must be expressible in Lojban; errors are inherent to human thought, and are not excluded from the language. When such negations are metalinguistic, we must separate them from logical claims about the truth or falsity of the statement, as well as from scalar negations which may not easily express (or imply) the preferred claim. Because Lojban allows concepts to be so freely combined in tanru, limits on what is plausible or not plausible tend to be harder to determine.

Mimicking the muddled nature of natural language negation would destroy this separation. Since Lojban does not use tone of voice, we need other means to metalinguistically indicate what is wrong with a statement. When the statement is entirely inappropriate, we need to be able to express metalinguistic negation in a more non-specific fashion.

Here is a list of some different kinds of metalinguistic negation with English-language examples:

<div class="example">
<a id="example-random-id-qhbg"></a>

**Example 15.97. <a id="c15e10d2"></a>** 

I have not _stopped_ beating my wife

(I never started – failure of presupposition).

</div>  
<div class="example">
<a id="example-random-id-qHcI"></a>

**Example 15.98. <a id="c15e10d3"></a>** 

5 is not blue

(color does not apply to abstract concepts – failure of category).

</div>  
<div class="example">
<a id="example-random-id-qHEQ"></a>

**Example 15.99. <a id="c15e10d4"></a>** 

The current King of France is not bald.

(there is no current King of France – existential failure)

</div>  
<div class="example">
<a id="example-random-id-qhet"></a>

**Example 15.100. <a id="c15e10d5"></a>** 

I do not have THREE children.

(I have two – simple undue quantity)

</div>  
<div class="example">
<a id="example-random-id-qhEU"></a>

**Example 15.101. <a id="c15e10d6"></a>** 

I have not held THREE jobs previously, but four.

(inaccurate quantity; the difference from the previous example is that someone who has held four jobs has also held three jobs)

</div>  
<div class="example">
<a id="example-random-id-qhf5"></a>

**Example 15.102. <a id="c15e10d7"></a>** 

It is not good, but bad.

(undue quantity negation indicating that the value on a scale for measuring the predicate is incorrect)

</div>  
<div class="example">
<a id="example-random-id-qHhA"></a>

**Example 15.103. <a id="c15e10d8"></a>** 

She is not PRETTY; she is beautiful.

(undue quantity transferred to a non-numeric scale)

</div>  
<div class="example">
<a id="example-random-id-qhHI"></a>

**Example 15.104. <a id="c15e10d9"></a>** 

The house is not blue, but green.

(the scale/category being used is incorrect, but a related category applies)

</div>  
<div class="example">
<a id="example-random-id-qHHw"></a>

**Example 15.105. <a id="c15e10d10"></a>** 

The house is not blue, but is colored.

(the scale/category being used is incorrect, but a broader category applies)

</div>  
<div class="example">
<a id="example-random-id-qHI4"></a>

**Example 15.106. <a id="c15e10d11"></a>** 

The cat is not blue, but long-haired.

(the scale/category being used is incorrect, but an unrelated category applies)

</div>  
<div class="example">
<a id="example-random-id-qHja"></a>

**Example 15.107. <a id="c15e10d12"></a>** 

A: He ain't coming today.

B: “Ain't” ain't a word.

(solecism, or improper grammatical action)

</div>  
<div class="example">
<a id="example-random-id-qHJi"></a>

**Example 15.108. <a id="c15e10d13"></a>** 

I haven't STOOPED beating my wife; I've STOPPED.

(spelling or mispronunciation error)

</div>  
<div class="example">
<a id="example-random-id-qhJj"></a>

**Example 15.109. <a id="c15e10d14"></a>** 

Not only was it a sheep, it was a black sheep.

(non-contradictory correction)

</div>  

The set of possible metalinguistic errors is open-ended.

Many of these forms have a counterpart in the various examples that we've discussed under logical negation. Metalinguistic negation doesn't claim that the sentence is false or true, though. Rather, it claims that, due to some error in the statement, “true” and “false” don't really apply.

Because one can metalinguistically negate a true statement intending a non-contradictory correction (say, a spelling error), we need a way (or ways) to metalinguistically negate a statement which is independent of our logical negation schemes using _<a id="id-1.16.12.24.1.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ , _<a id="id-1.16.12.24.2.1" class="indexterm"></a>[_na'e_](../go01#valsi-nahe)_ and kin. The cmavo _<a id="id-1.16.12.24.3.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ is assigned this function. If it is present in a statement, it indicates metalinguistically that something in the statement is incorrect. This metalinguistic negation must override any evaluation of the logic of the statement. It is equally allowed in both positive and negative statements.

Since _<a id="id-1.16.12.25.1.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ is not a logical operator, multiple occurrences of _<a id="id-1.16.12.25.2.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ need not be assumed to cancel each other. Indeed, we can use the position of _<a id="id-1.16.12.25.3.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ to indicate metalinguistically what is incorrect, preparatory to correcting it in a later sentence; for this reason, we give _<a id="id-1.16.12.25.4.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ the grammar of UI. The inclusion of _<a id="id-1.16.12.25.5.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ anywhere in a sentence makes it a non-assertion, and suggests one or more pitfalls in assigning a truth value.

Let us briefly indicate how the above-mentioned metalinguistic errors can be identified. Other metalinguistic problems can then be marked by devising analogies to these examples:

Existential failure can be marked by attaching _<a id="id-1.16.12.27.1.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ to the descriptor _<a id="id-1.16.12.27.2.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ or the _<a id="id-1.16.12.27.3.1" class="indexterm"></a>[_poi_](../go01#valsi-poi)_ in a _<a id="id-1.16.12.27.4.1" class="indexterm"></a>da poi_ -form sumti. (See [Section 6.2](../section-basic-descriptors) and [Section 16.4](../section-restricted-claims) for details on these constructions.) Remember that if a _<a id="id-1.16.12.27.7.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ sumti seems to refer to a non-existent referent, you may not understand what the speaker has in mind – the appropriate response is then _<a id="id-1.16.12.27.8.1" class="indexterm"></a>[_ki'a_](../go01#valsi-kiha)_ , asking for clarification.

Presupposition failure can be marked directly if the presupposition is overt; if not, one can insert a “mock presupposition” to question with the sumtcita (selma'o BAI) word _<a id="id-1.16.12.28.2.1" class="indexterm"></a>[_ji'u_](../go01#valsi-jihu)_ ; _<a id="id-1.16.12.28.3.1" class="indexterm"></a>ji'uku_ thus explicitly refers to an unexpressed assumption, and _<a id="id-1.16.12.28.4.1" class="indexterm"></a>ji'una'iku_ metalinguistically says that something is wrong with that assumption. (See [Chapter 9](../chapter-sumti-tcita).)

Scale errors and category errors can be similarly expressed with selma'o BAI. _<a id="id-1.16.12.29.1.1" class="indexterm"></a>[_le'a_](../go01#valsi-leha)_ has meaning “of category/class/type X” , _<a id="id-1.16.12.29.3.1" class="indexterm"></a>[_ci'u_](../go01#valsi-cihu)_ has meaning “on scale X” , and _<a id="id-1.16.12.29.5.1" class="indexterm"></a>[_ci'e_](../go01#valsi-cihe)_ , based on _<a id="id-1.16.12.29.6.1" class="indexterm"></a>[_ciste_](../go01#valsi-ciste)_ , can be used to talk about universes of discourse defined either as systems or sets of components, as shown in [Section 15.8](../section-truth-questions). _<a id="id-1.16.12.29.8.1" class="indexterm"></a>[_kai_](../go01#valsi-kai)_ and _<a id="id-1.16.12.29.9.1" class="indexterm"></a>[_la'u_](../go01#valsi-lahu)_ also exist in BAI for discussing other quality and quantity errors.

We have to make particular note of potential problems in the areas of undue quantity and incorrect scale/category. Assertions about the relationships between gismu are among the basic substance of the language. It is thus invalid to logically require that if something is blue, that it is colored, or if it is not-blue, then it is some other color. In Lojban, _<a id="id-1.16.12.30.1.1" class="indexterm"></a>[_blanu_](../go01#valsi-blanu)_ ( “blue”) is not explicitly defined as a _<a id="id-1.16.12.30.3.1" class="indexterm"></a>[_skari_](../go01#valsi-skari)_ ( “color”). Similarly, it is not implicit that the opposite of “good” is “bad”.

This mutual independence of gismu is only an ideal. Pragmatically, people will categorize things based on their world-views. We will write dictionary definitions that will relate gismu, unfortunately including some of these world-view assumptions. Lojbanists should try to minimize these assumptions, but this seems a likely area where logical rules will break down (or where Sapir-Whorf effects will be made evident). In terms of negation, however, it is vital that we clearly preserve the capability of denying a presumably obvious scale or category assumption.

Solecisms, grammatical and spelling errors will be marked by marking the offending word or phrase with _<a id="id-1.16.12.32.1.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ (in the manner of any selma'o UI cmavo). In this sense, _<a id="id-1.16.12.32.2.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ becomes equivalent to the English metalinguistic marker “\[sic\]”. Purists may choose to use ZOI or LOhU/LEhU quotes or _<a id="id-1.16.12.32.4.1" class="indexterm"></a>[_sa'a_](../go01#valsi-saha)_ -marked corrections to avoid repeating a truly unparsable passage, especially if a computer is to analyze the speech/text. See [Section 19.12](../section-parentheses) for explanations of these usages.

In summary, metalinguistic negation will typically take the form of referring to a previous statement and marking it with one or more _<a id="id-1.16.12.33.1.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ to indicate what metalinguistic errors have been made, and then repeating the statement with corrections. References to previous statements may be full repetitions, or may use members of selma'o GOhA. _<a id="id-1.16.12.33.2.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ at the beginning of a statement merely says that something is inappropriate about the statement, without specificity.

In normal use, metalinguistic negation requires that a corrected statement follow the negated statement. In Lojban, however, it is possible to completely and unambiguously specify metalinguistic errors without correcting them. It will eventually be seen whether an uncorrected metalinguistic negation remains an acceptable form in Lojban. In such a statement, metalinguistic expression would involve an ellipsis not unlike that of tenseless expression.

Note that metalinguistic negation gives us another kind of legitimate negative answer to a _<a id="id-1.16.12.35.1.1" class="indexterm"></a>[_xu_](../go01#valsi-xu)_ question (see [Section 15.8](../section-truth-questions)). _<a id="id-1.16.12.35.3.1" class="indexterm"></a>[_na'i_](../go01#valsi-nahi)_ will be used when something about the questioned statement is inappropriate, such as in questions like “Have you stopped beating your wife?” :

<div class="interlinear-gloss-example example">
<a id="example-random-id-SfSU"></a>

**Example 15.110. <a id="c15e10d15"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>xu</td><td>do</td><td>sisti</td><td>lezu'o</td></tr><tr class="gloss"><td>is-it-true-that:</td><td>you</td><td>cease</td><td>the-activity-of</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>rapydarxi</td><td>ledo</td><td>fetspe</td></tr><tr class="gloss"><td>you</td><td>repeat-hitting</td><td>your</td><td>female-spouse?</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Have you stopped beating your wife?</p></td></tr></tbody></table>

</div>  

Responses could include:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qHJJ"></a>

**Example 15.111. <a id="c15e10d16"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>na'i</td><td>go'i</td></tr><tr class="gloss"><td>[metalinguistic-negation]</td><td>[repeat-previous]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The bridi as a whole is inappropriate in some way.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qHKe"></a>

**Example 15.112. <a id="c15e10d17"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>go'i</td><td>na'i</td></tr><tr class="gloss"><td>[repeat-previous]</td><td>[metalinguistic-negation]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The selbri ( <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.16.12.39.3.1.1.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-sisti"><em class="glossterm">sisti</em></a></em></span>) is inappropriate in some way.</p></td></tr></tbody></table>

</div>  

One can also specifically qualify the metalinguistic negation, by explicitly repeating the erroneous portion of the bridi to be metalinguistically negated, or adding on of the selma'o BAI qualifiers mentioned above:

<div class="interlinear-gloss-example example">
<a id="example-random-id-ANpd"></a>

**Example 15.113. <a id="c15e10d18"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>go'i</td><td>ji'una'iku</td></tr><tr class="gloss"><td>[repeat-previous]</td><td>[presupposition-wrong]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Some presupposition is wrong with the previous bridi.</p></td></tr></tbody></table>

</div>  

Finally, one may metalinguistically affirm a bridi with _<a id="id-1.16.12.42.1.1" class="indexterm"></a>[_jo'a_](../go01#valsi-joha)_ , another cmavo of selma'o UI. A common use for _<a id="id-1.16.12.42.2.1" class="indexterm"></a>[_jo'a_](../go01#valsi-joha)_ might be to affirm that a particular construction, though unusual or counterintuitive, is in fact correct; another usage would be to disagree with – by overriding – a respondent's metalinguistic negation.