<a id="section-masses"></a>6.3. <a id="c6s3"></a>Individuals and masses
-----------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">lei</p></td><td class="selmaho"><p class="selmaho">LE</p></td><td class="description"><p class="description">the mass I describe as</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">loi</p></td><td class="selmaho"><p class="selmaho">LE</p></td><td class="description"><p class="description">part of the mass of those which really are</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">lai</p></td><td class="selmaho"><p class="selmaho">LA</p></td><td class="description"><p class="description">the mass of those named</p></td></tr></tbody></table>

<a id="id-1.7.5.4.1" class="indexterm"></a><a id="id-1.7.5.4.2" class="indexterm"></a><a id="id-1.7.5.4.3" class="indexterm"></a><a id="id-1.7.5.4.4" class="indexterm"></a>All Lojban sumti are classified by whether they refer to one of three types of objects, known as “individuals” , “masses” , and “sets”. The term “individual” is misleading when used to refer to more than one object, but no less-confusing term has as yet been found. All the descriptions in [Section 6.1](../chapter-sumti#section-simple-sumti-kinds) and [Section 6.2](../section-basic-descriptors) refer to individuals, whether one or more than one. Consider the following example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-mwhq"></a>

**Example 6.16. <a id="c6e3d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>prenu</td><td>cu</td><td>bevri</td><td>le</td><td>pipno</td></tr><tr class="gloss"><td>One-or-more-of-those-I-describe-as</td><td>persons</td><td></td><td>carry</td><td>the</td><td>piano.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The person(s) carry the piano.</p></td></tr></tbody></table>

</div>  

(Of course the second _<a id="id-1.7.5.6.1.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ should really get the same translation as the first, but I am putting the focus of this discussion on the first _<a id="id-1.7.5.6.2.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ , the one preceding _<a id="id-1.7.5.6.3.1" class="indexterm"></a>[_prenu_](../go01#valsi-prenu)_. I will assume that there is only one piano under discussion.)

<a id="id-1.7.5.7.1" class="indexterm"></a><a id="id-1.7.5.7.2" class="indexterm"></a><a id="id-1.7.5.7.3" class="indexterm"></a><a id="id-1.7.5.7.4" class="indexterm"></a>Suppose the context of [Example 6.16](../section-masses#example-random-id-mwhq) is such that you can determine that I am talking about three persons. What am I claiming? I am claiming that each of the three persons carried the piano. This claim can be true if the persons carried the piano one at a time, or in turns, or in a variety of other ways. But in order for [Example 6.16](../section-masses#example-random-id-mwhq) to be true, I must be willing to assert that person 1 carried the piano, and that person 2 carried the piano, and that person 3 carried the piano.

But suppose I am not willing to claim that. For in fact pianos are heavy, and very few persons can carry a piano all by themselves. The most likely factual situation is that person 1 carried one end of the piano, and person 2 the other end, while person 3 either held up the middle or else supervised the whole operation without actually lifting anything. The correct way of expressing such a situation in Lojban is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-eCsh"></a>

**Example 6.17. <a id="id-1.7.5.9.1.1" class="indexterm"></a><a id="c6e3d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lei</td><td>prenu</td><td>cu</td><td>bevri</td><td>le</td><td>pipno</td></tr><tr class="gloss"><td>The-mass-of-one-or-more-of-those-I-describe-as</td><td>persons</td><td></td><td>carry</td><td>the</td><td>piano.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The person(s) carry the piano.</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.5.10.1" class="indexterm"></a><a id="id-1.7.5.10.2" class="indexterm"></a><a id="id-1.7.5.10.3" class="indexterm"></a><a id="id-1.7.5.10.4" class="indexterm"></a>Here the same three persons are treated not as individuals, but as a so-called “mass entity” , or just “mass”. A mass has the properties of each individual which composes it, and may have other properties of its own as well. This can lead to apparent contradictions. Thus suppose in the piano-moving example above that person 1 has fair skin, whereas person 2 has dark skin. Then it is correct to say that the person-mass has both fair skin and dark skin. Using the mass descriptor _<a id="id-1.7.5.10.7.1" class="indexterm"></a>[_lei_](../go01#valsi-lei)_ signals that ordinary logical reasoning is not applicable: contradictions can be maintained, and all sorts of other peculiarities may exist. However, we can safely say that a mass inherits only the component properties that are relevant to it; it would be ludicrous to say that a mass of two persons is of molecular dimensions, simply because some of the parts (namely, the molecules) of the persons are that small.

<a id="id-1.7.5.11.1" class="indexterm"></a><a id="id-1.7.5.11.2" class="indexterm"></a>The descriptors _<a id="id-1.7.5.11.3.1" class="indexterm"></a>[_loi_](../go01#valsi-loi)_ and _<a id="id-1.7.5.11.4.1" class="indexterm"></a>[_lai_](../go01#valsi-lai)_ are analogous to _<a id="id-1.7.5.11.5.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ and _<a id="id-1.7.5.11.6.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ respectively, but refer to masses either by property ( _<a id="id-1.7.5.11.7.1" class="indexterm"></a>[_loi_](../go01#valsi-loi)_) or by name ( _<a id="id-1.7.5.11.8.1" class="indexterm"></a>[_lai_](../go01#valsi-lai)_). A classic example of _<a id="id-1.7.5.11.9.1" class="indexterm"></a>[_loi_](../go01#valsi-loi)_ use is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-T1pF"></a>

**Example 6.18. <a id="id-1.7.5.12.1.1" class="indexterm"></a><a id="c6e3d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>loi</td><td>cinfo</td><td>cu</td><td>xabju</td><td>le</td><td>fi'ortu'a</td></tr><tr class="gloss"><td>Part-of-the-mass-of-those-which-really</td><td>are-lions</td><td></td><td>dwell-in</td><td>the</td><td>African-land.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The lion dwells in Africa.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">Lions dwell in Africa.</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.5.13.1" class="indexterm"></a><a id="id-1.7.5.13.2" class="indexterm"></a>The difference between _<a id="id-1.7.5.13.3.1" class="indexterm"></a>[_lei_](../go01#valsi-lei)_ and _<a id="id-1.7.5.13.4.1" class="indexterm"></a>[_loi_](../go01#valsi-loi)_ is that _<a id="id-1.7.5.13.5.1" class="indexterm"></a>lei cinfo_ refers to a mass of specific individuals which the speaker calls lions, whereas _<a id="id-1.7.5.13.6.1" class="indexterm"></a>loi cinfo_ refers to some part of the mass of all those individuals which actually are lions. The restriction to “some part of the mass” allows statements like [Example 6.18](../section-masses#example-random-id-T1pF) to be true even though some lions do not dwell in Africa – they live in various zoos around the world. On the other hand, [Example 6.18](../section-masses#example-random-id-T1pF) doesn't actually say that most lions live in Africa: equally true is

<div class="interlinear-gloss-example example">
<a id="example-random-id-JzXc"></a>

**Example 6.19. <a id="id-1.7.5.14.1.1" class="indexterm"></a><a id="c6e3d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>loi</td><td>glipre</td></tr><tr class="gloss"><td>Part-of-the-mass-of-those-which-really</td><td>are-English-persons</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>cu</td><td>xabju</td><td>le</td><td>fi'ortu'a</td></tr><tr class="gloss"><td></td><td>dwell-in</td><td>the</td><td>African-land.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The English dwell in Africa.</p></td></tr></tbody></table>

</div>  

since there is at least one English person living there. [Section 6.4](../section-sets) explains another method of saying what is usually meant by “The lion lives in Africa” which does imply that living in Africa is normal, not exceptional, for lions.

<a id="id-1.7.5.16.1" class="indexterm"></a>Note that the Lojban mass articles are sometimes translated by English plurals (the most usual case), sometimes by English singulars (when the singular is used to express typicalness or abstraction), and sometimes by singulars with no article:

<div class="interlinear-gloss-example example">
<a id="example-random-id-yDCF"></a>

**Example 6.20. <a id="id-1.7.5.17.1.1" class="indexterm"></a><a id="c6e3d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>loi</td><td>matne</td><td>cu</td><td>ranti</td></tr><tr class="gloss"><td>Part-of-the-mass-of-that-which-really-is</td><td>a-quantity-of-butter</td><td></td><td>is-soft.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Butter is soft.</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.5.18.1" class="indexterm"></a>Of course, some butter is hard (for example, if it is frozen butter), so the “part-of” implication of _<a id="id-1.7.5.18.3.1" class="indexterm"></a>[_loi_](../go01#valsi-loi)_ becomes once again useful. The reason this mechanism works is that the English words like “butter” , which are seen as already describing masses, are translated in Lojban by non-mass forms. The place structure of _<a id="id-1.7.5.18.5.1" class="indexterm"></a>[_matne_](../go01#valsi-matne)_ is “x1 is a quantity of butter from source x2” , so the single English word “butter” is translated as something like “a part of the mass formed from all the quantities of butter that exist”. (Note that the operation of forming a mass entity does not imply, in Lojban, that the components of the mass are necessarily close to one another or even related in any way other than conceptually. Masses are formed by the speaker's intention to form a mass, and can in principle contain anything.)

<a id="id-1.7.5.19.1" class="indexterm"></a>The mass name descriptor _<a id="id-1.7.5.19.2.1" class="indexterm"></a>[_lai_](../go01#valsi-lai)_ is used in circumstances where we wish to talk about a mass of things identified by a name which is common to all of them. It is not used to identify a mass by a single name peculiar to it. Thus the mass version of [Example 6.9](../section-basic-descriptors#example-random-id-fSxN) ,

<div class="interlinear-gloss-example example">
<a id="example-random-id-H8z5"></a>

**Example 6.21. <a id="id-1.7.5.20.1.1" class="indexterm"></a><a id="c6e3d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lai</td><td>cribe</td><td>pu</td><td>finti</td><td>le</td><td>vi</td><td>cukta</td></tr><tr class="gloss"><td>The-mass-of-those-named</td><td><span class="quote">“<span class="quote">bear</span>”</span></td><td>[past]</td><td>creates</td><td>the</td><td>nearby</td><td>book.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The Bears wrote this book.</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.5.21.1" class="indexterm"></a><a id="id-1.7.5.21.2" class="indexterm"></a>in a context where _<a id="id-1.7.5.21.3.1" class="indexterm"></a>la cribe_ would be understood as plural, would mean that either Tom Bear or Fred Bear (to make up some names) might have written the book, or that Tom and Fred might have written it as collaborators. Using _<a id="id-1.7.5.21.4.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ instead of _<a id="id-1.7.5.21.5.1" class="indexterm"></a>[_lai_](../go01#valsi-lai)_ in [Example 6.21](../section-masses#example-random-id-H8z5) would give the implication that each of Tom and Fred, considered individually, had written it.