<a id="section-lujvo"></a>4.5. <a id="c4s5"></a>lujvo
-----------------------------------------------------

<a id="id-1.5.7.2.1" class="indexterm"></a><a id="id-1.5.7.2.2" class="indexterm"></a><a id="id-1.5.7.2.3" class="indexterm"></a><a id="id-1.5.7.2.4" class="indexterm"></a>When specifying a concept that is not found among the gismu (or, more specifically, when the relevant gismu seems too general in meaning), a Lojbanist generally attempts to express the concept as a tanru. Lojban tanru are an elaboration of the concept of “metaphor” used in English. In Lojban, any brivla can be used to modify another brivla. The first of the pair modifies the second. This modification is usually restrictive – the modifying brivla reduces the broader sense of the modified brivla to form a more narrow, concrete, or specific concept. Modifying brivla may thus be seen as acting like English adverbs or adjectives. For example,

<div class="interlinear-gloss-example example">
<a id="example-random-id-xhQP"></a>

**Example 4.19. <a id="c4e5d1"></a>** 

<a id="id-1.5.7.3.2.1" class="indexterm"></a>skami pilno

</div>  

is the tanru which expresses the concept of “computer user”.

<a id="id-1.5.7.5.1" class="indexterm"></a>The simplest Lojban tanru are pairings of two concepts or ideas. Such tanru take two simpler ideas that can be represented by gismu and combine them into a single more complex idea. Two-part tanru may then be recombined in pairs with other tanru, or with individual gismu, to form more complex or more specific ideas, and so on.

<a id="id-1.5.7.6.1" class="indexterm"></a>The meaning of a tanru is usually at least partly ambiguous: _<a id="id-1.5.7.6.2.1" class="indexterm"></a>skami pilno_ could refer to a computer that is a user, or to a user of computers. There are a variety of ways that the modifier component can be related to the modified component. It is also possible to use cmavo within tanru to provide variations (or to prevent ambiguities) of meaning.

<a id="id-1.5.7.7.1" class="indexterm"></a>Making tanru is essentially a poetic or creative act, not a science. While the syntax expressing the grouping relationships within tanru is unambiguous, tanru are still semantically ambiguous, since the rules defining the relationships between the gismu are flexible. The process of devising a new tanru is dealt with in detail in [Chapter 5](../chapter-selbri).

<a id="id-1.5.7.8.1" class="indexterm"></a>To express a simple tanru, simply say the component gismu together. Thus the binary metaphor “big boat” becomes the tanru

<div class="interlinear-gloss-example example">
<a id="example-random-id-oLE3"></a>

**Example 4.20. <a id="id-1.5.7.9.1.1" class="indexterm"></a><a id="c4e5d2"></a>** 

<a id="id-1.5.7.9.2.1" class="indexterm"></a>barda bloti

</div>  

representing roughly the same concept as the English word “ship”.

<a id="id-1.5.7.11.1" class="indexterm"></a>The binary metaphor “father mother” can refer to a paternal grandmother ( “a father-ly type of mother”), while “mother father” can refer to a maternal grandfather ( “a mother-ly type of father”). In Lojban, these become the tanru

<div class="interlinear-gloss-example example">
<a id="example-random-id-4wK9"></a>

**Example 4.21. <a id="id-1.5.7.12.1.1" class="indexterm"></a><a id="c4e5d3"></a>** 

<a id="id-1.5.7.12.2.1" class="indexterm"></a>patfu mamta

</div>  

and

<div class="interlinear-gloss-example example">
<a id="example-random-id-KQ4s"></a>

**Example 4.22. <a id="id-1.5.7.14.1.1" class="indexterm"></a><a id="c4e5d4"></a>** 

<a id="id-1.5.7.14.2.1" class="indexterm"></a>mamta patfu

</div>  

respectively.

<a id="id-1.5.7.16.1" class="indexterm"></a>The possibility of semantic ambiguity can easily be seen in the last case. To interpret [Example 4.22](../section-lujvo#example-random-id-KQ4s) , the listener must determine what type of motherliness pertains to the father being referred to. In an appropriate context, _<a id="id-1.5.7.16.3.1" class="indexterm"></a>mamta patfu_ could mean not “grandfather” but simply “father with some motherly attributes” , depending on the culture. If absolute clarity is required, there are ways to expand upon and explain the exact interrelationship between the components; but such detail is usually not needed.

<a id="id-1.5.7.17.1" class="indexterm"></a><a id="id-1.5.7.17.2" class="indexterm"></a><a id="id-1.5.7.17.3" class="indexterm"></a>When a concept expressed in a tanru proves useful, or is frequently expressed, it is desirable to choose one of the possible meanings of the tanru and assign it to a new brivla. For [Example 4.19](../section-lujvo#example-random-id-xhQP) , we would probably choose “user of computers” , and form the new word

<div class="lujvo-example example">
<a id="example-random-id-v5YD"></a>

**Example 4.23. <a id="c4e5d5"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">sampli</p></td></tr></tbody></table>

</div>  

Such a brivla, built from the rafsi which represent its component words, is called a _<a id="id-1.5.7.19.1.1" class="indexterm"></a>[_lujvo_](../go01#valsi-lujvo)_. Another example, corresponding to the tanru of [Example 4.20](../section-lujvo#example-random-id-oLE3) , would be:

<div class="lujvo-example example">
<a id="example-random-id-aiAR"></a>

**Example 4.24. <a id="c4e5d6"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">bralo'i</p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">big-boat</span>”</span></p></td></tr><tr><td><p class="natlang">ship</p></td></tr></tbody></table>

</div>  

<a id="id-1.5.7.21.1" class="indexterm"></a><a id="id-1.5.7.21.2" class="indexterm"></a><a id="id-1.5.7.21.3" class="indexterm"></a>The lujvo representing a given tanru is built from units representing the component gismu. These units are called _<a id="id-1.5.7.21.4.1" class="indexterm"></a>[_rafsi_](../go01#valsi-rafsi)_ in Lojban. Each rafsi represents only one gismu. The rafsi are attached together in the order of the words in the tanru, occasionally inserting so-called “hyphen” letters to ensure that the pieces stick together as a single word and cannot accidentally be broken apart into cmavo, gismu, or other word forms. As a result, each lujvo can be readily and accurately recognized, allowing a listener to pick out the word from a string of spoken Lojban, and if necessary, unambiguously decompose the word to a unique source tanru, thus providing a strong clue to its meaning.

The lujvo that can be built from the tanru _<a id="id-1.5.7.22.1.1" class="indexterm"></a>mamta patfu_ in [Example 4.22](../section-lujvo#example-random-id-KQ4s) is

<div class="lujvo-example example">
<a id="example-random-id-TCUH"></a>

**Example 4.25. <a id="c4e5d7"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">mampa'u</p></td></tr></tbody></table>

</div>  

which refers specifically to the concept “maternal grandfather”. The two gismu that constitute the tanru are represented in _mampa'u_ by the rafsi _mam-_ and _\-pa'u_ , respectively; these two rafsi are then concatenated together to form _mampa'u_.

<a id="id-1.5.7.25.1" class="indexterm"></a><a id="id-1.5.7.25.2" class="indexterm"></a><a id="id-1.5.7.25.3" class="indexterm"></a><a id="id-1.5.7.25.4" class="indexterm"></a><a id="id-1.5.7.25.5" class="indexterm"></a>Like gismu, lujvo have only one meaning. When a lujvo is formally entered into a dictionary of the language, a specific definition will be assigned based on one particular interrelationship between the terms. (See [Chapter 12](../chapter-lujvo) for how this has been done.) Unlike gismu, lujvo may have more than one form. This is because there is no difference in meaning between the various rafsi for a gismu when they are used to build a lujvo. A long rafsi may be used, especially in noisy environments, in place of a short rafsi; the result is considered the same lujvo, even though the word is spelled and pronounced differently. Thus the word _<a id="id-1.5.7.25.7.1" class="indexterm"></a>[_brivla_](../go01#valsi-brivla)_ , built from the tanru _<a id="id-1.5.7.25.8.1" class="indexterm"></a>bridi valsi_ , is the same lujvo as _brivalsi_ , _bridyvla_ , and _bridyvalsi_ , each of which uses a different combination of rafsi.

<a id="id-1.5.7.26.1" class="indexterm"></a><a id="id-1.5.7.26.2" class="indexterm"></a><a id="id-1.5.7.26.3" class="indexterm"></a><a id="id-1.5.7.26.4" class="indexterm"></a><a id="id-1.5.7.26.5" class="indexterm"></a>When assembling rafsi together into lujvo, the rules for valid brivla must be followed: a consonant cluster must occur in the first five letters (excluding _y_ and _'_), and the lujvo must end in a vowel.

<a id="id-1.5.7.27.1" class="indexterm"></a><a id="id-1.5.7.27.2" class="indexterm"></a><a id="id-1.5.7.27.3" class="indexterm"></a>A _y_ (which is ignored in determining stress or consonant clusters) is inserted in the middle of the consonant cluster to glue the word together when the resulting cluster is either not permissible or the word is likely to break up. There are specific rules describing these conditions, detailed in [Section 4.6](../section-rafsi).

<a id="id-1.5.7.28.1" class="indexterm"></a><a id="id-1.5.7.28.2" class="indexterm"></a><a id="id-1.5.7.28.3" class="indexterm"></a><a id="id-1.5.7.28.4" class="indexterm"></a>An _r_ (in some cases, an _n_) is inserted when a CVV-form rafsi attaches to the beginning of a lujvo in such a way that there is no consonant cluster. For example, in the lujvo

<div class="lujvo-example example">
<a id="example-random-id-3Qtv"></a>

**Example 4.26. <a id="id-1.5.7.29.1.1" class="indexterm"></a><a id="c4e5d8"></a>** 

<table class="lujvo-making"><colgroup></colgroup><tbody><tr><td><p class="jbo">soirsai</p></td></tr><tr><td><p>from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.7.29.2.3.1.1.1.1" class="indexterm"></a>sonci sanmi</em></span></p></td></tr><tr><td><p class="gloss"><span class="quote">“<span class="quote">soldier meal</span>”</span></p></td></tr><tr><td><p class="natlang">field rations</p></td></tr></tbody></table>

</div>  

<a id="id-1.5.7.30.1" class="indexterm"></a><a id="id-1.5.7.30.2" class="indexterm"></a>the rafsi _soi-_ and _\-sai_ are joined, with the additional _r_ making up the _rs_ consonant pair needed to make the word a brivla. Without the _r_ , the word would break up into _<a id="id-1.5.7.30.8.1" class="indexterm"></a>soi sai_ , two cmavo. The pair of cmavo have no relation to their rafsi lookalikes; they will either be ungrammatical (as in this case), or will express a different meaning from what was intended.

Learning rafsi and the rules for assembling them into lujvo is clearly seen to be necessary for fully using the potential Lojban vocabulary.

<a id="id-1.5.7.32.1" class="indexterm"></a>Most important, it is possible to invent new lujvo while you speak or write in order to represent a new or unfamiliar concept, one for which you do not know any existing Lojban word. As long as you follow the rules for building these compounds, there is a good chance that you will be understood without explanation.