<a id="section-lujvo-meanings"></a>12.3. <a id="c12s3"></a>The meaning of lujvo
-------------------------------------------------------------------------------

This is a fairly long way to go to try and work out how to say “doghouse” ! The reader can take heart; we're nearly there. Recall that one of the components involved in fixing the meaning of a tanru – the one left deliberately vague – is the precise relation between the tertau and the seltau. Indeed, fixing this relation is tantamount to giving an interpretation to the ambiguous tanru.

<a id="id-1.13.5.3.1" class="indexterm"></a><a id="id-1.13.5.3.2" class="indexterm"></a><a id="id-1.13.5.3.3" class="indexterm"></a>A lujvo is defined by a single disambiguated instance of a tanru. That is to say, when we try to design the place structure of a lujvo, we don't need to try to discover the relation between the tertau and the seltau. We already know what kind of relation we're looking for; it's given by the specific need we wish to express, and it determines the place structure of the lujvo itself.

Therefore, it is generally not appropriate to simply devise lujvo and decide on place structures for them without considering one or more specific usages for the coinage. If one does not consider specifics, one will be likely to make erroneous generalizations on the relationship r.

<a id="id-1.13.5.5.1" class="indexterm"></a>The insight driving the rest of this chapter is this: while the relation expressed by a tanru can be very distant (e.g. Spot chasing Socks, above), the relationship singled out for disambiguation in a lujvo should be quite close. This is because lujvo-making, paralleling natural language compounding, picks out the most salient relationship r between a tertau place and a seltau place to be expressed in a single word. The relationship “dog chases cat owned by daughter of person living in house” is too distant, and too incidental, to be likely to need expression as a single short word; the relationship “dog lives in house” is not. From all the various interpretations of _<a id="id-1.13.5.5.4.1" class="indexterm"></a>gerku zdani_ , the person creating _<a id="id-1.13.5.5.5.1" class="indexterm"></a>[_gerzda_](../go01#valsi-gerzda)_ should pick the most useful value of r. The most useful one is usually going to be the most obvious one, and the most obvious one is usually the closest one.

In fact, the relationship will almost always be so close that the predicate expressing r will be either the seltau or the tertau predicate itself. This should come as no surprise, given that a word like _<a id="id-1.13.5.6.1.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ in Lojban is a predicate. Predicates express relations; so when you're looking for a relation to tie together _<a id="id-1.13.5.6.2.1" class="indexterm"></a>le zdani_ and _<a id="id-1.13.5.6.3.1" class="indexterm"></a>le gerku_ , the most obvious relation to pick is the very relation named by the tertau, _<a id="id-1.13.5.6.4.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ : the relation between a home and its dweller. As a result, the object which fills the first place of _<a id="id-1.13.5.6.5.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_ (the dog) also fills the second place of _<a id="id-1.13.5.6.6.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ (the house-dweller).

<a id="id-1.13.5.7.1" class="indexterm"></a>The seltau-tertau relationship in the veljvo is expressed by the seltau or tertau predicate itself. Therefore, at least one of the seltau places is going to be equivalent to a tertau place. This place is thus redundant, and can be dropped from the place structure of the lujvo. As a corollary, the precise relationship between the veljvo components can be implicitly determined by finding one or more places to overlap in this way.

So what is the place structure of _<a id="id-1.13.5.8.1.1" class="indexterm"></a>[_gerzda_](../go01#valsi-gerzda)_ ? We're left with three places, since the dweller, the _<a id="id-1.13.5.8.2.1" class="indexterm"></a>se zdani_ , turned out to be identical to the dog, the _<a id="id-1.13.5.8.3.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_. We can proceed as follows:

<a id="id-1.13.5.9.1" class="indexterm"></a>(The notation introduced casually in [Section 12.2](../section-tanru-meanings) will be useful in the rest of this chapter. Rather than using the regular x1, x2, etc. to represent places, we'll use the first letter of the relevant gismu in place of the “x” , or more than one letter where necessary to resolve ambiguities. Thus, z1 is the first place of _<a id="id-1.13.5.9.6.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ , and g2 is the second place of _<a id="id-1.13.5.9.7.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_.)

<a id="id-1.13.5.10.1" class="indexterm"></a><a id="id-1.13.5.10.2" class="indexterm"></a>The place structure of _<a id="id-1.13.5.10.3.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ is given as [Example 12.3](../section-tanru-meanings#example-random-id-xcfi) , but is repeated here using the new notation:

<div class="example">
<a id="example-random-id-95t5"></a>

**Example 12.6. <a id="c12e3d1"></a>** 

> z1 is a nest/house/lair/den of z2

</div>  

The place structure of _<a id="id-1.13.5.12.1.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_ is:

<div class="example">
<a id="example-random-id-H4ed"></a>

**Example 12.7. <a id="c12e3d2"></a>** 

> g1 is a dog of breed g2

</div>  

But z2 is the same as g1; therefore, the tentative place structure for _<a id="id-1.13.5.14.1.1" class="indexterm"></a>[_gerzda_](../go01#valsi-gerzda)_ now becomes:

<div class="example">
<a id="example-random-id-VHXr"></a>

**Example 12.8. <a id="c12e3d3"></a>** 

> z1 is a house for dweller z2 of breed g2

</div>  

which can also be written

<div class="example">
<a id="example-random-id-MnKf"></a>

**Example 12.9. <a id="c12e3d4"></a>** 

> z1 is a house for dog g1 of breed g2

</div>  

or more comprehensively

<div class="example">
<a id="example-random-id-Wx42"></a>

**Example 12.10. <a id="c12e3d5"></a><a id="id-1.13.5.19.1.2" class="indexterm"></a>** 

> z1 is a house for dweller/dog z2=g1 of breed g2

</div>  

Despite the apparently conclusive nature of [Example 12.10](../section-lujvo-meanings#example-random-id-Wx42) , our task is not yet done: we still need to decide whether any of the remaining places should also be eliminated, and what order the lujvo places should appear in. These concerns will be addressed in the remainder of the chapter; but we are now equipped with the terminology needed for those discussions.