<a id="section-lujvo-making-examples"></a>4.13. <a id="c4s13"></a>lujvo-making examples
---------------------------------------------------------------------------------------

<a id="id-1.5.15.2.1" class="indexterm"></a>This section contains examples of making and scoring lujvo. First, we will start with the tanru _<a id="id-1.5.15.2.2.1" class="indexterm"></a>gerku zdani_ ( “dog house”) and construct a lujvo meaning “doghouse” , that is, a house where a dog lives. We will use a brute-force application of the algorithm in [Section 4.12](../section-lujvo-scoring) , using every possible rafsi.

The rafsi for _<a id="id-1.5.15.3.1.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_ are:

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ger-</em></span> ,</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ge'u-</em></span> ,</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gerk-</em></span> ,</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gerku</em></span></td></tr></tbody></table>

The rafsi for _<a id="id-1.5.15.5.1.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ are:

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-zda-</em></span> ,</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-zdan-</em></span> ,</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-zdani</em></span>.</td></tr></tbody></table>

Step 1 of the algorithm directs us to use _\-ger-_ , _\-ge'u-_ and _\-gerk-_ as possible rafsi for _<a id="id-1.5.15.7.4.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_ ; Step 2 directs us to use _\-zda-_ and _\-zdani_ as possible rafsi for _<a id="id-1.5.15.7.7.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_. The six possible forms of the lujvo are then:

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ger</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-zda</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ger</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-zdani</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ge'u</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-zda</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">ge'u</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-zdani</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">gerk</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-zda</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">gerk</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-zdani</em></span></td></tr></tbody></table>

We must then insert appropriate hyphens in each case. The first two forms need no hyphenation: _<a id="id-1.5.15.9.1.1" class="indexterm"></a>[_ge_](../go01#valsi-ge)_ cannot fall off the front, because the following word would begin with _rz_ , which is not a permissible initial consonant pair. So the lujvo forms are _<a id="id-1.5.15.9.3.1" class="indexterm"></a>[_gerzda_](../go01#valsi-gerzda)_ and _gerzdani_.

The third form, _ge'u_ _\-zda_ , needs no hyphen, because even though the first rafsi is CVV, the second one is CCV, so there is a consonant cluster in the first five letters. So _ge'uzda_ is this form of the lujvo.

The fourth form, _ge'u-zdani_ , however, requires an r-hyphen; otherwise, the _ge'u-_ part would fall off as a cmavo. So this form of the lujvo is _ge'urzdani_.

The last two forms require y-hyphens, as all 4-letter rafsi do, and so are _gerkyzda_ and _gerkyzdani_ respectively.

<a id="id-1.5.15.13.1" class="indexterm"></a>The scoring algorithm is heavily weighted in favor of short lujvo, so we might expect that _<a id="id-1.5.15.13.2.1" class="indexterm"></a>[_gerzda_](../go01#valsi-gerzda)_ would win. Its L score is 6, its A score is 0, its H score is 0, its R score is 12, and its V score is 3, for a final score of 5878. The other forms have scores of 7917, 6367, 9506, 8008, and 10047 respectively. Consequently, this lujvo would probably appear in the dictionary in the form _<a id="id-1.5.15.13.8.1" class="indexterm"></a>[_gerzda_](../go01#valsi-gerzda)_.

For the next example, we will use the tanru _<a id="id-1.5.15.14.1.1" class="indexterm"></a>bloti klesi_ ( “boat class”) presumably referring to the category (rowboat, motorboat, cruise liner) into which a boat falls. We will omit the long rafsi from the process, since lujvo containing long rafsi are almost never preferred by the scoring algorithm when there are short rafsi available.

The rafsi for _<a id="id-1.5.15.15.1.1" class="indexterm"></a>[_bloti_](../go01#valsi-bloti)_ are _\-lot-_ , _\-blo-_ , and _\-lo'i-_ ; for _<a id="id-1.5.15.15.5.1" class="indexterm"></a>[_klesi_](../go01#valsi-klesi)_ they are _\-kle-_ and _\-lei-_. Both these gismu are among the handful which have both CVV-form and CCV-form rafsi, so there is an unusual number of possibilities available for a two-part tanru:

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lotkle</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">blokle</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lo'ikle</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lotlei</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.15.16.5.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-blolei"><em class="glossterm">blolei</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lo'irlei</em></span></td></tr></tbody></table>

Only _lo'irlei_ requires hyphenation (to avoid confusion with the cmavo sequence _<a id="id-1.5.15.17.2.1" class="indexterm"></a>lo'i lei_). All six forms are valid versions of the lujvo, as are the six further forms using long rafsi; however, the scoring algorithm produces the following results:

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lotkle</em></span></td><td>5878</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">blokle</em></span></td><td>5858</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lo'ikle</em></span></td><td>6367</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lotlei</em></span></td><td>5867</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.15.18.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-blolei"><em class="glossterm">blolei</em></a></em></span></td><td>5847</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lo'irlei</em></span></td><td>7456</td></tr></tbody></table>

<a id="id-1.5.15.19.1" class="indexterm"></a>So the form _<a id="id-1.5.15.19.2.1" class="indexterm"></a>[_blolei_](../go01#valsi-blolei)_ is preferred, but only by a tiny margin over _blokle_ ; "lotlei" and "lotkle" are only slightly worse; _lo'ikle_ suffers because of its apostrophe, and _lo'irlei_ because of having both apostrophe and hyphen.

Our third example will result in forming both a lujvo and a cmevla from the tanru _<a id="id-1.5.15.20.1.1" class="indexterm"></a>logji bangu girzu_ , or “logical-language group” in English. ( “The Logical Language Group” is the name of the publisher of this book and the organization for the promotion of Lojban.)

The available rafsi are _\-loj-_ and _\-logj-_ ; _\-ban-_ , _\-bau-_ , and _\-bang-_ ; and _\-gri-_ and _\-girzu_ , and (for cmevla purposes only) _\-gir-_ and _\-girz-_. The resulting 12 lujvo possibilities are:

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">loj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ban</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gri</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">loj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bau</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gri</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">loj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bang</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gri</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ban</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gri</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bau</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gri</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bang</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gri</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">loj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ban</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-girzu</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">loj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bau</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-girzu</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">loj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bang</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-girzu</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ban</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-girzu</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bau</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-girzu</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bang</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-girzu</em></span></td></tr></tbody></table>

and the 12 cmevla possibilities are:

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">loj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ban</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gir</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">loj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bau</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gir</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">loj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bang</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gir</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ban</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gir</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bau</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gir</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bang</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-gir</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">loj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ban</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-girz</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">loj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bau</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-girz</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">loj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bang</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-girz</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ban</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-girz</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bau</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-girz</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logj</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-bang</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-girz</em></span></td></tr></tbody></table>

After hyphenation, we have:

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lojbangri</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lojbaugri</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lojbangygri</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logjybangri</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logjybaugri</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logjybangygri</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lojbangirzu</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lojbaugirzu</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lojbangygirzu</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logjybangirzu</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logjybaugirzu</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logjybangygirzu</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lojbangir</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lojbaugir</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lojbangygir</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logjybangir</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logjybaugir</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logjybangygir</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.15.26.19.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-lojbangirz"><em class="glossterm">lojbangirz</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lojbaugirz</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lojbangygirz</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logjybangirz</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logjybaugirz</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">logjybangygirz</em></span></td></tr></tbody></table>

<a id="id-1.5.15.27.1" class="indexterm"></a><a id="id-1.5.15.27.2" class="indexterm"></a>The only fully reduced lujvo forms are _lojbangri_ and _<a id="id-1.5.15.27.4.1" class="indexterm"></a>[_lojbaugri_](../go01#valsi-lojbaugri)_ , of which the latter has a slightly lower score: 8827 versus 8796, respectively. However, for the name of the organization, we chose to make sure the name of the language was embedded in it, and to use the clearer long-form rafsi for _<a id="id-1.5.15.27.5.1" class="indexterm"></a>[_girzu_](../go01#valsi-girzu)_ , producing _.lojbangirz._

Finally, here is a four-part lujvo with a cmavo in it, based on the tanru _<a id="id-1.5.15.28.1.1" class="indexterm"></a>nakni ke cinse ctuca_ or “male (sexual teacher)”. The _<a id="id-1.5.15.28.3.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ cmavo ensures the interpretation “teacher of sexuality who is male” , rather than “teacher of male sexuality”. Here are the possible forms of the lujvo, both before and after hyphenation:

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nak</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-kem</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-cin</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ctu</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.15.29.2.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-nakykemcinctu"><em class="glossterm">nakykemcinctu</em></a></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nak</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-kem</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-cin</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ctuca</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nakykemcinctuca</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nak</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-kem</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-cins</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ctu</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nakykemcinsyctu</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nak</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-kem</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-cins</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ctuca</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nakykemcinsyctuca</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nakn</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-kem</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-cin</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ctu</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">naknykemcinctu</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nakn</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-kem</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-cin</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ctuca</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">naknykemcinctuca</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nakn</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-kem</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-cins</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ctu</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">naknykemcinsyctu</em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nakn</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-kem</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-cins</em> </span><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">-ctuca</em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">naknykemcinsyctuca</em></span></td></tr></tbody></table>

<a id="id-1.5.15.30.1" class="indexterm"></a>Of these forms, _<a id="id-1.5.15.30.2.1" class="indexterm"></a>[_nakykemcinctu_](../go01#valsi-nakykemcinctu)_ is the shortest and is preferred by the scoring algorithm. On the whole, however, it might be better to just make a lujvo for _<a id="id-1.5.15.30.3.1" class="indexterm"></a>cinse ctuca_ (which would be _cinctu_) since the sex of the teacher is rarely important. If there was a reason to specify “male” , then the simpler tanru _<a id="id-1.5.15.30.6.1" class="indexterm"></a>nakni cinctu_ ( “male sexual-teacher”) would be appropriate. This tanru is actually shorter than the four-part lujvo, since the _<a id="id-1.5.15.30.8.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ required for grouping need not be expressed.