<a id="section-lujvo-considerations"></a>4.10. <a id="c4s10"></a>Considerations for making lujvo
------------------------------------------------------------------------------------------------

Given a tanru which expresses an idea to be used frequently, it can be turned into a lujvo by following the lujvo-making algorithm which is given in [Section 4.11](../section-lujvo-making).

In building a lujvo, the first step is to replace each gismu with a rafsi that uniquely represents that gismu. These rafsi are then attached together by fixed rules that allow the resulting compound to be recognized as a single word and to be analyzed in only one way.

There are three other complications; only one is serious.

<a id="id-1.5.12.5.1" class="indexterm"></a>The first is that there is usually more than one rafsi that can be used for each gismu. The one to be used is simply whichever one sounds or looks best to the speaker or writer. There are usually many valid combinations of possible rafsi. They all are equally valid, and all of them mean exactly the same thing. (The scoring algorithm given in [Section 4.12](../section-lujvo-scoring) is used to choose the standard form of the lujvo – the version which would be entered into a dictionary.)

<a id="id-1.5.12.6.1" class="indexterm"></a><a id="id-1.5.12.6.2" class="indexterm"></a><a id="id-1.5.12.6.3" class="indexterm"></a>The second complication is the serious one. Remember that a tanru is ambiguous – it has several possible meanings. A lujvo, or at least one that would be put into the dictionary, has just a single meaning. Like a gismu, a lujvo is a predicate which encompasses one area of the semantic universe, with one set of places. Hopefully the meaning chosen is the most useful of the possible semantic spaces. A possible source of linguistic drift in Lojban is that as Lojbanic society evolves, the concept that seems the most useful one may change.

<a id="id-1.5.12.7.1" class="indexterm"></a><a id="id-1.5.12.7.2" class="indexterm"></a>You must also be aware of the possibility of some prior meaning of a new lujvo, especially if you are writing for posterity. If a lujvo is invented which involves the same tanru as one that is in the dictionary, and is assigned a different meaning (or even just a different place structure), linguistic drift results. This isn't necessarily bad. Every natural language does it. But in communication, when you use a meaning different from the dictionary definition, someone else may use the dictionary and therefore misunderstand you. You can use the cmavo _<a id="id-1.5.12.7.3.1" class="indexterm"></a>[_za'e_](../go01#valsi-zahe)_ (explained in [Section 19.11](../section-bahe)) before a newly coined lujvo to indicate that it may have a non-dictionary meaning.

<a id="id-1.5.12.8.1" class="indexterm"></a>The essential nature of human communication is that if the listener understands, then all is well. Let this be the ultimate guideline for choosing meanings and place structures for invented lujvo.

<a id="id-1.5.12.9.1" class="indexterm"></a><a id="id-1.5.12.9.2" class="indexterm"></a>The third complication is also simple, but tends to scare new Lojbanists with its implications. It is based on Zipf's Law, which says that the length of words is inversely proportional to their usage. The shortest words are those which are used more; the longest ones are used less. Conversely, commonly used concepts will be tend to be abbreviated. In English, we have abbreviations and acronyms and jargon, all of which represent complex ideas that are used often by small groups of people, so they shortened them to convey more information more rapidly.

Therefore, given a complicated tanru with grouping markers, abstraction markers, and other cmavo in it to make it syntactically unambiguous, the psychological basis of Zipf's Law may compel the lujvo-maker to drop some of the cmavo to make a shorter (technically incorrect) tanru, and then use that tanru to make the lujvo.

<a id="id-1.5.12.11.1" class="indexterm"></a>This doesn't lead to ambiguity, as it might seem to. A given lujvo still has exactly one meaning and place structure. It is just that more than one tanru is competing for the same lujvo. But more than one meaning for the tanru was already competing for the “right” to define the meaning of the lujvo. Someone has to use judgment in deciding which one meaning is to be chosen over the others.

<a id="id-1.5.12.12.1" class="indexterm"></a><a id="id-1.5.12.12.2" class="indexterm"></a>If the lujvo made by a shorter form of tanru is in use, or is likely to be useful for another meaning, the decider then retains one or more of the cmavo, preferably ones that set this meaning apart from the shorter form meaning that is used or anticipated. As a rule, therefore, the shorter lujvo will be used for a more general concept, possibly even instead of a more frequent word. If both words are needed, the simpler one should be shorter. It is easier to add a cmavo to clarify the meaning of the more complex term than it is to find a good alternate tanru for the simpler term.

<a id="id-1.5.12.13.1" class="indexterm"></a><a id="id-1.5.12.13.2" class="indexterm"></a>And of course, we have to consider the listener. On hearing an unknown word, the listener will decompose it and get a tanru that makes no sense or the wrong sense for the context. If the listener realizes that the grouping operators may have been dropped out, he or she may try alternate groupings, or try inserting an abstraction operator if that seems plausible. (The grouping of tanru is explained in [Chapter 5](../chapter-selbri) ; abstraction is explained in [Chapter 11](../chapter-abstractions).) Plausibility is the key to learning new ideas and to evaluating unfamiliar lujvo.