<a id="section-lojban-characters"></a>3.3. <a id="c3s3"></a>The special Lojban characters
-----------------------------------------------------------------------------------------

<a id="id-1.4.5.2.1" class="indexterm"></a>The apostrophe, period, and comma need special attention. They are all used as indicators of a division between syllables, but each has a different pronunciation, and each is used for different reasons:

<a id="id-1.4.5.3.1" class="indexterm"></a><a id="id-1.4.5.3.2" class="indexterm"></a><a id="id-1.4.5.3.3" class="indexterm"></a>The apostrophe represents a phoneme similar to a short, breathy English “h” , (IPA \[h\]). The letter “h” is not used to represent this sound for two reasons: primarily in order to simplify explanations of the morphology, but also because the sound is very common, and the apostrophe is a visually lightweight representation of it. The apostrophe sound is a consonant in nature, but is not treated as either a consonant or a vowel for purposes of Lojban morphology (word-formation), which is explained in [Chapter 4](../chapter-morphology). In addition, the apostrophe visually parallels the comma and the period, which are also used (in different ways) to separate syllables.

<a id="id-1.4.5.4.1" class="indexterm"></a><a id="id-1.4.5.4.2" class="indexterm"></a>The apostrophe is included in Lojban only to enable a smooth transition between vowels, while joining the vowels within a single word. In fact, one way to think of the apostrophe is as representing an unvoiced vowel glide.

<a id="id-1.4.5.5.1" class="indexterm"></a>As a permitted variant, any unvoiced fricative other than those already used in Lojban may be used to render the apostrophe: IPA \[θ\] is one possibility. The convenience of the listener should be regarded as paramount in deciding to use a substitute for \[h\].

<a id="id-1.4.5.6.1" class="indexterm"></a><a id="id-1.4.5.6.2" class="indexterm"></a><a id="id-1.4.5.6.3" class="indexterm"></a>The period represents a mandatory pause, with no specified length; a glottal stop (IPA \[ʔ\]) is considered a pause of shortest length. A pause (or glottal stop) may appear between any two words, and in certain cases – explained in detail in [Section 4.9](../section-pauses) – must occur. In particular, a word beginning with a vowel is always preceded by a pause, and a word ending in a consonant is always surrounded by pauses.

<a id="id-1.4.5.7.1" class="indexterm"></a>Technically, the period is an optional reminder to the reader of a mandatory pause that is dictated by the rules of the language; because these rules are unambiguous, a missing period can be inferred from otherwise correct text. Periods are included only as an aid to the reader.

<a id="id-1.4.5.8.1" class="indexterm"></a>A period also may be found apparently embedded in a word. When this occurs, such a written string is not one word but two, written together to indicate that the writer intends a unitary meaning for the compound. It is not really necessary to use a space between words if a period appears.

<a id="id-1.4.5.9.1" class="indexterm"></a><a id="id-1.4.5.9.2" class="indexterm"></a><a id="id-1.4.5.9.3" class="indexterm"></a><a id="id-1.4.5.9.4" class="indexterm"></a>The comma is used to indicate a syllable break within a word, generally one that is not obvious to the reader. Such a comma is written to separate syllables, but indicates that there must be no pause between them, in contrast to the period. Between two vowels, a comma indicates that some type of glide may be necessary to avoid a pause that would split the two syllables into separate words. It is always legal to use the apostrophe (IPA \[h\]) sound in pronouncing a comma. However, a comma cannot be pronounced as a pause or glottal stop between the two letters separated by the comma, because that pronunciation would split the word into two words.

<a id="id-1.4.5.10.1" class="indexterm"></a><a id="id-1.4.5.10.2" class="indexterm"></a>Otherwise, a comma is usually only used to clarify the presence of syllabic _l_ , _m_ , _n_ , or _r_ (discussed later). Commas are never required: no two Lojban words differ solely because of the presence or placement of a comma.

<a id="id-1.4.5.11.1" class="indexterm"></a>Here is a somewhat artificial example of the difference in pronunciation between periods, commas and apostrophes. In the English song about Old MacDonald's Farm, the vowel string which is written as “ee-i-ee-i-o” in English could be Lojbanized with periods as:

<div class="pronunciation-example example">
<a id="example-random-id-k2B4"></a>

**Example 3.1. <a id="id-1.4.5.12.1.1" class="indexterm"></a><a id="c3e3d1"></a>** 

*   .i.ai.i.ai.o

*   \[ʔi ʔaj ʔi ʔaj ʔo\]

*   Ee! Eye! Ee! Eye! Oh!

</div>  

However, this would sound clipped, staccato, and unmusical compared to the English. Furthermore, although [Example 3.1](../section-lojban-characters#example-random-id-k2B4) is a string of meaningful Lojban words, as a sentence it makes very little sense. (Note the use of periods embedded within the written word.)

<a id="id-1.4.5.14.1" class="indexterm"></a>If commas were used instead of periods, we could represent the English string as a Lojbanized name, ending in a consonant:

<div class="pronunciation-example example">
<a id="example-random-id-k2b9"></a>

**Example 3.2. <a id="c3e3d2"></a>** 

*   .i,ai,i,ai,on.

*   \[ʔi jaj ji jaj jonʔ\]

</div>  

<a id="id-1.4.5.16.1" class="indexterm"></a>The commas represent new syllable breaks, but prohibit the use of pauses or glottal stop. The pronunciation shown is just one possibility, but closely parallels the intended English pronunciation.

However, the use of commas in this way is risky to unambiguous interpretation, since the glides might be heard by some listeners as diphthongs, producing something like

<div class="pronunciation-example example">
<a id="example-random-id-dQfn"></a>

**Example 3.3. <a id="c3e3d3"></a>** 

*   .i,iai,ii,iai,ion.

</div>  

which is technically a different Lojban name. Since the intent with Lojbanized names is to allow them to be pronounced more like their native counterparts, the comma is allowed to represent vowel glides or some non-Lojbanic sound. Such an exception affects only spelling accuracy and the ability of a reader to replicate the desired pronunciation exactly; it will not affect the recognition of word boundaries.

<a id="id-1.4.5.20.1" class="indexterm"></a>Still, it is better if Lojbanized names are always distinct. Therefore, the apostrophe is preferred in regular Lojbanized names that are not attempting to simulate a non-Lojban pronunciation perfectly. (Perfection, in any event, is not really achievable, because some sounds simply lack reasonable Lojbanic counterparts.)

If apostrophes were used instead of commas in [Example 3.2](../section-lojban-characters#example-random-id-k2b9) , it would appear as:

<div class="pronunciation-example example">
<a id="example-random-id-k2bc"></a>

**Example 3.4. <a id="c3e3d4"></a>** 

*   .i'ai'i'ai'on.

*   \[ʔi hai hi hai honʔ\]

</div>  

<a id="id-1.4.5.23.1" class="indexterm"></a>which preserves the rhythm and length, if not the exact sounds, of the original English.