<a id="section-intensity-scale"></a>13.4. <a id="c13s4"></a>Attitudes as scales
-------------------------------------------------------------------------------

<a id="id-1.14.6.2.1" class="indexterm"></a><a id="id-1.14.6.2.2" class="indexterm"></a><a id="id-1.14.6.2.3" class="indexterm"></a><a id="id-1.14.6.2.4" class="indexterm"></a>In Lojban, all emotions and attitudes are scales. These scales run from some extreme value (which we'll call “positive”) to an opposite extreme (which we'll call “negative”). In the tables above, we have seen three points on the scale: “positive” , neutral, and “negative”. The terms “positive” and “negative” are put into quotation marks because they are loaded words when applied to emotions, and the attitudinal system reflects this loading, which is a known cultural bias. Only two of the “positive” words, namely _<a id="id-1.14.6.2.12.1" class="indexterm"></a>[_.ii_](../go01#valsi-ii)_ (fear) and _<a id="id-1.14.6.2.13.1" class="indexterm"></a>[_.oi_](../go01#valsi-oi)_ (pain/complaint), represent emotions commonly thought of as less “virtuous” in most cases than their negative counterparts. But these two were felt to be instinctive, distinct, and very powerful emotions that needed to be expressible in a monosyllable when necessary, while their counterparts are less commonly expressed.

<a id="id-1.14.6.3.1" class="indexterm"></a>(Why the overt bias? Because there are a lot of attitudinals and they will be difficult to learn as an entire set. By aligning our scales arbitrarily, we give the monosyllable _<a id="id-1.14.6.3.2.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ a useful meaning and make it easier for a novice to recognize at least the positive or negative alignment of an indicator, if not the specific word. Other choices considered were “random” orientation, which would have unknown biases and be difficult to learn, and orientation based on our guesses as to which scale orientations made the most frequent usages shorter, which would be biased in favor of American perceptions of “usefulness”. If bias must exist in our indicator set, it might as well be a known bias that eases learning, and in addition might as well favor a harmonious and positive world-view.)

<a id="id-1.14.6.4.1" class="indexterm"></a><a id="id-1.14.6.4.2" class="indexterm"></a>In fact, though, each emotional scale has seven positions defined, three “positive” ones (shown below on the left), three “negative” ones (shown below on the right), and a neutral one indicating that no particular attitude on this scale is felt. The following chart indicates the seven positions of the scale and the associated cmavo. All of these cmavo, except _<a id="id-1.14.6.4.5.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ , are in selma'o CAI.

<table class="rotated"><colgroup></colgroup><tbody><tr><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td>cai</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.6.5.2.1.1.2.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-carmi"><em class="glossterm">carmi</em></a></em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td>sai</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.6.5.2.2.1.2.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-tsali"><em class="glossterm">tsali</em></a></em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td>ru'e</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.6.5.2.3.1.2.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ruble"><em class="glossterm">ruble</em></a></em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td>cu'i</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.6.5.2.4.1.2.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-cumki"><em class="glossterm">cumki</em></a></em></span></td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td>nairu'e</td></tr><tr><td>-</td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td>naisai</td></tr><tr><td>-</td></tr></tbody></table></td><td><table border="0" summary="Simple list" class="simplelist"><tbody><tr><td>naicai</td></tr><tr><td>-</td></tr></tbody></table></td></tr></tbody></table>

<a id="id-1.14.6.6.1" class="indexterm"></a><a id="id-1.14.6.6.2" class="indexterm"></a>A scalar attitude is expressed by using the attitudinal word, and then following it by the desired scalar intensity. The bias creeps in because the “negative” emotions take the extra syllable _<a id="id-1.14.6.6.4.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ to indicate their negative position on the axis, and thus require a bit more effort to express.

<a id="id-1.14.6.7.1" class="indexterm"></a>Much of this system is optional. You can express an attitude without a scale indicator, if you don't want to stop and think about how strongly you feel. Indeed, for most attitudinals, we've found that either no scalar value is used, or _<a id="id-1.14.6.7.2.1" class="indexterm"></a>[_cai_](../go01#valsi-cai)_ is used to indicate especially high intensity. Less often, _<a id="id-1.14.6.7.3.1" class="indexterm"></a>[_ru'e_](../go01#valsi-ruhe)_ is used for a recognizably weak intensity, and _<a id="id-1.14.6.7.4.1" class="indexterm"></a>[_cu'i_](../go01#valsi-cuhi)_ is used in response to the attitudinal question _<a id="id-1.14.6.7.5.1" class="indexterm"></a>[_pei_](../go01#valsi-pei)_ (see [Section 13.10](../section-questions-empathy-contours)) to indicate that the emotion is not felt.

<a id="id-1.14.6.8.1" class="indexterm"></a>The following shows the variations resulting from intensity variation:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qfUc"></a>

**Example 13.42. <a id="c13e4d1"></a><a id="id-1.14.6.9.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ei</td></tr><tr class="gloss"><td>[obligation]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I ought to</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">(a non-specific obligation)</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFUR"></a>

**Example 13.43. <a id="c13e4d2"></a><a id="id-1.14.6.10.1.2" class="indexterm"></a><a id="id-1.14.6.10.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.eicai</td></tr><tr class="gloss"><td>[obligation-maximal]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I shall/must</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">(an intense obligation or requirement, possibly a formal one)</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfuy"></a>

**Example 13.44. <a id="c13e4d3"></a><a id="id-1.14.6.11.1.2" class="indexterm"></a><a id="id-1.14.6.11.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.eisai</td></tr><tr class="gloss"><td>[obligation-strong]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I should</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">(a strong obligation or necessity, possibly an implied but not formal requirement)</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfvL"></a>

**Example 13.45. <a id="c13e4d4"></a><a id="id-1.14.6.12.1.2" class="indexterm"></a><a id="id-1.14.6.12.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.eiru'e</td></tr><tr class="gloss"><td>[obligation-weak]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I might</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">(a weak obligation – in English often mixed with permission and desire)</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qfvn"></a>

**Example 13.46. <a id="c13e4d5"></a><a id="id-1.14.6.13.1.2" class="indexterm"></a><a id="id-1.14.6.13.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.eicu'i</td></tr><tr class="gloss"><td>[obligation-neutral]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">No matter</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">(no particular obligation)</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFw3"></a>

**Example 13.47. <a id="c13e4d6"></a><a id="id-1.14.6.14.1.2" class="indexterm"></a><a id="id-1.14.6.14.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.einai</td></tr><tr class="gloss"><td>[obligation-not]</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I need not</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">(a non-obligation)</p></td></tr></tbody></table>

</div>  

<a id="id-1.14.6.15.1" class="indexterm"></a><a id="id-1.14.6.15.2" class="indexterm"></a><a id="id-1.14.6.15.3" class="indexterm"></a><a id="id-1.14.6.15.4" class="indexterm"></a><a id="id-1.14.6.15.5" class="indexterm"></a><a id="id-1.14.6.15.6" class="indexterm"></a>You can also utter a scale indicator without a specific emotion. This is often used in the language: in order to emphasize a point about which you feel strongly, you mark what you are saying with the scale indicator _<a id="id-1.14.6.15.7.1" class="indexterm"></a>[_cai_](../go01#valsi-cai)_. You could also indicate that you don't care using _<a id="id-1.14.6.15.8.1" class="indexterm"></a>[_cu'i_](../go01#valsi-cuhi)_ by itself.