<a id="section-implicit-abstraction"></a>12.13. <a id="c12s13"></a>Implicit-abstraction lujvo
---------------------------------------------------------------------------------------------

Eliding NU rafsi involves the same restrictions as eliding SE rafsi, plus additional ones. In general, NU rafsi should not be elided from the tertau, since that changes the kind of thing the lujvo is talking about from an abstraction to a concrete sumti. However, they may be elided from the seltau if no reasonable ambiguity would result.

A major difference, however, between SE elision and NU elision is that the former is a rather sparse process, providing a few convenient shortenings. Eliding _<a id="id-1.13.15.3.1.1" class="indexterm"></a>[_nu_](../go01#valsi-nu)_ , however, is extremely important in producing a class of lujvo called “implicit-abstraction lujvo”.

Let us make a detailed analysis of the lujvo _nunctikezgau_ , meaning “to feed”. (If you think this lujvo is excessively longwinded, be patient.) The veljvo of _nunctikezgau_ is _<a id="id-1.13.15.4.4.1" class="indexterm"></a>nu citka kei gasnu_. The relevant place structures are:

<div class="example">
<a id="example-random-id-bSDW"></a>

**Example 12.64. <a id="c12e13d1"></a>** 

_<a id="id-1.13.15.5.2.1.1" class="indexterm"></a>[_nu_](../go01#valsi-nu)_ : n1 is an event

_<a id="id-1.13.15.5.3.1.1" class="indexterm"></a>[_citka_](../go01#valsi-citka)_ : c1 eats c2

_<a id="id-1.13.15.5.4.1.1" class="indexterm"></a>[_gasnu_](../go01#valsi-gasnu)_ : g1 does action/is the agent of event g2

</div>  

In accordance with the procedure for analyzing three-part lujvo given in [Section 12.8](../section-n-part-lujvo) , we will first create an intermediate lujvo, _<a id="id-1.13.15.6.2.1" class="indexterm"></a>[_nuncti_](../go01#valsi-nuncti)_ , whose veljvo is _<a id="id-1.13.15.6.3.1" class="indexterm"></a>nu citka \[kei\]_. By the rules given in [Section 12.12](../section-abstraction-lujvo) , _<a id="id-1.13.15.6.5.1" class="indexterm"></a>[_nuncti_](../go01#valsi-nuncti)_ has the place structure

<div class="example">
<a id="example-random-id-Xhrx"></a>

**Example 12.65. <a id="c12e13d2"></a>** 

> n1 is the event of c1 eating c2

</div>  

Now we can transform the veljvo of _nunctikezgau_ into _<a id="id-1.13.15.8.2.1" class="indexterm"></a>nuncti gasnu_. The g2 place (what is brought about by the actor g1) obviously denotes the same thing as n1 (the event of eating). So we can eliminate g2 as redundant, leaving us with a tentative place structure of

<div class="example">
<a id="example-random-id-izvp"></a>

**Example 12.66. <a id="c12e13d3"></a>** 

> g1 is the actor in the event n1=g2 of c1 eating c2

</div>  

But it is also possible to omit the n1 place itself! The n1 place describes the event brought about; an event in Lojban is described as a bridi, by a selbri and its sumti; the selbri is already known (it's the seltau), and the sumti are also already known (they're in the lujvo place structure). So n1 would not give us any information we didn't already know. In fact, the n1=g2 place is dependent on c1 and c2 jointly – it does not depend on either c1 or c2 by itself. Being dependent and derived from the seltau, it is omissible. So the final place structure of _nunctikezgau_ is:

<div class="example">
<a id="example-random-id-9oTP"></a>

**Example 12.67. <a id="c12e13d4"></a>** 

> g1 is the actor in the event of c1 eating c2

</div>  

There is one further step that can be taken. As we have already seen with _<a id="id-1.13.15.12.1.1" class="indexterm"></a>[_balsoi_](../go01#valsi-balsoi)_ in [Section 12.5](../section-symmetrical-asymmetrical) , the interpretation of lujvo is constrained by the semantics of gismu and of their sumti places. Now, any asymmetrical lujvo with _<a id="id-1.13.15.12.3.1" class="indexterm"></a>[_gasnu_](../go01#valsi-gasnu)_ as its tertau will involve an event abstraction either implicitly or explicitly, since that is how the g2 place of _<a id="id-1.13.15.12.4.1" class="indexterm"></a>[_gasnu_](../go01#valsi-gasnu)_ is defined.

Therefore, if we assume that _<a id="id-1.13.15.13.1.1" class="indexterm"></a>[_nu_](../go01#valsi-nu)_ is the type of abstraction one would expect to be a _<a id="id-1.13.15.13.2.1" class="indexterm"></a>se gasnu_ , then the rafsi _nun_ and _kez_ in _nunctikezgau_ are only telling us what we would already have guessed – that the seltau of a _<a id="id-1.13.15.13.6.1" class="indexterm"></a>[_gasnu_](../go01#valsi-gasnu)_ lujvo is an event. If we drop these rafsi out, and use instead the shorter lujvo _<a id="id-1.13.15.13.7.1" class="indexterm"></a>[_ctigau_](../go01#valsi-ctigau)_ , rejecting its symmetrical interpretation ( “someone who both does and eats” ; “an eating doer”), we can still deduce that the seltau refers to an event.

(You can't “do an eater” / _<a id="id-1.13.15.14.2.1" class="indexterm"></a>gasnu lo citka_ , with the meaning of _<a id="id-1.13.15.14.3.1" class="indexterm"></a>[_do_](../go01#valsi-do)_ as “bring about an event” ; so the seltau must refer to an event, _<a id="id-1.13.15.14.5.1" class="indexterm"></a>nu citka_. The English slang meanings of “do someone” , namely “socialize with someone” and “have sex with someone” , are not relevant to _<a id="id-1.13.15.14.9.1" class="indexterm"></a>[_gasnu_](../go01#valsi-gasnu)_.)

So we can simply use _<a id="id-1.13.15.15.1.1" class="indexterm"></a>[_ctigau_](../go01#valsi-ctigau)_ with the same place structure as _nunctikezgau_ :

<div class="example">
<a id="example-random-id-ITvd"></a>

**Example 12.68. <a id="c12e13d5"></a>** 

> agent g1 causes c1 to eat c2

> g1 feeds c2 to c1

</div>  

This particular kind of asymmetrical lujvo, in which the seltau serves as the selbri of an abstraction which is a place of the tertau, is called an implicit-abstraction lujvo, because one deduces the presence of an abstraction which is unexpressed (implicit).

To give another example: the gismu _<a id="id-1.13.15.18.1.1" class="indexterm"></a>[_basti_](../go01#valsi-basti)_ , whose place structure is

<div class="example">
<a id="example-random-id-3LIm"></a>

**Example 12.69. <a id="c12e13d6"></a>** 

> b1 replaces b2 in circumstances b3

</div>  

can form the lujvo _<a id="id-1.13.15.20.1.1" class="indexterm"></a>[_basygau_](../go01#valsi-basygau)_ , with the place structure:

<div class="example">
<a id="example-random-id-byp8"></a>

**Example 12.70. <a id="c12e13d7"></a>** 

> g1 (agent) replaces b1 with b2 in circumstances b3

</div>  

where both _<a id="id-1.13.15.22.1.1" class="indexterm"></a>[_basti_](../go01#valsi-basti)_ and _<a id="id-1.13.15.22.2.1" class="indexterm"></a>[_basygau_](../go01#valsi-basygau)_ are translated “replace” in English, but represent different relations: _<a id="id-1.13.15.22.4.1" class="indexterm"></a>[_basti_](../go01#valsi-basti)_ may be used with no mention of any agent doing the replacing.

In addition, _<a id="id-1.13.15.23.1.1" class="indexterm"></a>[_gasnu_](../go01#valsi-gasnu)_ -based lujvo can be built from what we would consider nouns or adjectives in English. In Lojban, everything is a predicate, so adjectives, nouns and verbs are all treated in the same way. This is consistent with the use of similar causative affixes in other languages. For example, the gismu _<a id="id-1.13.15.23.2.1" class="indexterm"></a>[_litki_](../go01#valsi-litki)_ , meaning “liquid” , with the place structure

<div class="example">
<a id="example-random-id-tDsX"></a>

**Example 12.71. <a id="c12e13d8"></a>** 

> l1 is a quantity of liquid of composition l2 under conditions l3

</div>  

can give _likygau_ , meaning “to liquefy” :

<div class="example">
<a id="example-random-id-p5Bt"></a>

**Example 12.72. <a id="c12e13d9"></a>** 

> g1 (agent) causes l1 to be a quantity of liquid of composition l2 under conditions l3.

</div>  

While _likygau_ correctly represents “causes to be a liquid” , a different lujvo based on _<a id="id-1.13.15.27.3.1" class="indexterm"></a>[_galfi_](../go01#valsi-galfi)_ (meaning “modify”) may be more appropriate for “causes to become a liquid”. On the other hand, _fetsygau_ is potentially confusing, because it could mean “agent in the event of something becoming female” (the implicit-abstraction interpretation) or simply “female agent” (the parallel interpretation), so using implicit-abstraction lujvo is always accompanied with some risk of being misunderstood.

Many other Lojban gismu have places for event abstractions, and therefore are good candidates for the tertau of an implicit-abstraction lujvo. For example, lujvo based on _<a id="id-1.13.15.28.1.1" class="indexterm"></a>[_rinka_](../go01#valsi-rinka)_ , with its place structure

<div class="example">
<a id="example-random-id-Pmz8"></a>

**Example 12.73. <a id="c12e13d10"></a>** 

> event r1 causes event r2 to occur

</div>  

are closely related to those based on _<a id="id-1.13.15.30.1.1" class="indexterm"></a>[_gasnu_](../go01#valsi-gasnu)_. However, _<a id="id-1.13.15.30.2.1" class="indexterm"></a>[_rinka_](../go01#valsi-rinka)_ is less generally useful than _<a id="id-1.13.15.30.3.1" class="indexterm"></a>[_gasnu_](../go01#valsi-gasnu)_ , because its r1 place is another event rather than a person: _<a id="id-1.13.15.30.4.1" class="indexterm"></a>lo rinka_ is a cause, not a causer. Thus the place structure of _likyri'a_ , a lujvo analogous to _likygau_ , is

<div class="example">
<a id="example-random-id-1HT3"></a>

**Example 12.74. <a id="c12e13d11"></a>** 

event r1 causes l1 to be a quantity of liquid of composition l2 under conditions l3

</div>  

and would be useful in translating sentences like “The heat of the sun liquefied the block of ice.”

Implicit-abstraction lujvo are a powerful means in the language of rendering quite verbose bridi into succinct and manageable concepts, and increasing the expressive power of the language.