<a id="section-gismu"></a>4.4. <a id="c4s4"></a>gismu
-----------------------------------------------------

<a id="id-1.5.6.2.1" class="indexterm"></a><a id="id-1.5.6.2.2" class="indexterm"></a>The gismu, or Lojban root words, are those brivla representing concepts most basic to the language. The gismu were chosen for various reasons: some represent concepts that are very familiar and basic; some represent concepts that are frequently used in other languages; some were added because they would be helpful in constructing more complex words; some because they represent fundamental Lojban concepts (like _<a id="id-1.5.6.2.3.1" class="indexterm"></a>[_cmavo_](../go01#valsi-cmavo)_ and _<a id="id-1.5.6.2.4.1" class="indexterm"></a>[_gismu_](../go01#valsi-gismu)_ themselves).

<a id="id-1.5.6.3.1" class="indexterm"></a><a id="id-1.5.6.3.2" class="indexterm"></a>The gismu do not represent any sort of systematic partitioning of semantic space. Some gismu may be superfluous, or appear for historical reasons: the gismu list was being collected for almost 35 years and was only weeded out once. Instead, the intention is that the gismu blanket semantic space: they make it possible to talk about the entire range of human concerns.

<a id="id-1.5.6.4.1" class="indexterm"></a><a id="id-1.5.6.4.2" class="indexterm"></a><a id="id-1.5.6.4.3" class="indexterm"></a>There are about 1350 gismu. In learning Lojban, you need only to learn most of these gismu and their combining forms (known as _<a id="id-1.5.6.4.4.1" class="indexterm"></a>[_rafsi_](../go01#valsi-rafsi)_) as well as perhaps 200 major cmavo, and you will be able to communicate effectively in the language. This may sound like a lot, but it is a small number compared to the vocabulary needed for similar communications in other languages.

<a id="id-1.5.6.5.1" class="indexterm"></a>All gismu have very strong form restrictions. Using the conventions defined in [Section 4.1](../chapter-morphology#section-morphology-introduction) , all gismu are of the forms CVC/CV or CCVCV. They must meet the rules for all brivla given in [Section 4.3](../section-morphology-brivla) ; furthermore, they:

1.  always have five letters;

2.  always start with a consonant and end with a single vowel;

3.  always contain exactly one consonant pair, which is a permissible initial pair (CC) if it's at the beginning of the gismu, but otherwise only has to be a permissible pair (C/C);

4.  are always stressed on the first syllable (since that is penultimate).

<a id="id-1.5.6.7.1" class="indexterm"></a>The five letter length distinguishes gismu from lujvo and fu'ivla. In addition, no gismu contains _'_.

<a id="id-1.5.6.8.1" class="indexterm"></a><a id="id-1.5.6.8.2" class="indexterm"></a>With the exception of five special brivla variables, _<a id="id-1.5.6.8.3.1" class="indexterm"></a>[_broda_](../go01#valsi-broda)_ , _<a id="id-1.5.6.8.4.1" class="indexterm"></a>[_brode_](../go01#valsi-brode)_ , _<a id="id-1.5.6.8.5.1" class="indexterm"></a>[_brodi_](../go01#valsi-brodi)_ , _<a id="id-1.5.6.8.6.1" class="indexterm"></a>[_brodo_](../go01#valsi-brodo)_ , and _<a id="id-1.5.6.8.7.1" class="indexterm"></a>[_brodu_](../go01#valsi-brodu)_ , no two gismu differ only in the final vowel. Furthermore, the set of gismu was specifically designed to reduce the likelihood that two similar sounding gismu could be confused. For example, because _<a id="id-1.5.6.8.8.1" class="indexterm"></a>[_gismu_](../go01#valsi-gismu)_ is in the set of gismu, _kismu_ , _xismu_ , _gicmu_ , _gizmu_ , and _gisnu_ cannot be.

<a id="id-1.5.6.9.1" class="indexterm"></a>Almost all Lojban gismu are constructed from pieces of words drawn from other languages, specifically Chinese, English, Hindi, Spanish, Russian, and Arabic, the six most widely spoken natural languages. For a given concept, words in the six languages that represent that concept were written in Lojban phonetics. Then a gismu was selected to maximize the recognizability of the Lojban word for speakers of the six languages by weighting the inclusion of the sounds drawn from each language by the number of speakers of that language. See [Section 4.14](../section-gismu-making) for a full explanation of the algorithm.

<a id="id-1.5.6.10.1" class="indexterm"></a>Here are a few examples of gismu, with rough English equivalents (not definitions):

<div class="interlinear-gloss-example example">
<a id="example-random-id-qJ0x"></a>

**Example 4.11. <a id="c4e4d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>creka</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">shirt</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qj4M"></a>

**Example 4.12. <a id="c4e4d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lijda</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">religion</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qJ4M"></a>

**Example 4.13. <a id="c4e4d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>blanu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">blue</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qJ5Y"></a>

**Example 4.14. <a id="c4e4d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mamta</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">mother</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qj6K"></a>

**Example 4.15. <a id="c4e4d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>cukta</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">book</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qJ6R"></a>

**Example 4.16. <a id="c4e4d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>patfu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">father</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qJ6y"></a>

**Example 4.17. <a id="c4e4d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>nanmu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">man</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qj71"></a>

**Example 4.18. <a id="c4e4d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ninmu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">woman</p></td></tr></tbody></table>

</div>  

A small number of gismu were formed differently; see [Section 4.15](../section-cultural-gismu) for a list.