<a id="section-gismu-place-structures"></a>12.16. <a id="c12s16"></a>Notes on gismu place structures
----------------------------------------------------------------------------------------------------

<a id="id-1.13.18.2.1" class="indexterm"></a><a id="id-1.13.18.2.2" class="indexterm"></a>Unlike the place structures of lujvo, the place structures of gismu were assigned in a far less systematic way through a detailed case-by-case analysis and repeated reviews with associated changes. (The gismu list is now baselined, so no further changes are contemplated.) Nevertheless, certain regularities were imposed both in the choice of places and in the ordering of places which may be helpful to the learner and the lujvo-maker, and which are therefore discussed here.

<a id="id-1.13.18.3.1" class="indexterm"></a>The choice of gismu places results from the varying outcome of four different pressures: brevity, convenience, metaphysical necessity, and regularity. (These are also to some extent the underlying factors in the lujvo place structures generated by the methods of this chapter.) The implications of each are roughly as follows:

*   Brevity tends to remove places: the fewer places a gismu has, the easier it is to learn, and the less specific it is. As mentioned in [Section 12.4](../section-selecting-places) , a brivla with fewer place structures is less specific, and generality is a virtue in gismu, because they must thoroughly blanket all of semantic space.

*   Convenience tends to increase the number of places: if a concept can be expressed as a place of some existing gismu, there is no need to make another gismu, a lujvo or a fu'ivla for it.

*   Metaphysical necessity can either increase or decrease places: it is a pressure tending to provide the “right number” of places. If something is part of the essential nature of a concept, then a place must be made for it; on the other hand, if instances of the concept need not have some property, then this pressure will tend to remove the place.

*   Regularity is a pressure which can also either increase or decrease places. If a gismu has a given place, then gismu which are semantically related to it are likely to have the place also.

Here are some examples of gismu place structures, with a discussion of the pressures operating on them:

<div class="example">
<a id="example-random-id-iu0B"></a>

**Example 12.100. <a id="c12e16d1"></a>** 

_<a id="id-1.13.18.6.2.1.1" class="indexterm"></a>[_xekri_](../go01#valsi-xekri)_ : xe1 is black

</div>  

<a id="id-1.13.18.7.1" class="indexterm"></a>Brevity was the most important goal here, reinforced by one interpretation of metaphysical necessity. There is no mention of color standards here, as many people have pointed out; like all color gismu, _<a id="id-1.13.18.7.2.1" class="indexterm"></a>[_xekri_](../go01#valsi-xekri)_ is explicitly subjective. Objective color standards can be brought in by an appropriate BAI tag such as _<a id="id-1.13.18.7.3.1" class="indexterm"></a>[_ci'u_](../go01#valsi-cihu)_ ( “on scale” ; see [Section 9.6](../section-BAI)) or by making a lujvo.

<div class="example">
<a id="example-random-id-cuYP"></a>

**Example 12.101. <a id="c12e16d2"></a>** 

_<a id="id-1.13.18.8.2.1.1" class="indexterm"></a>[_jbena_](../go01#valsi-jbena)_ : j1 is born to j2 at time j3 and location j4

</div>  

The gismu _<a id="id-1.13.18.9.1.1" class="indexterm"></a>[_jbena_](../go01#valsi-jbena)_ contains places for time and location, which few other gismu have: normally, the time and place at which something is done is supplied by a tense tag (see [Chapter 10](../chapter-tenses)). However, providing these places makes _<a id="id-1.13.18.9.3.1" class="indexterm"></a>le te jbena_ a simple term for “birthday” and _<a id="id-1.13.18.9.5.1" class="indexterm"></a>le ve jbena_ for “birthplace” , so these places were provided despite their lack of metaphysical necessity.

<div class="example">
<a id="example-random-id-NTJn"></a>

**Example 12.102. <a id="c12e16d3"></a>** 

_<a id="id-1.13.18.10.2.1.1" class="indexterm"></a>[_rinka_](../go01#valsi-rinka)_ : event r1 is the cause of event r2

</div>  

<a id="id-1.13.18.11.1" class="indexterm"></a>The place structure of _<a id="id-1.13.18.11.2.1" class="indexterm"></a>[_rinka_](../go01#valsi-rinka)_ does not have a place for the agent, the one who causes, as a result of the pressure toward metaphysical necessity. A cause-effect relationship does not have to include an agent: an event (such as snow melting in the mountains) may cause another event (such as the flooding of the Nile) without any human intervention or even knowledge.

<a id="id-1.13.18.12.1" class="indexterm"></a>Indeed, there is a general tendency to omit agent places from most gismu except for a few such as _<a id="id-1.13.18.12.2.1" class="indexterm"></a>[_gasnu_](../go01#valsi-gasnu)_ and _<a id="id-1.13.18.12.3.1" class="indexterm"></a>[_zukte_](../go01#valsi-zukte)_ which are then used as tertau in order to restore the agent place when needed: see [Section 12.13](../section-implicit-abstraction).

<div class="example">
<a id="example-random-id-Atby"></a>

**Example 12.103. <a id="c12e16d4"></a>** 

> _<a id="id-1.13.18.13.2.1.1.1.1" class="indexterm"></a>[_cinfo_](../go01#valsi-cinfo)_ c1 is a lion of species/breed c2

</div>  

<a id="id-1.13.18.14.1" class="indexterm"></a><a id="id-1.13.18.14.2" class="indexterm"></a>The c2 place of _<a id="id-1.13.18.14.3.1" class="indexterm"></a>[_cinfo_](../go01#valsi-cinfo)_ is provided as a result of the pressure toward regularity. All animal and plant gismu have such an x2 place; although there is in fact only one species of lion, and breeds of lion, though they exist, aren't all that important in talking about lions. The species/breed place must exist for such diversified species as dogs, and for general terms like _<a id="id-1.13.18.14.5.1" class="indexterm"></a>[_cinki_](../go01#valsi-cinki)_ (insect), and are provided for all other animals and plants as a matter of regularity.

<a id="id-1.13.18.15.1" class="indexterm"></a>Less can be said about gismu place structure ordering, but some regularities are apparent. The places tend to appear in decreasing order of psychological saliency or importance. There is an implication within the place structure of _<a id="id-1.13.18.15.2.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ , for example, that _<a id="id-1.13.18.15.3.1" class="indexterm"></a>lo klama_ (the one going) will be talked about more often, and is thus more important, than _<a id="id-1.13.18.15.4.1" class="indexterm"></a>lo se klama_ (the destination), which is in turn more important than _<a id="id-1.13.18.15.5.1" class="indexterm"></a>lo xe klama_ (the means of transport).

Some specific tendencies (not really rules) can also be observed. For example, when there is an agent place, it tends to be the first place. Similarly, when a destination and an origin point are mentioned, the destination is always placed just before the origin point. Places such as “under conditions” and “by standard” , which often go unfilled, are moved to near the end of the place structure.