<a id="section-fuhivla"></a>4.7. <a id="c4s7"></a>fu'ivla
---------------------------------------------------------

<a id="id-1.5.9.2.1" class="indexterm"></a><a id="id-1.5.9.2.2" class="indexterm"></a><a id="id-1.5.9.2.3" class="indexterm"></a><a id="id-1.5.9.2.4" class="indexterm"></a><a id="id-1.5.9.2.5" class="indexterm"></a><a id="id-1.5.9.2.6" class="indexterm"></a><a id="id-1.5.9.2.7" class="indexterm"></a><a id="id-1.5.9.2.8" class="indexterm"></a>The use of tanru or lujvo is not always appropriate for very concrete or specific terms (e.g. “brie” or “cobra”), or for jargon words specialized to a narrow field (e.g. “quark” , “integral” , or “iambic pentameter”). These words are in effect names for concepts, and the names were invented by speakers of another language. The vast majority of words referring to plants, animals, foods, and scientific terminology cannot be easily expressed as tanru. They thus must be borrowed (actually “copied”) into Lojban from the original language.

<a id="id-1.5.9.3.1" class="indexterm"></a><a id="id-1.5.9.3.2" class="indexterm"></a><a id="id-1.5.9.3.3" class="indexterm"></a>There are four stages of borrowing in Lojban, as words become more and more modified (but shorter and easier to use). Stage 1 is the use of a foreign name quoted with the cmavo _<a id="id-1.5.9.3.4.1" class="indexterm"></a>[_la'o_](../go01#valsi-laho)_ (explained in full in [Section 19.10](../section-more-quotations)):

<div class="interlinear-gloss-example example">
<a id="example-random-id-QpNm"></a>

**Example 4.44. <a id="c4e7d1"></a>** 

<a id="id-1.5.9.4.2.1" class="indexterm"></a>me la'o ly. spaghetti .ly.

</div>  

<a id="id-1.5.9.5.1" class="indexterm"></a>is a predicate with the place structure “x1 is a quantity of spaghetti”.

<a id="id-1.5.9.6.1" class="indexterm"></a><a id="id-1.5.9.6.2" class="indexterm"></a>Stage 2 involves changing the foreign name to a Lojbanized name, as explained in [Section 4.8](../section-cmevla):

<div class="interlinear-gloss-example example">
<a id="example-random-id-zijY"></a>

**Example 4.45. <a id="c4e7d2"></a>** 

<a id="id-1.5.9.7.2.1" class="indexterm"></a>me la .spagetis.

</div>  

One of these expedients is often quite sufficient when you need a word quickly in conversation. (This can make it easier to get by when you do not yet have full command of the Lojban vocabulary, provided you are talking to someone who will recognize the borrowing.)

<a id="id-1.5.9.9.1" class="indexterm"></a><a id="id-1.5.9.9.2" class="indexterm"></a><a id="id-1.5.9.9.3" class="indexterm"></a>Where a little more universality is desired, the word to be borrowed must be Lojbanized into one of several permitted forms. A rafsi is then usually attached to the beginning of the Lojbanized form, using a hyphen to ensure that the resulting word doesn't fall apart.

<a id="id-1.5.9.10.1" class="indexterm"></a><a id="id-1.5.9.10.2" class="indexterm"></a><a id="id-1.5.9.10.3" class="indexterm"></a><a id="id-1.5.9.10.4" class="indexterm"></a>The rafsi categorizes or limits the meaning of the fu'ivla; otherwise a word having several different jargon meanings in other languages would require the word-inventor to choose which meaning should be assigned to the fu'ivla, since fu'ivla (like other brivla) are not permitted to have more than one definition. Such a Stage 3 borrowing is the most common kind of fu'ivla.

<a id="id-1.5.9.11.1" class="indexterm"></a><a id="id-1.5.9.11.2" class="indexterm"></a><a id="id-1.5.9.11.3" class="indexterm"></a>Finally, Stage 4 fu'ivla do not have any rafsi classifier, and are used where a fu'ivla has become so common or so important that it must be made as short as possible. (See [Section 4.16](../section-rafsi-fuhivla) for a proposal concerning Stage 4 fu'ivla.)

<a id="id-1.5.9.12.1" class="indexterm"></a><a id="id-1.5.9.12.2" class="indexterm"></a>The form of a fu'ivla reliably distinguishes it from both the gismu and the cmavo. Like cultural gismu, fu'ivla are generally based on a word from a single non-Lojban language. The word is “borrowed” (actually “copied” , hence the Lojban tanru _<a id="id-1.5.9.12.5.1" class="indexterm"></a>fukpi valsi_) from the other language and Lojbanized – the phonemes are converted to their closest Lojban equivalent and modifications are made as necessary to make the word a legitimate Lojban fu'ivla-form word. All fu'ivla:

1.  <a id="id-1.5.9.13.1.1.1" class="indexterm"></a><a id="id-1.5.9.13.1.1.2" class="indexterm"></a>must contain a consonant cluster in the first five letters of the word; if this consonant cluster is at the beginning, it must either be a permissible initial consonant pair, or a longer cluster such that each pair of adjacent consonants in the cluster is a permissible initial consonant pair: _spraile_ is acceptable, but not _ktraile_ or _trkaile_ ;

2.  must end in one or more vowels;

3.  <a id="id-1.5.9.13.3.1.1" class="indexterm"></a>must not be gismu or lujvo, or any combination of cmavo, gismu, and lujvo; furthermore, a fu'ivla with a CV cmavo joined to the front of it must not have the form of a lujvo (the so-called “slinku'i test” , not discussed further in this book);

4.  <a id="id-1.5.9.13.4.1.1" class="indexterm"></a>cannot contain _y_ , although they may contain syllabic pronunciations of Lojban consonants;

5.  <a id="id-1.5.9.13.5.1.1" class="indexterm"></a>like other brivla, are stressed on the penultimate syllable.

<a id="id-1.5.9.14.1" class="indexterm"></a>Note that consonant triples or larger clusters that are not at the beginning of a fu'ivla can be quite flexible, as long as all consonant pairs are permissible. There is no need to restrict fu'ivla clusters to permissible initial pairs except at the beginning.

<a id="id-1.5.9.15.1" class="indexterm"></a><a id="id-1.5.9.15.2" class="indexterm"></a>This is a fairly liberal definition and allows quite a lot of possibilities within “fu'ivla space”. Stage 3 fu'ivla can be made easily on the fly, as lujvo can, because the procedure for forming them always guarantees a word that cannot violate any of the rules. Stage 4 fu'ivla require running tests that are not simple to characterize or perform, and should be made only after deliberation and by someone knowledgeable about all the considerations that apply.

<a id="id-1.5.9.16.1" class="indexterm"></a>Here is a simple and reliable procedure for making a non-Lojban word into a valid Stage 3 fu'ivla:

1.  Eliminate all double consonants and silent letters.

2.  Convert all sounds to their closest Lojban equivalents. Lojban _y_ , however, may not be used in any fu'ivla.

3.  If the last letter is not a vowel, modify the ending so that the word ends in a vowel, either by removing a final consonant or by adding a suggestively chosen final vowel.

4.  If the first letter is not a consonant, modify the beginning so that the word begins with a consonant, either by removing an initial vowel or adding a suggestively chosen initial consonant.

5.  <a id="id-1.5.9.17.5.1.1" class="indexterm"></a><a id="id-1.5.9.17.5.1.2" class="indexterm"></a>Prefix the result of steps 1-4 with a 4-letter rafsi that categorizes the fu'ivla into a “topic area”. It is only safe to use a 4-letter rafsi; short rafsi sometimes produce invalid fu'ivla. Hyphenate the rafsi to the rest of the fu'ivla with an r-hyphen; if that would produce a double _r_ , use an n-hyphen instead; if the rafsi ends in _r_ and the rest of the fu'ivla begins with _n_ (or vice versa), or if the rafsi ends in "r" and the rest of the fu'ivla begins with "tc", "ts", "dj", or "dz" (using "n" would result in a phonotactically impermissible cluster), use an l-hyphen. (This is the only use of l-hyphen in Lojban.)

    Alternatively, if a CVC-form short rafsi is available it can be used instead of the long rafsi.

6.  Remember that the stress necessarily appears on the penultimate (next-to-the-last) syllable.

In this section, the hyphen is set off with commas in the examples, but these commas are not required in writing, and the hyphen need not be pronounced as a separate syllable.

Here are a few examples:

<div class="lojbanization-example example">
<a id="example-random-id-ufin"></a>

**Example 4.46. <a id="id-1.5.9.20.1.1" class="indexterm"></a><a id="c4e7d3"></a><a id="id-1.5.9.20.1.3" class="indexterm"></a><a id="id-1.5.9.20.1.4" class="indexterm"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="natlang"><td colspan="12321"><p class="natlang">spaghetti <span class="comment">(from English or Italian)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">spageti <span class="comment">(Lojbanize)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">cidj,r,spageti <span class="comment">(prefix long rafsi)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">dja,r,spageti <span class="comment">(prefix short rafsi)</span></p></td></tr></tbody></table>

</div>  

where _cidj-_ is the 4-letter rafsi for _<a id="id-1.5.9.21.2.1" class="indexterm"></a>[_cidja_](../go01#valsi-cidja)_ , the Lojban gismu for “food” , thus categorizing _<a id="id-1.5.9.21.4.1" class="indexterm"></a>[_cidjrspageti_](../go01#valsi-cidjrspageti)_ as a kind of food. The form with the short rafsi happens to work, but such good fortune cannot be relied on: in any event, it means the same thing.

<div class="lojbanization-example example">
<a id="example-random-id-pzXe"></a>

**Example 4.47. <a id="id-1.5.9.22.1.1" class="indexterm"></a><a id="id-1.5.9.22.1.2" class="indexterm"></a><a id="id-1.5.9.22.1.3" class="indexterm"></a><a id="id-1.5.9.22.1.4" class="indexterm"></a><a id="id-1.5.9.22.1.5" class="indexterm"></a><a id="c4e7d4"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="natlang"><td colspan="12321"><p class="natlang">Acer <span class="comment">(the scientific name of maple trees)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">acer <span class="comment">(Lojbanize)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">xaceru <span class="comment">(add initial consonant and final vowel)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">tric,r,xaceru <span class="comment">(prefix rafsi)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">ric,r,xaceru <span class="comment">(prefix short rafsi)</span></p></td></tr></tbody></table>

</div>  

where _tric-_ and _ric-_ are rafsi for _<a id="id-1.5.9.23.3.1" class="indexterm"></a>[_tricu_](../go01#valsi-tricu)_ , the gismu for “tree”. Note that by the same principles, “maple sugar” could get the fu'ivla _saktrxaceru_ , or could be represented by the tanru _<a id="id-1.5.9.23.7.1" class="indexterm"></a>tricrxaceru sakta_. Technically, _ricrxaceru_ and _tricrxaceru_ are distinct fu'ivla, but they would surely be given the same meanings if both happened to be in use.

<div class="lojbanization-example example">
<a id="example-random-id-C0YS"></a>

**Example 4.48. <a id="id-1.5.9.24.1.1" class="indexterm"></a><a id="id-1.5.9.24.1.2" class="indexterm"></a><a id="id-1.5.9.24.1.3" class="indexterm"></a><a id="c4e7d5"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="natlang"><td colspan="12321"><p class="natlang">brie <span class="comment">(from French)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">bri <span class="comment">(Lojbanize)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">cirl,r,bri <span class="comment">(prefix rafsi)</span></p></td></tr></tbody></table>

</div>  

where _cirl-_ represents _<a id="id-1.5.9.25.2.1" class="indexterm"></a>[_cirla_](../go01#valsi-cirla)_ ( “cheese”).

<div class="lojbanization-example example">
<a id="example-random-id-DQju"></a>

**Example 4.49. <a id="id-1.5.9.26.1.1" class="indexterm"></a><a id="id-1.5.9.26.1.2" class="indexterm"></a><a id="id-1.5.9.26.1.3" class="indexterm"></a><a id="c4e7d6"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="natlang"><td colspan="12321"><p class="natlang">cobra</p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">kobra <span class="comment">(Lojbanize)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">sinc,r,kobra <span class="comment">(prefix rafsi)</span></p></td></tr></tbody></table>

</div>  

where _sinc-_ represents _<a id="id-1.5.9.27.2.1" class="indexterm"></a>[_since_](../go01#valsi-since)_ ( “snake”).

<div class="lojbanization-example example">
<a id="example-random-id-TFzH"></a>

**Example 4.50. <a id="id-1.5.9.28.1.1" class="indexterm"></a><a id="id-1.5.9.28.1.2" class="indexterm"></a><a id="id-1.5.9.28.1.3" class="indexterm"></a><a id="c4e7d7"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="natlang"><td colspan="12321"><p class="natlang">quark</p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">kuark <span class="comment">(Lojbanize)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">kuarka <span class="comment">(add final vowel)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">sask,r,kuarka <span class="comment">(prefix rafsi)</span></p></td></tr></tbody></table>

</div>  

<a id="id-1.5.9.29.1" class="indexterm"></a><a id="id-1.5.9.29.2" class="indexterm"></a><a id="id-1.5.9.29.3" class="indexterm"></a><a id="id-1.5.9.29.4" class="indexterm"></a>where _sask-_ represents _<a id="id-1.5.9.29.6.1" class="indexterm"></a>[_saske_](../go01#valsi-saske)_ ( “science”). Note the extra vowel _a_ added to the end of the word, and the diphthong _ua_ , which never appears in gismu or lujvo, but may appear in fu'ivla.

<div class="lojbanization-example example">
<a id="example-random-id-FTfQ"></a>

**Example 4.51. <a id="id-1.5.9.30.1.1" class="indexterm"></a><a id="id-1.5.9.30.1.2" class="indexterm"></a><a id="c4e7d8"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="natlang"><td colspan="12321"><p xml:lang="ko" class="natlang" lang="ko">자모 <span class="comment">(from Korean)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">djamo <span class="comment">(Lojbanize)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">lerf,r,djamo <span class="comment">(prefix rafsi)</span></p></td></tr><tr class="jbo"><td colspan="12321"><p class="jbo">ler,l,djamo <span class="comment">(prefix rafsi)</span></p></td></tr></tbody></table>

</div>  

where _ler-_ represents _<a id="id-1.5.9.31.2.1" class="indexterm"></a>[_lerfu_](../go01#valsi-lerfu)_ ( “letter”). Note the l-hyphen in "lerldjamo", since "lerndjamo" contains the forbidden cluster "ndj".

<a id="id-1.5.9.32.1" class="indexterm"></a><a id="id-1.5.9.32.2" class="indexterm"></a>The use of the prefix helps distinguish among the many possible meanings of the borrowed word, depending on the field. As it happens, _<a id="id-1.5.9.32.3.1" class="indexterm"></a>[_spageti_](../go01#valsi-spageti)_ and _<a id="id-1.5.9.32.4.1" class="indexterm"></a>[_kuarka_](../go01#valsi-kuarka)_ are valid Stage 4 fu'ivla, but _xaceru_ looks like a compound cmavo, and _kobra_ like a gismu.

<a id="id-1.5.9.33.1" class="indexterm"></a>For another example, “integral” has a specific meaning to a mathematician. But the Lojban fu'ivla _.integrale_ , which is a valid Stage 4 fu'ivla, does not convey that mathematical sense to a non-mathematical listener, even one with an English-speaking background; its source – the English word “integral” – has various other specialized meanings in other fields.

Left uncontrolled, _.integrale_ almost certainly would eventually come to mean the same collection of loosely related concepts that English associates with “integral” , with only the context to indicate (possibly) that the mathematical term is meant.

<a id="id-1.5.9.35.1" class="indexterm"></a><a id="id-1.5.9.35.2" class="indexterm"></a>The prefix method would render the mathematical concept as _cmacrntegrale_ , if the _i_ of _.integrale_ is removed, or something like _cmacrnintegrale_ , if a new consonant is added to the beginning; _cmac-_ is the rafsi for _<a id="id-1.5.9.35.8.1" class="indexterm"></a>[_cmaci_](../go01#valsi-cmaci)_ ( “mathematics”). The architectural sense of “integral” might be conveyed with _dinjrnintegrale_ or _tarmrnintegrale_ , where _<a id="id-1.5.9.35.13.1" class="indexterm"></a>[_dinju_](../go01#valsi-dinju)_ and _<a id="id-1.5.9.35.14.1" class="indexterm"></a>[_tarmi_](../go01#valsi-tarmi)_ mean “building” and “form” respectively.

Here are some fu'ivla representing cultures and related things, shown with more than one rafsi prefix:

<div class="lojbanization-example example">
<a id="example-random-id-qJG8"></a>

**Example 4.52. <a id="id-1.5.9.37.1.1" class="indexterm"></a><a id="id-1.5.9.37.1.2" class="indexterm"></a><a id="id-1.5.9.37.1.3" class="indexterm"></a><a id="c4e7d9"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="pronunciation">bang,r,blgaria</p></td></tr><tr class="natlang"><td colspan="12321"><p class="natlang">Bulgarian <span class="comment">(in language)</span></p></td></tr></tbody></table>

</div>  
<div class="lojbanization-example example">
<a id="example-random-id-qJga"></a>

**Example 4.53. <a id="c4e7d10"></a><a id="id-1.5.9.38.1.2" class="indexterm"></a><a id="id-1.5.9.38.1.3" class="indexterm"></a><a id="id-1.5.9.38.1.4" class="indexterm"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="pronunciation">kuln,r,blgaria</p></td></tr><tr class="natlang"><td colspan="12321"><p class="natlang">Bulgarian <span class="comment">(in culture)</span></p></td></tr></tbody></table>

</div>  
<div class="lojbanization-example example">
<a id="example-random-id-qjGf"></a>

**Example 4.54. <a id="id-1.5.9.39.1.1" class="indexterm"></a><a id="id-1.5.9.39.1.2" class="indexterm"></a><a id="c4e7d11"></a><a id="id-1.5.9.39.1.4" class="indexterm"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="pronunciation">gugd,r,blgaria</p></td></tr><tr class="natlang"><td colspan="12321"><p class="natlang">Bulgaria <span class="comment">(the country)</span></p></td></tr></tbody></table>

</div>  
<div class="lojbanization-example example">
<a id="example-random-id-qJGv"></a>

**Example 4.55. <a id="c4e7d12"></a><a id="id-1.5.9.40.1.2" class="indexterm"></a><a id="id-1.5.9.40.1.3" class="indexterm"></a><a id="id-1.5.9.40.1.4" class="indexterm"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="pronunciation">bang,r,kore,a</p></td></tr><tr class="natlang"><td colspan="12321"><p class="natlang">Korean <span class="comment">(the language)</span></p></td></tr></tbody></table>

</div>  
<div class="lojbanization-example example">
<a id="example-random-id-qjh0"></a>

**Example 4.56. <a id="id-1.5.9.41.1.1" class="indexterm"></a><a id="id-1.5.9.41.1.2" class="indexterm"></a><a id="c4e7d13"></a><a id="id-1.5.9.41.1.4" class="indexterm"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="pronunciation">kuln,r,kore,a</p></td></tr><tr class="natlang"><td colspan="12321"><p class="natlang">Korean <span class="comment">(the culture)</span></p></td></tr></tbody></table>

</div>  

<a id="id-1.5.9.42.1" class="indexterm"></a><a id="id-1.5.9.42.2" class="indexterm"></a><a id="id-1.5.9.42.3" class="indexterm"></a><a id="id-1.5.9.42.4" class="indexterm"></a>Note the commas in [Example 4.55](../section-fuhivla#example-random-id-qJGv) and [Example 4.56](../section-fuhivla#example-random-id-qjh0) , used because _ea_ is not a valid diphthong in Lojban. Arguably, some form of the native name “Chosen” should have been used instead of the internationally known “Korea” ; this is a recurring problem in all borrowings. In general, it is better to use the native name unless using it will severely impede understanding: “Navajo” is far more widely known than “Dine'e”.