<a id="section-four-basics"></a>14.2. <a id="c14s2"></a>The four basic vowels
-----------------------------------------------------------------------------

<a id="id-1.15.4.2.1" class="indexterm"></a><a id="id-1.15.4.2.2" class="indexterm"></a><a id="id-1.15.4.2.3" class="indexterm"></a>Lojban regards four of these 16 truth functions as fundamental, and assigns them the four vowels A , E , O , and U. These letters do not represent actual cmavo or selma'o, but rather a component vowel from which actual logical-connective cmavo are built up, as explained in the next section. Here are the four vowels, their truth tables, and rough English equivalents:<a id="id-1.15.4.2.8" class="indexterm"></a><a id="id-1.15.4.2.9" class="indexterm"></a><a id="id-1.15.4.2.10" class="indexterm"></a><a id="id-1.15.4.2.11" class="indexterm"></a><a id="id-1.15.4.2.12" class="indexterm"></a>

<table><tbody><tr><td><span class="logical-vowel">A</span></td><td>TTTF</td><td>or, and/or</td></tr><tr><td><span class="logical-vowel">E</span></td><td>TFFF</td><td>and</td></tr><tr><td><span class="logical-vowel">O</span></td><td>TFFT</td><td>if and only if</td></tr><tr><td><span class="logical-vowel">U</span></td><td>TTFF</td><td>whether or not</td></tr></tbody></table>

More precisely:

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span class="logical-vowel">A</span> is true if either or both sentences are true</td></tr><tr><td><span class="logical-vowel">E</span> is true if both sentences are true, but not otherwise</td></tr><tr><td><span class="logical-vowel">O</span> is true if the sentences are both true or both false</td></tr><tr><td><span class="logical-vowel">U</span> is true if the first sentence is true, regardless of the truth value of the second sentence</td></tr></tbody></table>

<a id="id-1.15.4.6.1" class="indexterm"></a>With the four vowels, the ability to negate either sentence, and the ability to exchange the sentences, as if their order had been reversed, we can create all of the 16 possible truth functions except TTTT and FFFF, which are fairly useless anyway. The following table illustrates how to create each of the 14 remaining truth functions:

<table><tbody><tr><td>TTTF</td><td><span class="logical-vowel">A</span></td></tr><tr><td>TTFT</td><td><span class="logical-vowel">A</span> with second sentence negated</td></tr><tr><td>TTFF</td><td><span class="logical-vowel">U</span></td></tr><tr><td>TFTT</td><td><span class="logical-vowel">A</span> with first sentence negated</td></tr><tr><td>TFTF</td><td><span class="logical-vowel">U</span> with sentences exchanged</td></tr><tr><td>TFFT</td><td><span class="logical-vowel">O</span></td></tr><tr><td>TFFF</td><td><span class="logical-vowel">E</span></td></tr><tr><td>FTTT</td><td><span class="logical-vowel">A</span> with both sentences negated</td></tr><tr><td>FTTF</td><td><span class="logical-vowel">O</span> with either first or second negated (not both)</td></tr><tr><td>FTFT</td><td><span class="logical-vowel">U</span> with sentences exchanged and then second negated</td></tr><tr><td>FTFF</td><td><span class="logical-vowel">E</span> with second sentence negated</td></tr><tr><td>FFTT</td><td><span class="logical-vowel">U</span> with first sentence negated</td></tr><tr><td>FFTF</td><td><span class="logical-vowel">E</span> with first sentence negated</td></tr><tr><td>FFFT</td><td><span class="logical-vowel">E</span> with both sentences negated</td></tr></tbody></table>

<a id="id-1.15.4.8.1" class="indexterm"></a><a id="id-1.15.4.8.2" class="indexterm"></a>Note that exchanging the sentences is only necessary with U. The three other basic truth functions are commutative; that is, they mean the same thing regardless of the order of the component sentences. There are other ways of getting some of these truth tables; these just happen to be the methods usually employed.