<a id="section-forethought-bridi-connection"></a>14.5. <a id="c14s5"></a>Forethought bridi connection
-----------------------------------------------------------------------------------------------------

<a id="id-1.15.7.2.1" class="indexterm"></a><a id="id-1.15.7.2.2" class="indexterm"></a>Many concepts in Lojban are expressible in two different ways, generally referred to as “afterthought” and “forethought”. [Section 14.4](../section-bridi-connection) discussed what is called “afterthought bridi logical connection”. The word “afterthought” is used because the connective cmavo and the second bridi were added, as it were, afterwards and without changing the form of the first bridi. This form might be used by someone who makes a statement and then wishes to add or qualify that statement after it has been completed. Thus,

<div class="interlinear-gloss-example example">
<a id="example-random-id-dp8V"></a>

**Example 14.14. <a id="c14e5d1"></a>** 

<a id="id-1.15.7.3.2.1" class="indexterm"></a>la .djan. nanmu

</div>  

is a complete bridi, and adding an afterthought connection to make

<div class="interlinear-gloss-example example">
<a id="example-random-id-7h3s"></a>

**Example 14.15. <a id="c14e5d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>nanmu</td><td>.ija</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John is a man or James is a woman (or both)</p></td></tr></tbody></table>

</div>  

provides additional information without requiring any change in the form of what has come before; changes which may not be possible or practical, especially in speaking. (The meaning, however, may be changed by the use of a negating connective.) Afterthought connectives make it possible to construct all the important truth-functional relationships in a variety of ways.

<a id="id-1.15.7.7.1" class="indexterm"></a><a id="id-1.15.7.7.2" class="indexterm"></a><a id="id-1.15.7.7.3" class="indexterm"></a><a id="id-1.15.7.7.4" class="indexterm"></a><a id="id-1.15.7.7.5" class="indexterm"></a><a id="id-1.15.7.7.6" class="indexterm"></a>In forethought style the speaker decides in advance, before expressing the first bridi, that a logical connection will be expressed. Forethought and afterthought connectives are expressed with separate selma'o. The forethought logical connectives corresponding to afterthought ijeks are geks:

<div class="interlinear-gloss-example example">
<a id="example-random-id-mYeS"></a>

**Example 14.16. <a id="c14e5d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ga</td><td>la</td><td>.djan.</td><td>nanmu</td><td>gi</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Either John is a man or James is a woman (or both).</p></td></tr></tbody></table>

</div>  

_<a id="id-1.15.7.9.1.1" class="indexterm"></a>[_ga_](../go01#valsi-ga)_ is the cmavo which represents the A truth function in selma'o GA. The word _<a id="id-1.15.7.9.3.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_ does not belong to GA at all, but constitutes its own selma'o: it serves only to separate the two bridi without having any content of its own. The English translation of _<a id="id-1.15.7.9.4.1" class="indexterm"></a>[_ga_](../go01#valsi-ga)_ … _<a id="id-1.15.7.9.5.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_ is “either ... or” , but in the English form the truth function is specified both by the word “either” and by the word “or” : not so in Lojban.

<a id="id-1.15.7.10.1" class="indexterm"></a><a id="id-1.15.7.10.2" class="indexterm"></a>Even though two bridi are being connected, geks and giks do not have any _<a id="id-1.15.7.10.3.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ in them. The forethought construct binds up the two bridi into a single sentence as far as the grammar is concerned.

Some more examples of forethought bridi connection are:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qGLh"></a>

**Example 14.17. <a id="c14e5d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ge</td><td>la</td><td>.djan.</td><td>nanmu</td><td>gi</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">(It is true that) both John is a man and James is a woman.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qgMN"></a>

**Example 14.18. <a id="c14e5d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>gu</td><td>la</td><td>.djan.</td><td>nanmu</td><td>gi</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">It is true that John is a man, whether or not James is a woman.</p></td></tr></tbody></table>

</div>  

It is worth emphasizing that [Example 14.18](../section-forethought-bridi-connection#example-random-id-qgMN) does not assert that James is (or is not) a woman. The _<a id="id-1.15.7.14.2.1" class="indexterm"></a>[_gu_](../go01#valsi-gu)_ which indicates that _<a id="id-1.15.7.14.3.1" class="indexterm"></a>la .djeimyz. ninmu_ may be true or false is unfortunately rather remote from the bridi thus affected.

Perhaps the most important of the truth functions commonly expressed in forethought is TFTT, which can be paraphrased as “if ... then ...” :

<div class="interlinear-gloss-example example">
<a id="example-random-id-Xcg1"></a>

**Example 14.19. <a id="c14e5d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ganai</td><td>la</td><td>.djan.</td><td>nanmu</td><td>gi</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr><tr class="gloss"><td>Either</td><td>that-named</td><td>John</td><td>is-not-a-man,</td><td>or</td><td>that-named</td><td>James</td><td>is-a-woman.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">If John is a man, then James is a woman.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.7.17.1" class="indexterm"></a><a id="id-1.15.7.17.2" class="indexterm"></a>Note the placement of the _<a id="id-1.15.7.17.3.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ in [Example 14.19](../section-forethought-bridi-connection#example-random-id-Xcg1). When added to afterthought selma'o such as JA, a following _<a id="id-1.15.7.17.5.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ negates the second bridi, to which it is adjacent. Since GA cmavo precede the first bridi, a following _<a id="id-1.15.7.17.6.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ negates the first bridi instead.

<a id="id-1.15.7.18.1" class="indexterm"></a>Why does English insist on forethought in the translation of [Example 14.19](../section-forethought-bridi-connection#example-random-id-Xcg1) ? Possibly because it would be confusing to seemingly assert a sentence and then make it conditional (which, as the Lojban form shows, involves a negation). Truth functions which involve negating the first sentence may be confusing, even to the Lojbanic understanding, when expressed using afterthought.

<a id="id-1.15.7.19.1" class="indexterm"></a>It must be reiterated here that not every use of English “if ... then” is properly translated by _<a id="id-1.15.7.19.3.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ _<a id="id-1.15.7.19.4.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ _<a id="id-1.15.7.19.5.1" class="indexterm"></a>[_ja_](../go01#valsi-ja)_ or _<a id="id-1.15.7.19.6.1" class="indexterm"></a>[_ganai_](../go01#valsi-ganai)_ … _<a id="id-1.15.7.19.7.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_ ; anything with implications of time needs a somewhat different Lojban translation, which will be discussed in [Section 14.18](../section-sumtcita). Causal sentences like “If you feed the pig, then it will grow” are not logical connectives of any type, but rather need a translation using _<a id="id-1.15.7.19.10.1" class="indexterm"></a>[_rinka_](../go01#valsi-rinka)_ as the selbri joining two event abstractions, thus:

<div class="interlinear-gloss-example example">
<a id="example-random-id-TQP9"></a>

**Example 14.20. <a id="c14e5d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nu</td><td>do</td><td>cidja</td><td>dunda</td><td>fi</td><td>le</td><td>xarju</td></tr><tr class="gloss"><td>The</td><td>event-of</td><td>(you</td><td>food</td><td>give</td><td>to</td><td>the</td><td>pig)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>cu</td><td>rinka</td><td>le</td><td>nu</td><td>ri</td><td>ba</td><td>banro</td></tr><tr class="gloss"><td></td><td>causes</td><td>the</td><td>event-of</td><td>(it</td><td>will</td><td>grow).</td></tr></tbody></table>

</div>  

Causality is discussed in far more detail in [Section 9.7](../section-causals).

[Example 14.21](../section-forethought-bridi-connection#example-random-id-I2jU) and [Example 14.22](../section-forethought-bridi-connection#example-random-id-Tiz6) illustrates a truth function, FTTF, which needs to negate either the first or the second bridi. We already understand how to negate the first bridi:

<div class="interlinear-gloss-example example">
<a id="example-random-id-I2jU"></a>

**Example 14.21. <a id="c14e5d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>gonai</td><td>la</td><td>.djan.</td><td>nanmu</td><td>gi</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John is not a man if and only if James is a woman.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">Either John is a man or James is a woman but not both.</p></td></tr></tbody></table>

</div>  

How can the second bridi be negated? By adding _<a id="id-1.15.7.24.1.1" class="indexterm"></a>\-nai_ to the _<a id="id-1.15.7.24.2.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_.

<div class="interlinear-gloss-example example">
<a id="example-random-id-Tiz6"></a>

**Example 14.22. <a id="c14e5d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>go</td><td>la</td><td>.djan.</td><td>nanmu</td><td>ginai</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John is a man if and only if James is not a woman.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">Either John is a man or James is a woman but not both.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.7.26.1" class="indexterm"></a>A compound cmavo based on _<a id="id-1.15.7.26.2.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_ is called a gik; the only giks are _<a id="id-1.15.7.26.3.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_ itself and _<a id="id-1.15.7.26.4.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_ _<a id="id-1.15.7.26.5.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_.

Further examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qgmv"></a>

**Example 14.23. <a id="c14e5d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ge</td><td>la</td><td>.djan.</td><td>nanmu</td><td>ginai</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John is a man and James is not a woman.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qgMy"></a>

**Example 14.24. <a id="c14e5d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ganai</td><td>la</td><td>.djan.</td><td>nanmu</td><td>ginai</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John is not a man or James is not a woman.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.7.30.1" class="indexterm"></a><a id="id-1.15.7.30.2" class="indexterm"></a><a id="id-1.15.7.30.3" class="indexterm"></a><a id="id-1.15.7.30.4" class="indexterm"></a><a id="id-1.15.7.30.5" class="indexterm"></a>The syntax of geks is:

> \[se\] GA \[nai\]

<a id="id-1.15.7.32.1" class="indexterm"></a><a id="id-1.15.7.32.2" class="indexterm"></a>and of giks (which are not themselves connectives, but part of the machinery of forethought connection) is:

> _<a id="id-1.15.7.33.1.1.1" class="indexterm"></a>[_gi_](../go01#valsi-gi)_ \[nai\]