<a id="section-explicit-magnitudes"></a>10.25. <a id="c10s25"></a>Explicit magnitudes
-------------------------------------------------------------------------------------

It is a limitation of the VA and ZI system of specifying magnitudes that they can only prescribe vague magnitudes: small, medium, or large. In order to express both an origin point and an exact distance, the Lojban construction called a “termset” is employed. (Termsets are explained further in [Section 14.11](../section-termsets) and [Section 16.7](../section-quantifier-grouping).) It is grammatical for a termset to be placed after a tense or modal tag rather than a sumti, which allows both the origin of the imaginary journey and its distance to be specified. Here is an example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-7Lys"></a>

**Example 10.189. <a id="c10e25d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.frank.</td><td>sanli</td><td>zu'a</td><td>nu'i</td><td>la</td><td>.djordj.</td></tr><tr class="gloss"><td>That-named</td><td>Frank</td><td>stands</td><td>[left]</td><td>[start-termset]</td><td></td><td>George</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la'u</td><td>lo</td><td>mitre</td><td>be</td><td>li</td><td>mu</td><td>[nu'u]</td></tr><tr class="gloss"><td>[quantity]</td><td>a</td><td>thing-measuring-in-meters</td><td></td><td>the-number</td><td>5</td><td>[end-termset].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Frank is standing five meters to the left of George.</p></td></tr></tbody></table>

</div>  

Here the termset extends from the _<a id="id-1.11.27.4.1.1" class="indexterm"></a>[_nu'i_](../go01#valsi-nuhi)_ to the implicit _<a id="id-1.11.27.4.2.1" class="indexterm"></a>[_nu'u_](../go01#valsi-nuhu)_ at the end of the sentence, and includes the terms _<a id="id-1.11.27.4.3.1" class="indexterm"></a>la .djordj._ , which is the unmarked origin point, and the tagged sumti _<a id="id-1.11.27.4.4.1" class="indexterm"></a>lo mitre be li mu_ , which the cmavo _<a id="id-1.11.27.4.5.1" class="indexterm"></a>[_la'u_](../go01#valsi-lahu)_ (of selma'o BAI, and meaning “with quantity” ; see [Section 9.6](../section-BAI)) marks as a quantity. Both terms are governed by the tag _<a id="id-1.11.27.4.8.1" class="indexterm"></a>[_zu'a_](../go01#valsi-zuha)_

It is not necessary to have both an origin point and an explicit magnitude: a termset may have only a single term in it. A less precise version of [Example 10.189](../section-explicit-magnitudes#example-random-id-7Lys) is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-RWEE"></a>

**Example 10.190. <a id="c10e25d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.frank.</td><td>sanli</td><td>zu'a</td><td>nu'i</td><td>la'u</td></tr><tr class="gloss"><td>That-named</td><td>Frank</td><td>stands</td><td>[left]</td><td>[termset]</td><td>[quantity]</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>mitre</td><td>be</td><td>li</td><td>mu</td></tr><tr class="gloss"><td>a</td><td>thing-measuring-in-meters</td><td></td><td>the-number</td><td>5.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Frank stands five meters to the left.</p></td></tr></tbody></table>

</div>