<a id="section-evidentials"></a>13.11. <a id="c13s11"></a>Evidentials
---------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ja'o</p></td><td class="gismu"><p class="gismu">[jalge]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">I conclude</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ca'e</p></td><td class="gismu"><p class="gismu"></p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">I define</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ba'a</p></td><td class="gismu"><p class="gismu">[balvi]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">I expect</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">I experience</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">I remember</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">su'a</p></td><td class="gismu"><p class="gismu">[sucta]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">I generalize</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">I particularize</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ti'e</p></td><td class="gismu"><p class="gismu">[tirna]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">I hear (hearsay)</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ka'u</p></td><td class="gismu"><p class="gismu">[kulnu]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">I know by cultural means</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">se'o</p></td><td class="gismu"><p class="gismu">[senva]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">I know by internal experience</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">za'a</p></td><td class="gismu"><p class="gismu">[zgana]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">I observe</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">pe'i</p></td><td class="gismu"><p class="gismu">[pensi]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">I opine</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ru'a</p></td><td class="gismu"><p class="gismu">[sruma]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">I postulate</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ju'a</p></td><td class="gismu"><p class="gismu">[jufra]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">I state</p></td></tr></tbody></table>

<a id="id-1.14.13.4.1" class="indexterm"></a><a id="id-1.14.13.4.2" class="indexterm"></a><a id="id-1.14.13.4.3" class="indexterm"></a><a id="id-1.14.13.4.4" class="indexterm"></a><a id="id-1.14.13.4.5" class="indexterm"></a>Now we proceed from the attitudinal indicators and their relatives to the other, semantically unrelated, categories of indicators. The indicators known as “evidentials” show how the speaker came to say the utterance; i.e. the source of the information or the idea. Lojban's list of evidentials was derived from lists describing several American Indian languages. Evidentials are also essential to the constructed language Láadan, designed by the linguist and novelist Suzette Haden Elgin. Láadan's set of indicators was drawn on extensively in developing the Lojban indicator system.

<a id="id-1.14.13.5.1" class="indexterm"></a>It is important to realize, however, that evidentials are not some odd system used by some strange people who live at the other end of nowhere: although their English equivalents aren't single words, English-speakers have vivid notions of what constitutes evidence, and of the different kinds of evidence.

<a id="id-1.14.13.6.1" class="indexterm"></a><a id="id-1.14.13.6.2" class="indexterm"></a>Like the attitudinal indicators, the evidentials belong to selma'o UI, and may be treated identically for grammatical purposes. Most of them are not usually considered scalar in nature, but a few have associated scales.

<a id="id-1.14.13.7.1" class="indexterm"></a><a id="id-1.14.13.7.2" class="indexterm"></a><a id="id-1.14.13.7.3" class="indexterm"></a>A bridi with an evidential in it becomes “indisputable” , in the sense that the speaker is saying “how it is with him or her” , which is beyond argument. Claims about one's own mental states may be true or false, but are hardly subject to other people's examination. If you say that you think, or perceive, or postulate such-and-such a predication, who can contradict you? Discourse that uses evidentials has therefore a different rhetorical flavor than discourse that does not; arguments tend to become what can be called dialogues or alternating monologues, depending on your prejudices.

<a id="id-1.14.13.8.1" class="indexterm"></a>Evidentials are most often placed at the beginning of sentences, and are often attached to the _<a id="id-1.14.13.8.2.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ that separates sentences in connected discourse. It is in the nature of an evidential to affect the entire bridi in which it is placed: like the propositional attitude indicators, they strongly affect the claim made by the main bridi.

<a id="id-1.14.13.9.1" class="indexterm"></a><a id="id-1.14.13.9.2" class="indexterm"></a>A bridi marked by _<a id="id-1.14.13.9.3.1" class="indexterm"></a>[_ja'o_](../go01#valsi-jaho)_ is a conclusion by the speaker based on other (stated or unstated) information or ideas. Rough English equivalents of _<a id="id-1.14.13.9.4.1" class="indexterm"></a>[_ja'o_](../go01#valsi-jaho)_ are “thus” and “therefore”.

A bridi marked by _<a id="id-1.14.13.10.1.1" class="indexterm"></a>[_ca'e_](../go01#valsi-cahe)_ is true because the speaker says so. In addition to definitions of words, _<a id="id-1.14.13.10.2.1" class="indexterm"></a>[_ca'e_](../go01#valsi-cahe)_ is also appropriate in what are called performatives, where the very act of speaking the words makes them true. An English example is “I now pronounce you husband and wife” , where the very act of uttering the words makes the listeners into husband and wife. A Lojban translation might be:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Po4T"></a>

**Example 13.77. <a id="c13e11d1"></a><a id="id-1.14.13.11.1.2" class="indexterm"></a><a id="id-1.14.13.11.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ca'e</td><td>le</td><td>re</td><td>do</td><td>cu</td><td>simxu</td><td>speni</td></tr><tr class="gloss"><td>[I-define!]</td><td>the</td><td>two</td><td>of-you</td><td></td><td>are-mutual</td><td>spouses.</td></tr></tbody></table>

</div>  

<a id="id-1.14.13.12.1" class="indexterm"></a><a id="id-1.14.13.12.2" class="indexterm"></a><a id="id-1.14.13.12.3" class="indexterm"></a>The three scale positions of _<a id="id-1.14.13.12.4.1" class="indexterm"></a>[_ba'a_](../go01#valsi-baha)_ , when attached to a bridi, indicate that it is based on the speaker's view of the real world. Thus _<a id="id-1.14.13.12.5.1" class="indexterm"></a>[_ba'a_](../go01#valsi-baha)_ means that the statement represents a future event as anticipated by the speaker; _<a id="id-1.14.13.12.6.1" class="indexterm"></a>[_ba'acu'i_](../go01#valsi-bahacuhi)_ , a present event as experienced by the speaker; _<a id="id-1.14.13.12.7.1" class="indexterm"></a>[_ba'anai_](../go01#valsi-bahanai)_ , a past event as remembered by the speaker. It is accidental that this scale runs from future to past instead of past to future.

<div class="interlinear-gloss-example example">
<a id="example-random-id-B87W"></a>

**Example 13.78. <a id="c13e11d2"></a><a id="id-1.14.13.13.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ba'acu'i</td><td>le</td><td>tuple</td><td>be</td><td>mi</td><td>cu</td><td>se&nbsp;cortu</td></tr><tr class="gloss"><td>[I-experience!]</td><td>the</td><td>leg</td><td>of</td><td>me</td><td></td><td>is-the-locus-of-pain.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">My leg hurts.</p></td></tr></tbody></table>

</div>  

<a id="id-1.14.13.14.1" class="indexterm"></a><a id="id-1.14.13.14.2" class="indexterm"></a><a id="id-1.14.13.14.3" class="indexterm"></a>A bridi marked by _<a id="id-1.14.13.14.4.1" class="indexterm"></a>[_su'a_](../go01#valsi-suha)_ is a generalization by the speaker based on other (stated or unstated) information or ideas. The difference between _<a id="id-1.14.13.14.5.1" class="indexterm"></a>[_su'a_](../go01#valsi-suha)_ and _<a id="id-1.14.13.14.6.1" class="indexterm"></a>[_ja'o_](../go01#valsi-jaho)_ is that _<a id="id-1.14.13.14.7.1" class="indexterm"></a>[_ja'o_](../go01#valsi-jaho)_ suggests some sort of reasoning or deduction (not necessarily rigorous), whereas _<a id="id-1.14.13.14.8.1" class="indexterm"></a>[_su'a_](../go01#valsi-suha)_ suggests some sort of induction or pattern recognition from existing examples (not necessarily rigorous).

<a id="id-1.14.13.15.1" class="indexterm"></a>The opposite point of the scale, _<a id="id-1.14.13.15.2.1" class="indexterm"></a>[_su'anai_](../go01#valsi-suhanai)_ , indicates abduction, or drawing specific conclusions from general premises or patterns.

<a id="id-1.14.13.16.1" class="indexterm"></a>This cmavo can also function as a discursive (see [Section 13.12](../section-discursives)), in which case _<a id="id-1.14.13.16.3.1" class="indexterm"></a>[_su'a_](../go01#valsi-suha)_ means “abstractly” or “in general” , and _<a id="id-1.14.13.16.6.1" class="indexterm"></a>[_su'anai_](../go01#valsi-suhanai)_ means “concretely” or “in particular”.

<a id="id-1.14.13.17.1" class="indexterm"></a>A bridi marked by _<a id="id-1.14.13.17.2.1" class="indexterm"></a>[_ti'e_](../go01#valsi-tihe)_ is relayed information from some source other than the speaker. There is no necessary implication that the information was relayed via the speaker's ears; what we read in a newspaper is an equally good example of _<a id="id-1.14.13.17.3.1" class="indexterm"></a>[_ti'e_](../go01#valsi-tihe)_ , unless we have personal knowledge of the content.

<div class="interlinear-gloss-example example">
<a id="example-random-id-jiXV"></a>

**Example 13.79. <a id="c13e11d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ti'e</td><td>la</td><td>.uengas</td><td>cu</td><td>zergau</td></tr><tr class="gloss"><td>[I-hear!]</td><td>Wenga</td><td></td><td>is-a-criminal-doer.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I hear that Wenga is a crook.</p></td></tr></tbody></table>

</div>  

<a id="id-1.14.13.19.1" class="indexterm"></a><a id="id-1.14.13.19.2" class="indexterm"></a>A bridi marked by _<a id="id-1.14.13.19.3.1" class="indexterm"></a>[_ka'u_](../go01#valsi-kahu)_ is one held to be true in the speaker's cultural context, as a matter of myth or custom, for example. Such statements should be agreed on by a community of people – you cannot just make up your own cultural context – although “objectivity” in the sense of actual correspondence with the facts is certainly not required.

<a id="id-1.14.13.20.1" class="indexterm"></a><a id="id-1.14.13.20.2" class="indexterm"></a><a id="id-1.14.13.20.3" class="indexterm"></a><a id="id-1.14.13.20.4" class="indexterm"></a>On the other hand, _<a id="id-1.14.13.20.5.1" class="indexterm"></a>[_se'o_](../go01#valsi-seho)_ marks a bridi whose truth is asserted by the speaker as a result of an internal experience not directly available to others, such as a dream, vision, or personal revelation. In some cultures, the line between _<a id="id-1.14.13.20.6.1" class="indexterm"></a>[_ka'u_](../go01#valsi-kahu)_ and _<a id="id-1.14.13.20.7.1" class="indexterm"></a>[_se'o_](../go01#valsi-seho)_ is fuzzy or even nonexistent.

<a id="id-1.14.13.21.1" class="indexterm"></a><a id="id-1.14.13.21.2" class="indexterm"></a>A bridi marked by _<a id="id-1.14.13.21.3.1" class="indexterm"></a>[_za'a_](../go01#valsi-zaha)_ is based on perception or direct observation by the speaker. This use of “observe” is not connected with the Lojban “observative” , or bridi with the first sumti omitted. The latter has no explicit aspect, and could be a direct observation, a conclusion, an opinion, or other aspectual point of view.

<div class="interlinear-gloss-example example">
<a id="example-random-id-KEKa"></a>

**Example 13.80. <a id="c13e11d4"></a><a id="id-1.14.13.22.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>za'a</td><td>do</td><td>tatpi</td></tr><tr class="gloss"><td>[I-observe!]</td><td>you</td><td>are-tired.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I see you are tired.</p></td></tr></tbody></table>

</div>  

A bridi marked by _<a id="id-1.14.13.23.1.1" class="indexterm"></a>[_pe'i_](../go01#valsi-pehi)_ is the opinion of the speaker. The form _<a id="id-1.14.13.23.2.1" class="indexterm"></a>pe'ipei_ is common, meaning “Is this your opinion?”. (Strictly, this should be _<a id="id-1.14.13.23.4.1" class="indexterm"></a>peipe'i_ , in accordance with the distinction explained in [Example 13.69](../section-questions-empathy-contours#example-random-id-qFYU) through [Example 13.71](../section-questions-empathy-contours#example-random-id-qFzH) , but since _<a id="id-1.14.13.23.7.1" class="indexterm"></a>[_pe'i_](../go01#valsi-pehi)_ is not really a scale, there is no real difference between the two orders.)

<div class="interlinear-gloss-example example">
<a id="example-random-id-DcAG"></a>

**Example 13.81. <a id="c13e11d5"></a><a id="id-1.14.13.24.1.2" class="indexterm"></a><a id="id-1.14.13.24.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>pe'i</td><td>la</td><td>.kartagos.</td><td>.ei</td><td>se&nbsp;daspo</td></tr><tr class="gloss"><td>[I-opine!]</td><td>that-named</td><td>Carthage</td><td>[obligation]</td><td>is-destroyed.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">In my opinion, Carthage should be destroyed.</p></td></tr></tbody></table>

</div>  

<a id="id-1.14.13.25.1" class="indexterm"></a><a id="id-1.14.13.25.2" class="indexterm"></a>A bridi marked by _<a id="id-1.14.13.25.3.1" class="indexterm"></a>[_ru'a_](../go01#valsi-ruha)_ is an assumption made by the speaker. This is similar to one possible use of _<a id="id-1.14.13.25.4.1" class="indexterm"></a>[_.e'u_](../go01#valsi-ehu)_.

<div class="interlinear-gloss-example example">
<a id="example-random-id-ydRN"></a>

**Example 13.82. <a id="c13e11d6"></a><a id="id-1.14.13.26.1.2" class="indexterm"></a><a id="id-1.14.13.26.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ru'a</td><td>doi</td><td>.livinston.</td></tr><tr class="gloss"><td>[I-presume]</td><td>o</td><td>Livingstone.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Dr. Livingstone, I presume? (A rhetorical question: Stanley knew who he was.)</p></td></tr></tbody></table>

</div>  

<a id="id-1.14.13.27.1" class="indexterm"></a>Finally, the evidential _<a id="id-1.14.13.27.2.1" class="indexterm"></a>[_ju'a_](../go01#valsi-juha)_ is used to avoid stating a specific basis for a statement. It can also be used when the basis for the speaker's statement is not covered by any other evidential. For the most part, using _<a id="id-1.14.13.27.3.1" class="indexterm"></a>[_ju'a_](../go01#valsi-juha)_ is equivalent to using no evidential at all, but in question form it can be useful: _<a id="id-1.14.13.27.4.1" class="indexterm"></a>ju'apei_ means “What is the basis for your statement?” and serves as an evidential, as distinct from emotional, question.