<a id="section-events"></a>11.2. <a id="c11s2"></a>Event abstraction
--------------------------------------------------------------------

<a id="id-1.12.4.2.1" class="indexterm"></a><a id="id-1.12.4.2.2" class="indexterm"></a>The following cmavo is discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">nu</p></td><td class="selmaho"><p class="selmaho">NU</p></td><td class="description"><p class="description">event abstractor</p></td></tr></tbody></table>

<a id="id-1.12.4.4.1" class="indexterm"></a><a id="id-1.12.4.4.2" class="indexterm"></a><a id="id-1.12.4.4.3" class="indexterm"></a>The examples in [Section 11.1](../chapter-abstractions#section-syntax) made use of _<a id="id-1.12.4.4.5.1" class="indexterm"></a>[_nu_](../go01#valsi-nu)_ as the abstractor, and it is certainly the most common abstractor in Lojban text. Its purpose is to capture the event or state of the bridi considered as a whole. Do not confuse the _<a id="id-1.12.4.4.6.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ description built on a _<a id="id-1.12.4.4.7.1" class="indexterm"></a>[_nu_](../go01#valsi-nu)_ abstraction with ordinary descriptions based on _<a id="id-1.12.4.4.8.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ alone. The following sumti are quite distinct:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qF0u"></a>

**Example 11.5. <a id="c11e2d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>klama</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the comer, that which comes</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qF0U"></a>

**Example 11.6. <a id="c11e2d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>se</td><td>klama</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the destination</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qf11"></a>

**Example 11.7. <a id="c11e2d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>te</td><td>klama</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the origin</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qf22"></a>

**Example 11.8. <a id="c11e2d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ve</td><td>klama</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the route</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qf4x"></a>

**Example 11.9. <a id="c11e2d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>xe</td><td>klama</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the means of transportation</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qf97"></a>

**Example 11.10. <a id="c11e2d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nu</td><td>klama</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the event of someone coming to somewhere from somewhere by some route using some means</p></td></tr></tbody></table>

</div>  

[Example 11.5](../section-events#example-random-id-qF0u) through [Example 11.9](../section-events#example-random-id-qf4x) are descriptions that isolate the five individual sumti places of the selbri _<a id="id-1.12.4.11.3.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_. [Example 11.10](../section-events#example-random-id-qf97) describes something associated with the bridi as a whole: the event of it.

<a id="id-1.12.4.12.1" class="indexterm"></a>In Lojban, the term “event” is divorced from its ordinary English sense of something that happens over a short period of time. The description:

<div class="interlinear-gloss-example example">
<a id="example-random-id-mxAt"></a>

**Example 11.11. <a id="c11e2d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nu</td><td>mi</td><td>vasxu</td></tr><tr class="gloss"><td>the</td><td>event-of</td><td>my</td><td>breathing</td></tr></tbody></table>

</div>  

is an event which lasts for the whole of my life (under normal circumstances). On the other hand,

<div class="interlinear-gloss-example example">
<a id="example-random-id-BPcI"></a>

**Example 11.12. <a id="c11e2d8"></a><a id="id-1.12.4.15.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nu</td><td>la</td><td>.djan.</td><td>cinba</td><td>la</td><td>.djein.</td></tr><tr class="gloss"><td>the</td><td>event-of</td><td>that-named</td><td>John</td><td>kissing</td><td>that-named</td><td>Jane</td></tr></tbody></table>

</div>  

<a id="id-1.12.4.16.1" class="indexterm"></a>is relatively brief by comparison (again, under normal circumstances).

<a id="id-1.12.4.17.1" class="indexterm"></a>We can see from [Example 11.10](../section-events#example-random-id-qf97) through [Example 11.12](../section-events#example-random-id-BPcI) that ellipsis of sumti is valid in the bridi of abstraction selbri, just as in the main bridi of a sentence. Any sumti may be ellipsized if the listener will be able to figure out from context what the proper value of it is, or else to recognize that the proper value is unimportant. It is extremely common for _<a id="id-1.12.4.17.4.1" class="indexterm"></a>[_nu_](../go01#valsi-nu)_ abstractions in descriptions to have the x1 place ellipsized:

<div class="interlinear-gloss-example example">
<a id="example-random-id-FRoP"></a>

**Example 11.13. <a id="c11e2d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nelci</td><td>le</td><td>nu</td><td>limna</td></tr><tr class="gloss"><td>I</td><td>like</td><td>the</td><td>event-of</td><td>swimming.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I like swimming.</p></td></tr></tbody></table>

</div>  

is elliptical, and most probably means:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Ys8w"></a>

**Example 11.14. <a id="c11e2d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nelci</td><td>le</td><td>nu</td><td>mi</td><td>limna</td></tr><tr class="gloss"><td>I</td><td>like</td><td>the</td><td>event-of</td><td>I</td><td>swim.</td></tr></tbody></table>

</div>  

In the proper context, of course, [Example 11.13](../section-events#example-random-id-FRoP) could refer to the event of somebody else swimming. Its English equivalent, “I like swimming” , can't be interpreted as “I like Frank's swimming” ; this is a fundamental distinction between English and Lojban. In Lojban, an omitted sumti can mean whatever the context indicates that it should mean.

<a id="id-1.12.4.22.1" class="indexterm"></a>Note that the lack of an explicit NU cmavo in a sumti can sometimes hide an implicit abstraction. In the context of [Example 11.14](../section-events#example-random-id-Ys8w) , the appearance of _<a id="id-1.12.4.22.3.1" class="indexterm"></a>le se nelci_ ( “that which is liked”) is in effect an abstraction:

<div class="interlinear-gloss-example example">
<a id="example-random-id-sMsx"></a>

**Example 11.15. <a id="c11e2d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>se&nbsp;nelci</td><td>cu</td><td>cafne</td></tr><tr class="gloss"><td>The</td><td>liked-thing</td><td>&nbsp;</td><td>is-frequent.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The thing which I like happens often.</p></td></tr></tbody></table>

</div>  

which in this context means

> My swimming happens often.

Event descriptions with _<a id="id-1.12.4.26.1.1" class="indexterm"></a>le nu_ are commonly used to fill the “under conditions...” places, among others, of gismu and lujvo place structures:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Ia6f"></a>

**Example 11.16. <a id="c11e2d12"></a><a id="id-1.12.4.27.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.lojban.</td><td>cu</td><td>frili</td><td></td><td>mi</td></tr><tr class="gloss"><td>That-named</td><td>Lojban</td><td>&nbsp;</td><td>is-easy-for</td><td>me</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>&nbsp;</td><td>le</td><td>nu</td><td>mi</td><td>tadni</td><td>[kei]</td></tr><tr class="gloss"><td>under-conditions</td><td>the</td><td>event-of</td><td>I</td><td>study</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Lojban is easy for me when I study.</p></td></tr></tbody></table>

</div>  

(The “when” of the English would also be appropriate for a construction involving a Lojban tense, but the Lojban sentence says more than that the studying is concurrent with the ease.)

<a id="id-1.12.4.29.1" class="indexterm"></a><a id="id-1.12.4.29.2" class="indexterm"></a>The place structure of a _<a id="id-1.12.4.29.3.1" class="indexterm"></a>[_nu_](../go01#valsi-nu)_ abstraction selbri is simply:

> x1 is an event of (the bridi)