<a id="section-events-and-contours"></a>11.11. <a id="c11s11"></a>Event-type abstractors and event contour tenses
-----------------------------------------------------------------------------------------------------------------

This section is a logical continuation of [Section 11.3](../section-event-types).

<a id="id-1.12.13.3.1" class="indexterm"></a>There exists a relationship between the four types of events explained in [Section 11.3](../section-event-types) and the event contour tense cmavo of selma'o ZAhO. The specific cmavo of NU and of ZAhO are mutually interdefining; the ZAhO contours were chosen to fit the needs of the NU event types and vice versa. Event contours are explained in full in [Section 10.10](../section-event-contours) , and only summarized here.

The purpose of ZAhO cmavo is to represent the natural portions of an event, such as the beginning, the middle, and the end. They fall into several groups:

*   <a id="id-1.12.13.5.1.1.1" class="indexterm"></a>The cmavo _<a id="id-1.12.13.5.1.1.2.1" class="indexterm"></a>[_pu'o_](../go01#valsi-puho)_ , _<a id="id-1.12.13.5.1.1.3.1" class="indexterm"></a>[_ca'o_](../go01#valsi-caho)_ , and _<a id="id-1.12.13.5.1.1.4.1" class="indexterm"></a>[_ba'o_](../go01#valsi-baho)_ represent spans of time: before an event begins, while it is going on, and after it is over, respectively.

*   The cmavo _<a id="id-1.12.13.5.2.1.1.1" class="indexterm"></a>[_co'a_](../go01#valsi-coha)_ , _<a id="id-1.12.13.5.2.1.2.1" class="indexterm"></a>[_de'a_](../go01#valsi-deha)_ , _<a id="id-1.12.13.5.2.1.3.1" class="indexterm"></a>[_di'a_](../go01#valsi-diha)_ , and _<a id="id-1.12.13.5.2.1.4.1" class="indexterm"></a>[_co'u_](../go01#valsi-cohu)_ represent points of time: the start of an event, the temporary stopping of an event, the resumption of an event after a stop, and the end of an event, respectively. Not all events can have breaks in them, in which case _<a id="id-1.12.13.5.2.1.5.1" class="indexterm"></a>[_de'a_](../go01#valsi-deha)_ and _<a id="id-1.12.13.5.2.1.6.1" class="indexterm"></a>[_di'a_](../go01#valsi-diha)_ do not apply.

*   The cmavo _<a id="id-1.12.13.5.3.1.1.1" class="indexterm"></a>[_mo'u_](../go01#valsi-mohu)_ and _<a id="id-1.12.13.5.3.1.2.1" class="indexterm"></a>[_za'o_](../go01#valsi-zaho)_ correspond to _<a id="id-1.12.13.5.3.1.3.1" class="indexterm"></a>[_co'u_](../go01#valsi-cohu)_ and _<a id="id-1.12.13.5.3.1.4.1" class="indexterm"></a>[_ba'o_](../go01#valsi-baho)_ respectively, in the case of those events which have a natural ending point that may not be the same as the actual ending point: _<a id="id-1.12.13.5.3.1.5.1" class="indexterm"></a>[_mo'u_](../go01#valsi-mohu)_ refers to the natural ending point, and _<a id="id-1.12.13.5.3.1.6.1" class="indexterm"></a>[_za'o_](../go01#valsi-zaho)_ to the time between the natural ending point and the actual ending point (the “excessive” or “superfective” part of the event).

*   The cmavo _<a id="id-1.12.13.5.4.1.1.1" class="indexterm"></a>[_co'i_](../go01#valsi-cohi)_ represents an entire event considered as a point-event or achievement.

All these cmavo are applicable to events seen as processes and abstracted with _<a id="id-1.12.13.6.1.1" class="indexterm"></a>[_pu'u_](../go01#valsi-puhu)_. Only processes have enough internal structure to make all these points and spans of time meaningful.

<a id="id-1.12.13.7.1" class="indexterm"></a>For events seen as states and abstracted with _<a id="id-1.12.13.7.2.1" class="indexterm"></a>[_za'i_](../go01#valsi-zahi)_ , the meaningful event contours are the spans _<a id="id-1.12.13.7.3.1" class="indexterm"></a>[_pu'o_](../go01#valsi-puho)_ , _<a id="id-1.12.13.7.4.1" class="indexterm"></a>[_ca'o_](../go01#valsi-caho)_ , and _<a id="id-1.12.13.7.5.1" class="indexterm"></a>[_ba'o_](../go01#valsi-baho)_ ; the starting and ending points _<a id="id-1.12.13.7.6.1" class="indexterm"></a>[_co'a_](../go01#valsi-coha)_ and _<a id="id-1.12.13.7.7.1" class="indexterm"></a>[_co'u_](../go01#valsi-cohu)_ , and the achievement contour _<a id="id-1.12.13.7.8.1" class="indexterm"></a>[_co'i_](../go01#valsi-cohi)_. States do not have natural endings distinct from their actual endings. (It is an open question whether states can be stopped and resumed.)

<a id="id-1.12.13.8.1" class="indexterm"></a>For events seen as activities and abstracted with _<a id="id-1.12.13.8.2.1" class="indexterm"></a>[_zu'o_](../go01#valsi-zuho)_ , the meaningful event contours are the spans _<a id="id-1.12.13.8.3.1" class="indexterm"></a>[_pu'o_](../go01#valsi-puho)_ , _<a id="id-1.12.13.8.4.1" class="indexterm"></a>[_ca'o_](../go01#valsi-caho)_ , and _<a id="id-1.12.13.8.5.1" class="indexterm"></a>[_ba'o_](../go01#valsi-baho)_ , and the achievement contour _<a id="id-1.12.13.8.6.1" class="indexterm"></a>[_co'i_](../go01#valsi-cohi)_. Because activities are inherently cyclic and repetitive, the beginning and ending points are not well-defined: you do not know whether an activity has truly begun until it begins to repeat.

<a id="id-1.12.13.9.1" class="indexterm"></a><a id="id-1.12.13.9.2" class="indexterm"></a>For events seen as point-events and abstracted with _<a id="id-1.12.13.9.3.1" class="indexterm"></a>[_mu'e_](../go01#valsi-muhe)_ , the meaningful event contours are the spans _<a id="id-1.12.13.9.4.1" class="indexterm"></a>[_pu'o_](../go01#valsi-puho)_ and _<a id="id-1.12.13.9.5.1" class="indexterm"></a>[_ba'o_](../go01#valsi-baho)_ but not _<a id="id-1.12.13.9.6.1" class="indexterm"></a>[_ca'o_](../go01#valsi-caho)_ (a point-event has no duration), and the achievement contour _<a id="id-1.12.13.9.7.1" class="indexterm"></a>[_co'i_](../go01#valsi-cohi)_.

Note that the parts of events are themselves events, and may be treated as such. The points in time may be seen as _<a id="id-1.12.13.10.1.1" class="indexterm"></a>[_mu'e_](../go01#valsi-muhe)_ point-events; the spans of time may constitute processes or activities. Therefore, Lojban allows us to refer to processes within processes, activities within states, and many other complicated abstract things.