<a id="section-event-types"></a>11.3. <a id="c11s3"></a>Types of event abstractions
-----------------------------------------------------------------------------------

<a id="id-1.12.5.2.1" class="indexterm"></a>The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">mu'e</p></td><td class="selmaho"><p class="selmaho">NU</p></td><td class="description"><p class="description">point-event abstractor</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">pu'u</p></td><td class="selmaho"><p class="selmaho">NU</p></td><td class="description"><p class="description">process abstractor</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">zu'o</p></td><td class="selmaho"><p class="selmaho">NU</p></td><td class="description"><p class="description">activity abstractor</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">za'i</p></td><td class="selmaho"><p class="selmaho">NU</p></td><td class="description"><p class="description">state abstractor</p></td></tr></tbody></table>

Event abstractions with _<a id="id-1.12.5.4.1.1" class="indexterm"></a>[_nu_](../go01#valsi-nu)_ suffice to express all kinds of events, whether long, short, unique, repetitive, or whatever. Lojban also has more finely discriminating machinery for talking about events, however. There are four other abstractors of selma'o NU for talking about four specific types of events, or four ways of looking at the same event.

<a id="id-1.12.5.5.1" class="indexterm"></a><a id="id-1.12.5.5.2" class="indexterm"></a><a id="id-1.12.5.5.3" class="indexterm"></a><a id="id-1.12.5.5.4" class="indexterm"></a><a id="id-1.12.5.5.5" class="indexterm"></a><a id="id-1.12.5.5.6" class="indexterm"></a>An event considered as a point in time is called a “point-event” , or sometimes an “achievement”. (This latter word should be divorced, in this context, from all connotations of success or triumph.) A point-event can be extended in duration, but it is still a point-event if it is thought of as unitary, having no internal structure. The abstractor _<a id="id-1.12.5.5.9.1" class="indexterm"></a>[_mu'e_](../go01#valsi-muhe)_ means “point-event-of” :

<div class="interlinear-gloss-example example">
<a id="example-random-id-nFR1"></a>

**Example 11.17. <a id="c11e3d1"></a><a id="id-1.12.5.6.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>mu'e</td><td>la</td><td>.djan.</td><td>catra</td><td>la</td><td>.djim.</td><td>cu</td><td>zekri</td></tr><tr class="gloss"><td>The</td><td>point-event-of</td><td>(that-named</td><td>John</td><td>kills</td><td>that-named</td><td>Jim)</td><td>&nbsp;</td><td>is-a-crime.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John's killing Jim (considered as a point in time) is a crime.</p></td></tr></tbody></table>

</div>  

<a id="id-1.12.5.7.1" class="indexterm"></a><a id="id-1.12.5.7.2" class="indexterm"></a><a id="id-1.12.5.7.3" class="indexterm"></a><a id="id-1.12.5.7.4" class="indexterm"></a>An event considered as extended in time, and structured with a beginning, a middle containing one or more stages, and an end, is called a “process”. The abstractor _<a id="id-1.12.5.7.6.1" class="indexterm"></a>[_pu'u_](../go01#valsi-puhu)_ means “process-of” :

<div class="interlinear-gloss-example example">
<a id="example-random-id-WaxD"></a>

**Example 11.18. <a id="c11e3d2"></a><a id="id-1.12.5.8.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ca'o</td><td>le</td><td>pu'u</td><td>le</td><td>latmo</td><td>balje'a</td><td>cu</td><td>porpi</td><td>kei</td></tr><tr class="gloss"><td>[continuitive]</td><td>the</td><td>process-of(</td><td>the</td><td>Latin</td><td>great-state</td><td></td><td>breaking-up</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>so'i</td><td>je'atru</td><td>cu</td><td>selcatra</td></tr><tr class="gloss"><td>many</td><td>state-rulers</td><td></td><td>were-killed</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">During the fall of the Roman Empire, many Emperors were killed.</p></td></tr></tbody></table>

</div>  

<a id="id-1.12.5.9.1" class="indexterm"></a><a id="id-1.12.5.9.2" class="indexterm"></a><a id="id-1.12.5.9.3" class="indexterm"></a><a id="id-1.12.5.9.4" class="indexterm"></a>An event considered as extended in time and cyclic or repetitive is called an “activity”. The abstractor _<a id="id-1.12.5.9.6.1" class="indexterm"></a>[_zu'o_](../go01#valsi-zuho)_ means “activity-of” :

<div class="interlinear-gloss-example example">
<a id="example-random-id-89nw"></a>

**Example 11.19. <a id="c11e3d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>tatpi</td><td>ri'a</td><td>le</td><td>zu'o</td><td>mi</td><td>plipe</td></tr><tr class="gloss"><td>I</td><td>am-tired</td><td>because-of</td><td>the</td><td>activity-of</td><td>(I</td><td>jump).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am tired because I jump.</p></td></tr></tbody></table>

</div>  

<a id="id-1.12.5.11.1" class="indexterm"></a><a id="id-1.12.5.11.2" class="indexterm"></a><a id="id-1.12.5.11.3" class="indexterm"></a>An event considered as something that is either happening or not happening, with sharp boundaries, is called a “state”. The abstractor _<a id="id-1.12.5.11.5.1" class="indexterm"></a>[_za'i_](../go01#valsi-zahi)_ means “state-of” :

<div class="interlinear-gloss-example example">
<a id="example-random-id-WztQ"></a>

**Example 11.20. <a id="c11e3d4"></a><a id="id-1.12.5.12.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>za'i</td><td>mi</td><td>jmive</td><td>cu</td><td>ckape</td><td>do</td></tr><tr class="gloss"><td>The</td><td>state-of</td><td>(I</td><td>am-alive)</td><td>&nbsp;</td><td>is-dangerous-to</td><td>you.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">My being alive is dangerous to you.</p></td></tr></tbody></table>

</div>  

<a id="id-1.12.5.13.1" class="indexterm"></a>The abstractors in [Example 11.17](../section-event-types#example-random-id-nFR1) through [Example 11.20](../section-event-types#example-random-id-WztQ) could all have been replaced by _<a id="id-1.12.5.13.4.1" class="indexterm"></a>[_nu_](../go01#valsi-nu)_ , with some loss of precision. Note that Lojban allows every sort of event to be viewed in any of these four ways:

*   <a id="id-1.12.5.14.1.1.1" class="indexterm"></a>the “state of running” begins when the runner starts and ends when the runner stops;

*   <a id="id-1.12.5.14.2.1.1" class="indexterm"></a>the “activity of running” consists of the cycle “lift leg, step forward, drop leg, lift other leg...” (each such cycle is a process, but the activity consists in the repetition of the cycle);

*   <a id="id-1.12.5.14.3.1.1" class="indexterm"></a><a id="id-1.12.5.14.3.1.2" class="indexterm"></a><a id="id-1.12.5.14.3.1.3" class="indexterm"></a>the “process of running” puts emphasis on the initial sprint, the steady speed, and the final slowdown;

*   <a id="id-1.12.5.14.4.1.1" class="indexterm"></a><a id="id-1.12.5.14.4.1.2" class="indexterm"></a><a id="id-1.12.5.14.4.1.3" class="indexterm"></a><a id="id-1.12.5.14.4.1.4" class="indexterm"></a><a id="id-1.12.5.14.4.1.5" class="indexterm"></a>the “achievement of running” is most alien to English, but sees the event of running as a single indivisible thing, like “Pheidippides' run from Marathon to Athens” (the original marathon).

Further information on types of events can be found in [Section 11.12](../section-abstractor-connection).

The four event type abstractors have the following place structures:

> _<a id="id-1.12.5.17.1.1.1" class="indexterm"></a>[_mu'e_](../go01#valsi-muhe)_ : x1 is a point event of (the bridi)<a id="id-1.12.5.17.1.3" class="indexterm"></a><a id="id-1.12.5.17.1.4" class="indexterm"></a><a id="id-1.12.5.17.1.5" class="indexterm"></a>

> _<a id="id-1.12.5.18.1.1.1" class="indexterm"></a>[_pu'u_](../go01#valsi-puhu)_ : x1 is a process of (the bridi) with stages x2<a id="id-1.12.5.18.1.3" class="indexterm"></a><a id="id-1.12.5.18.1.4" class="indexterm"></a>

> _<a id="id-1.12.5.19.1.1.1" class="indexterm"></a>[_za'i_](../go01#valsi-zahi)_ : x1 is a continuous state of (the bridi) being true<a id="id-1.12.5.19.1.3" class="indexterm"></a><a id="id-1.12.5.19.1.4" class="indexterm"></a>

> _<a id="id-1.12.5.20.1.1.1" class="indexterm"></a>[_zu'o_](../go01#valsi-zuho)_ : x1 is an activity of (the bridi) consisting of repeated actions x2<a id="id-1.12.5.20.1.3" class="indexterm"></a><a id="id-1.12.5.20.1.4" class="indexterm"></a>