<a id="section-event-contours"></a>10.10. <a id="c10s10"></a>Event contours: ZAhO and _re'u_
--------------------------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">pu'o</p></td><td class="selmaho"><p class="selmaho">ZAhO</p></td><td class="description"><p class="description">prospective</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ca'o</p></td><td class="selmaho"><p class="selmaho">ZAhO</p></td><td class="description"><p class="description">continuitive</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ba'o</p></td><td class="selmaho"><p class="selmaho">ZAhO</p></td><td class="description"><p class="description">retrospective</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">co'a</p></td><td class="selmaho"><p class="selmaho">ZAhO</p></td><td class="description"><p class="description">initiative</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">co'u</p></td><td class="selmaho"><p class="selmaho">ZAhO</p></td><td class="description"><p class="description">cessitive</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">mo'u</p></td><td class="selmaho"><p class="selmaho">ZAhO</p></td><td class="description"><p class="description">completitive</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">za'o</p></td><td class="selmaho"><p class="selmaho">ZAhO</p></td><td class="description"><p class="description">superfective</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">co'i</p></td><td class="selmaho"><p class="selmaho">ZAhO</p></td><td class="description"><p class="description">achievative</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">de'a</p></td><td class="selmaho"><p class="selmaho">ZAhO</p></td><td class="description"><p class="description">pausative</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">di'a</p></td><td class="selmaho"><p class="selmaho">ZAhO</p></td><td class="description"><p class="description">resumptive</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">re'u</p></td><td class="selmaho"><p class="selmaho">ROI</p></td><td class="description"><p class="description">ordinal tense</p></td></tr></tbody></table>

<a id="id-1.11.12.4.1" class="indexterm"></a><a id="id-1.11.12.4.2" class="indexterm"></a><a id="id-1.11.12.4.3" class="indexterm"></a><a id="id-1.11.12.4.4" class="indexterm"></a><a id="id-1.11.12.4.5" class="indexterm"></a><a id="id-1.11.12.4.6" class="indexterm"></a><a id="id-1.11.12.4.7" class="indexterm"></a><a id="id-1.11.12.4.8" class="indexterm"></a><a id="id-1.11.12.4.9" class="indexterm"></a><a id="id-1.11.12.4.10" class="indexterm"></a><a id="id-1.11.12.4.11" class="indexterm"></a><a id="id-1.11.12.4.12" class="indexterm"></a>The cmavo of selma'o ZAhO express the Lojban version of what is traditionally called “aspect”. This is not a notion well expressed by English tenses, but many languages (including Chinese and Russian among Lojban's six source languages) consider it more important than the specification of mere position in time.

<a id="id-1.11.12.5.1" class="indexterm"></a><a id="id-1.11.12.5.2" class="indexterm"></a><a id="id-1.11.12.5.3" class="indexterm"></a><a id="id-1.11.12.5.4" class="indexterm"></a>The “event contours” of selma'o ZAhO, with their bizarre keywords, represent the natural portions of an event considered as a process, an occurrence with an internal structure including a beginning, a middle, and an end. Since the keywords are scarcely self-explanatory, each ZAhO will be explained in detail here. Note that from the viewpoint of Lojban syntax, ZAhOs are interval modifiers like TAhEs or ROI compounds; if both are found in a single tense, the TAhE/ROI comes first and the ZAhO afterward. The imaginary journey described by other tense cmavo moves us to the portion of the event-as-process which the ZAhO specifies.

<a id="id-1.11.12.6.1" class="indexterm"></a><a id="id-1.11.12.6.2" class="indexterm"></a><a id="id-1.11.12.6.3" class="indexterm"></a><a id="id-1.11.12.6.4" class="indexterm"></a><a id="id-1.11.12.6.5" class="indexterm"></a><a id="id-1.11.12.6.6" class="indexterm"></a>It is important to understand that ZAhO cmavo, unlike the other tense cmavo, specify characteristic portions of the event, and are seen from an essentially timeless perspective. The “beginning” of an event is the same whether the event is in the speaker's present, past, or future. It is especially important not to confuse the speaker-relative viewpoint of the PU tenses with the event-relative viewpoint of the ZAhO tenses.

<a id="id-1.11.12.7.1" class="indexterm"></a><a id="id-1.11.12.7.2" class="indexterm"></a><a id="id-1.11.12.7.3" class="indexterm"></a>The cmavo _<a id="id-1.11.12.7.4.1" class="indexterm"></a>[_pu'o_](../go01#valsi-puho)_ , _<a id="id-1.11.12.7.5.1" class="indexterm"></a>[_ca'o_](../go01#valsi-caho)_ , and _<a id="id-1.11.12.7.6.1" class="indexterm"></a>[_ba'o_](../go01#valsi-baho)_ (etymologically derived from the PU cmavo) refer to an event that has not yet begun, that is in progress, or that has ended, respectively:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qdwz"></a>

**Example 10.51. <a id="c10e10d1"></a><a id="id-1.11.12.8.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu'o</td><td>damba</td></tr><tr class="gloss"><td>I</td><td>[prospective]</td><td>fight.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I'm on the verge of fighting.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qdX7"></a>

**Example 10.52. <a id="c10e10d2"></a><a id="id-1.11.12.9.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.stiv.</td><td>ca'o</td><td>bacru</td></tr><tr class="gloss"><td>That-named</td><td>Steve</td><td>[continuitive]</td><td>utters.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Steve continues to talk.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qdxB"></a>

**Example 10.53. <a id="id-1.11.12.10.1.1" class="indexterm"></a><a id="c10e10d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>verba</td><td>ba'o</td><td>cadzu</td><td>le</td><td>bisli</td></tr><tr class="gloss"><td>The</td><td>child</td><td>[retrospective]</td><td>walks-on</td><td>the</td><td>ice.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The child is no longer walking on the ice.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.12.11.1" class="indexterm"></a><a id="id-1.11.12.11.2" class="indexterm"></a><a id="id-1.11.12.11.3" class="indexterm"></a><a id="id-1.11.12.11.4" class="indexterm"></a><a id="id-1.11.12.11.5" class="indexterm"></a><a id="id-1.11.12.11.6" class="indexterm"></a>As discussed in [Section 10.6](../section-vagueness) , the simple PU cmavo make no assumptions about whether the scope of a past, present, or future event extends into one of the other tenses as well. [Example 10.51](../section-event-contours#example-random-id-qdwz) through [Example 10.53](../section-event-contours#example-random-id-qdxB) illustrate that these ZAhO cmavo do make such assumptions possible: the event in [Example 10.51](../section-event-contours#example-random-id-qdwz) has not yet begun, definitively; likewise, the event in [Example 10.53](../section-event-contours#example-random-id-qdxB) is definitely over.

<a id="id-1.11.12.12.1" class="indexterm"></a><a id="id-1.11.12.12.2" class="indexterm"></a><a id="id-1.11.12.12.3" class="indexterm"></a><a id="id-1.11.12.12.4" class="indexterm"></a>Note that in [Example 10.51](../section-event-contours#example-random-id-qdwz) and [Example 10.53](../section-event-contours#example-random-id-qdxB) , _<a id="id-1.11.12.12.7.1" class="indexterm"></a>[_pu'o_](../go01#valsi-puho)_ and _<a id="id-1.11.12.12.8.1" class="indexterm"></a>[_ba'o_](../go01#valsi-baho)_ may appear to be reversed: _<a id="id-1.11.12.12.9.1" class="indexterm"></a>[_pu'o_](../go01#valsi-puho)_ , although etymologically connected with _<a id="id-1.11.12.12.10.1" class="indexterm"></a>[_pu_](../go01#valsi-pu)_ , is referring to a future event; whereas _<a id="id-1.11.12.12.11.1" class="indexterm"></a>[_ba'o_](../go01#valsi-baho)_ , connected with _<a id="id-1.11.12.12.12.1" class="indexterm"></a>[_ba_](../go01#valsi-ba)_ , is referring to a past event. This is the natural result of the event-centered view of ZAhO cmavo. The prospective, or _<a id="id-1.11.12.12.13.1" class="indexterm"></a>[_pu'o_](../go01#valsi-puho)_ , part of an event, is in the “pastward” portion of that event, when seen from the perspective of the event itself. It is only by inference that we suppose that [Example 10.51](../section-event-contours#example-random-id-qdwz) refers to the speaker's future: in fact, no PU tense is given, so the prospective part of the event need not be coincident with the speaker's present: _<a id="id-1.11.12.12.16.1" class="indexterm"></a>[_pu'o_](../go01#valsi-puho)_ is not necessarily, though in fact often is, the same as _<a id="id-1.11.12.12.17.1" class="indexterm"></a>ca pu'o_.

<a id="id-1.11.12.13.1" class="indexterm"></a><a id="id-1.11.12.13.2" class="indexterm"></a><a id="id-1.11.12.13.3" class="indexterm"></a><a id="id-1.11.12.13.4" class="indexterm"></a>The cmavo in [Example 10.51](../section-event-contours#example-random-id-qdwz) through [Example 10.53](../section-event-contours#example-random-id-qdxB) refer to spans of time. There are also two points of time that can be usefully associated with an event: the beginning, marked by _<a id="id-1.11.12.13.7.1" class="indexterm"></a>[_co'a_](../go01#valsi-coha)_ , and the end, marked by _<a id="id-1.11.12.13.8.1" class="indexterm"></a>[_co'u_](../go01#valsi-cohu)_. Specifically, _<a id="id-1.11.12.13.9.1" class="indexterm"></a>[_co'a_](../go01#valsi-coha)_ marks the boundary between the _<a id="id-1.11.12.13.10.1" class="indexterm"></a>[_pu'o_](../go01#valsi-puho)_ and _<a id="id-1.11.12.13.11.1" class="indexterm"></a>[_ca'o_](../go01#valsi-caho)_ parts of an event, and _<a id="id-1.11.12.13.12.1" class="indexterm"></a>[_co'u_](../go01#valsi-cohu)_ marks the boundary between the _<a id="id-1.11.12.13.13.1" class="indexterm"></a>[_ca'o_](../go01#valsi-caho)_ and _<a id="id-1.11.12.13.14.1" class="indexterm"></a>[_ba'o_](../go01#valsi-baho)_ parts:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qdxH"></a>

**Example 10.54. <a id="c10e10d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ba</td><td>co'a</td><td>citka</td><td>le</td><td>mi</td><td>sanmi</td></tr><tr class="gloss"><td>I</td><td>[future]</td><td>[initiative]</td><td>eat</td><td>the</td><td>associated-with-me</td><td>meal.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I will begin to eat my meal.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qdY5"></a>

**Example 10.55. <a id="c10e10d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>co'u</td><td>citka</td><td>le</td><td>mi</td><td>sanmi</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>[cessitive]</td><td>eat</td><td>the</td><td>associated-with-me</td><td>meal.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I ceased eating my meal.</p></td></tr></tbody></table>

</div>  

Compare [Example 10.54](../section-event-contours#example-random-id-qdxH) with:

<div class="interlinear-gloss-example example">
<a id="example-random-id-ChHI"></a>

**Example 10.56. <a id="c10e10d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ba</td><td>di'i</td><td>co'a</td><td>bajra</td></tr><tr class="gloss"><td>I</td><td>[future]</td><td>[regularly]</td><td>[initiative]</td><td>run.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I will regularly begin to run.</p></td></tr></tbody></table>

</div>  

which illustrates the combination of a TAhE with a ZAhO.

<a id="id-1.11.12.19.1" class="indexterm"></a><a id="id-1.11.12.19.2" class="indexterm"></a><a id="id-1.11.12.19.3" class="indexterm"></a><a id="id-1.11.12.19.4" class="indexterm"></a><a id="id-1.11.12.19.5" class="indexterm"></a>A process can have two end points, one reflecting the “natural end” (when the process is complete) and the other reflecting the “actual stopping point” (whether complete or not). [Example 10.55](../section-event-contours#example-random-id-qdY5) may be contrasted with:

<div class="interlinear-gloss-example example">
<a id="example-random-id-3s6c"></a>

**Example 10.57. <a id="c10e10d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>mo'u</td><td>citka</td><td>le</td><td>mi</td><td>sanmi</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>[completitive]</td><td>eat</td><td>the</td><td>associated-with-me</td><td>meal.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I finished eating my meal.</p></td></tr></tbody></table>

</div>  

In [Example 10.57](../section-event-contours#example-random-id-3s6c) , the meal has reached its natural end; in [Example 10.55](../section-event-contours#example-random-id-qdY5) , the meal has merely ceased, without necessarily reaching its natural end.

<a id="id-1.11.12.22.1" class="indexterm"></a><a id="id-1.11.12.22.2" class="indexterm"></a><a id="id-1.11.12.22.3" class="indexterm"></a><a id="id-1.11.12.22.4" class="indexterm"></a><a id="id-1.11.12.22.5" class="indexterm"></a><a id="id-1.11.12.22.6" class="indexterm"></a><a id="id-1.11.12.22.7" class="indexterm"></a><a id="id-1.11.12.22.8" class="indexterm"></a>A process such as eating a meal does not necessarily proceed uninterrupted. If it is interrupted, there are two more relevant point events: the point just before the interruption, marked by _<a id="id-1.11.12.22.9.1" class="indexterm"></a>[_de'a_](../go01#valsi-deha)_ , and the point just after the interruption, marked by _<a id="id-1.11.12.22.10.1" class="indexterm"></a>[_di'a_](../go01#valsi-diha)_. Some examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qdyD"></a>

**Example 10.58. <a id="c10e10d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>de'a</td><td>citka</td><td>le</td><td>mi</td><td>sanmi</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>[pausative]</td><td>eat</td><td>the</td><td>associated-with-me</td><td>meal.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I stopped eating my meal (with the intention of resuming).</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qE08"></a>

**Example 10.59. <a id="c10e10d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ba</td><td>di'a</td><td>citka</td><td>le</td><td>mi</td><td>sanmi</td></tr><tr class="gloss"><td>I</td><td>[future]</td><td>[resumptive]</td><td>eat</td><td>the</td><td>associated-with-me</td><td>meal.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I will resume eating my meal.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.12.25.1" class="indexterm"></a><a id="id-1.11.12.25.2" class="indexterm"></a>In addition, it is possible for a process to continue beyond its natural end. The span of time between the natural and the actual end points is represented by _<a id="id-1.11.12.25.3.1" class="indexterm"></a>[_za'o_](../go01#valsi-zaho)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-jSQ4"></a>

**Example 10.60. <a id="c10e10d10"></a><a id="id-1.11.12.26.1.2" class="indexterm"></a><a id="id-1.11.12.26.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>ctuca</td><td>pu</td><td>za'o</td><td>ciksi</td></tr><tr class="gloss"><td>The</td><td>teacher</td><td>[past]</td><td>[superfective]</td><td>explained</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>cmaci</td><td>seldanfu</td><td>le</td><td>tadgri</td></tr><tr class="gloss"><td>the</td><td>mathematics</td><td>problem</td><td>to-the</td><td>student-group.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The teacher kept on explaining the mathematics problem to the class too long.</p></td></tr></tbody></table>

</div>  

That is, the teacher went on explaining after the class already understood the problem.

<a id="id-1.11.12.28.1" class="indexterm"></a><a id="id-1.11.12.28.2" class="indexterm"></a>An entire event can be treated as a single moment using the cmavo _<a id="id-1.11.12.28.3.1" class="indexterm"></a>[_co'i_](../go01#valsi-cohi)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-odH5"></a>

**Example 10.61. <a id="c10e10d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>pu</td><td>co'i</td><td>catra</td><td>la</td><td>djim</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>[past]</td><td>[achievative]</td><td>kills</td><td>that-named</td><td>Jim.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John was at the point in time where he killed Jim.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.12.30.1" class="indexterm"></a><a id="id-1.11.12.30.2" class="indexterm"></a>Finally, since an activity is cyclical, an individual cycle can be referred to using a number followed by _<a id="id-1.11.12.30.3.1" class="indexterm"></a>[_re'u_](../go01#valsi-rehu)_ , which is the other cmavo of selma'o ROI:

<div class="interlinear-gloss-example example">
<a id="example-random-id-msrS"></a>

**Example 10.62. <a id="c10e10d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pare'u</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[first-time]</td><td>go-to</td><td>the</td><td>store.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I go to the store for the first time (within a vague interval).</p></td></tr></tbody></table>

</div>  

Note the difference between:

<div class="interlinear-gloss-example example">
<a id="example-random-id-j3DQ"></a>

**Example 10.63. <a id="c10e10d13"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pare'u</td><td>paroi</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[first-time]</td><td>[one-time]</td><td>go-to</td><td>the</td><td>store.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">For the first time, I go to the store once.</p></td></tr></tbody></table>

</div>  

and

<div class="interlinear-gloss-example example">
<a id="example-random-id-IBns"></a>

**Example 10.64. <a id="c10e10d14"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>paroi</td><td>pare'u</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[one-time]</td><td>[first-time]</td><td>go-to</td><td>the</td><td>store.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">There is one occasion on which I go to the store for the first time.</p></td></tr></tbody></table>

</div>