<a id="section-erasure"></a>19.13. <a id="c19s13"></a>Erasure: SI, SA, SU
-------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">si</p></td><td class="selmaho"><p class="selmaho">SI</p></td><td class="description"><p class="description">erase word</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">sa</p></td><td class="selmaho"><p class="selmaho">SA</p></td><td class="description"><p class="description">erase phrase</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">su</p></td><td class="selmaho"><p class="selmaho">SU</p></td><td class="description"><p class="description">erase discourse</p></td></tr></tbody></table>

<a id="id-1.20.15.4.1" class="indexterm"></a>The cmavo _<a id="id-1.20.15.4.2.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ (of selma'o SI) is a metalinguistic operator that erases the preceding word, as if it had never been spoken:

<div class="interlinear-gloss-example example">
<a id="example-random-id-JErC"></a>

**Example 19.75. <a id="c19e13d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ti</td><td>gerku</td><td>si</td><td>mlatu</td></tr><tr class="gloss"><td>This</td><td>is-a-dog,</td><td>er,</td><td>is-a-cat.</td></tr></tbody></table>

</div>  

means the same thing as _<a id="id-1.20.15.6.1.1" class="indexterm"></a>ti mlatu_. Multiple _<a id="id-1.20.15.6.2.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ cmavo in succession erase the appropriate number of words:

<div class="interlinear-gloss-example example">
<a id="example-random-id-rjyy"></a>

**Example 19.76. <a id="c19e13d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>blanu</td><td>zdani</td><td>si</td><td>si</td><td>xekri</td><td>zdani</td></tr><tr class="gloss"><td>That</td><td>is-a-blue</td><td>house,</td><td>er,</td><td>er,</td><td>is-a-black</td><td>house.</td></tr></tbody></table>

</div>  

<a id="id-1.20.15.8.1" class="indexterm"></a>In order to erase the word _<a id="id-1.20.15.8.2.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ , it is necessary to use three _<a id="id-1.20.15.8.3.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ cmavo in a row:

<div class="interlinear-gloss-example example">
<a id="example-random-id-zSQi"></a>

**Example 19.77. <a id="c19e13d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>zo</td><td>.bab.</td><td>se</td><td>cmene</td><td>zo</td><td>si</td><td>si</td><td>si</td><td>la</td><td>.bab.</td></tr><tr class="gloss"><td>The-word</td><td><span class="quote">“<span class="quote">Bob</span>”</span></td><td>is-the-name-of</td><td>the</td><td>word</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.20.15.9.2.3.6.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-si"><em class="glossterm">si</em></a></em></span></td><td>,</td><td>er,</td><td>er,</td><td>Bob.</td></tr></tbody></table>

</div>  

The first use of _<a id="id-1.20.15.10.1.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ does not erase anything, but completes the _<a id="id-1.20.15.10.2.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ quotation. Two more _<a id="id-1.20.15.10.3.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ cmavo are then necessary to erase the first _<a id="id-1.20.15.10.4.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ and the _<a id="id-1.20.15.10.5.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_.

Incorrect names can likewise cause trouble with _<a id="id-1.20.15.11.1.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-s7V6"></a>

**Example 19.78. <a id="c19e13d4"></a><a id="id-1.20.15.12.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>tavla</td><td>fo</td><td>la</td><td>.esperanto</td></tr><tr class="gloss"><td>I</td><td>talk</td><td>in-language</td><td>that-named</td><td>and-speranto,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>si</td><td>si</td><td>.esperanton.</td></tr><tr class="gloss"><td>er,</td><td>er,</td><td>Esperanto.</td></tr></tbody></table>

</div>  

The Lojbanized spelling _.esperanto_ breaks up, as a consequence of the Lojban morphology rules (see [Chapter 4](../chapter-morphology)) into two Lojban words, the cmavo _<a id="id-1.20.15.13.3.1" class="indexterm"></a>[_.e_](../go01#valsi-e)_ and the undefined lujvo _speranto_. Therefore, two _<a id="id-1.20.15.13.5.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ cmavo are needed to erase them. Of course, _<a id="id-1.20.15.13.6.1" class="indexterm"></a>.e speranto_ is not grammatical after _<a id="id-1.20.15.13.7.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ , but recognition of _<a id="id-1.20.15.13.8.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ is done before grammatical analysis.

<a id="id-1.20.15.14.1" class="indexterm"></a>Even more messy is the result of an incorrect _<a id="id-1.20.15.14.2.1" class="indexterm"></a>[_zoi_](../go01#valsi-zoi)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-zoWF"></a>

**Example 19.79. <a id="c19e13d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cusku</td><td>zoi</td><td>fy.</td><td>gy.</td><td>.fy.</td><td>si</td><td>si</td><td>si</td><td>si</td><td>zo&nbsp;.djan</td></tr><tr class="gloss"><td>I</td><td>express</td><td>[foreign]</td><td>[quote]</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.20.15.15.2.3.5.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-gy"><em class="glossterm">gy.</em></a></em></span></td><td>[unquote],</td><td>er,</td><td>er,</td><td>er,</td><td>er,</td><td><span class="quote">“<span class="quote">John</span>”</span></td><td>.</td></tr></tbody></table>

</div>  

In [Example 19.79](../section-erasure#example-random-id-zoWF) , the first _<a id="id-1.20.15.16.2.1" class="indexterm"></a>[_fy._](../go01#valsi-fy)_ is taken to be the delimiting word. The next word must be different from the delimiting word, and _<a id="id-1.20.15.16.3.1" class="indexterm"></a>[_gy._](../go01#valsi-gy)_ , the Lojban name for the letter _g_ , was chosen arbitrarily. Then the delimiting word must be repeated. For purposes of _<a id="id-1.20.15.16.5.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ erasure, the entire quoted text is taken to be a word, so four words have been uttered, and four more _<a id="id-1.20.15.16.6.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ cmavo are needed to erase them altogether. Similarly, a stray _<a id="id-1.20.15.16.7.1" class="indexterm"></a>[_lo'u_](../go01#valsi-lohu)_ quotation mark must be erased with _<a id="id-1.20.15.16.8.1" class="indexterm"></a>fy. le'u si si si_ , by completing the quotation and then erasing it all with three _<a id="id-1.20.15.16.9.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ cmavo.

What if less than the entire _<a id="id-1.20.15.17.1.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ or _<a id="id-1.20.15.17.2.1" class="indexterm"></a>[_zoi_](../go01#valsi-zoi)_ construct is erased? The result is something which has a loose _<a id="id-1.20.15.17.3.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ or _<a id="id-1.20.15.17.4.1" class="indexterm"></a>[_zoi_](../go01#valsi-zoi)_ in it, without its expected sequels, and which is incurably ungrammatical. Thus, to erase just the word quoted by _<a id="id-1.20.15.17.5.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ , it turns out to be necessary to erase the _<a id="id-1.20.15.17.6.1" class="indexterm"></a>[_zo_](../go01#valsi-zo)_ as well:

<div class="interlinear-gloss-example example">
<a id="example-random-id-FzoX"></a>

**Example 19.80. <a id="c19e13d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>se</td><td>cmene</td><td>zo</td><td>.djan.</td><td>si</td><td>si</td><td>zo</td><td>.djordj.</td></tr><tr class="gloss"><td>I</td><td></td><td>am-named-by</td><td>the-word</td><td><span class="quote">“<span class="quote">John,</span>”</span></td><td>er,</td><td>er,</td><td>the-word</td><td><span class="quote">“<span class="quote">George.</span>”</span></td></tr></tbody></table>

</div>  

The parser will reject _<a id="id-1.20.15.19.1.1" class="indexterm"></a>zo .djan. si .djordj._ , because in that context _djordj._ is a bare cmevla rather than a quoted word.

Note: The current machine parser does not implement _<a id="id-1.20.15.20.1.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ erasure.

<a id="id-1.20.15.21.1" class="indexterm"></a><a id="id-1.20.15.21.2" class="indexterm"></a><a id="id-1.20.15.21.3" class="indexterm"></a>As the above examples plainly show, precise erasures with _<a id="id-1.20.15.21.4.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ can be extremely hard to get right. Therefore, the cmavo _<a id="id-1.20.15.21.5.1" class="indexterm"></a>[_sa_](../go01#valsi-sa)_ (of selma'o SA) is provided for erasing more than one word. The cmavo following _<a id="id-1.20.15.21.6.1" class="indexterm"></a>[_sa_](../go01#valsi-sa)_ should be the starting marker of some grammatical construct. The effect of the _<a id="id-1.20.15.21.7.1" class="indexterm"></a>[_sa_](../go01#valsi-sa)_ is to erase back to and including the last starting marker of the same kind. For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-YdX7"></a>

**Example 19.81. <a id="c19e13d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>le</td><td>sa</td><td>.i</td><td>mi</td><td>cusku</td><td>zo</td><td>.djan.</td></tr><tr class="gloss"><td>I</td><td>see</td><td>the</td><td>...</td><td></td><td>I</td><td>say</td><td>the-word</td><td><span class="quote">“<span class="quote">John</span>”</span></td><td>.</td></tr></tbody></table>

</div>  

Since the word following _<a id="id-1.20.15.23.1.1" class="indexterm"></a>[_sa_](../go01#valsi-sa)_ is _<a id="id-1.20.15.23.2.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ , the sentence separator, its effect is to erase the preceding sentence. So [Example 19.81](../section-erasure#example-random-id-YdX7) is equivalent to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-JJmn"></a>

**Example 19.82. <a id="c19e13d8"></a>** 

<a id="id-1.20.15.24.2.1" class="indexterm"></a>mi cusku zo .djan.

</div>  

Another example, erasing a partial description rather than a partial sentence:

<div class="interlinear-gloss-example example">
<a id="example-random-id-SszI"></a>

**Example 19.83. <a id="c19e13d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>le</td><td>blanu</td><td>.zdan.</td><td>sa</td><td>le</td><td>xekri</td><td>zdani</td></tr><tr class="gloss"><td>I</td><td>see</td><td>the</td><td>blue</td><td>hou</td><td>...</td><td>the</td><td>black</td><td>house.</td></tr></tbody></table>

</div>  

In [Example 19.83](../section-erasure#example-random-id-SszI) , _<a id="id-1.20.15.27.2.1" class="indexterm"></a>le blanu .zdan._ is ungrammatical, but clearly reflects the speaker's original intention to say _<a id="id-1.20.15.27.3.1" class="indexterm"></a>le blanu zdani_. However, the _<a id="id-1.20.15.27.4.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ was cut off before the end and changed into a cmevla. The entire ungrammatical _<a id="id-1.20.15.27.5.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ construct is erased and replaced by _<a id="id-1.20.15.27.6.1" class="indexterm"></a>le xekri zdani_.

Note: The current machine parser does not implement _<a id="id-1.20.15.28.1.1" class="indexterm"></a>[_sa_](../go01#valsi-sa)_ erasure. Getting _<a id="id-1.20.15.28.2.1" class="indexterm"></a>[_sa_](../go01#valsi-sa)_ right is even more difficult (for a computer) than getting _<a id="id-1.20.15.28.3.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ right, as the behavior of _<a id="id-1.20.15.28.4.1" class="indexterm"></a>[_si_](../go01#valsi-si)_ is defined in terms of words rather than in terms of grammatical constructs (possibly incorrect ones) and words are conceptually simpler entities. On the other hand, _<a id="id-1.20.15.28.5.1" class="indexterm"></a>[_sa_](../go01#valsi-sa)_ is generally easier for human beings, because the rules for using it correctly are less finicky.

<a id="id-1.20.15.29.1" class="indexterm"></a><a id="id-1.20.15.29.2" class="indexterm"></a>The cmavo _<a id="id-1.20.15.29.3.1" class="indexterm"></a>[_su_](../go01#valsi-su)_ (of selma'o SU) is yet another metalinguistic operator that erases the entire text. However, if the text involves multiple speakers, then _<a id="id-1.20.15.29.4.1" class="indexterm"></a>[_su_](../go01#valsi-su)_ will only erase the remarks made by the one who said it, unless that speaker has said nothing. Therefore _<a id="id-1.20.15.29.5.1" class="indexterm"></a>susu_ is needed to eradicate a whole discussion in conversation.

Note: The current machine parser does not implement either _<a id="id-1.20.15.30.1.1" class="indexterm"></a>[_su_](../go01#valsi-su)_ or _<a id="id-1.20.15.30.2.1" class="indexterm"></a>susu_ erasure.