<a id="section-discursives"></a>13.12. <a id="c13s12"></a>Discursives
---------------------------------------------------------------------

<a id="id-1.14.14.2.1" class="indexterm"></a><a id="id-1.14.14.2.2" class="indexterm"></a><a id="id-1.14.14.2.3" class="indexterm"></a>The term “discursive” is used for those members of selma'o UI that provide structure to the discourse, and which show how a given word or utterance relates to the whole discourse. To express these concepts in regular bridi would involve extra layers of nesting: rather than asserting that “I also came” , we would have to say “I came; furthermore, the event of my coming is an additional instance of the relationship expressed by the previous sentence” , which is intolerably clumsy. Typical English equivalents of discursives are words or phrases like “however” , “summarizing” , “in conclusion” , and “for example”.

<a id="id-1.14.14.3.1" class="indexterm"></a><a id="id-1.14.14.3.2" class="indexterm"></a><a id="id-1.14.14.3.3" class="indexterm"></a>Discursives are not attitudinals: they express no particular emotion. Rather, they are abbreviations for metalinguistic claims that reference the sentence or text they are found in.

<a id="id-1.14.14.4.1" class="indexterm"></a>Discursives are most often used at the beginning of sentences, often attached to the _<a id="id-1.14.14.4.2.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ that separates sentences in running discourse, but can (like all other indicators) be attached to single words when it seems necessary or useful.

<a id="id-1.14.14.5.1" class="indexterm"></a>The discursives discussed in this section are given in groups, roughly organized by function. First, the “consecutive discourse” group:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ku'i</p></td><td class="gismu"><p class="gismu">[karbi]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">however/but/in contrast</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ji'a</p></td><td class="gismu"><p class="gismu">[jmina]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">additionally</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">si'a</p></td><td class="gismu"><p class="gismu">[simsa]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">similarly</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">mi'u</p></td><td class="gismu"><p class="gismu">[mintu]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">ditto</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">po'o</p></td><td class="gismu"><p class="gismu"></p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">the only relevant case</p></td></tr></tbody></table>

<a id="id-1.14.14.7.1" class="indexterm"></a><a id="id-1.14.14.7.2" class="indexterm"></a><a id="id-1.14.14.7.3" class="indexterm"></a><a id="id-1.14.14.7.4" class="indexterm"></a><a id="id-1.14.14.7.5" class="indexterm"></a><a id="id-1.14.14.7.6" class="indexterm"></a>These five discursives are mutually exclusive, and therefore they are not usually considered as scales. The first four are used in consecutive discourse. The first, _<a id="id-1.14.14.7.7.1" class="indexterm"></a>[_ku'i_](../go01#valsi-kuhi)_ , makes an exception to the previous argument. The second, _<a id="id-1.14.14.7.8.1" class="indexterm"></a>[_ji'a_](../go01#valsi-jiha)_ , adds weight to the previous argument. The third, _<a id="id-1.14.14.7.9.1" class="indexterm"></a>[_si'a_](../go01#valsi-siha)_ , adds quantity to the previous argument, enumerating an additional example. The fourth, _<a id="id-1.14.14.7.10.1" class="indexterm"></a>[_mi'u_](../go01#valsi-mihu)_ , adds a parallel case to the previous argument, and can also be used in tables or the like to show that something is being repeated from the previous column. It is distinct from _<a id="id-1.14.14.7.11.1" class="indexterm"></a>[_go'i_](../go01#valsi-gohi)_ (of selma'o GOhA, discussed in [Section 7.6](../section-ri-gohi-series)), which is a non-discursive version of “ditto” that explicitly repeats the claim of the previous bridi.

Lastly, _<a id="id-1.14.14.8.1.1" class="indexterm"></a>[_po'o_](../go01#valsi-poho)_ is used when there is no other comparable case, and thus corresponds to some of the uses of “only” , a word difficult to express in pure bridi form:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qG0v"></a>

**Example 13.83. <a id="c13e12d1"></a><a id="id-1.14.14.9.1.2" class="indexterm"></a><a id="id-1.14.14.9.1.3" class="indexterm"></a><a id="id-1.14.14.9.1.4" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>po'o</td><td>darxi</td><td>le</td><td>mi</td><td>tamne</td><td>fo</td><td>le</td><td>nazbi</td></tr><tr class="gloss"><td>I</td><td>[only]</td><td>hit</td><td>the</td><td>of-me</td><td>cousin</td><td>at-locus</td><td>the</td><td>nose.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Only I (nobody else) hit my cousin on his nose.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qg21"></a>

**Example 13.84. <a id="c13e12d2"></a><a id="id-1.14.14.10.1.2" class="indexterm"></a><a id="id-1.14.14.10.1.3" class="indexterm"></a><a id="id-1.14.14.10.1.4" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>darxi</td><td>po'o</td><td>le</td><td>mi</td><td>tamne</td><td>fo</td><td>le</td><td>nazbi</td></tr><tr class="gloss"><td>I</td><td>hit</td><td>[only]</td><td>the</td><td>of-me</td><td>cousin</td><td>at-locus</td><td>the</td><td>nose.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I only hit my cousin on his nose (I did nothing else to him).</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qg2f"></a>

**Example 13.85. <a id="c13e12d3"></a><a id="id-1.14.14.11.1.2" class="indexterm"></a><a id="id-1.14.14.11.1.3" class="indexterm"></a><a id="id-1.14.14.11.1.4" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>darxi</td><td>le</td><td>mi</td><td>tamne</td><td>ku</td><td>po'o</td><td>fo</td><td>le</td><td>nazbi</td></tr><tr class="gloss"><td>I</td><td>hit</td><td>the</td><td>of-me</td><td>cousin</td><td></td><td>[only]</td><td>at-locus</td><td>the</td><td>nose.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I hit only my cousin on his nose (no one else).</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qG42"></a>

**Example 13.86. <a id="c13e12d4"></a><a id="id-1.14.14.12.1.2" class="indexterm"></a><a id="id-1.14.14.12.1.3" class="indexterm"></a><a id="id-1.14.14.12.1.4" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>darxi</td><td>le</td><td>mi</td><td>tamne</td><td>fo</td><td>le</td><td>nazbi</td><td>ku</td><td>po'o</td></tr><tr class="gloss"><td>I</td><td>hit</td><td>the</td><td>of-me</td><td>cousin</td><td>at-locus</td><td>the</td><td>nose</td><td></td><td>[only].</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I hit my cousin only on his nose (nowhere else).</p></td></tr></tbody></table>

</div>  

<a id="id-1.14.14.13.1" class="indexterm"></a>Note that “only” can go before or after what it modifies in English, but _<a id="id-1.14.14.13.3.1" class="indexterm"></a>[_po'o_](../go01#valsi-poho)_ , as an indicator, always comes afterward.

Next, the “commentary on words” group:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">va'i</p></td><td class="gismu"><p class="gismu">[valsi]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">in other words</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">in the same words</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ta'u</p></td><td class="gismu"><p class="gismu">[tanru]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">expanding a tanru</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">making a tanru</p></td></tr></tbody></table>

<a id="id-1.14.14.16.1" class="indexterm"></a><a id="id-1.14.14.16.2" class="indexterm"></a>The discursives _<a id="id-1.14.14.16.3.1" class="indexterm"></a>[_va'i_](../go01#valsi-vahi)_ and _<a id="id-1.14.14.16.4.1" class="indexterm"></a>[_ta'u_](../go01#valsi-tahu)_ operate at the level of words, rather than discourse proper, or if you like, they deal with how things are said. An alternative English expression for _<a id="id-1.14.14.16.5.1" class="indexterm"></a>[_va'i_](../go01#valsi-vahi)_ is “rephrasing” ; for _<a id="id-1.14.14.16.7.1" class="indexterm"></a>[_va'inai_](../go01#valsi-vahinai)_ , “repeating”. Also compare _<a id="id-1.14.14.16.9.1" class="indexterm"></a>[_va'i_](../go01#valsi-vahi)_ with _<a id="id-1.14.14.16.10.1" class="indexterm"></a>[_ke'u_](../go01#valsi-kehu)_ , discussed below.

<a id="id-1.14.14.17.1" class="indexterm"></a><a id="id-1.14.14.17.2" class="indexterm"></a><a id="id-1.14.14.17.3" class="indexterm"></a>The cmavo _<a id="id-1.14.14.17.4.1" class="indexterm"></a>[_ta'u_](../go01#valsi-tahu)_ is a discursive unique to Lojban; it expresses the particularly Lojbanic device of tanru. Since tanru are semantically ambiguous, they are subject to misunderstanding. This ambiguity can be removed by expanding the tanru into some semantically unambiguous structure, often involving relative clauses or the introduction of additional brivla. The discursive _<a id="id-1.14.14.17.5.1" class="indexterm"></a>[_ta'u_](../go01#valsi-tahu)_ marks the transition from the use of a brief but possibly confusing tanru to its fuller, clearer expansion; the discursive _<a id="id-1.14.14.17.6.1" class="indexterm"></a>[_ta'unai_](../go01#valsi-tahunai)_ marks a transition in the reverse direction.

Next, the “commentary on discourse” group:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">li'a</p></td><td class="gismu"><p class="gismu">[klina]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">clearly; obviously</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">obscurely</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ba'u</p></td><td class="gismu"><p class="gismu">[banli]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">exaggeration</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">accuracy</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">understatement</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">zo'o</p></td><td class="gismu"><p class="gismu"></p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">humorously</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">dully</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">seriously</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">sa'e</p></td><td class="gismu"><p class="gismu">[satci]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">precisely speaking</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">loosely speaking</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">to'u</p></td><td class="gismu"><p class="gismu">[tordu]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">in brief</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">in detail</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">do'a</p></td><td class="gismu"><p class="gismu">[dunda]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">generously</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">parsimoniously</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">sa'u</p></td><td class="gismu"><p class="gismu">[sampu]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">simply</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">elaborating</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">pa'e</p></td><td class="gismu"><p class="gismu">[pajni]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">justice</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">prejudice</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">je'u</p></td><td class="gismu"><p class="gismu">[jetnu]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">truly</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">falsely</p></td></tr></tbody></table>

<a id="id-1.14.14.20.1" class="indexterm"></a><a id="id-1.14.14.20.2" class="indexterm"></a><a id="id-1.14.14.20.3" class="indexterm"></a><a id="id-1.14.14.20.4" class="indexterm"></a>This group is used by the speaker to characterize the nature of the discourse, so as to prevent misunderstanding. It is well-known that listeners often fail to recognize a humorous statement and take it seriously, or miss an exaggeration, or try to read more into a statement than the speaker intends to put there. In speech, the tone of voice often provides the necessary cue, but the reader of ironic or understated or imprecise discourse is often simply clueless. As with the attitudinals, the use of these cmavo may seem fussy to new Lojbanists, but it is important to remember that _<a id="id-1.14.14.20.5.1" class="indexterm"></a>[_zo'o_](../go01#valsi-zoho)_ , for example, is the equivalent of smiling while you speak, not the equivalent of a flat declaration like “What I'm about to say is supposed to be funny.”

A few additional English equivalents: for _<a id="id-1.14.14.21.1.1" class="indexterm"></a>[_sa'enai_](../go01#valsi-sahenai)_ , “roughly speaking” or “approximately speaking” ; for _<a id="id-1.14.14.21.4.1" class="indexterm"></a>[_sa'unai_](../go01#valsi-sahunai)_ , “furthermore” ; for _<a id="id-1.14.14.21.6.1" class="indexterm"></a>[_to'u_](../go01#valsi-tohu)_ , “in short” or “skipping details” ; for _<a id="id-1.14.14.21.9.1" class="indexterm"></a>[_do'a_](../go01#valsi-doha)_ , “broadly construed” ; for _<a id="id-1.14.14.21.11.1" class="indexterm"></a>[_do'anai_](../go01#valsi-dohanai)_ (as you might expect), “narrowly construed”.

The cmavo _<a id="id-1.14.14.22.1.1" class="indexterm"></a>[_pa'e_](../go01#valsi-pahe)_ is used to claim (truly or falsely) that one is being fair or just to all parties mentioned, whereas _<a id="id-1.14.14.22.2.1" class="indexterm"></a>[_pa'enai_](../go01#valsi-pahenai)_ admits (or proclaims) a bias in favor of one party.

<a id="id-1.14.14.23.1" class="indexterm"></a><a id="id-1.14.14.23.2" class="indexterm"></a><a id="id-1.14.14.23.3" class="indexterm"></a><a id="id-1.14.14.23.4" class="indexterm"></a>The scale of _<a id="id-1.14.14.23.5.1" class="indexterm"></a>[_je'u_](../go01#valsi-jehu)_ and _<a id="id-1.14.14.23.6.1" class="indexterm"></a>[_je'unai_](../go01#valsi-jehunai)_ is a little different from the others in the group. By default, we assume that people speak the truth – or at least, that if they are lying, they will do their best to conceal it from us. So under what circumstances would _<a id="id-1.14.14.23.7.1" class="indexterm"></a>[_je'unai_](../go01#valsi-jehunai)_ be used, or _<a id="id-1.14.14.23.8.1" class="indexterm"></a>[_je'u_](../go01#valsi-jehu)_ be useful? For one thing, _<a id="id-1.14.14.23.9.1" class="indexterm"></a>[_je'u_](../go01#valsi-jehu)_ can be used to mark a tautology: a sentence that is a truth of logic, like “All cats are cats.” Its counterpart _<a id="id-1.14.14.23.11.1" class="indexterm"></a>[_je'unai_](../go01#valsi-jehunai)_ then serves to mark a logical contradiction. In addition, _<a id="id-1.14.14.23.12.1" class="indexterm"></a>[_je'unai_](../go01#valsi-jehunai)_ can be used to express one kind of sarcasm or irony, where the speaker pretends to believe what he/she says, but actually wishes the listener to infer a contrary opinion. Other forms of irony can be marked with _<a id="id-1.14.14.23.13.1" class="indexterm"></a>[_zo'o_](../go01#valsi-zoho)_ (humor) or _<a id="id-1.14.14.23.14.1" class="indexterm"></a>[_.ianai_](../go01#valsi-ianai)_ (disbelief).

When used as a discursive, _<a id="id-1.14.14.24.1.1" class="indexterm"></a>[_su'a_](../go01#valsi-suha)_ (see [Section 13.11](../section-evidentials)) belongs to this group.

Next, the “knowledge” group:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ju'o</p></td><td class="gismu"><p class="gismu">[djuno]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">certainly</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">uncertain</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">certainly not</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">la'a</p></td><td class="gismu"><p class="gismu">[lakne]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">probably</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">improbably</p></td></tr></tbody></table>

<a id="id-1.14.14.27.1" class="indexterm"></a><a id="id-1.14.14.27.2" class="indexterm"></a><a id="id-1.14.14.27.3" class="indexterm"></a><a id="id-1.14.14.27.4" class="indexterm"></a><a id="id-1.14.14.27.5" class="indexterm"></a>These two discursives describe the speaker's state of knowledge about the claim of the associated bridi. They are similar to the propositional attitudes of [Section 13.3](../section-propositional-emotions) , as they create a hypothetical world. We may be quite certain that something is true, and label our bridi with _<a id="id-1.14.14.27.7.1" class="indexterm"></a>[_ju'o_](../go01#valsi-juho)_ ; but it may be false all the same.

Next, the “discourse management” group:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ta'o</p></td><td class="gismu"><p class="gismu">[tanjo]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">by the way</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">returning to point</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ra'u</p></td><td class="gismu"><p class="gismu">[ralju]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">chiefly</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">equally</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">incidentally</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">mu'a</p></td><td class="gismu"><p class="gismu">[mupli]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">for example</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">omitting examples</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">end examples</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">zu'u</p></td><td class="gismu"><p class="gismu"></p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">on the one hand</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">on the other hand</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ke'u</p></td><td class="gismu"><p class="gismu">[krefu]</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">repeating</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">continuing</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">da'i</p></td><td class="gismu"><p class="gismu"></p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">supposing</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">in fact</p></td></tr></tbody></table>

<a id="id-1.14.14.30.1" class="indexterm"></a><a id="id-1.14.14.30.2" class="indexterm"></a><a id="id-1.14.14.30.3" class="indexterm"></a>This final group is used to perform what may be called “managing the discourse” : providing reference points to help the listener understand the flow from one sentence to the next.

Other English equivalents of _<a id="id-1.14.14.31.1.1" class="indexterm"></a>[_ta'onai_](../go01#valsi-tahonai)_ are “anyway” , “anyhow” , “in any case” , “in any event” , “as I was saying” , and “continuing”.

<a id="id-1.14.14.32.1" class="indexterm"></a><a id="id-1.14.14.32.2" class="indexterm"></a>The scale of _<a id="id-1.14.14.32.3.1" class="indexterm"></a>[_ra'u_](../go01#valsi-rahu)_ has to do with the importance of the point being, or about to be, expressed: _<a id="id-1.14.14.32.4.1" class="indexterm"></a>[_ra'u_](../go01#valsi-rahu)_ is the most important point, _<a id="id-1.14.14.32.5.1" class="indexterm"></a>[_ra'ucu'i_](../go01#valsi-rahucuhi)_ is a point of equal importance, and _<a id="id-1.14.14.32.6.1" class="indexterm"></a>[_ra'unai_](../go01#valsi-rahunai)_ is a lesser point. Other English equivalents of _<a id="id-1.14.14.32.7.1" class="indexterm"></a>[_ra'u_](../go01#valsi-rahu)_ are “above all” and “primarily”.

<a id="id-1.14.14.33.1" class="indexterm"></a><a id="id-1.14.14.33.2" class="indexterm"></a>The cmavo _<a id="id-1.14.14.33.3.1" class="indexterm"></a>[_ke'u_](../go01#valsi-kehu)_ is very similar to _<a id="id-1.14.14.33.4.1" class="indexterm"></a>[_va'i_](../go01#valsi-vahi)_ , although _<a id="id-1.14.14.33.5.1" class="indexterm"></a>[_ke'unai_](../go01#valsi-kehunai)_ and _<a id="id-1.14.14.33.6.1" class="indexterm"></a>[_va'inai_](../go01#valsi-vahinai)_ are quite different. Both _<a id="id-1.14.14.33.7.1" class="indexterm"></a>[_ke'u_](../go01#valsi-kehu)_ and _<a id="id-1.14.14.33.8.1" class="indexterm"></a>[_va'i_](../go01#valsi-vahi)_ indicate that the same idea is going to be expressed using different words, but the two cmavo differ in emphasis. Using _<a id="id-1.14.14.33.9.1" class="indexterm"></a>[_ke'u_](../go01#valsi-kehu)_ emphasizes that the content is the same; using _<a id="id-1.14.14.33.10.1" class="indexterm"></a>[_va'i_](../go01#valsi-vahi)_ emphasizes that the words are different. Therefore, _<a id="id-1.14.14.33.11.1" class="indexterm"></a>[_ke'unai_](../go01#valsi-kehunai)_ shows that the content is new (and therefore the words are also); _<a id="id-1.14.14.33.12.1" class="indexterm"></a>[_va'inai_](../go01#valsi-vahinai)_ shows that the words are the same (and therefore so is the content). One English equivalent of _<a id="id-1.14.14.33.13.1" class="indexterm"></a>[_ke'unai_](../go01#valsi-kehunai)_ is “furthermore”.

<a id="id-1.14.14.34.1" class="indexterm"></a><a id="id-1.14.14.34.2" class="indexterm"></a><a id="id-1.14.14.34.3" class="indexterm"></a><a id="id-1.14.14.34.4" class="indexterm"></a>The discursive _<a id="id-1.14.14.34.5.1" class="indexterm"></a>[_da'i_](../go01#valsi-dahi)_ marks the discourse as possibly taking a non-real-world viewpoint ( “Supposing that” , “By hypothesis”), whereas _<a id="id-1.14.14.34.8.1" class="indexterm"></a>[_da'inai_](../go01#valsi-dahinai)_ insists on the real-world point of view ( “In fact” , “In truth” , “According to the facts”). A common use of _<a id="id-1.14.14.34.12.1" class="indexterm"></a>[_da'i_](../go01#valsi-dahi)_ is to distinguish between:

<div class="interlinear-gloss-example example">
<a id="example-random-id-v6BU"></a>

**Example 13.87. <a id="c13e12d5"></a><a id="id-1.14.14.35.1.2" class="indexterm"></a><a id="id-1.14.14.35.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ganai</td><td>da'i</td><td>do</td><td>viska</td><td>le</td><td>mi</td><td>citno</td><td>mensi</td></tr><tr class="gloss"><td>If</td><td>[hypothetical]</td><td>you</td><td>see</td><td>the</td><td>of-me</td><td>young</td><td>sister,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>gi</td><td>ju'o</td><td>do</td><td>djuno</td><td>le</td><td>du'u</td><td>ri</td><td>pazvau</td></tr><tr class="gloss"><td>then</td><td>[certain]</td><td>you</td><td>know</td><td>the</td><td>predication-of</td><td>she</td><td>is-pregnant.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">If you were to see my younger sister, you would certainly know she is pregnant.</p></td></tr></tbody></table>

</div>  

<a id="id-1.14.14.36.1" class="indexterm"></a><a id="id-1.14.14.36.2" class="indexterm"></a>and:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Sach"></a>

**Example 13.88. <a id="c13e12d6"></a><a id="id-1.14.14.37.1.2" class="indexterm"></a><a id="id-1.14.14.37.1.3" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ganai</td><td>da'inai</td><td>do</td><td>viska</td><td>le</td><td>mi</td><td>citno</td><td>mensi</td></tr><tr class="gloss"><td>If</td><td>[factual]</td><td>you</td><td>see</td><td>the</td><td>of-me</td><td>young</td><td>sister,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>gi</td><td>ju'o</td><td>do</td><td>djuno</td><td>le</td><td>du'u</td><td>ri</td><td>pazvau</td></tr><tr class="gloss"><td>then</td><td>[certainty]</td><td>you</td><td>know</td><td>the</td><td>predication-of</td><td>she</td><td>is-pregnant.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">If you saw my younger sister, you would certainly know she is pregnant.</p></td></tr></tbody></table>

</div>  

It is also perfectly correct to omit the discursive altogether, and leave the context to indicate which significance is meant. (Chinese always leaves this distinction to the context: the Chinese sentence

<div class="interlinear-gloss-example example">
<a id="example-random-id-rxfh"></a>

**Example 13.89. <a id="c13e12d7"></a>** 

*   _如果你看到我的妹妹，你一定会知道，她怀孕了。_

*   _Rúguǒ nǐ kàn dào wǒ de mèimei, nǐ yīdìng huì zhīdào, tā huáiyùnle._

*   if you see-arrive my younger-sister, you certainly know she pregnant

</div>  

is the equivalent of either [Example 13.87](../section-discursives#example-random-id-v6BU) or [Example 13.88](../section-discursives#example-random-id-Sach).)