<a id="section-diphthongs"></a>3.4. <a id="c3s4"></a>Diphthongs and syllabic consonants
---------------------------------------------------------------------------------------

<a id="id-1.4.6.2.1" class="indexterm"></a>There exist 16 diphthongs in the Lojban language. A diphthong is a vowel sound that consists of two elements, a short vowel sound and a glide, either a labial (IPA \[w\]) or palatal (IPA \[j\]) glide, that either precedes (an on-glide) or follows (an off-glide) the main vowel. Diphthongs always constitute a single syllable.

<a id="id-1.4.6.3.1" class="indexterm"></a><a id="id-1.4.6.3.2" class="indexterm"></a>For Lojban purposes, a vowel sound is a relatively long speech-sound that forms the nucleus of a syllable. Consonant sounds are relatively brief and normally require an accompanying vowel sound in order to be audible. Consonants may occur at the beginning or end of a syllable, around the vowel, and there may be several consonants in a cluster in either position. Each separate vowel sound constitutes a distinct syllable; consonant sounds do not affect the determination of syllables.

<a id="id-1.4.6.4.1" class="indexterm"></a>The six Lojban vowels are _a_ , _e_ , _i_ , _o_ , _u_ , and _y_. The first five vowels appear freely in all kinds of Lojban words. The vowel _y_ has a limited distribution: it appears only in Lojbanized names, in the Lojban names of the letters of the alphabet, as a glue vowel in compound words, and standing alone as a space-filler word (like English “uh” or “er”).

<a id="id-1.4.6.5.1" class="indexterm"></a><a id="id-1.4.6.5.2" class="indexterm"></a>The Lojban diphthongs are shown in the table below. (Variant pronunciations have been omitted, but are much as one would expect based on the variant pronunciations of the separate vowel letters: _ai_ may be pronounced \[ɑj\] , for example.)

| Letters | IPA | Description |
| --- | --- | --- |
| _ai_ | \[aj\] | an open vowel with palatal off-glide |
| _ei_ | \[ɛj\] | a front mid vowel with palatal off-glide |
| _oi_ | \[oj\] | a back mid vowel with palatal off-glide |
| _au_ | \[aw\] | an open vowel with labial off-glide |
| _ia_ | \[ja\] | an open vowel with palatal on-glide |
| _ie_ | \[jɛ\] | a front mid vowel with palatal on-glide |
| _ii_ | \[ji\] | a front close vowel with palatal on-glide |
| _io_ | \[jo\] | a back mid vowel with palatal on-glide |
| _iu_ | \[ju\] | a back close vowel with palatal on-glide |
| _ua_ | \[wa\] | an open vowel with labial on-glide |
| _ue_ | \[wɛ\] | a front mid vowel with labial on-glide |
| _ui_ | \[wi\] | a front close vowel with labial on-glide |
| _uo_ | \[wo\] | a back mid vowel with labial on-glide |
| _uu_ | \[wu\] | a back close vowel with labial on-glide |
| _iy_ | \[jə\] | a central mid vowel with palatal on-glide |
| _uy_ | \[wə\] | a central mid vowel with labial on-glide |

(Approximate English equivalents of most of these diphthongs exist: see [Section 3.11](../section-anglophone-diphthongs) for examples.)

<a id="id-1.4.6.8.1" class="indexterm"></a>The first four diphthongs above ( _ai_ , _ei_ , _oi_ , and _au_ , the ones with off-glides) are freely used in most types of Lojban words; the ten following ones are used only as stand-alone words and in Lojbanized names and borrowings; and the last two ( _iy_ and _uy_) are used only in Lojbanized names.

<a id="id-1.4.6.9.1" class="indexterm"></a><a id="id-1.4.6.9.2" class="indexterm"></a>The syllabic consonants of Lojban, \[l̩\] , \[m̩\] , \[n̩\] , and \[r̩\] , are variants of the non-syllabic \[l\] , \[m\] , \[n\] , and \[r\] respectively. They normally have only a limited distribution, appearing in Lojbanized names and borrowings, although in principle any _l_ , _m_ , _n_ , or _r_ may be pronounced syllabically. If a syllabic consonant appears next to a _l_ , _m_ , _n_ , or _r_ that is not syllabic, it may not be clear which is which:

<div class="pronunciation-example example">
<a id="example-random-id-k2CE"></a>

**Example 3.5. <a id="c3e4d1"></a>** 

*   .brlgan.

*   \[br̩l gan\]

*   or

*   \[brl̩ gan\]

</div>  

is a hypothetical Lojbanized name with more than one valid pronunciation; however it is pronounced, it remains the same word.

<a id="id-1.4.6.12.1" class="indexterm"></a><a id="id-1.4.6.12.2" class="indexterm"></a>Syllabic consonants are treated as consonants rather than vowels from the standpoint of Lojban morphology. Thus Lojbanized names, which are generally required to end in a consonant, are allowed to end with a syllabic consonant. An example is _.rl._ , which is an approximation of the English name “Earl” , and has two syllabic consonants.

<a id="id-1.4.6.13.1" class="indexterm"></a><a id="id-1.4.6.13.2" class="indexterm"></a>Syllables with syllabic consonants and no vowel are never stressed or counted when determining which syllables to stress (see [Section 3.9](../section-stress)).