<a id="section-descriptors"></a>8.6. <a id="c8s6"></a>Relative clauses and descriptors
--------------------------------------------------------------------------------------

So far, this chapter has described the various kinds of relative clauses (including relative phrases). The list is now complete, and the rest of the chapter will be concerned with the syntax of sumti that include relative clauses. So far, all relative clauses have appeared directly after the sumti to which they are attached. This is the most common position (and originally the only one), but a variety of other placements are also possible which produce a variety of semantic effects.

There are actually three places where a relative clause can be attached to a description sumti: after the descriptor ( _<a id="id-1.9.8.3.1.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ , _<a id="id-1.9.8.3.2.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ , or whatever), after the embedded selbri but before the elidable terminator (which is _<a id="id-1.9.8.3.3.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_), and after the _<a id="id-1.9.8.3.4.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_. The relative clauses attached to descriptors that we have seen have occupied the second position. Thus [Example 8.43](../section-voi#example-random-id-pcvP) , if written out with all elidable terminators, would appear as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-UmLX"></a>

**Example 8.47. <a id="c8e6d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>gerku</td><td>poi</td><td>blabi</td><td>ku'o</td><td>ku</td><td>cu</td><td>klama</td><td>vau</td></tr><tr class="gloss"><td>The</td><td>(dog</td><td>which</td><td>(is-white</td><td>)</td><td>)</td><td>&nbsp;</td><td>goes</td><td>.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The dog which is white is going.</p></td></tr></tbody></table>

</div>  

Here _<a id="id-1.9.8.5.1.1" class="indexterm"></a>[_ku'o_](../go01#valsi-kuho)_ is the terminator paired with _<a id="id-1.9.8.5.2.1" class="indexterm"></a>[_poi_](../go01#valsi-poi)_ and _<a id="id-1.9.8.5.3.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ with _<a id="id-1.9.8.5.4.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ , and _<a id="id-1.9.8.5.5.1" class="indexterm"></a>[_vau_](../go01#valsi-vau)_ is the terminator of the whole bridi.

When a simple descriptor using _<a id="id-1.9.8.6.1.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ , like _<a id="id-1.9.8.6.2.1" class="indexterm"></a>le gerku_ , has a relative clause attached, it is purely a matter of style and emphasis where the relative clause should go. Therefore, the following examples are all equivalent in meaning to [Example 8.47](../section-descriptors#example-random-id-UmLX) :

<div class="interlinear-gloss-example example">
<a id="example-random-id-qmCQ"></a>

**Example 8.48. <a id="c8e6d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>poi</td><td>blabi</td><td>ku'o</td><td>gerku</td><td>cu</td><td>klama</td></tr><tr class="gloss"><td>The</td><td>such-that-(</td><td>it-is-white</td><td>)</td><td>dog</td><td>&nbsp;</td><td>goes.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qMct"></a>

**Example 8.49. <a id="c8e6d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>gerku</td><td>ku</td><td>poi</td><td>blabi</td><td>cu</td><td>klama</td></tr><tr class="gloss"><td>The</td><td>(dog</td><td>)</td><td>which</td><td>is-white</td><td>&nbsp;</td><td>goes.</td></tr></tbody></table>

</div>  

[Example 8.47](../section-descriptors#example-random-id-UmLX) will seem most natural to speakers of languages like English, which always puts relative clauses after the noun phrases they are attached to; [Example 8.48](../section-descriptors#example-random-id-qmCQ) , on the other hand, may seem more natural to Finnish or Chinese speakers, who put the relative clause first. Note that in [Example 8.48](../section-descriptors#example-random-id-qmCQ) , the elidable terminator _<a id="id-1.9.8.9.4.1" class="indexterm"></a>[_ku'o_](../go01#valsi-kuho)_ must appear, or the selbri of the relative clause ( _<a id="id-1.9.8.9.5.1" class="indexterm"></a>[_blabi_](../go01#valsi-blabi)_) will merge with the selbri of the description ( _<a id="id-1.9.8.9.6.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_), resulting in an ungrammatical sentence. The purpose of the form appearing in [Example 8.49](../section-descriptors#example-random-id-qMct) will be apparent shortly.

As is explained in detail in [Section 6.7](../section-quantified-descriptions) , two different numbers (known as the “inner quantifier” and the “outer quantifier”) can be attached to a description. The inner quantifier specifies how many things the descriptor refers to: it appears between the descriptor and the description selbri. The outer quantifier appears before the descriptor, and specifies how many of the things referred to by the descriptor are involved in this particular bridi. In the following example,

<div class="interlinear-gloss-example example">
<a id="example-random-id-3nJN"></a>

**Example 8.50. <a id="c8e6d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>re</td><td></td><td>le</td><td>mu</td><td>prenu</td><td>cu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>Two</td><td>of</td><td>the</td><td>five</td><td>persons</td><td>&nbsp;</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Two of the five people [that I have in mind] are going to the market.</p></td></tr></tbody></table>

</div>  

_<a id="id-1.9.8.12.1.1" class="indexterm"></a>[_mu_](../go01#valsi-mu)_ is the inner quantifier and _<a id="id-1.9.8.12.2.1" class="indexterm"></a>[_re_](../go01#valsi-re)_ is the outer quantifier. Now what is meant by attaching a relative clause to the sumti _<a id="id-1.9.8.12.3.1" class="indexterm"></a>re le mu prenu_ ? Suppose the relative clause is _<a id="id-1.9.8.12.4.1" class="indexterm"></a>poi ninmu_ (meaning “who are women”). Now the three possible attachment points discussed previously take on significance.

<div class="interlinear-gloss-example example">
<a id="example-random-id-qMdb"></a>

**Example 8.51. <a id="c8e6d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>re</td><td></td><td>le</td><td>poi</td><td>ninmu</td><td>ku'o</td></tr><tr class="gloss"><td>Two</td><td>of</td><td>the</td><td>such-that([they]</td><td>are-women</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mu</td><td>prenu</td><td>cu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>five</td><td>persons</td><td>&nbsp;</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Two women out of the five persons go to the market.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qmDo"></a>

**Example 8.52. <a id="c8e6d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>re</td><td></td><td>le</td><td>mu</td><td>prenu</td><td>poi</td><td>ninmu</td><td>[ku]</td><td>cu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>Two</td><td>of</td><td>the</td><td>(five</td><td>persons</td><td>which-(</td><td>are-women)</td><td>)</td><td>&nbsp;</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Two of the five women go to the market.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qMDQ"></a>

**Example 8.53. <a id="c8e6d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>re</td><td></td><td>le</td><td>mu</td><td>prenu</td><td>ku</td><td>poi</td><td>ninmu</td><td>cu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>(Two</td><td>of</td><td>the</td><td>five</td><td>persons</td><td>)</td><td>which-(</td><td>are-women</td><td>)</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Two women out of the five persons go to the market.</p></td></tr></tbody></table>

</div>  

As the parentheses show, [Example 8.52](../section-descriptors#example-random-id-qmDo) means that all five of the persons are women, whereas [Example 8.53](../section-descriptors#example-random-id-qMDQ) means that the two who are going to the market are women. How do we remember which is which? If the relative clause comes after the explicit _<a id="id-1.9.8.16.3.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ , as in [Example 8.53](../section-descriptors#example-random-id-qMDQ) , then the sumti as a whole is qualified by the relative clause. If there is no _<a id="id-1.9.8.16.5.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ , or if the relative clause comes before an explicit _<a id="id-1.9.8.16.6.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ , then the relative clause is understood to apply to everything which the underlying selbri applies to.

What about [Example 8.51](../section-descriptors#example-random-id-qMdb) ? By convention, it means the same as [Example 8.53](../section-descriptors#example-random-id-qMDQ) , and it requires no _<a id="id-1.9.8.17.3.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ , but it does typically require a _<a id="id-1.9.8.17.4.1" class="indexterm"></a>[_ku'o_](../go01#valsi-kuho)_ instead. Note that the relative clause comes before the inner quantifier.

When _<a id="id-1.9.8.18.1.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ is the descriptor being used, and the sumti has no explicit outer quantifier, then the outer quantifier is understood to be _<a id="id-1.9.8.18.2.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_ (meaning “all”), as is explained in [Section 6.7](../section-quantified-descriptions). Thus _<a id="id-1.9.8.18.5.1" class="indexterm"></a>le gerku_ is taken to mean “all of the things I refer to as dogs” , possibly all one of them. In that case, there is no difference between a relative clause after the _<a id="id-1.9.8.18.7.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ or before it. However, if the descriptor is _<a id="id-1.9.8.18.8.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ , the difference is quite important:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qmDS"></a>

**Example 8.54. <a id="c8e6d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>prenu</td><td>ku</td><td>noi</td><td>blabi</td><td>cu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>(Some</td><td>persons</td><td>)</td><td>incidentally-which-(</td><td>are-white</td><td>)</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Some people, who are white, go to the market.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qmdX"></a>

**Example 8.55. <a id="c8e6d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>prenu</td><td>noi</td><td>blabi</td><td>[ku]</td><td>cu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>Some</td><td>(persons</td><td>incidentally-which</td><td>are-white</td><td>)</td><td>&nbsp;</td><td>go</td><td>to-the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Some of the people, who by the way are white, go to the market.</p></td></tr></tbody></table>

</div>  

Both [Example 8.54](../section-descriptors#example-random-id-qmDS) and [Example 8.55](../section-descriptors#example-random-id-qmdX) tell us that one or more persons are going to the market. However, they make very different incidental claims. Now, what does _<a id="id-1.9.8.21.3.1" class="indexterm"></a>lo prenu noi blabi_ mean? Well, the default inner quantifier is _<a id="id-1.9.8.21.4.1" class="indexterm"></a>[_ro_](../go01#valsi-ro)_ (meaning “all”), and the default outer quantifier is _<a id="id-1.9.8.21.6.1" class="indexterm"></a>[_su'o_](../go01#valsi-suho)_ (meaning “at least one”). Therefore, we must first take all persons, then choose at least one of them. That one or more people will be going.

In [Example 8.54](../section-descriptors#example-random-id-qmDS) , the relative clause described the sumti once the outer quantifier was applied: one or more people, who are white, are going. But in [Example 8.55](../section-descriptors#example-random-id-qmdX) , the relative clause actually describes the sumti before the outer quantification is applied, so that it ends up meaning “First take all persons – by the way, they're all white”. But not all people are white, so the incidental claim being made here is false.

<a id="id-1.9.8.23.1" class="indexterm"></a>The safe strategy, therefore, is to always use _<a id="id-1.9.8.23.2.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ when attaching a _<a id="id-1.9.8.23.3.1" class="indexterm"></a>[_noi_](../go01#valsi-noi)_ relative clause to a _<a id="id-1.9.8.23.4.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ descriptor. Otherwise we may end up claiming far too much.

<a id="id-1.9.8.24.1" class="indexterm"></a><a id="id-1.9.8.24.2" class="indexterm"></a><a id="id-1.9.8.24.3" class="indexterm"></a><a id="id-1.9.8.24.4" class="indexterm"></a>When the descriptor is _<a id="id-1.9.8.24.5.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ , indicating that what follows is a selbri used for naming, then the positioning of relative clauses has a different significance. A relative clause inside the _<a id="id-1.9.8.24.6.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ , whether before or after the selbri, is reckoned part of the name; a relative clause outside the _<a id="id-1.9.8.24.7.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ is not. Therefore,

<div class="interlinear-gloss-example example">
<a id="example-random-id-JYj4"></a>

**Example 8.56. <a id="id-1.9.8.25.1.1" class="indexterm"></a><a id="c8e6d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>la</td><td>nanmu</td><td>poi</td><td>terpa</td><td>le</td><td>ke'a</td><td>xirma</td><td>[ku]</td></tr><tr class="gloss"><td>I</td><td>see</td><td>that-named-(</td><td>man</td><td>which</td><td>fears</td><td>the</td><td>of-IT</td><td>horse</td><td>).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I see Man Afraid Of His Horse.</p></td></tr></tbody></table>

</div>  

says that the speaker sees a person with a particular name, who does not necessarily fear any horses, whereas

<div class="interlinear-gloss-example example">
<a id="example-random-id-9GWR"></a>

**Example 8.57. <a id="c8e6d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>viska</td><td>la</td><td>nanmu</td><td>ku</td><td>poi</td><td>terpa</td><td>le</td><td>ke'a</td><td>xirma.</td></tr><tr class="gloss"><td>I</td><td>see</td><td>that-named-(</td><td>Man</td><td>)</td><td>which</td><td>fears</td><td>the</td><td>of-IT</td><td>horse.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I see the person named <span class="quote">“<span class="quote">Man</span>”</span> who is afraid of his horse.</p></td></tr></tbody></table>

</div>  

refers to one (or more) of those named “Man” , namely the one(s) who are afraid of their horses.

<a id="id-1.9.8.29.1" class="indexterm"></a><a id="id-1.9.8.29.2" class="indexterm"></a>Finally, so-called indefinite sumti like _<a id="id-1.9.8.29.3.1" class="indexterm"></a>re karce_ , which means almost the same as _<a id="id-1.9.8.29.4.1" class="indexterm"></a>re lo karce_ (which in turn means the same as _<a id="id-1.9.8.29.5.1" class="indexterm"></a>re lo ro karce_), can have relative clauses attached; these are taken to be of the outside-the- _<a id="id-1.9.8.29.6.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ variety. Here is an example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-J11I"></a>

**Example 8.58. <a id="c8e6d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ponse</td><td>re</td><td>karce</td><td>[ku]</td><td>poi</td><td>xekri</td></tr><tr class="gloss"><td>I</td><td>possess</td><td>two</td><td>cars</td><td>&nbsp;</td><td>which-are</td><td>black.</td></tr></tbody></table>

</div>  

<a id="id-1.9.8.31.1" class="indexterm"></a><a id="id-1.9.8.31.2" class="indexterm"></a>The restrictive relative clause only affects the two cars being affected by the main bridi, not all cars that exist. It is ungrammatical to try to place a relative clause within an indefinite sumti (that is, before an explicitly expressed terminating _<a id="id-1.9.8.31.3.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_.) Use an explicit _<a id="id-1.9.8.31.4.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ instead.