<a id="section-dependent-places"></a>12.6. <a id="c12s6"></a>Dependent places
-----------------------------------------------------------------------------

<a id="id-1.13.8.2.1" class="indexterm"></a>In order to understand which places, if any, should be completely removed from a lujvo place structure, we need to understand the concept of dependent places. One place of a brivla is said to be dependent on another if its value can be predicted from the values of one or more of the other places. For example, the g2 place of _<a id="id-1.13.8.2.2.1" class="indexterm"></a>[_gerku_](../go01#valsi-gerku)_ is dependent on the g1 place. Why? Because when we know what fits in the g1 place (Spot, let us say, a well-known dog), then we know what fits in the g2 place ( “St. Bernard” , let us say). In other words, when the value of the g1 place has been specified, the value of the g2 place is determined by it. Conversely, since each dog has only one breed, but each breed contains many dogs, the g1 place is not dependent on the g2 place; if we know only that some dog is a St. Bernard, we cannot tell by that fact alone which dog is meant.

For _<a id="id-1.13.8.3.1.1" class="indexterm"></a>[_zdani_](../go01#valsi-zdani)_ , on the other hand, there is no dependency between the places. When we know the identity of a house-dweller, we have not determined the house, because a dweller may dwell in more than one house. By the same token, when we know the identity of a house, we do not know the identity of its dweller, for a house may contain more than one dweller.

<a id="id-1.13.8.4.1" class="indexterm"></a>The rule for eliminating places from a lujvo is that dependent places provided by the seltau are eliminated. Therefore, in _<a id="id-1.13.8.4.2.1" class="indexterm"></a>[_gerzda_](../go01#valsi-gerzda)_ the dependent g2 place is removed from the tentative place structure given in [Example 12.10](../section-lujvo-meanings#example-random-id-Wx42) , leaving the place structure:

<div class="example">
<a id="example-random-id-zMyY"></a>

**Example 12.20. <a id="c12e6d1"></a>** 

> z1 is the house dwelt in by dog z2=g1

</div>  

Informally put, the reason this has happened – and it happens a lot with seltau places – is that the third place was describing not the doghouse, but the dog who lives in it. The sentence

<div class="interlinear-gloss-example example">
<a id="example-random-id-PI6B"></a>

**Example 12.21. <a id="c12e6d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.mon.</td><td>.rePOS.</td><td>gerzda</td><td>la</td><td>.spat.</td></tr><tr class="gloss"><td>That-named</td><td>Mon</td><td>Repos</td><td>is-a-doghouse-of</td><td>that-named</td><td>Spot.</td></tr></tbody></table>

</div>  

really means

<div class="interlinear-gloss-example example">
<a id="example-random-id-73x9"></a>

**Example 12.22. <a id="c12e6d3"></a><a id="id-1.13.8.9.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.mon.</td><td>.rePOS.</td><td>zdani</td><td>la</td><td>.spat.</td><td>noi</td><td>gerku</td></tr><tr class="gloss"><td>That-named</td><td>Mon</td><td>Repos</td><td>is-a-house-of</td><td>that-named</td><td>Spot,</td><td>who</td><td>is-a-dog.</td></tr></tbody></table>

</div>  

since that is the interpretation we have given _<a id="id-1.13.8.10.1.1" class="indexterm"></a>[_gerzda_](../go01#valsi-gerzda)_. But that in turn means<a id="id-1.13.8.10.2" class="indexterm"></a>

<div class="interlinear-gloss-example example">
<a id="example-random-id-wc69"></a>

**Example 12.23. <a id="c12e6d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.mon.</td><td>.rePOS.</td><td>zdani</td><td>la</td><td>spat</td></tr><tr class="gloss"><td>That-named</td><td>Mon</td><td>Repos</td><td>is-a-house-of</td><td>that-named</td><td>Spot,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>noi&nbsp;ke'a</td><td>gerku</td><td>zo'e</td></tr><tr class="gloss"><td>who</td><td>is-a-dog</td><td>of-unspecified-breed.</td></tr></tbody></table>

</div>  

Specifically,

<div class="interlinear-gloss-example example">
<a id="example-random-id-KqrV"></a>

**Example 12.24. <a id="c12e6d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.mon.</td><td>.rePOS.</td><td>zdani</td><td>la</td><td>.spat.</td></tr><tr class="gloss"><td>That-named</td><td>Mon</td><td>Repos</td><td>is-a-house-of</td><td>that-named</td><td>Spot,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>noi&nbsp;ke'a</td><td>gerku</td><td>la</td><td>.sankt.</td><td>.berNARD.</td></tr><tr class="gloss"><td>who</td><td>is-a-dog-of-breed</td><td>that-named</td><td>St.</td><td>Bernard.</td></tr></tbody></table>

</div>  

and in that case, it makes little sense to say

<div class="interlinear-gloss-example example">
<a id="example-random-id-yXR0"></a>

**Example 12.25. <a id="c12e6d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.mon.</td><td>.rePOS.</td><td>gerzda</td><td>la</td><td>.spat.</td><td>noi&nbsp;ke'a</td><td>gerku</td></tr><tr class="gloss"><td>That-named</td><td>Mon</td><td>Repos</td><td>is-a-doghouse-of</td><td>that-named</td><td>Spot,</td><td>who</td><td>is-a-dog</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td></td><td>la</td><td>.sankt.</td><td>.berNARD.</td><td>ku'o</td></tr><tr class="gloss"><td>of-breed</td><td>that-named</td><td>St.</td><td>Bernard,</td><td></td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td></td><td>la</td><td>.sankt.</td><td>.berNARD.</td></tr><tr class="gloss"><td>of-breed</td><td>that-named</td><td>St.</td><td>Bernard.</td></tr></tbody></table>

</div>  

<a id="id-1.13.8.16.1" class="indexterm"></a>employing the over-ample place structure of [Example 12.10](../section-lujvo-meanings#example-random-id-Wx42). The dog breed is redundantly given both in the main selbri and in the relative clause, and (intuitively speaking) is repeated in the wrong place, since the dog breed is supplementary information about the dog, and not about the doghouse.

As a further example, take _<a id="id-1.13.8.17.1.1" class="indexterm"></a>[_cakcinki_](../go01#valsi-cakcinki)_ , the lujvo for “beetle” , based on the tanru _<a id="id-1.13.8.17.3.1" class="indexterm"></a>calku cinki_ , or “shell-insect”. The gismu place structures are:

<div class="example">
<a id="example-random-id-D0qb"></a>

**Example 12.26. <a id="c12e6d7"></a>** 

_<a id="id-1.13.8.18.2.1.1" class="indexterm"></a>[_calku_](../go01#valsi-calku)_ : ca1 is a shell/husk around ca2 made of ca3

_<a id="id-1.13.8.18.3.1.1" class="indexterm"></a>[_cinki_](../go01#valsi-cinki)_ : ci1 is an insect/arthropod of species ci2

</div>  

<a id="id-1.13.8.19.1" class="indexterm"></a><a id="id-1.13.8.19.2" class="indexterm"></a><a id="id-1.13.8.19.3" class="indexterm"></a><a id="id-1.13.8.19.4" class="indexterm"></a>This example illustrates a cross-dependency between a place of one gismu and a place of the other. The ca3 place is dependent on ci1, because all insects (which fit into ci1) have shells made of chitin (which fits into ca3). Furthermore, ca1 is dependent on ci1 as well, because each insect has only a single shell. And since ca2 (the thing with the shell) is equivalent to ci1 (the insect), the place structure is

<div class="example">
<a id="example-random-id-n7JB"></a>

**Example 12.27. <a id="c12e6d8"></a><a id="id-1.13.8.20.1.2" class="indexterm"></a>** 

> ci1=ca2 is a beetle of species ci2

</div>  

with not a single place of _<a id="id-1.13.8.21.1.1" class="indexterm"></a>[_calku_](../go01#valsi-calku)_ surviving independently!

<a id="id-1.13.8.22.1" class="indexterm"></a><a id="id-1.13.8.22.2" class="indexterm"></a>(Note that there is nothing in this explanation that tells us just why _<a id="id-1.13.8.22.3.1" class="indexterm"></a>[_cakcinki_](../go01#valsi-cakcinki)_ means “beetle” (member of Coleoptera), since all insects in their adult forms have chitin shells of some sort. The answer, which is in no way predictable, is that the shell is a prominent, highly noticeable feature of beetles in particular.)

<a id="id-1.13.8.23.1" class="indexterm"></a>What about the dependency of ci2 on ci1? After all, no beetle belongs to more than one species, so it would seem that the ci2 place of _<a id="id-1.13.8.23.2.1" class="indexterm"></a>[_cakcinki_](../go01#valsi-cakcinki)_ could be eliminated on the same reasoning that allowed us to eliminate the g2 place of _<a id="id-1.13.8.23.3.1" class="indexterm"></a>[_gerzda_](../go01#valsi-gerzda)_ above. However, it is a rule that dependent places are not eliminated from a lujvo when they are derived from the tertau of its veljvo. This rule is imposed to keep the place structures of lujvo from drifting too far from the tertau place structure; if a place is necessary in the tertau, it's treated as necessary in the lujvo as well.

<a id="id-1.13.8.24.1" class="indexterm"></a><a id="id-1.13.8.24.2" class="indexterm"></a><a id="id-1.13.8.24.3" class="indexterm"></a>In general, the desire to remove places coming from the tertau is a sign that the veljvo selected is simply wrong. Different place structures imply different concepts, and the lujvo maker may be trying to shoehorn the wrong concept into the place structure of his or her choosing. This is obvious when someone tries to shoehorn a _<a id="id-1.13.8.24.4.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ tertau into a _<a id="id-1.13.8.24.5.1" class="indexterm"></a>[_litru_](../go01#valsi-litru)_ or _<a id="id-1.13.8.24.6.1" class="indexterm"></a>[_cliva_](../go01#valsi-cliva)_ concept, for example: these gismu differ in their number of arguments, and suppressing places of _<a id="id-1.13.8.24.7.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ in a lujvo doesn't make any sense if the resulting modified place structure is that of _<a id="id-1.13.8.24.8.1" class="indexterm"></a>[_litru_](../go01#valsi-litru)_ or _<a id="id-1.13.8.24.9.1" class="indexterm"></a>[_cliva_](../go01#valsi-cliva)_.

Sometimes the dependency is between a single place of the tertau and the whole event described by the seltau. Such cases are discussed further in [Section 12.13](../section-implicit-abstraction).

<a id="id-1.13.8.26.1" class="indexterm"></a><a id="id-1.13.8.26.2" class="indexterm"></a><a id="id-1.13.8.26.3" class="indexterm"></a><a id="id-1.13.8.26.4" class="indexterm"></a><a id="id-1.13.8.26.5" class="indexterm"></a>Unfortunately, not all dependent places in the seltau can be safely removed: some of them are necessary to interpreting the lujvo's meaning in context. It doesn't matter much to a doghouse what breed of dog inhabits it, but it can make quite a lot of difference to the construction of a school building what kind of school is in it! Music schools need auditoriums and recital rooms, elementary schools need playgrounds, and so on: therefore, the place structure of _<a id="id-1.13.8.26.6.1" class="indexterm"></a>[_kuldi'u_](../go01#valsi-kuldihu)_ (from _<a id="id-1.13.8.26.7.1" class="indexterm"></a>ckule dinju_ , and meaning “school building”) needs to be

<div class="example">
<a id="example-random-id-u6Xz"></a>

**Example 12.28. <a id="c12e6d9"></a><a id="id-1.13.8.27.1.2" class="indexterm"></a>** 

> d1 is a building housing school c1 teaching subject c3 to audience c4

</div>  

even though c3 and c4 are plainly dependent on c1. The other places of _<a id="id-1.13.8.28.1.1" class="indexterm"></a>[_ckule_](../go01#valsi-ckule)_ , the location (c2) and operators (c5), don't seem to be necessary to the concept “school building” , and are dependent on c1 to boot, so they are omitted. Again, the need for case-by-case consideration of place structures is demonstrated.