<a id="section-cultural-gismu"></a>4.15. <a id="c4s15"></a>Cultural and other non-algorithmic gismu
---------------------------------------------------------------------------------------------------

The following gismu were not made by the gismu creation algorithm. They are, in effect, coined words similar to fu'ivla. They are exceptions to the otherwise mandatory gismu creation algorithm where there was sufficient justification for such exceptions. Except for the small metric prefixes and the assignable predicates beginning with _brod-_ , they all end in the letter _o_ , which is otherwise a rare letter in Lojban gismu.

<a id="id-1.5.17.3.1" class="indexterm"></a>The following gismu represent concepts that are sufficiently unique to Lojban that they were either coined from combining forms of other gismu, or else made up out of whole cloth. These gismu are thus conceptually similar to lujvo even though they are only five letters long; however, unlike lujvo, they have rafsi assigned to them for use in building more complex lujvo. Assigning gismu to these concepts helps to keep the resulting lujvo reasonably short.

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.4.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-broda"><em class="glossterm">broda</em></a></em></span></td><td><p>1st assignable predicate</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.4.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-brode"><em class="glossterm">brode</em></a></em></span></td><td><p>2nd assignable predicate</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.4.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-brodi"><em class="glossterm">brodi</em></a></em></span></td><td><p>3rd assignable predicate</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.4.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-brodo"><em class="glossterm">brodo</em></a></em></span></td><td><p>4th assignable predicate</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.4.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-brodu"><em class="glossterm">brodu</em></a></em></span></td><td><p>5th assignable predicate</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.4.7.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-cmavo"><em class="glossterm">cmavo</em></a></em></span></td><td><p>structure word (from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.4.7.2.1.1.1" class="indexterm"></a>cmalu valsi</em></span>)</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.4.8.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-lojbo"><em class="glossterm">lojbo</em></a></em></span></td><td><p>Lojbanic (from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.4.8.2.1.1.1" class="indexterm"></a>logji bangu</em></span>)</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.4.9.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-lujvo"><em class="glossterm">lujvo</em></a></em></span></td><td><p>compound word (from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.4.9.2.1.1.1" class="indexterm"></a>pluja valsi</em></span>)</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.4.10.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-mekso"><em class="glossterm">mekso</em></a></em></span></td><td><p>Mathematical EXpression</p></td></tr></tbody></table>

It is important to understand that even though _<a id="id-1.5.17.5.1.1" class="indexterm"></a>[_cmavo_](../go01#valsi-cmavo)_ , _<a id="id-1.5.17.5.2.1" class="indexterm"></a>[_lojbo_](../go01#valsi-lojbo)_ , and _<a id="id-1.5.17.5.3.1" class="indexterm"></a>[_lujvo_](../go01#valsi-lujvo)_ were made up from parts of other gismu, they are now full-fledged gismu used in exactly the same way as all other gismu, both in grammar and in word formation.

The following three groups of gismu represent concepts drawn from the international language of science and mathematics. They are used for concepts that are represented in most languages by a root which is recognized internationally.

Small metric prefixes (values less than 1):

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.9.1.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-decti"><em class="glossterm">decti</em></a></em></span></td><td>.1</td><td>deci</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.9.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-centi"><em class="glossterm">centi</em></a></em></span></td><td>.01</td><td>centi</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.9.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-milti"><em class="glossterm">milti</em></a></em></span></td><td>.001</td><td>milli</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.9.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-mikri"><em class="glossterm">mikri</em></a></em></span></td><td><span class="mathphrase">10 <sup>-6</sup></span></td><td>micro</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.9.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-nanvi"><em class="glossterm">nanvi</em></a></em></span></td><td><span class="mathphrase">10 <sup>-9</sup></span></td><td>nano</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.9.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-picti"><em class="glossterm">picti</em></a></em></span></td><td><span class="mathphrase">10 <sup>-12</sup></span></td><td>pico</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.9.7.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-femti"><em class="glossterm">femti</em></a></em></span></td><td><span class="mathphrase">10 <sup>-15</sup></span></td><td>femto</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.9.8.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-xatsi"><em class="glossterm">xatsi</em></a></em></span></td><td><span class="mathphrase">10 <sup>-18</sup></span></td><td>atto</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.9.9.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-zepti"><em class="glossterm">zepti</em></a></em></span></td><td><span class="mathphrase">10 <sup>-21</sup></span></td><td>zepto</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.9.10.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-gocti"><em class="glossterm">gocti</em></a></em></span></td><td><span class="mathphrase">10 <sup>-24</sup></span></td><td>yocto</td></tr></tbody></table>

Large metric prefixes (values greater than 1):

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.11.1.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-dekto"><em class="glossterm">dekto</em></a></em></span></td><td>10</td><td>deka</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.11.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-xecto"><em class="glossterm">xecto</em></a></em></span></td><td>100</td><td>hecto</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.11.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-kilto"><em class="glossterm">kilto</em></a></em></span></td><td>1000</td><td>kilo</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.11.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-megdo"><em class="glossterm">megdo</em></a></em></span></td><td><span class="mathphrase">10 <sup>6</sup></span></td><td>mega</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.11.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-gigdo"><em class="glossterm">gigdo</em></a></em></span></td><td><span class="mathphrase">10 <sup>9</sup></span></td><td>giga</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.11.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-terto"><em class="glossterm">terto</em></a></em></span></td><td><span class="mathphrase">10 <sup>12</sup></span></td><td>tera</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.11.7.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-petso"><em class="glossterm">petso</em></a></em></span></td><td><span class="mathphrase">10 <sup>15</sup></span></td><td>peta</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.11.8.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-xexso"><em class="glossterm">xexso</em></a></em></span></td><td><span class="mathphrase">10 <sup>18</sup></span></td><td>exa</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.11.9.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-zetro"><em class="glossterm">zetro</em></a></em></span></td><td><span class="mathphrase">10 <sup>21</sup></span></td><td>zetta</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.11.10.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-gotro"><em class="glossterm">gotro</em></a></em></span></td><td><span class="mathphrase">10 <sup>24</sup></span></td><td>yotta</td></tr></tbody></table>

<a id="id-1.5.17.12.1" class="indexterm"></a>Other scientific or mathematical terms:

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.13.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-delno"><em class="glossterm">delno</em></a></em></span></td><td><p>candela</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.13.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-kelvo"><em class="glossterm">kelvo</em></a></em></span></td><td><p>kelvin</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.13.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-molro"><em class="glossterm">molro</em></a></em></span></td><td><p>mole</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.13.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-radno"><em class="glossterm">radno</em></a></em></span></td><td><p>radian</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.13.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-sinso"><em class="glossterm">sinso</em></a></em></span></td><td><p>sine</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.13.7.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-stero"><em class="glossterm">stero</em></a></em></span></td><td><p>steradian</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.13.8.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-tanjo"><em class="glossterm">tanjo</em></a></em></span></td><td><p>tangent</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.13.9.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-xampo"><em class="glossterm">xampo</em></a></em></span></td><td><p>ampere</p></td></tr></tbody></table>

<a id="id-1.5.17.14.1" class="indexterm"></a><a id="id-1.5.17.14.2" class="indexterm"></a>The gismu _<a id="id-1.5.17.14.3.1" class="indexterm"></a>[_sinso_](../go01#valsi-sinso)_ and _<a id="id-1.5.17.14.4.1" class="indexterm"></a>[_tanjo_](../go01#valsi-tanjo)_ were only made non-algorithmically because they were identical (having been borrowed from a common source) in all the dictionaries that had translations. The other terms in this group are units in the international metric system; some metric units, however, were made by the ordinary process (usually because they are different in Chinese).

Finally, there are the cultural gismu, which are also borrowed, but by modifying a word from one particular language, instead of using the multi-lingual gismu creation algorithm. Cultural gismu are used for words that have local importance to a particular culture; other cultures or languages may have no word for the concept at all, or may borrow the word from its home culture, just as Lojban does. In such a case, the gismu algorithm, which uses weighted averages, doesn't accurately represent the frequency of usage of the individual concept. Cultural gismu are not even required to be based on the six major languages.

The six Lojban source languages:

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.17.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-jungo"><em class="glossterm">jungo</em></a></em></span></td><td><p>Chinese (from <span xml:lang="zh" class="quote" lang="zh">“<span class="quote">Zhōngguó</span>”</span>)</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.17.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-glico"><em class="glossterm">glico</em></a></em></span></td><td><p>English</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.17.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-xindo"><em class="glossterm">xindo</em></a></em></span></td><td><p>Hindi</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.17.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-spano"><em class="glossterm">spano</em></a></em></span></td><td><p>Spanish</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.17.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-rusko"><em class="glossterm">rusko</em></a></em></span></td><td><p>Russian</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.17.7.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-xrabo"><em class="glossterm">xrabo</em></a></em></span></td><td><p>Arabic</p></td></tr></tbody></table>

<a id="id-1.5.17.18.1" class="indexterm"></a>Seven other widely spoken languages that were on the list of candidates for gismu-making, but weren't used:

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.19.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-bengo"><em class="glossterm">bengo</em></a></em></span></td><td><p>Bengali</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.19.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-porto"><em class="glossterm">porto</em></a></em></span></td><td><p>Portuguese</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.19.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-baxso"><em class="glossterm">baxso</em></a></em></span></td><td><p>Bahasa Melayu/Bahasa Indonesia</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.19.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ponjo"><em class="glossterm">ponjo</em></a></em></span></td><td><p>Japanese (from <span class="quote">“<span class="quote">Nippon</span>”</span>)</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.19.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-dotco"><em class="glossterm">dotco</em></a></em></span></td><td><p>German (from <span xml:lang="de" class="quote" lang="de">„<span class="quote">Deutsch</span>“</span>)</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.19.7.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-fraso"><em class="glossterm">fraso</em></a></em></span></td><td><p>French (from <span xml:lang="fr" class="quote" lang="fr">«&nbsp;<span class="quote">Français</span>&nbsp;»</span>)</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.19.8.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-xurdo"><em class="glossterm">xurdo</em></a></em></span></td><td><p>Urdu</p></td></tr></tbody></table>

<a id="id-1.5.17.20.1" class="indexterm"></a><a id="id-1.5.17.20.2" class="indexterm"></a>(Urdu and Hindi began as the same language with different writing systems, but have now become somewhat different, principally in borrowed vocabulary. Urdu-speakers were counted along with Hindi-speakers when weights were assigned for gismu-making purposes.)

<a id="id-1.5.17.21.1" class="indexterm"></a>Countries with a large number of speakers of any of the above languages (where the meaning of “large” is dependent on the specific language):

<table><tbody><tr><td colspan="12321">English:</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.1.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-merko"><em class="glossterm">merko</em></a></em></span></td><td>American</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.1.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-brito"><em class="glossterm">brito</em></a></em></span></td><td>British</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.1.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-skoto"><em class="glossterm">skoto</em></a></em></span></td><td>Scottish</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.1.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-sralo"><em class="glossterm">sralo</em></a></em></span></td><td>Australian</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.1.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-kadno"><em class="glossterm">kadno</em></a></em></span></td><td>Canadian</td></tr></tbody></table>

<table><tbody><tr><td colspan="12321">Spanish:</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.2.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-gento"><em class="glossterm">gento</em></a></em></span></td><td>Argentinian</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.2.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-mexno"><em class="glossterm">mexno</em></a></em></span></td><td>Mexican</td></tr></tbody></table>

<table><tbody><tr><td colspan="12321">Russian:</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.3.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-softo"><em class="glossterm">softo</em></a></em></span></td><td>Soviet/USSR</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.3.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-vukro"><em class="glossterm">vukro</em></a></em></span></td><td>Ukrainian</td></tr></tbody></table>

<table><tbody><tr><td colspan="12321">Arabic:</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.4.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-filso"><em class="glossterm">filso</em></a></em></span></td><td>Palestinian</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.4.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-jerxo"><em class="glossterm">jerxo</em></a></em></span></td><td>Algerian</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.4.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-jordo"><em class="glossterm">jordo</em></a></em></span></td><td>Jordanian</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.4.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-libjo"><em class="glossterm">libjo</em></a></em></span></td><td>Libyan</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.4.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-lubno"><em class="glossterm">lubno</em></a></em></span></td><td>Lebanese</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.4.7.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-misro"><em class="glossterm">misro</em></a></em></span></td><td>Egyptian</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.4.8.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-morko"><em class="glossterm">morko</em></a></em></span></td><td>Moroccan</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.4.9.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-rakso"><em class="glossterm">rakso</em></a></em></span></td><td>Iraqi</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.4.10.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-sadjo"><em class="glossterm">sadjo</em></a></em></span></td><td>Saudi</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.4.11.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-sirxo"><em class="glossterm">sirxo</em></a></em></span></td><td>Syrian</td></tr></tbody></table>

<table><tbody><tr><td colspan="12321">Bahasa Melayu/Bahasa Indonesia:</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.5.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-bindo"><em class="glossterm">bindo</em></a></em></span></td><td>Indonesian</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.5.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-meljo"><em class="glossterm">meljo</em></a></em></span></td><td>Malaysian</td></tr></tbody></table>

<table><tbody><tr><td colspan="12321">Portuguese:</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.6.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-brazo"><em class="glossterm">brazo</em></a></em></span></td><td>Brazilian</td></tr></tbody></table>

<table><tbody><tr><td colspan="12321">Urdu:</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.22.7.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-kisto"><em class="glossterm">kisto</em></a></em></span></td><td>Pakistani</td></tr></tbody></table>

<a id="id-1.5.17.23.1" class="indexterm"></a>The continents (and oceanic regions) of the Earth:

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.25.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-bemro"><em class="glossterm">bemro</em></a></em></span></td><td><p>North American (from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.25.2.2.1.1.1" class="indexterm"></a>berti merko</em></span>)</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.25.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-dzipo"><em class="glossterm">dzipo</em></a></em></span></td><td><p>Antarctican (from <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.25.3.2.1.1.1" class="indexterm"></a>cadzu cipni</em></span>)</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.25.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ketco"><em class="glossterm">ketco</em></a></em></span></td><td><p>South American (from <span xml:lang="qu" class="quote" lang="qu">“<span class="quote">Quechua</span>”</span>)</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.25.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-friko"><em class="glossterm">friko</em></a></em></span></td><td><p>African</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.25.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-polno"><em class="glossterm">polno</em></a></em></span></td><td><p>Polynesian/Oceanic</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.25.7.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ropno"><em class="glossterm">ropno</em></a></em></span></td><td><p>European</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.25.8.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-xazdo"><em class="glossterm">xazdo</em></a></em></span></td><td><p>Asiatic</p></td></tr></tbody></table>

A few smaller but historically important cultures:

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.27.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-latmo"><em class="glossterm">latmo</em></a></em></span></td><td><p>Latin/Roman</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.27.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-srito"><em class="glossterm">srito</em></a></em></span></td><td><p>Sanskrit</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.27.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-xebro"><em class="glossterm">xebro</em></a></em></span></td><td><p>Hebrew/Israeli/Jewish</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.27.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-xelso"><em class="glossterm">xelso</em></a></em></span></td><td><p>Greek (from <span xml:lang="el" class="quote" lang="el">«<span class="quote">Hellas</span>»</span>)</p></td></tr></tbody></table>

<a id="id-1.5.17.28.1" class="indexterm"></a><a id="id-1.5.17.28.2" class="indexterm"></a>Major world religions:

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.29.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-budjo"><em class="glossterm">budjo</em></a></em></span></td><td><p>Buddhist</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.29.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-dadjo"><em class="glossterm">dadjo</em></a></em></span></td><td><p>Taoist</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.29.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-muslo"><em class="glossterm">muslo</em></a></em></span></td><td><p>Islamic/Moslem</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.29.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-xriso"><em class="glossterm">xriso</em></a></em></span></td><td><p>Christian</p></td></tr></tbody></table>

<a id="id-1.5.17.30.1" class="indexterm"></a><a id="id-1.5.17.30.2" class="indexterm"></a>A few terms that cover multiple groups of the above:

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.31.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-jegvo"><em class="glossterm">jegvo</em></a></em></span></td><td><p>Jehovist (Judeo-Christian-Moslem)</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.31.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-semto"><em class="glossterm">semto</em></a></em></span></td><td><p>Semitic</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.31.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-slovo"><em class="glossterm">slovo</em></a></em></span></td><td><p>Slavic</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.17.31.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-xispo"><em class="glossterm">xispo</em></a></em></span></td><td><p>Hispanic (New World Spanish)</p></td></tr></tbody></table>