<a id="section-cu"></a>9.2. <a id="c9s2"></a>Standard bridi form: _cu_
----------------------------------------------------------------------

The following cmavo is discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">cu</p></td><td class="selmaho"><p class="selmaho">CU</p></td><td class="description"><p class="description">prefixed selbri separator</p></td></tr></tbody></table>

<a id="id-1.10.4.4.1" class="indexterm"></a>The most usual way of constructing a bridi from a selbri such as _<a id="id-1.10.4.4.2.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ and an appropriate number of sumti is to place the sumti intended for the x1 place before the selbri, and all the other sumti in order after the selbri, thus:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Ji94"></a>

**Example 9.1. <a id="id-1.10.4.5.1.1" class="indexterm"></a><a id="id-1.10.4.5.1.2" class="indexterm"></a><a id="id-1.10.4.5.1.3" class="indexterm"></a><a id="c9e2d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>cu</td><td>klama</td><td>la</td><td>.bastn.</td><td>la</td><td>.atlantas.</td></tr><tr class="gloss"><td>I</td><td></td><td>go</td><td>to-that-named</td><td>Boston</td><td>from-that-named</td><td>Atlanta</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>dargu</td><td>le</td><td>karce</td></tr><tr class="gloss"><td>via-the</td><td>road</td><td>using-the</td><td>car.</td></tr></tbody></table>

</div>  

Here the sumti are assigned to the places as follows:

<table><colgroup></colgroup><tbody><tr><td>x<sub>1</sub></td><td>agent</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.4.7.2.3.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-mi"><em class="glossterm">mi</em></a></em></span></td></tr><tr><td>x<sub>2</sub></td><td>destination</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.4.7.3.3.1.1" class="indexterm"></a>la .bastn.</em></span></td></tr><tr><td>x<sub>3</sub></td><td>origin</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.4.7.4.3.1.1" class="indexterm"></a>la .atlantas.</em></span></td></tr><tr><td>x<sub>4</sub></td><td>route</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.4.7.5.3.1.1" class="indexterm"></a>le dargu</em></span></td></tr><tr><td>x<sub>5</sub></td><td>means</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.4.7.6.3.1.1" class="indexterm"></a>le karce</em></span></td></tr></tbody></table>

(Note: Many of the examples in the rest of this chapter will turn out to have the same meaning as [Example 9.1](../section-cu#example-random-id-Ji94) ; this fact will not be reiterated.)

<a id="id-1.10.4.9.1" class="indexterm"></a><a id="id-1.10.4.9.2" class="indexterm"></a><a id="id-1.10.4.9.3" class="indexterm"></a>This ordering, with the x1 place before the selbri and all other places in natural order after the selbri, is called “standard bridi form” , and is found in the bulk of Lojban bridi, whether used in main sentences or in subordinate clauses. However, many other forms are possible, such as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-yLqT"></a>

**Example 9.2. <a id="c9e2d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>la</td><td>.bastn.</td><td>la</td><td>.atlantas.</td></tr><tr class="gloss"><td>I,</td><td>to-that-named</td><td>Boston</td><td>from-that-named</td><td>Atlanta</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>dargu</td><td>le</td><td>karce</td><td>cu</td><td>klama</td></tr><tr class="gloss"><td>via-the</td><td>road</td><td>using-the</td><td>car,</td><td></td><td>go.</td></tr></tbody></table>

</div>  

<a id="id-1.10.4.11.1" class="indexterm"></a>Here the selbri is at the end; all the sumti are placed before it. However, the same order is maintained.

Similarly, we may split up the sumti, putting some before the selbri and others after it:

<div class="interlinear-gloss-example example">
<a id="example-random-id-vzNY"></a>

**Example 9.3. <a id="c9e2d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>la</td><td>.bastn.</td><td>cu</td><td>klama</td><td>la</td><td>.atlantas.</td></tr><tr class="gloss"><td>I</td><td>to-that-named</td><td>Boston</td><td></td><td>go</td><td>from-that-named</td><td>Atlanta</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>dargu</td><td>le</td><td>karce</td></tr><tr class="gloss"><td>via-the</td><td>road</td><td>using-the</td><td>car.</td></tr></tbody></table>

</div>  

<a id="id-1.10.4.14.1" class="indexterm"></a><a id="id-1.10.4.14.2" class="indexterm"></a>All of the variant forms in this section and following sections can be used to place emphasis on the part or parts which have been moved out of their standard places. Thus, [Example 9.2](../section-cu#example-random-id-yLqT) places emphasis on the selbri (because it is at the end); [Example 9.3](../section-cu#example-random-id-vzNY) emphasizes _<a id="id-1.10.4.14.5.1" class="indexterm"></a>la .bastn._ , because it has been moved before the selbri. Moving more than one component may dilute this emphasis. It is permitted, but no stylistic significance has yet been established for drastic reordering.

<a id="id-1.10.4.15.1" class="indexterm"></a><a id="id-1.10.4.15.2" class="indexterm"></a><a id="id-1.10.4.15.3" class="indexterm"></a><a id="id-1.10.4.15.4" class="indexterm"></a>In all these examples, the cmavo _<a id="id-1.10.4.15.5.1" class="indexterm"></a>[_cu_](../go01#valsi-cu)_ (belonging to selma'o CU) is used to separate the selbri from any preceding sumti. It is never absolutely necessary to use _<a id="id-1.10.4.15.6.1" class="indexterm"></a>[_cu_](../go01#valsi-cu)_. However, providing it helps the reader or listener to locate the selbri quickly, and may make it possible to place a complex sumti just before the selbri, allowing the speaker to omit elidable terminators, possibly a whole stream of them, that would otherwise be necessary.

<a id="id-1.10.4.16.1" class="indexterm"></a><a id="id-1.10.4.16.2" class="indexterm"></a><a id="id-1.10.4.16.3" class="indexterm"></a><a id="id-1.10.4.16.4" class="indexterm"></a><a id="id-1.10.4.16.5" class="indexterm"></a>The general rule, then, is that the selbri may occur anywhere in the bridi as long as the sumti maintain their order. The only exception (and it is an important one) is that if the selbri appears first, the x1 sumti is taken to have been omitted:

<div class="interlinear-gloss-example example">
<a id="example-random-id-aQtM"></a>

**Example 9.4. <a id="c9e2d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>klama</td><td>la</td><td>.bastn.</td></tr><tr class="gloss"><td>A-goer</td><td>to-that-named</td><td>Boston</td></tr><tr class="gloss"><td>Goes</td><td></td><td>to-Boston</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.atlantas.</td></tr><tr class="gloss"><td>from-that-named</td><td>Atlanta</td></tr><tr class="gloss"><td></td><td>from-Atlanta</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>dargu</td></tr><tr class="gloss"><td>via-the</td><td>road</td></tr><tr class="gloss"><td>via-the</td><td>road</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>karce</td></tr><tr class="gloss"><td>using-the</td><td>car.</td></tr><tr class="gloss"><td>using-the</td><td>car.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Look: a goer to Boston from Atlanta via the road using the car!</p></td></tr></tbody></table>

</div>  

<a id="id-1.10.4.18.1" class="indexterm"></a><a id="id-1.10.4.18.2" class="indexterm"></a><a id="id-1.10.4.18.3" class="indexterm"></a><a id="id-1.10.4.18.4" class="indexterm"></a><a id="id-1.10.4.18.5" class="indexterm"></a>Here the x1 place is empty: the listener must guess from context who is going to Boston. In [Example 9.4](../section-cu#example-random-id-aQtM) , _<a id="id-1.10.4.18.8.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_ is glossed “a goer” rather than “go” because “Go” at the beginning of an English sentence would suggest a command: “Go to Boston!”. [Example 9.4](../section-cu#example-random-id-aQtM) is not a command, simply a normal statement with the x1 place unspecified, causing the emphasis to fall on the selbri _<a id="id-1.10.4.18.15.1" class="indexterm"></a>[_klama_](../go01#valsi-klama)_. Such a bridi, with empty x1, is called an “observative” , because it usually calls on the listener to observe something in the environment which would belong in the x1 place. The third translation above shows this observative nature. Sometimes it is the relationship itself which the listener is asked to observe.

(There is a way to both provide a sumti for the x1 place and put the selbri first in the bridi: see [Example 9.14](../section-FA#example-random-id-oDES).)

<a id="id-1.10.4.20.1" class="indexterm"></a><a id="id-1.10.4.20.2" class="indexterm"></a><a id="id-1.10.4.20.3" class="indexterm"></a>Suppose the speaker desires to omit a place other than the x1 place? (Presumably it is obvious or, for one reason or another, not worth saying.) Places at the end may simply be dropped:

<div class="interlinear-gloss-example example">
<a id="example-random-id-5Eqa"></a>

**Example 9.5. <a id="c9e2d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>la</td><td>.bastn.</td><td>la</td><td>.atlantas.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I go to-Boston from-Atlanta (via an unspecified route, using an unspecified means).</p></td></tr></tbody></table>

</div>  

<a id="id-1.10.4.22.1" class="indexterm"></a>[Example 9.5](../section-cu#example-random-id-5Eqa) has empty x4 and x5 places: the speaker does not specify the route or the means of transport. However, simple omission will not work for a place when the places around it are to be specified: in

<div class="interlinear-gloss-example example">
<a id="example-random-id-jh7T"></a>

**Example 9.6. <a id="c9e2d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>la</td><td>.bastn.</td><td>la</td><td>.atlantas.</td><td>le</td><td>karce</td></tr><tr class="gloss"><td>I</td><td>go</td><td>to-that-named</td><td>Boston</td><td>from-that-named</td><td>Atlanta</td><td>via-the</td><td>car.</td></tr></tbody></table>

</div>  

_<a id="id-1.10.4.24.1.1" class="indexterm"></a>le karce_ occupies the x4 place, and therefore [Example 9.6](../section-cu#example-random-id-jh7T) means:

> I go to Boston from Atlanta, using the car as a route.

This is nonsense, since a car cannot be a route. What the speaker presumably meant is expressed by:

<div class="interlinear-gloss-example example">
<a id="example-random-id-tqoQ"></a>

**Example 9.7. <a id="c9e2d7"></a><a id="id-1.10.4.27.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>la</td><td>.bastn.</td><td>la</td><td>.atlantas.</td></tr><tr class="gloss"><td>I</td><td>go</td><td>to-that-named</td><td>Boston</td><td>from-that-named</td><td>Atlanta</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>zo'e</td><td>le</td><td>karce</td></tr><tr class="gloss"><td>via-something-unspecified</td><td>using-the</td><td>car.</td></tr></tbody></table>

</div>  

<a id="id-1.10.4.28.1" class="indexterm"></a><a id="id-1.10.4.28.2" class="indexterm"></a><a id="id-1.10.4.28.3" class="indexterm"></a><a id="id-1.10.4.28.4" class="indexterm"></a><a id="id-1.10.4.28.5" class="indexterm"></a>Here the sumti cmavo _<a id="id-1.10.4.28.6.1" class="indexterm"></a>[_zo'e_](../go01#valsi-zohe)_ is used to explicitly fill the x4 place; _<a id="id-1.10.4.28.8.1" class="indexterm"></a>[_zo'e_](../go01#valsi-zohe)_ means “the unspecified thing” and has the same meaning as leaving the place empty: the listener must infer the correct meaning from context.