<a id="section-conventions"></a>1.3. <a id="c1s3"></a>What are the typographical conventions of this book?
----------------------------------------------------------------------------------------------------------

Each chapter is broken into numbered sections; each section contains a mixture of expository text, numbered examples, and possibly tables.

<a id="id-1.2.5.3.1" class="indexterm"></a><a id="id-1.2.5.3.2" class="indexterm"></a>The reader will notice a certain similarity in the examples used throughout the book. One chapter after another rings the changes on the self-same sentences:

<div class="interlinear-gloss-example example">
<a id="example-random-id-hrtj"></a>

**Example 1.1. <a id="id-1.2.5.4.1.1" class="indexterm"></a><a id="c1e3d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>go-to</td><td>that-which-I-describe-as-a</td><td>store.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I go to the store.</p></td></tr></tbody></table>

</div>  

will become wearisomely familiar before [Chapter 21](../chapter-grammars) is reached. This method is deliberate; I have tried to use simple and (eventually) familiar examples wherever possible, to avoid obscuring new grammatical points with new vocabulary. Of course, this is not the method of a textbook, but this book is not a textbook (although people have learned Lojban from it and its predecessors). Rather, it is intended both for self-learning (of course, at present would-be Lojban teachers must be self-learners) and to serve as a reference in the usual sense, for looking up obscure points about the language.

<a id="id-1.2.5.6.1" class="indexterm"></a><a id="id-1.2.5.6.2" class="indexterm"></a><a id="id-1.2.5.6.3" class="indexterm"></a>It is useful to talk further about [Example 1.1](../section-conventions#example-random-id-hrtj) for what it illustrates about examples in this book. Examples usually occupy three lines. The first of these is in Lojban (in italics), the second in a word-by-word literal translation of the Lojban into English (in boldface), and the third in colloquial English. The second and third lines are sometimes called the “literal translation” and the “colloquial translation” respectively. Sometimes, when clarity is not sacrificed thereby, one or both are omitted. If there is more than one Lojban sentence, it generally means that they have the same meaning.

<a id="id-1.2.5.7.1" class="indexterm"></a>Words are sometimes surrounded by square brackets. In Lojban texts, these enclose optional grammatical particles that may (in the context of the particular example) be either omitted or included. In literal translations, they enclose words that are used as conventional translations of specific Lojban words, but don't have exactly the meanings or uses that the English word would suggest. In [Chapter 3](../chapter-phonology) , square brackets surround phonetic representations in the International Phonetic Alphabet.

<a id="id-1.2.5.8.1" class="indexterm"></a><a id="id-1.2.5.8.2" class="indexterm"></a>Many of the tables, especially those placed at the head of various sections, are in three columns. The first column contains Lojban words discussed in that section; the second column contains the grammatical category (represented by an UPPER CASE Lojban word) to which the word belongs, and the third column contains a brief English gloss, not necessarily or typically a full explanation. Other tables are explained in context.

<a id="id-1.2.5.9.1" class="indexterm"></a>A few Lojban words are used in this book as technical terms. All of these are explained in [Chapter 2](../chapter-tour) , except for a few used only in single chapters, which are explained in the introductory sections of those chapters.