<a id="section-connectives-within-mekso"></a>18.17. <a id="c18s17"></a>Logical and non-logical connectives within mekso
-----------------------------------------------------------------------------------------------------------------------

The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">.abu</p></td><td class="selmaho"><p class="selmaho">BY</p></td><td class="description"><p class="description">letter <span class="quote">“<span class="quote">a</span>”</span></p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">by</p></td><td class="selmaho"><p class="selmaho">BY</p></td><td class="description"><p class="description">letter <span class="quote">“<span class="quote">b</span>”</span></p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">cy</p></td><td class="selmaho"><p class="selmaho">BY</p></td><td class="description"><p class="description">letter <span class="quote">“<span class="quote">c</span>”</span></p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">fe'a</p></td><td class="selmaho"><p class="selmaho">VUhU</p></td><td class="description"><p class="description">nth root of (default square root)</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">lo'o</p></td><td class="selmaho"><p class="selmaho">LOhO</p></td><td class="description"><p class="description">terminator for LI</p></td></tr></tbody></table>

<a id="id-1.19.19.4.1" class="indexterm"></a><a id="id-1.19.19.4.2" class="indexterm"></a><a id="id-1.19.19.4.3" class="indexterm"></a><a id="id-1.19.19.4.4" class="indexterm"></a><a id="id-1.19.19.4.5" class="indexterm"></a><a id="id-1.19.19.4.6" class="indexterm"></a><a id="id-1.19.19.4.7" class="indexterm"></a><a id="id-1.19.19.4.8" class="indexterm"></a><a id="id-1.19.19.4.9" class="indexterm"></a><a id="id-1.19.19.4.10" class="indexterm"></a>As befits a logical language, Lojban has extensive provision for logical connectives within both operators and operands. Full details on logical and non-logical connectives are provided in [Chapter 14](../chapter-connectives). Operands are connected in afterthought with selma'o A and in forethought with selma'o GA, just like sumti. Operators are connected in afterthought with selma'o JA and in forethought with selma'o GUhA, just like tanru components. This parallelism is no accident.

<a id="id-1.19.19.5.1" class="indexterm"></a><a id="id-1.19.19.5.2" class="indexterm"></a><a id="id-1.19.19.5.3" class="indexterm"></a>In addition, A+BO and A+KE constructs are allowed for grouping logically connected operands, and _<a id="id-1.19.19.5.4.1" class="indexterm"></a>[_ke_](../go01#valsi-ke)_ … _<a id="id-1.19.19.5.5.1" class="indexterm"></a>[_ke'e_](../go01#valsi-kehe)_ is allowed for grouping logically connected operators, although there are no analogues of tanru among the operators.

Despite the large number of rules required to support this feature, it is of relatively minor importance in the mekso scheme of things. [Example 18.114](../section-connectives-within-mekso#example-random-id-e9Xi) exhibits afterthought logical connection between operands:

<div class="interlinear-gloss-example example">
<a id="example-random-id-e9Xi"></a>

**Example 18.114. <a id="c18e17d1"></a><a id="id-1.19.19.7.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>vei</td><td>ci</td><td>.a</td><td>vo</td><td>ve'o</td><td>prenu</td><td>cu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>(</td><td>Three</td><td>or</td><td>four</td><td>)</td><td>people</td><td></td><td>go</td><td>to-the</td><td>market.</td></tr></tbody></table>

</div>  

[Example 18.115](../section-connectives-within-mekso#example-random-id-eiTM) is equivalent in meaning, but uses forethought connection:

<div class="interlinear-gloss-example example">
<a id="example-random-id-eiTM"></a>

**Example 18.115. <a id="c18e17d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>vei</td><td>ga</td><td>ci</td><td>gi</td><td>vo</td><td>ve'o</td><td>prenu</td><td>cu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>(</td><td>Either</td><td>3</td><td>or</td><td>4</td><td>)</td><td>people</td><td></td><td>go</td><td>to-the</td><td>market.</td></tr></tbody></table>

</div>  

<a id="id-1.19.19.10.1" class="indexterm"></a><a id="id-1.19.19.10.2" class="indexterm"></a>Note that the mekso here are being used as quantifiers. Lojban requires that any mekso other than a simple number be enclosed in parentheses when used as a quantifier. This rule prevents ambiguities that do not exist when using _<a id="id-1.19.19.10.3.1" class="indexterm"></a>[_li_](../go01#valsi-li)_.

<a id="id-1.19.19.11.1" class="indexterm"></a><a id="id-1.19.19.11.2" class="indexterm"></a><a id="id-1.19.19.11.3" class="indexterm"></a>By the way, _<a id="id-1.19.19.11.4.1" class="indexterm"></a>[_li_](../go01#valsi-li)_ has an elidable terminator, _<a id="id-1.19.19.11.5.1" class="indexterm"></a>[_lo'o_](../go01#valsi-loho)_ , which is needed when a _<a id="id-1.19.19.11.6.1" class="indexterm"></a>[_li_](../go01#valsi-li)_ sumti is followed by a logical connective that could seem to be within the mekso. For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-LXtp"></a>

**Example 18.116. <a id="c18e17d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>re</td><td>su'i</td><td>re</td><td>du</td></tr><tr class="gloss"><td>The-number</td><td>two</td><td>plus</td><td>two</td><td>equals</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>vo</td><td>lo'o</td><td>.onai</td><td>lo</td><td>nalseldjuno</td><td>namcu</td></tr><tr class="gloss"><td>the-number</td><td>four</td><td></td><td>or-else</td><td>a</td><td>non-known</td><td>number.</td></tr></tbody></table>

</div>  

Omitting the _<a id="id-1.19.19.13.1.1" class="indexterm"></a>[_lo'o_](../go01#valsi-loho)_ would cause the parser to assume that another operand followed the _<a id="id-1.19.19.13.2.1" class="indexterm"></a>[_.onai_](../go01#valsi-onai)_ and reject _<a id="id-1.19.19.13.3.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ as an invalid operand.

Simple examples of logical connection between operators are hard to come by. A contrived example is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-YoFg"></a>

**Example 18.117. <a id="c18e17d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>re</td><td>su'i</td><td>je</td><td>pi'i</td><td>re</td><td>du</td><td>li</td><td>vo</td></tr><tr class="gloss"><td>The-number</td><td>two</td><td>plus</td><td>and</td><td>times</td><td>two</td><td>equals</td><td>the-number</td><td>four.</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">2 + 2 = 4 and 2 × 2 = 4.</span></div></td></tr></tbody></table>

</div>  

The forethought-connection form of [Example 18.117](../section-connectives-within-mekso#example-random-id-YoFg) is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-ccNn"></a>

**Example 18.118. <a id="c18e17d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>re</td><td>gu'e</td><td>su'i</td><td>gi</td><td>pi'i</td><td>re</td><td>du</td><td>li</td><td>vo</td></tr><tr class="gloss"><td>the-number</td><td>two</td><td>both</td><td>plus</td><td>and</td><td>times</td><td>two</td><td>equals</td><td>the-number</td><td>four.</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">Both 2 + 2 = 4 and 2 × 2 = 4.</span></div></td></tr></tbody></table>

</div>  

Here is a classic example of operand logical connection:

<div class="interlinear-gloss-example example">
<a id="example-random-id-k36J"></a>

**Example 18.119. <a id="c18e17d6"></a><a id="id-1.19.19.19.1.2" class="indexterm"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>go</td><td>li</td><td>.abu</td><td>bi'epi'i</td><td>vei</td><td>xy.</td><td>te'a</td><td>re</td><td>ve'o</td><td>su'i</td></tr><tr class="gloss"><td>If-and-only-if</td><td>the-number</td><td><span class="quote">“<span class="quote">a</span>”</span></td><td>times</td><td>(</td><td><span class="quote">“<span class="quote">x</span>”</span></td><td>power</td><td>two</td><td>)</td><td>plus</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>by.</td><td>bi'epi'i</td><td>xy.</td><td>su'i</td><td>cy.</td><td>du</td><td>li</td><td>no</td></tr><tr class="gloss"><td><span class="quote">“<span class="quote">b</span>”</span></td><td>times</td><td><span class="quote">“<span class="quote">x</span>”</span></td><td>plus</td><td><span class="quote">“<span class="quote">c</span>”</span></td><td>equals</td><td>the-number</td><td>zero</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>gi</td><td>li</td><td>xy.</td><td>du</td><td>li</td><td>vei</td><td>va'a</td><td>by.</td><td>ku'e</td></tr><tr class="gloss"><td>then</td><td>the-number</td><td>x</td><td>equals</td><td>the-number</td><td>[</td><td>the-negation-of(</td><td>b</td><td>)</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>su'i</td><td>ja</td><td>vu'u</td><td>fe'a</td></tr><tr class="gloss"><td>plus</td><td>or</td><td>minus</td><td>the-root-of</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>vei</td><td>by.</td><td>bi'ete'a</td><td>re</td><td>vu'u</td><td>vo</td><td>bi'epi'i</td><td>.abu</td><td>bi'epi'i</td><td>cy.</td></tr><tr class="gloss"><td>(</td><td><span class="quote">“<span class="quote">b</span>”</span></td><td>power</td><td>2</td><td>minus</td><td>four</td><td>times</td><td><span class="quote">“<span class="quote">a</span>”</span></td><td>times</td><td><span class="quote">“<span class="quote">c</span>”</span></td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ve'o</td><td>[ku'e]</td><td>ve'o</td><td>fe'i</td><td>re</td><td>bi'epi'i</td><td>.abu</td></tr><tr class="gloss"><td>)</td><td></td><td>]</td><td>divided-by</td><td>two</td><td>times</td><td><span class="quote">“<span class="quote">a</span>”</span></td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><math xmlns="http://www.w3.org/1998/Math/MathML" xmlns:xlink="http://www.w3.org/1999/xlink" display="block"><mrow><mo>Iff </mo><mi>a</mi> <mo>⁢</mo> <msup><mi>x</mi> <mn>2</mn> </msup><mo>+</mo> <mi>b</mi> <mo>⁢</mo> <mi>x</mi> <mo>+</mo> <mi>c</mi> <mo>=</mo> <mn>0</mn> <mo>, then </mo><mi>x</mi> <mo>=</mo> <mfrac><mrow><mrow><mo>-</mo> <mi>b</mi> </mrow><mo>±</mo> <msqrt><mrow><msup><mi>b</mi> <mn>2</mn> </msup><mo>-</mo> <mrow><mn>4</mn> <mo>⁢</mo> <mi>a</mi> <mo>⁢</mo> <mi>c</mi> </mrow></mrow></msqrt></mrow><mrow><mn>2</mn> <mo>⁢</mo> <mi>a</mi></mrow></mfrac></mrow></math></div></td></tr></tbody></table>

</div>  

<a id="id-1.19.19.20.1" class="indexterm"></a><a id="id-1.19.19.20.2" class="indexterm"></a><a id="id-1.19.19.20.3" class="indexterm"></a><a id="id-1.19.19.20.4" class="indexterm"></a>Note the mixture of styles in [Example 18.119](../section-connectives-within-mekso#example-random-id-k36J) : the negation of b and the square root are represented by forethought and most of the operator precedence by prefixed _<a id="id-1.19.19.20.6.1" class="indexterm"></a>[_bi'e_](../go01#valsi-bihe)_ , but explicit parentheses had to be added to group the numerator properly. In addition, the square root parentheses cannot be removed here in favor of simple _<a id="id-1.19.19.20.7.1" class="indexterm"></a>[_fe'a_](../go01#valsi-feha)_ and _<a id="id-1.19.19.20.8.1" class="indexterm"></a>[_ku'e_](../go01#valsi-kuhe)_ bracketing, because infix operators are present in the operand. Getting [Example 18.119](../section-connectives-within-mekso#example-random-id-k36J) to parse perfectly using the current parser took several tries: a more relaxed style would dispense with most of the _<a id="id-1.19.19.20.10.1" class="indexterm"></a>[_bi'e_](../go01#valsi-bihe)_ cmavo and just let the standard precedence rules be understood.

<a id="id-1.19.19.21.1" class="indexterm"></a><a id="id-1.19.19.21.2" class="indexterm"></a><a id="id-1.19.19.21.3" class="indexterm"></a>Non-logical connection with JOI and BIhI is also permitted between operands and between operators. One use for this construct is to connect operands with _<a id="id-1.19.19.21.4.1" class="indexterm"></a>[_bi'o_](../go01#valsi-biho)_ to create intervals:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Bzf6"></a>

**Example 18.120. <a id="c18e17d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>no</td><td>ga'o</td><td>bi'o</td><td>ke'i</td><td>pa</td></tr><tr class="gloss"><td>the-number</td><td>zero</td><td>(inclusive)</td><td>from-to</td><td>(exclusive)</td><td>one</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">[0,1)</span></div></td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the numbers from zero to one, including zero but not including one</p></td></tr></tbody></table>

</div>  

Intervals defined by a midpoint and range rather than beginning and end points can be expressed by _<a id="id-1.19.19.23.1.1" class="indexterm"></a>[_mi'i_](../go01#valsi-mihi)_ :

<div class="interlinear-gloss-example example">
<a id="example-random-id-LvBT"></a>

**Example 18.121. <a id="c18e17d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>pimu</td><td>ga'o</td><td>mi'i</td><td>ke'i</td><td>pimu</td></tr><tr class="gloss"><td>the-number</td><td>0.5</td><td>(inclusive)</td><td>centered-with-range</td><td>(exclusive)</td><td>0.5</td></tr></tbody></table>

</div>  

<a id="id-1.19.19.25.1" class="indexterm"></a><a id="id-1.19.19.25.2" class="indexterm"></a>which expresses the same interval as [Example 18.120](../section-connectives-within-mekso#example-random-id-Bzf6). Note that the _<a id="id-1.19.19.25.4.1" class="indexterm"></a>[_ga'o_](../go01#valsi-gaho)_ and _<a id="id-1.19.19.25.5.1" class="indexterm"></a>[_ke'i_](../go01#valsi-kehi)_ still refer to the endpoints, although these are now implied rather than expressed. Another way of expressing the same thing:

<div class="interlinear-gloss-example example">
<a id="example-random-id-CEvD"></a>

**Example 18.122. <a id="c18e17d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>li</td><td>pimu</td><td>su'i</td><td>ni'upimu</td><td>ga'o</td><td>bi'o</td><td>ke'i</td><td>ma'upimu</td></tr><tr class="gloss"><td>the-number</td><td>0.5</td><td>plus</td><td>[-0.5</td><td>(inclusive)</td><td>from-to</td><td>(exclusive)</td><td>+0.5]</td></tr></tbody></table>

</div>  

<a id="id-1.19.19.27.1" class="indexterm"></a>Here we have the sum of a number and an interval, which produces another interval centered on the number. As [Example 18.122](../section-connectives-within-mekso#example-random-id-CEvD) shows, non-logical (or logical) connection of operands has higher precedence than any mekso operator.

<a id="id-1.19.19.28.1" class="indexterm"></a><a id="id-1.19.19.28.2" class="indexterm"></a>You can also combine two operands with _<a id="id-1.19.19.28.3.1" class="indexterm"></a>[_ce'o_](../go01#valsi-ceho)_ , the sequence connective of selma'o JOI, to make a compound subscript:

<div class="interlinear-gloss-example example">
<a id="example-random-id-eMsd"></a>

**Example 18.123. <a id="c18e17d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>xy.</td><td>xi</td><td>vei</td><td>by.</td><td>ce'o</td><td>dy.</td><td>[ve'o]</td></tr><tr class="gloss"><td><span class="quote">“<span class="quote">x</span>”</span></td><td>sub</td><td>(</td><td><span class="quote">“<span class="quote">b</span>”</span></td><td>sequence</td><td><span class="quote">“<span class="quote">d</span>”</span></td><td>)</td></tr><tr class="informalequation"><td colspan="12321"><div class="informalequation"><span class="mathphrase">x <sub>b,d</sub></span></div></td></tr></tbody></table>

</div>