<a id="section-connected-tenses"></a>10.20. <a id="c10s20"></a>Logical and non-logical connections between tenses
-----------------------------------------------------------------------------------------------------------------

Like many things in Lojban, tenses may be logically connected; logical connection is explained in more detail in [Chapter 14](../chapter-connectives). Some of the terminology in this section will be clear only if you already understand logical connectives.

<a id="id-1.11.22.3.1" class="indexterm"></a><a id="id-1.11.22.3.2" class="indexterm"></a><a id="id-1.11.22.3.3" class="indexterm"></a><a id="id-1.11.22.3.4" class="indexterm"></a>The appropriate logical connectives belong to selma'o JA. A logical connective between tenses can always be expanded to one between sentences:

<div class="interlinear-gloss-example example">
<a id="example-random-id-XAj7"></a>

**Example 10.152. <a id="c10e20d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>je</td><td>ba</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>and</td><td>[future]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I went and will go to the market.</p></td></tr></tbody></table>

</div>  

means the same as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-BWI5"></a>

**Example 10.153. <a id="c10e20d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>pu</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[past]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ije</td><td>mi</td><td>ba</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>And</td><td>I</td><td>[future]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I went to the market, and I will go to the market.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.22.7.1" class="indexterm"></a>Tense connection and tense negation are combined in:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Tuz1"></a>

**Example 10.154. <a id="c10e20d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>punai</td><td>je</td><td>canai</td><td>je</td><td>ba</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[past-not]</td><td>and</td><td>[present-not]</td><td>and</td><td>[future]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I haven't yet gone to the market, but I will in future.</p></td></tr></tbody></table>

</div>  

[Example 10.154](../section-connected-tenses#example-random-id-Tuz1) is far more specific than

<div class="interlinear-gloss-example example">
<a id="example-random-id-J5jJ"></a>

**Example 10.155. <a id="c10e20d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ba</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[future]</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

which only says that I will go, without claiming anything about my past or present. _<a id="id-1.11.22.11.1.1" class="indexterm"></a>[_ba_](../go01#valsi-ba)_ does not imply _<a id="id-1.11.22.11.2.1" class="indexterm"></a>punai_ or _<a id="id-1.11.22.11.3.1" class="indexterm"></a>canai_ ; to compel that interpretation, either a logical connection or a ZAhO is needed.

<a id="id-1.11.22.12.1" class="indexterm"></a>Tense negation can often be removed in favor of negation in the logical connective itself. The following examples are equivalent in meaning:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qErC"></a>

**Example 10.156. <a id="c10e20d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>mo'izu'anai</td><td>je</td><td>mo'iri'u</td><td>cadzu</td></tr><tr class="gloss"><td>I</td><td>[motion-left-not]</td><td>and</td><td>[motion-right]</td><td>walk.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I walk not leftward but rightward.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qeRL"></a>

**Example 10.157. <a id="c10e20d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>mo'izu'a</td><td>naje</td><td>mo'iri'u</td><td>cadzu</td></tr><tr class="gloss"><td>I</td><td>[motion-left]</td><td>not-and</td><td>[motion-right]</td><td>walk.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I walk not leftward but rightward.</p></td></tr></tbody></table>

</div>  

<a id="id-1.11.22.15.1" class="indexterm"></a><a id="id-1.11.22.15.2" class="indexterm"></a>There are no forethought logical connections between tenses allowed by the grammar, to keep tenses simpler. Nor is there any way to override simple left-grouping of the connectives, the Lojban default.

<a id="id-1.11.22.16.1" class="indexterm"></a><a id="id-1.11.22.16.2" class="indexterm"></a><a id="id-1.11.22.16.3" class="indexterm"></a><a id="id-1.11.22.16.4" class="indexterm"></a>The non-logical connectives of selma'o JOI, BIhI, and GAhO are also permitted between tenses. One application is to specify intervals not by size, but by their end-points ( _<a id="id-1.11.22.16.5.1" class="indexterm"></a>[_bi'o_](../go01#valsi-biho)_ belongs to selma'o BIhI, and connects the end-points of an ordered interval, like English “from ... to”):

<div class="interlinear-gloss-example example">
<a id="example-random-id-KQUM"></a>

**Example 10.158. <a id="c10e20d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>puza</td><td>bi'o</td><td>bazu</td><td>vasxu</td></tr><tr class="gloss"><td>I</td><td>[past-medium]</td><td>from…to</td><td>[future-long]</td><td>breathe.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I breathe from a medium time ago till a long time to come.</p></td></tr></tbody></table>

</div>  

(It is to be hoped that I have a long life ahead of me.)

One additional use of non-logical connectives within tenses is discussed in [Section 10.21](../section-sub-events). Other uses will probably be identified in future.