<a id="section-compound-bridi"></a>14.9. <a id="c14s9"></a>Compound bridi
-------------------------------------------------------------------------

<a id="id-1.15.11.2.1" class="indexterm"></a><a id="id-1.15.11.2.2" class="indexterm"></a>So far we have seen how to handle two sentences that need have no similarity at all (bridi connection) and sentences that are identical except for a difference in one sumti (sumti connection). It would seem natural to ask how to logically connect sentences that are identical except for having different selbri.

<a id="id-1.15.11.3.1" class="indexterm"></a>Surprise! Lojban provides no logical connective that is designed to handle selbri and nothing else. Instead, selbri connection is provided as part of a more general-purpose mechanism called “compound bridi”. Compound bridi result from logically connecting sentences that differ in their selbri and possibly some of their sumti.

<a id="id-1.15.11.4.1" class="indexterm"></a>The simplest cases result when the x1 sumti is the only common point:

<div class="interlinear-gloss-example example">
<a id="example-random-id-WebJ"></a>

**Example 14.49. <a id="c14e9d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>le</td><td>zarci</td><td>.ije</td><td>mi</td><td>nelci</td><td>la</td><td>.djan.</td></tr><tr class="gloss"><td>I</td><td>go-to</td><td>the</td><td>market,</td><td>and</td><td>I</td><td>like</td><td>that-named</td><td>John.</td></tr></tbody></table>

</div>  

is equivalent in meaning to the compound bridi:

<div class="interlinear-gloss-example example">
<a id="example-random-id-9H9e"></a>

**Example 14.50. <a id="c14e9d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>le</td><td>zarci</td><td>gi'e</td><td>nelci</td><td>la</td><td>.djan.</td></tr><tr class="gloss"><td>I</td><td>go-to</td><td>the</td><td>market</td><td>and</td><td>like</td><td>that-named</td><td>John.</td></tr></tbody></table>

</div>  

<a id="id-1.15.11.8.1" class="indexterm"></a><a id="id-1.15.11.8.2" class="indexterm"></a><a id="id-1.15.11.8.3" class="indexterm"></a>As [Example 14.50](../section-compound-bridi#example-random-id-9H9e) indicates, giheks are used in afterthought to create compound bridi; _<a id="id-1.15.11.8.5.1" class="indexterm"></a>[_gi'e_](../go01#valsi-gihe)_ is the gihek corresponding to “and”. The actual phrases _<a id="id-1.15.11.8.7.1" class="indexterm"></a>klama le zarci_ and _<a id="id-1.15.11.8.8.1" class="indexterm"></a>nelci la .djan._ that the gihek connects are known as “bridi-tails” , because they represent (in this use) the “tail end” of a bridi, including the selbri and any following sumti, but excluding any sumti that precede the selbri:

<div class="interlinear-gloss-example example">
<a id="example-random-id-F3RE"></a>

**Example 14.51. <a id="c14e9d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ricfu</td><td>gi'e</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>am-rich</td><td>and</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

In [Example 14.51](../section-compound-bridi#example-random-id-F3RE) , the first bridi-tail is _<a id="id-1.15.11.10.2.1" class="indexterm"></a>[_ricfu_](../go01#valsi-ricfu)_ , a simple selbri, and the second bridi-tail is _<a id="id-1.15.11.10.3.1" class="indexterm"></a>klama le zarci_ , a selbri with one following sumti.

<a id="id-1.15.11.11.1" class="indexterm"></a>Suppose that more than a single sumti is identical between the two sentences:

<div class="interlinear-gloss-example example">
<a id="example-random-id-PRxj"></a>

**Example 14.52. <a id="c14e9d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>dunda</td><td>le</td><td>cukta</td><td>do</td><td>.ije</td><td>mi</td><td>lebna</td><td>lo</td><td>jdini</td><td>do</td></tr><tr class="gloss"><td>I</td><td>give</td><td>the</td><td>book</td><td>to-you,</td><td>and</td><td>I</td><td>take</td><td>some</td><td>money</td><td>from-you.</td></tr></tbody></table>

</div>  

<a id="id-1.15.11.13.1" class="indexterm"></a>In [Example 14.52](../section-compound-bridi#example-random-id-PRxj) , the first and last sumti of each bridi are identical; the selbri and the second sumti are different. By moving the final sumti to the beginning, a form analogous to [Example 14.50](../section-compound-bridi#example-random-id-9H9e) can be achieved:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Evo4"></a>

**Example 14.53. <a id="c14e9d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>fi</td><td>do</td><td>fa</td><td>mi</td><td>dunda</td><td>le</td><td>cukta</td></tr><tr class="gloss"><td>to/from</td><td>you</td><td></td><td>I</td><td>give</td><td>the</td><td>book</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>gi'e</td><td>lebna</td><td>lo</td><td>jdini</td></tr><tr class="gloss"><td>and</td><td>take</td><td>some</td><td>money.</td></tr></tbody></table>

</div>  

<a id="id-1.15.11.15.1" class="indexterm"></a><a id="id-1.15.11.15.2" class="indexterm"></a>where the _<a id="id-1.15.11.15.3.1" class="indexterm"></a>[_fi_](../go01#valsi-fi)_ does not have an exact English translation because it merely places _<a id="id-1.15.11.15.4.1" class="indexterm"></a>[_do_](../go01#valsi-do)_ in the third place of both _<a id="id-1.15.11.15.5.1" class="indexterm"></a>[_lebna_](../go01#valsi-lebna)_ and _<a id="id-1.15.11.15.6.1" class="indexterm"></a>[_dunda_](../go01#valsi-dunda)_. However, a form that preserves natural sumti order also exists in Lojban. Giheks connect two bridi-tails, but also allow sumti to be added following the bridi-tail. These sumti are known as tail-terms, and apply to both bridi. The straightforward gihek version of [Example 14.52](../section-compound-bridi#example-random-id-PRxj) therefore is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-DYBN"></a>

**Example 14.54. <a id="c14e9d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>dunda</td><td>le</td><td>cukta</td><td>gi'e</td><td>lebna</td><td>lo</td><td>jdini</td><td>vau</td><td>do</td></tr><tr class="gloss"><td>I</td><td>(give</td><td>the</td><td>book)</td><td>and</td><td>(take</td><td>some</td><td>money)</td><td></td><td>to/from-you.</td></tr></tbody></table>

</div>  

<a id="id-1.15.11.17.1" class="indexterm"></a><a id="id-1.15.11.17.2" class="indexterm"></a>The _<a id="id-1.15.11.17.3.1" class="indexterm"></a>[_vau_](../go01#valsi-vau)_ (of selma'o VAU) serves to separate the bridi-tail from the tail-terms. Every bridi-tail is terminated by an elidable _<a id="id-1.15.11.17.4.1" class="indexterm"></a>[_vau_](../go01#valsi-vau)_ , but only in connection with compound bridi is it ever necessary to express this _<a id="id-1.15.11.17.5.1" class="indexterm"></a>[_vau_](../go01#valsi-vau)_. Thus:

<div class="interlinear-gloss-example example">
<a id="example-random-id-L3eN"></a>

**Example 14.55. <a id="c14e9d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>le</td><td>zarci</td><td>[vau]</td></tr><tr class="gloss"><td>I</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

has a single elided _<a id="id-1.15.11.19.1.1" class="indexterm"></a>[_vau_](../go01#valsi-vau)_ , and [Example 14.50](../section-compound-bridi#example-random-id-9H9e) is equivalent to:

<div class="interlinear-gloss-example example">
<a id="example-random-id-RfIR"></a>

**Example 14.56. <a id="c14e9d8"></a>** 

<a id="id-1.15.11.20.2.1" class="indexterm"></a>mi klama le zarci \[vau\] gi'e nelci la .djan. \[vau\] \[vau\]

</div>  

where the double _<a id="id-1.15.11.21.1.1" class="indexterm"></a>[_vau_](../go01#valsi-vau)_ at the end of [Example 14.56](../section-compound-bridi#example-random-id-RfIR) terminates both the right-hand bridi-tail and the unexpressed tail-terms.

<a id="id-1.15.11.22.1" class="indexterm"></a>A final use of giheks is to combine bridi-tails used as complete sentences, the Lojban observative:

<div class="interlinear-gloss-example example">
<a id="example-random-id-rvUD"></a>

**Example 14.57. <a id="c14e9d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>klama</td><td>le</td><td>zarci</td><td>gi'e</td><td>dzukla</td><td>le</td><td>briju</td></tr><tr class="gloss"><td>A-goer</td><td>to-the</td><td>market</td><td>and</td><td>a-walker</td><td>to-the</td><td>office.</td></tr></tbody></table>

</div>  

<a id="id-1.15.11.24.1" class="indexterm"></a>Since x1 is omitted in both of the bridi underlying [Example 14.57](../section-compound-bridi#example-random-id-rvUD) , this compound bridi does not necessarily imply that the goer and the walker are the same. Only the presence of an explicit x1 (other than _<a id="id-1.15.11.24.5.1" class="indexterm"></a>[_zo'e_](../go01#valsi-zohe)_ , which is equivalent to omission) can force the goer and the walker to be identical.

<a id="id-1.15.11.25.1" class="indexterm"></a>A strong argument for this convention is provided by analysis of the following example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-cBrg"></a>

**Example 14.58. <a id="c14e9d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>klama</td><td>la</td><td>.nu,IORK.</td></tr><tr class="gloss"><td>A-goer</td><td>to-that-named</td><td>New-York</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.finyks.</td></tr><tr class="gloss"><td>from-that-named</td><td>Phoenix</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>gi'e</td><td>klama</td><td>la</td><td>.nu,IORK.</td></tr><tr class="gloss"><td>and</td><td>a-goer</td><td>to-that-named</td><td>New-York</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.rom.</td></tr><tr class="gloss"><td>from-that-named</td><td>Rome.</td></tr></tbody></table>

</div>  

If the rule were that the x1 places of the two underlying bridi were considered identical, then (since there is nothing special about x1), the unspecified x4 (route) and x5 (means) places would also have to be the same, leading to the absurd result that the route from Phoenix to New York is the same as the route from Rome to New York. Inserting _<a id="id-1.15.11.27.5.1" class="indexterm"></a>[_da_](../go01#valsi-da)_ , meaning roughly “something” , into the x1 place cures the problem:

<div class="interlinear-gloss-example example">
<a id="example-random-id-ij9G"></a>

**Example 14.59. <a id="c14e9d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>da</td><td>klama</td><td>la</td><td>.nu,IORK.</td><td>la</td><td>.finyks.</td></tr><tr class="gloss"><td>Something</td><td>is-a-goer</td><td>to-that-named</td><td>New-York</td><td>from-that-named</td><td>Phoenix</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>gi'e</td><td>klama</td><td>la</td><td>.nu,IORK.</td><td>la</td><td>.rom.</td></tr><tr class="gloss"><td>and</td><td>is-a-goer</td><td>to-that-named</td><td>New-York</td><td>from-that-named</td><td>Rome.</td></tr></tbody></table>

</div>  

<a id="id-1.15.11.29.1" class="indexterm"></a><a id="id-1.15.11.29.2" class="indexterm"></a><a id="id-1.15.11.29.3" class="indexterm"></a><a id="id-1.15.11.29.4" class="indexterm"></a><a id="id-1.15.11.29.5" class="indexterm"></a>The syntax of giheks is:

> \[na\] \[se\] GIhA \[nai\]

which is exactly parallel to the syntax of eks.