<a id="section-compound-attitudinals"></a>13.8. <a id="c13s8"></a>Compound indicators
-------------------------------------------------------------------------------------

<a id="id-1.14.10.2.1" class="indexterm"></a><a id="id-1.14.10.2.2" class="indexterm"></a>The grammar of indicators is quite simple; almost all facets are optional. You can combine indicators in any order, and they are still grammatical. The presumed denotation is additive; thus the whole is the sum of the parts regardless of the order expressed, although the first expressed is presumed most important to the speaker. Every possible string of UI cmavo has some meaning.

<a id="id-1.14.10.3.1" class="indexterm"></a><a id="id-1.14.10.3.2" class="indexterm"></a><a id="id-1.14.10.3.3" class="indexterm"></a>Within a string of indicators, there will be conventions of interpretation which amount to a kind of second-order grammar. Each of the modifier words is presumed to modify an indicator to the left, if there is one. (There is an “unspecified emotion” word, _<a id="id-1.14.10.3.5.1" class="indexterm"></a>[_ge'e_](../go01#valsi-gehe)_ , reserved to ensure that if you want to express a modifier without a root emotion, it doesn't attach to and modify a previous but distinct emotional expression.)

<a id="id-1.14.10.4.1" class="indexterm"></a><a id="id-1.14.10.4.2" class="indexterm"></a>For example, _<a id="id-1.14.10.4.3.1" class="indexterm"></a>.ieru'e_ expresses a weak positive value on the scale of agreement: the speaker agrees (presumably with the listener or with something else just stated), but with the least possible degree of intensity. But _<a id="id-1.14.10.4.4.1" class="indexterm"></a>.ie ge'eru'e_ expresses agreement (at an unspecified level), followed by some other unstated emotion which is felt at a weak level. A rough English equivalent of _<a id="id-1.14.10.4.5.1" class="indexterm"></a>.ie ge'eru'e_ might be “I agree, but ...” where the “but” is left hanging. (Again, attitudes aren't always expressed in English by English attitudinals.)

<a id="id-1.14.10.5.1" class="indexterm"></a>A scale variable similarly modifies the previous emotion word. You put the scale word for a root emotion word before a modifier, since the latter can have its own scale word. This merely maximizes the amount of information expressible. For example, _<a id="id-1.14.10.5.2.1" class="indexterm"></a>.oinaicu'i ro'ucai_ expresses a feeling midway between pain ( _<a id="id-1.14.10.5.3.1" class="indexterm"></a>[_.oi_](../go01#valsi-oi)_) and pleasure ( _<a id="id-1.14.10.5.4.1" class="indexterm"></a>[_.oinai_](../go01#valsi-oinai)_) which is intensely sexual ( _<a id="id-1.14.10.5.5.1" class="indexterm"></a>[_ro'u_](../go01#valsi-rohu)_) in nature.

<a id="id-1.14.10.6.1" class="indexterm"></a><a id="id-1.14.10.6.2" class="indexterm"></a>The cmavo _<a id="id-1.14.10.6.3.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ is the most tightly bound modifier in the language: it always negates exactly one word – the preceding one. Of all the words used in indicator constructs, _<a id="id-1.14.10.6.4.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ is the only one with any meaning outside the indicator system. If you try to put an indicator between a non-indicator cmavo and its _<a id="id-1.14.10.6.5.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ negator, the _<a id="id-1.14.10.6.6.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ will end up negating the last word of the indicator. The result, though unambiguous, is not what you want. For example,

<div class="interlinear-gloss-example example">
<a id="example-random-id-9BBA"></a>

**Example 13.61. <a id="c13e8d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>.e</td><td>.ui</td><td>nai</td><td>do</td></tr><tr class="gloss"><td>I</td><td>and</td><td>[Yay!]</td><td>[Not!]</td><td>you.</td></tr></tbody></table>

</div>  

means “I and (unfortunately) you” , whereas

<div class="interlinear-gloss-example example">
<a id="example-random-id-NBhW"></a>

**Example 13.62. <a id="c13e8d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>.e</td><td>nai</td><td>.ui</td><td>do</td></tr><tr class="gloss"><td>I</td><td>and</td><td>[Not!]</td><td>[Yay!]</td><td>you.</td></tr></tbody></table>

</div>  

means “I but (fortunately) not you”. Attitudinal _<a id="id-1.14.10.10.2.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ expresses a “scalar negation” , a concept explained in [Section 15.3](../section-scalar-negation) ; since every attitudinal word implies exactly one scale, the effect of _<a id="id-1.14.10.10.5.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ on each should be obvious.

<a id="id-1.14.10.11.1" class="indexterm"></a><a id="id-1.14.10.11.2" class="indexterm"></a>Thus, the complete internal grammar of UI is as follows, with each listed part optionally present or absent without affecting grammaticality, though it obviously would affect meaning.

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td>attitudinal</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.10.12.2.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-nai"><em class="glossterm">nai</em></a></em></span></td><td>intensity-word</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.10.12.4.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-nai"><em class="glossterm">nai</em></a></em></span></td><td>modifier</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.10.12.6.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-nai"><em class="glossterm">nai</em></a></em></span></td><td>intensity-word</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.14.10.12.8.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-nai"><em class="glossterm">nai</em></a></em></span></td><td>(possiblyrepeated)</td></tr></tbody></table>

_<a id="id-1.14.10.13.1.1" class="indexterm"></a>[_ge'e_](../go01#valsi-gehe)_ , the non-specific emotion word, functions as an attitudinal. If multiple attitudes are being expressed at once, then in the 2nd or greater position, either _<a id="id-1.14.10.13.2.1" class="indexterm"></a>[_ge'e_](../go01#valsi-gehe)_ or a VV word must be used to prevent any modifiers from modifying the previous attitudinal.