<a id="section-complex-grouping"></a>5.4. <a id="c5s4"></a>Complex tanru grouping
---------------------------------------------------------------------------------

<a id="id-1.6.6.2.1" class="indexterm"></a>If one element of a tanru can be another tanru, why not both elements?

<div class="interlinear-gloss-example example">
<a id="example-random-id-m5SD"></a>

**Example 5.25. <a id="c5e4d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>mutce</td><td>bo</td><td>barda</td><td>gerku</td><td>bo</td><td>kavbu</td></tr><tr class="gloss"><td>You</td><td>are-a-(very</td><td>type-of</td><td>large)</td><td>(dog</td><td>type-of</td><td>capturer).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">You are a very large dog-catcher.</p></td></tr></tbody></table>

</div>  

In [Example 5.25](../section-complex-grouping#example-random-id-m5SD), the selbri is a tanru with seltau _<a id="id-1.6.6.4.2.1" class="indexterm"></a>mutce bo barda_ and tertau _<a id="id-1.6.6.4.3.1" class="indexterm"></a>gerku bo kavbu_. It is worth emphasizing once again that this tanru has the same fundamental ambiguity as all other Lojban tanru: the sense in which the “dog type-of capturer” is said to be “very type-of large” is not precisely specified. Presumably it is his body which is large, but theoretically it could be one of his other properties.

<a id="id-1.6.6.5.1" class="indexterm"></a>We will now justify the title of this chapter by exploring the ramifications of the phrase “pretty little girls' school”, an expansion of the tanru used in [Section 5.3](../section-three-part-tanru) to four brivla. (Although this example has been used in the Loglan Project almost since the beginning – it first appeared in Quine's book _Word and Object_ (1960) – it is actually a mediocre example because of the ambiguity of English “pretty”; it can mean “beautiful”, the sense intended here, or it can mean “very”. Lojban _<a id="id-1.6.6.5.8.1" class="indexterm"></a>[_melbi_](../go01#valsi-melbi)_ is not subject to this ambiguity: it means only “beautiful”.)

Here are four ways to group this phrase:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qjmr"></a>

**Example 5.26. <a id="c5e4d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>melbi</td><td></td><td>cmalu</td><td></td><td>nixli</td><td></td><td>ckule</td></tr><tr class="gloss"><td>That</td><td>is-a-((pretty</td><td>type-of</td><td>little)</td><td>type-of</td><td>girl)</td><td>type-of</td><td>school.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That is a school for girls who are beautifully small.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qjNi"></a>

**Example 5.27. <a id="c5e4d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>melbi</td><td></td><td>cmalu</td><td>nixli</td><td>bo</td><td>ckule</td></tr><tr class="gloss"><td>That</td><td>is-a-(pretty</td><td>type-of</td><td>little)</td><td>(girl</td><td>type-of</td><td>school).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That is a girls' school which is beautifully small.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qjog"></a>

**Example 5.28. <a id="c5e4d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>melbi</td><td></td><td>cmalu</td><td>bo</td><td>nixli</td><td></td><td>ckule</td></tr><tr class="gloss"><td>That</td><td>is-a-(pretty</td><td>type-of</td><td>(little</td><td>type-of</td><td>girl))</td><td>type-of</td><td>school.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That is a school for small girls who are beautiful.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qjop"></a>

**Example 5.29. <a id="c5e4d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>melbi</td><td></td><td>cmalu</td><td>bo</td><td>nixli</td><td>bo</td><td>ckule</td></tr><tr class="gloss"><td>That</td><td>is-a-pretty</td><td>type-of</td><td>(little</td><td>type-of</td><td>(girl</td><td>type-of</td><td>school)).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">That is a small school for girls which is beautiful.</p></td></tr></tbody></table>

</div>  

<a id="id-1.6.6.11.1" class="indexterm"></a><a id="id-1.6.6.11.2" class="indexterm"></a><a id="id-1.6.6.11.3" class="indexterm"></a><a id="id-1.6.6.11.4" class="indexterm"></a>[Example 5.29](../section-complex-grouping#example-random-id-qjop) uses a construction which has not been seen before: _<a id="id-1.6.6.11.6.1" class="indexterm"></a>cmalu bo nixli bo ckule_, with two consecutive uses of _<a id="id-1.6.6.11.7.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ between brivla. The rule for multiple _<a id="id-1.6.6.11.8.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ constructions is the opposite of the rule when no _<a id="id-1.6.6.11.9.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ is present at all: the last two are grouped together. Not surprisingly, this is called the “right-grouping rule”, and it is associated with every use of _<a id="id-1.6.6.11.11.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ in the language. Therefore,

<div class="interlinear-gloss-example example">
<a id="example-random-id-snKn"></a>

**Example 5.30. <a id="c5e4d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ta</td><td>cmalu</td><td>bo</td><td>nixli</td><td>bo</td><td>ckule</td></tr><tr class="gloss"><td>That</td><td>is-a-little</td><td>type-of</td><td>(girl</td><td>type-of</td><td>school).</td></tr></tbody></table>

</div>  

means the same as [Example 5.19](../section-three-part-tanru#example-random-id-nwuU), not [Example 5.20](../section-three-part-tanru#example-random-id-jquh). This rule may seem peculiar at first, but one of its consequences is that _<a id="id-1.6.6.13.3.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ is never necessary between the first two elements of any of the complex tanru presented so far: all of [Example 5.26](../section-complex-grouping#example-random-id-qjmr) through [Example 5.29](../section-complex-grouping#example-random-id-qjop) could have _<a id="id-1.6.6.13.6.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ inserted between _<a id="id-1.6.6.13.7.1" class="indexterm"></a>[_melbi_](../go01#valsi-melbi)_ and _<a id="id-1.6.6.13.8.1" class="indexterm"></a>[_cmalu_](../go01#valsi-cmalu)_ with no change in meaning.