<a id="section-comparatives"></a>12.15. <a id="c12s15"></a>Comparatives and superlatives
----------------------------------------------------------------------------------------

<a id="id-1.13.17.2.1" class="indexterm"></a><a id="id-1.13.17.2.2" class="indexterm"></a>English has the concepts of “comparative adjectives” and “superlative adjectives” which can be formed from other adjectives, either by adding the suffixes “\-er” and “\-est” or by using the words “more” and “most” , respectively. The Lojbanic equivalents, which can be made from any brivla, are lujvo with the tertau _<a id="id-1.13.17.2.9.1" class="indexterm"></a>[_zmadu_](../go01#valsi-zmadu)_ , _<a id="id-1.13.17.2.10.1" class="indexterm"></a>[_mleca_](../go01#valsi-mleca)_ , _<a id="id-1.13.17.2.11.1" class="indexterm"></a>[_zenba_](../go01#valsi-zenba)_ , _<a id="id-1.13.17.2.12.1" class="indexterm"></a>[_jdika_](../go01#valsi-jdika)_ , and _<a id="id-1.13.17.2.13.1" class="indexterm"></a>[_traji_](../go01#valsi-traji)_. In order to make these lujvo regular and easy to make, certain special guidelines are imposed.

We will begin with lujvo based on _<a id="id-1.13.17.3.1.1" class="indexterm"></a>[_zmadu_](../go01#valsi-zmadu)_ and _<a id="id-1.13.17.3.2.1" class="indexterm"></a>[_mleca_](../go01#valsi-mleca)_ , whose place structures are:

<div class="example">
<a id="example-random-id-mn8T"></a>

**Example 12.86. <a id="c12e15d1"></a>** 

_<a id="id-1.13.17.4.2.1.1" class="indexterm"></a>[_zmadu_](../go01#valsi-zmadu)_ : z1 is more than z2 in property z3 in quantity z4

_<a id="id-1.13.17.4.3.1.1" class="indexterm"></a>[_mleca_](../go01#valsi-mleca)_ : m1 is less than m2 in property m3 in quantity m4

</div>  

For example, the concept “young” is expressed by the gismu _<a id="id-1.13.17.5.2.1" class="indexterm"></a>[_citno_](../go01#valsi-citno)_ , with place structure

<div class="example">
<a id="example-random-id-ciaK"></a>

**Example 12.87. <a id="c12e15d2"></a>** 

_<a id="id-1.13.17.6.2.1.1" class="indexterm"></a>[_citno_](../go01#valsi-citno)_ : c1 is young

</div>  

<a id="id-1.13.17.7.1" class="indexterm"></a>The comparative concept “younger” can be expressed by the lujvo _<a id="id-1.13.17.7.3.1" class="indexterm"></a>[_citmau_](../go01#valsi-citmau)_ (based on the veljvo _<a id="id-1.13.17.7.4.1" class="indexterm"></a>citno zmadu_ , meaning “young more-than”).

<div class="interlinear-gloss-example example">
<a id="example-random-id-GDt1"></a>

**Example 12.88. <a id="id-1.13.17.8.1.1" class="indexterm"></a><a id="c12e15d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>citmau</td><td>do</td><td>lo</td><td>nanca</td><td>be</td><td>li</td><td>xa</td></tr><tr class="gloss"><td>I</td><td>am-younger-than</td><td>you</td><td>by</td><td>one-year</td><td>multiplied-by</td><td>the-number</td><td>six.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am six years younger than you.</p></td></tr></tbody></table>

</div>  

The place structure for _<a id="id-1.13.17.9.1.1" class="indexterm"></a>[_citmau_](../go01#valsi-citmau)_ is

<div class="example">
<a id="example-random-id-I3Uh"></a>

**Example 12.89. <a id="id-1.13.17.10.1.1" class="indexterm"></a><a id="c12e15d4"></a>** 

> z1=c1 is younger than z2=c1 by amount z4

</div>  

Similarly, in Lojban you can say:

<div class="interlinear-gloss-example example">
<a id="example-random-id-tJDa"></a>

**Example 12.90. <a id="c12e15d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>citme'a</td><td>mi</td><td>lo</td><td>nanca</td><td>be</td><td>li</td><td>xa</td></tr><tr class="gloss"><td>You</td><td>are-less-young-than</td><td>me</td><td>by</td><td>one-year</td><td>multiplied-by</td><td>the-number</td><td>six.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">You are six years less young than me.</p></td></tr></tbody></table>

</div>  

In English, “more” comparatives are easier to make and use than “less” comparatives, but in Lojban the two forms are equally easy.

Because of their much simpler place structure, lujvo ending in _\-mau_ and _\-me'a_ are in fact used much more frequently than _<a id="id-1.13.17.14.3.1" class="indexterm"></a>[_zmadu_](../go01#valsi-zmadu)_ and _<a id="id-1.13.17.14.4.1" class="indexterm"></a>[_mleca_](../go01#valsi-mleca)_ themselves as selbri. It is highly unlikely for such lujvo to be construed as anything other than implicit-abstraction lujvo. But there is another type of ambiguity relevant to these lujvo, and which has to do with what is being compared.

<a id="id-1.13.17.15.1" class="indexterm"></a>For example, does _nelcymau_ mean “X likes Y more than X likes Z” , or “X likes Y more than Z likes Y” ? Does _klamau_ mean: “X goes to Y more than to Z” , “X goes to Y more than Z does” , “X goes to Y from Z more than from W” , or what?

<a id="id-1.13.17.16.1" class="indexterm"></a><a id="id-1.13.17.16.2" class="indexterm"></a>We answer this concern by putting regularity above any considerations of concept usefulness: by convention, the two things being compared always fit into the first place of the seltau. In that way, each of the different possible interpretations can be expressed by SE-converting the seltau, and making the required place the new first place. As a result, we get the following comparative lujvo place structures:

<div class="example">
<a id="example-random-id-eSTr"></a>

**Example 12.91. <a id="c12e15d6"></a>** 

_nelcymau_ : z1, more than z2, likes n2 by amount z4

_selnelcymau_ : z1, more than z2, is liked by n1 in amount z4

_klamau_ : z1, more than z2, goes to k2 from k3 via k4 by means of k5 by amount z4

_selklamau_ : z1, more than z2, is gone to by k1 from k3 via k4 by means of k5 by amount z4

_terklamau_ : z1, more than z2, is an origin point for destination k2 for k1's going via k4 by means of k5 by amount z4

</div>  

(See [Chapter 11](../chapter-abstractions) for the way in which this problem is resolved when lujvo aren't used.)

The ordering rule places the things being compared first, and the other seltau places following. Unfortunately the z4 place, which expresses by how much one entity exceeds the other, is displaced into a lujvo place whose number is different for each lujvo. For example, while _nelcymau_ has z4 as its fourth place, _klamau_ has it as its seventh place. In any sentence where a difficulty arises, this amount-place can be redundantly tagged with _<a id="id-1.13.17.19.3.1" class="indexterm"></a>[_vemau_](../go01#valsi-vemau)_ (for _<a id="id-1.13.17.19.4.1" class="indexterm"></a>[_zmadu_](../go01#valsi-zmadu)_) or _<a id="id-1.13.17.19.5.1" class="indexterm"></a>[_veme'a_](../go01#valsi-vemeha)_ (for _<a id="id-1.13.17.19.6.1" class="indexterm"></a>[_mleca_](../go01#valsi-mleca)_) to help make the speaker's intention clear.

<a id="id-1.13.17.20.1" class="indexterm"></a><a id="id-1.13.17.20.2" class="indexterm"></a><a id="id-1.13.17.20.3" class="indexterm"></a>It is important to realize that such comparative lujvo do not presuppose their seltau. Just as in English, saying someone is younger than someone else doesn't imply that they're young in the first place: an octogenarian, after all, is still younger than a nonagenarian. Rather, the 80-year-old has a greater _<a id="id-1.13.17.20.4.1" class="indexterm"></a>ni citno_ than the 90-year-old. Similarly, a 5-year-old is older than a 1-year-old, but is not considered “old” by most standards.

<a id="id-1.13.17.21.1" class="indexterm"></a><a id="id-1.13.17.21.2" class="indexterm"></a>There are some comparative concepts in which the _<a id="id-1.13.17.21.3.1" class="indexterm"></a>se zmadu_ is difficult to specify. Typically, these involve comparisons implicitly made with a former state of affairs, where stating a z2 place explicitly would be problematic.

In such cases, it is best not to use _<a id="id-1.13.17.22.1.1" class="indexterm"></a>[_zmadu_](../go01#valsi-zmadu)_ and leave the comparison hanging, but to use instead the gismu _<a id="id-1.13.17.22.2.1" class="indexterm"></a>[_zenba_](../go01#valsi-zenba)_ , meaning “increase” (and _<a id="id-1.13.17.22.4.1" class="indexterm"></a>[_jdika_](../go01#valsi-jdika)_ , meaning “decrease” , in place of _<a id="id-1.13.17.22.6.1" class="indexterm"></a>[_mleca_](../go01#valsi-mleca)_). The gismu _<a id="id-1.13.17.22.7.1" class="indexterm"></a>[_zenba_](../go01#valsi-zenba)_ was included in the language precisely in order to capture those notions of increase which _<a id="id-1.13.17.22.8.1" class="indexterm"></a>[_zmadu_](../go01#valsi-zmadu)_ can't quite cope with; in addition, we don't have to waste a place in lujvo or tanru on something that we'd never fill in with a value anyway. So we can translate “I'm stronger now” not as

<div class="interlinear-gloss-example example">
<a id="example-random-id-Uo7S"></a>

**Example 12.92. <a id="c12e15d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ca</td><td>tsamau</td></tr><tr class="gloss"><td>I</td><td>now</td><td>am-stronger.</td></tr></tbody></table>

</div>  

which implies that I'm currently stronger than somebody else (the elided occupant of the second or z2 place), but as

<div class="interlinear-gloss-example example">
<a id="example-random-id-vR4J"></a>

**Example 12.93. <a id="c12e15d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>ca</td><td>tsaze'a</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I increase in strength.</p></td></tr></tbody></table>

</div>  

Finally, lujvo with a tertau of _<a id="id-1.13.17.26.1.1" class="indexterm"></a>[_traji_](../go01#valsi-traji)_ are used to build superlatives. The place structure of _<a id="id-1.13.17.26.2.1" class="indexterm"></a>[_traji_](../go01#valsi-traji)_ is

<div class="example">
<a id="example-random-id-N3cU"></a>

**Example 12.94. <a id="c12e15d9"></a>** 

> t1 is superlative in property t2, being the t3 extremum (largest by default) of set t4

</div>  

Consider the gismu _<a id="id-1.13.17.28.1.1" class="indexterm"></a>[_xamgu_](../go01#valsi-xamgu)_ , whose place structure is:

<div class="example">
<a id="example-random-id-MWdr"></a>

**Example 12.95. <a id="c12e15d10"></a>** 

> xa1 is good for xa2 by standard xa3

</div>  

The comparative form is _<a id="id-1.13.17.30.1.1" class="indexterm"></a>[_xagmau_](../go01#valsi-xagmau)_ , corresponding to English “better” , with a place structure (by the rules given above) of

<div class="example">
<a id="example-random-id-pR5R"></a>

**Example 12.96. <a id="id-1.13.17.31.1.1" class="indexterm"></a><a id="c12e15d11"></a>** 

> z1 is better than z2 for xa2 by standard xa3 in amount z4

</div>  

<a id="id-1.13.17.32.1" class="indexterm"></a><a id="id-1.13.17.32.2" class="indexterm"></a>We would expect the place structure of _<a id="id-1.13.17.32.3.1" class="indexterm"></a>[_xagrai_](../go01#valsi-xagrai)_ , the superlative form, to somehow mirror that, given that comparatives and superlatives are comparable concepts, resulting in:

<div class="example">
<a id="example-random-id-Cc6J"></a>

**Example 12.97. <a id="c12e15d12"></a>** 

> xa1=t1 is the best of the set t4 for xa2 by standard xa3.

</div>  

The t2 place in _<a id="id-1.13.17.34.1.1" class="indexterm"></a>[_traji_](../go01#valsi-traji)_ , normally filled by a property abstraction, is replaced by the seltau places, and the t3 place specifying the extremum of _<a id="id-1.13.17.34.2.1" class="indexterm"></a>[_traji_](../go01#valsi-traji)_ (whether the most or the least, that is) is presumed by default to be “the most”.

<a id="id-1.13.17.35.1" class="indexterm"></a>But the set against which the t1 place of _<a id="id-1.13.17.35.2.1" class="indexterm"></a>[_traji_](../go01#valsi-traji)_ is compared is not the t2 place (which would make the place structure of _<a id="id-1.13.17.35.3.1" class="indexterm"></a>[_traji_](../go01#valsi-traji)_ fully parallel to that of _<a id="id-1.13.17.35.4.1" class="indexterm"></a>[_zmadu_](../go01#valsi-zmadu)_), but rather the t4 place. Nevertheless, by a special exception to the rules of place ordering, the t4 place of _<a id="id-1.13.17.35.5.1" class="indexterm"></a>[_traji_](../go01#valsi-traji)_ -based lujvo becomes the second place of the lujvo. Some examples:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qFf1"></a>

**Example 12.98. <a id="c12e15d13"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djudis.</td><td>cu</td><td>citrai</td><td>lo'i</td><td>lobypli</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Judy is the youngest of all Lojbanists.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qFf4"></a>

**Example 12.99. <a id="c12e15d14"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.ainctain.</td><td>cu</td><td>balrai</td><td>lo'i</td><td>skegunka</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Einstein was the greatest of all scientists.</p></td></tr></tbody></table>

</div>