<a id="section-cmevla"></a>4.8. <a id="c4s8"></a>cmevla
-------------------------------------------------------

<a id="id-1.5.10.2.1" class="indexterm"></a><a id="id-1.5.10.2.2" class="indexterm"></a><a id="id-1.5.10.2.3" class="indexterm"></a><a id="id-1.5.10.2.4" class="indexterm"></a>Lojbanized names, called _<a id="id-1.5.10.2.5.1" class="indexterm"></a>[_cmevla_](../go01#valsi-cmevla)_ , are very much like their counterparts in other languages. They are labels applied to things (or people) to stand for them in descriptions or in direct address. They may convey meaning in themselves, but do not necessarily do so.

<a id="id-1.5.10.3.1" class="indexterm"></a><a id="id-1.5.10.3.2" class="indexterm"></a><a id="id-1.5.10.3.3" class="indexterm"></a><a id="id-1.5.10.3.4" class="indexterm"></a><a id="id-1.5.10.3.5" class="indexterm"></a>Because names are often highly personal and individual, Lojban attempts to allow native language names to be used with a minimum of modification. The requirement that the Lojban speech stream be unambiguously analyzable, however, means that most names must be modified somewhat when they are Lojbanized. Here are a few examples of English names and possible Lojban equivalents:

<div class="lojbanization-example example">
<a id="example-random-id-qjhN"></a>

**Example 4.57. <a id="id-1.5.10.4.1.1" class="indexterm"></a><a id="c4e8d1"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="jbo">.djim.</p></td></tr><tr class="natlang"><td colspan="12321"><p class="natlang">Jim</p></td></tr></tbody></table>

</div>  
<div class="lojbanization-example example">
<a id="example-random-id-qjHo"></a>

**Example 4.58. <a id="id-1.5.10.5.1.1" class="indexterm"></a><a id="c4e8d2"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="jbo">.djein.</p></td></tr><tr class="natlang"><td colspan="12321"><p class="natlang">Jane</p></td></tr></tbody></table>

</div>  
<div class="lojbanization-example example">
<a id="example-random-id-qjIj"></a>

**Example 4.59. <a id="id-1.5.10.6.1.1" class="indexterm"></a><a id="c4e8d3"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="jbo">.arnold.</p></td></tr><tr class="natlang"><td colspan="12321"><p class="natlang">Arnold</p></td></tr></tbody></table>

</div>  
<div class="lojbanization-example example">
<a id="example-random-id-qjim"></a>

**Example 4.60. <a id="id-1.5.10.7.1.1" class="indexterm"></a><a id="c4e8d4"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="jbo">.pit.</p></td></tr><tr class="natlang"><td colspan="12321"><p class="natlang">Pete</p></td></tr></tbody></table>

</div>  
<div class="lojbanization-example example">
<a id="example-random-id-qjin"></a>

**Example 4.61. <a id="id-1.5.10.8.1.1" class="indexterm"></a><a id="c4e8d5"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="jbo">.katrinas.</p></td></tr><tr class="natlang"><td colspan="12321"><p class="natlang">Katrina</p></td></tr></tbody></table>

</div>  
<div class="lojbanization-example example">
<a id="example-random-id-qjIq"></a>

**Example 4.62. <a id="id-1.5.10.9.1.1" class="indexterm"></a><a id="c4e8d6"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="jbo">.kat,r,in.</p></td></tr><tr class="natlang"><td colspan="12321"><p class="natlang">Catherine</p></td></tr></tbody></table>

</div>  

<a id="id-1.5.10.10.1" class="indexterm"></a>(Note that syllabic _r_ is skipped in determining the stressed syllable, so [Example 4.62](../section-cmevla#example-random-id-qjIq) is stressed on the _<a id="id-1.5.10.10.4.1" class="indexterm"></a>[_ka_](../go01#valsi-ka)_.)

<div class="lojbanization-example example">
<a id="example-random-id-qJiv"></a>

**Example 4.63. <a id="id-1.5.10.11.1.1" class="indexterm"></a><a id="c4e8d7"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="jbo">.katis.</p></td></tr><tr class="natlang"><td colspan="12321"><p class="natlang">Cathy</p></td></tr></tbody></table>

</div>  
<div class="lojbanization-example example">
<a id="example-random-id-qjIy"></a>

**Example 4.64. <a id="id-1.5.10.12.1.1" class="indexterm"></a><a id="c4e8d8"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="jbo">.keit.</p></td></tr><tr class="natlang"><td colspan="12321"><p class="natlang">Kate</p></td></tr></tbody></table>

</div>  

<a id="id-1.5.10.13.1" class="indexterm"></a><a id="id-1.5.10.13.2" class="indexterm"></a><a id="id-1.5.10.13.3" class="indexterm"></a><a id="id-1.5.10.13.4" class="indexterm"></a><a id="id-1.5.10.13.5" class="indexterm"></a><a id="id-1.5.10.13.6" class="indexterm"></a>Cmevla may have almost any form, but always end in a consonant, are preceded by a pause, and are followed by a pause. They are penultimately stressed, unless unusual stress is marked with capitalization. A cmevla may have multiple parts, each ending with a consonant, starting and ending with a pause, or the parts may be combined into a single word with no pause in between. For example,

<div class="lojbanization-example example">
<a id="example-random-id-43uP"></a>

**Example 4.65. <a id="id-1.5.10.14.1.1" class="indexterm"></a><a id="id-1.5.10.14.1.2" class="indexterm"></a><a id="c4e8d9"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="jbo">.djan. .braun.</p></td></tr></tbody></table>

</div>  

and

<div class="lojbanization-example example">
<a id="example-random-id-QnyL"></a>

**Example 4.66. <a id="id-1.5.10.16.1.1" class="indexterm"></a><a id="id-1.5.10.16.1.2" class="indexterm"></a><a id="c4e8d10"></a>** 

<table class="lojbanization"><colgroup></colgroup><tbody><tr class="jbo"><td colspan="12321"><p class="jbo">.djanbraun.</p></td></tr></tbody></table>

</div>  

are both valid Lojbanizations of “John Brown”.

<a id="id-1.5.10.18.1" class="indexterm"></a><a id="id-1.5.10.18.2" class="indexterm"></a>The final arbiter of the correct form of a name is the person doing the naming, although most cultures grant people the right to determine how they want their own name to be spelled and pronounced. The English name “Mary” can thus be Lojbanized as _.meris._ , _.maris._ , _.meiris._ , _.merix._ , or even _.marys._. The last alternative is not pronounced much like its English equivalent, but may be desirable to someone who values spelling over pronunciation. The final consonant need not be an _s_ ; there must, however, be some Lojban consonant at the end.

<a id="id-1.5.10.19.1" class="indexterm"></a><a id="id-1.5.10.19.2" class="indexterm"></a>Lojban cmevla are identifiable as word forms by the following characteristics:

1.  <a id="id-1.5.10.20.1.1.1" class="indexterm"></a><a id="id-1.5.10.20.1.1.2" class="indexterm"></a>They must end in one or more consonants. There are no rules about how many consonants may appear in a cluster in cmevla, provided that each consonant pair (whether standing by itself, or as part of a larger cluster) is a permissible pair.

2.  <a id="id-1.5.10.20.2.1.1" class="indexterm"></a><a id="id-1.5.10.20.2.1.2" class="indexterm"></a><a id="id-1.5.10.20.2.1.3" class="indexterm"></a><a id="id-1.5.10.20.2.1.4" class="indexterm"></a>They may contain the letter y as a normal, non-hyphenating vowel. They are the only kind of Lojban word that may contain the two diphthongs _iy_ and _uy_.

3.  <a id="id-1.5.10.20.3.1.1" class="indexterm"></a>They are always surrounded in speech by pauses, one right before the first letter, and the other one right after the final consonant, both being written as “_._”.

4.  <a id="id-1.5.10.20.4.1.1" class="indexterm"></a><a id="id-1.5.10.20.4.1.2" class="indexterm"></a><a id="id-1.5.10.20.4.1.3" class="indexterm"></a><a id="id-1.5.10.20.4.1.4" class="indexterm"></a><a id="id-1.5.10.20.4.1.5" class="indexterm"></a>They may be stressed on any syllable; if this syllable is not the penultimate one, it must be capitalized when writing. Neither names nor words that begin sentences are capitalized in Lojban, so this is the only use of capital letters.

<a id="id-1.5.10.21.1" class="indexterm"></a><a id="id-1.5.10.21.2" class="indexterm"></a>cmevla meeting these criteria may be invented, Lojbanized from names in other languages, or formed by appending a consonant onto a cmavo, a gismu, a fu'ivla or a lujvo. Some cmevla built from Lojban words are:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qjj1"></a>

**Example 4.67. <a id="id-1.5.10.22.1.1" class="indexterm"></a><a id="c4e8d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.pav.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the One</p></td></tr></tbody></table>

from the cmavo _<a id="id-1.5.10.22.4.1.1" class="indexterm"></a>[_pa_](../go01#valsi-pa)_ , with rafsi _pav_ , meaning “one”

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qjjN"></a>

**Example 4.68. <a id="id-1.5.10.23.1.1" class="indexterm"></a><a id="c4e8d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.sol.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the Sun</p></td></tr></tbody></table>

from the gismu _<a id="id-1.5.10.23.4.1.1" class="indexterm"></a>[_solri_](../go01#valsi-solri)_ , meaning “solar” , or actually “pertaining to the Sun”

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qjJz"></a>

**Example 4.69. <a id="id-1.5.10.24.1.1" class="indexterm"></a><a id="c4e8d13"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.ralj.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Chief <span class="comment">(as a title)</span></p></td></tr></tbody></table>

from the gismu _<a id="id-1.5.10.24.4.1.1" class="indexterm"></a>[_ralju_](../go01#valsi-ralju)_ , meaning “principal”.

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qJKt"></a>

**Example 4.70. <a id="id-1.5.10.25.1.1" class="indexterm"></a><a id="id-1.5.10.25.1.2" class="indexterm"></a><a id="c4e8d14"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.nol.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Lord/Lady</p></td></tr></tbody></table>

from the gismu _<a id="id-1.5.10.25.4.1.1" class="indexterm"></a>[_nobli_](../go01#valsi-nobli)_ , with rafsi _nol_ , meaning “noble”.

</div>  

<a id="id-1.5.10.26.1" class="indexterm"></a><a id="id-1.5.10.26.2" class="indexterm"></a>To Lojbanize a name from the various natural languages, apply the following rules:

1.  Eliminate double consonants and silent letters.

2.  Add a final _s_ or _n_ (or some other consonant that sounds good) if the name ends in a vowel.

3.  Convert all sounds to their closest Lojban equivalents.

4.  If possible and acceptable, shift the stress to the penultimate (next-to-the-last) syllable. Use commas and capitalization in written Lojban when it is necessary to preserve non-standard syllabication or stress. Do not capitalize names otherwise.

5.  <a id="id-1.5.10.27.5.1.1" class="indexterm"></a>If the name contains an impermissible consonant pair, insert a vowel between the consonants: _y_ is recommended.

<a id="id-1.5.10.28.1" class="indexterm"></a><a id="id-1.5.10.28.2" class="indexterm"></a>There are some additional rules for Lojbanizing the scientific names (technically known as “Linnaean binomials” after their inventor) which are internationally applied to each species of animal or plant. Where precision is essential, these names need not be Lojbanized, but can be directly inserted into Lojban text using the cmavo _<a id="id-1.5.10.28.4.1" class="indexterm"></a>[_la'o_](../go01#valsi-laho)_ , explained in [Section 19.10](../section-more-quotations). Using this cmavo makes the already lengthy Latinized names at least four syllables longer, however, and leaves the pronunciation in doubt. The following suggestions, though incomplete, will assist in converting Linnaean binomals to valid Lojban names. They can also help to create fu'ivla based on Linnaean binomials or other words of the international scientific vocabulary. The term “back vowel” in the following list refers to any of the letters _a_ , _o_ , or _u_ ; the term “front vowel” correspondingly refers to any of the letters _e_ , _i_ , or _y_.

1.  Change double consonants other than _cc_ to single consonants.

2.  Change _cc_ before a front vowel to _kc_ , but otherwise to _k_.

3.  Change _c_ before a back vowel and final _c_ to _k_.

4.  Change _ng_ before a consonant (other than _h_) and final _ng_ to _n_.

5.  Change _x_ to _z_ initially, but otherwise to _ks_.

6.  Change _pn_ to _n_ initially.

7.  Change final _ie_ and _ii_ to _i_.

8.  Make the following idiosyncratic substitutions:

    <table><tbody><tr><td>aa</td><td>a</td></tr><tr><td>ae</td><td>e</td></tr><tr><td>ch</td><td>k</td></tr><tr><td>ee</td><td>i</td></tr><tr><td>eigh</td><td>ei</td></tr><tr><td>ew</td><td>u</td></tr><tr><td>igh</td><td>ai</td></tr><tr><td>oo</td><td>u</td></tr><tr><td>ou</td><td>u</td></tr><tr><td>ow</td><td>au</td></tr><tr><td>ph</td><td>f</td></tr><tr><td>q</td><td>k</td></tr><tr><td>sc</td><td>sk</td></tr><tr><td>w</td><td>u</td></tr><tr><td>y</td><td>i</td></tr></tbody></table>

    However, the diphthong substitutions should not be done if the two vowels are in two different syllables.

9.  Change “h” between two vowels to _'_ , but otherwise remove it completely. If preservation of the “h” seems essential, change it to _x_ instead.

10.  Place _'_ between any remaining vowel pairs that do not form Lojban diphthongs.

Some further examples of Lojbanized names are:

<table><tbody><tr><td>English</td><td><span class="quote">“<span class="quote">Mary</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.meris.</em></span> or <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.meiris.</em></span></td></tr><tr><td>English</td><td><span class="quote">“<span class="quote">Smith</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.smit.</em></span></td></tr><tr><td>English</td><td><span class="quote">“<span class="quote">Jones</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.djonz.</em></span></td></tr><tr><td>English</td><td><span class="quote">“<span class="quote">John</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.djan.</em></span> or <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.jan.</em></span> (American) or <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.djon.</em></span> or <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.jon.</em></span> (British)</td></tr><tr><td>English</td><td><span class="quote">“<span class="quote">Alice</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.alis.</em></span></td></tr><tr><td>English</td><td><span class="quote">“<span class="quote">Elise</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.eLIS.</em></span></td></tr><tr><td>English</td><td><span class="quote">“<span class="quote">Johnson</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.djansn.</em></span></td></tr><tr><td>English</td><td><span class="quote">“<span class="quote">William</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.uiliam.</em></span> or <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.uil,iam.</em></span></td></tr><tr><td>English</td><td><span class="quote">“<span class="quote">Brown</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.braun.</em></span></td></tr><tr><td>English</td><td><span class="quote">“<span class="quote">Charles</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.tcarlz.</em></span></td></tr><tr><td>French</td><td><span class="quote">“<span class="quote">Charles</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.carl.</em></span></td></tr><tr><td>French</td><td><span class="quote">“<span class="quote">De Gaulle</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.dyGOL.</em></span></td></tr><tr><td>German</td><td><span class="quote">“<span class="quote">Heinrich</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.xainrix.</em></span></td></tr><tr><td>Spanish</td><td><span class="quote">“<span class="quote">Joaquin</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.xuaKIN.</em></span></td></tr><tr><td>Russian</td><td><span class="quote">“<span class="quote">Svetlana</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.sfietlanys.</em></span></td></tr><tr><td>Russian</td><td><span class="quote">“<span class="quote">Khrushchev</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.xrucTCOF.</em></span></td></tr><tr><td>Hindi</td><td><span class="quote">“<span class="quote">Krishna</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.kricnas.</em></span></td></tr><tr><td>Polish</td><td><span class="quote">“<span class="quote">Lech Walesa</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.lex. .va,uensas.</em></span></td></tr><tr><td>Spanish</td><td><span class="quote">“<span class="quote">Don Quixote</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.don. .kicotes.</em></span> or modern Spanish: <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.don. .kixotes.</em></span> or Mexican dialect: <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.don. .ki'otes.</em></span></td></tr><tr><td>Chinese</td><td><span class="quote">“<span class="quote">Mao Zedong</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.maudzydyn.</em></span></td></tr><tr><td>Japanese</td><td><span class="quote">“<span class="quote">Fujiko</span>”</span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.fudjikos.</em></span> or <span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">.fujikos.</em></span></td></tr></tbody></table>