<a id="section-cmavo"></a>4.2. <a id="c4s2"></a>cmavo
-----------------------------------------------------

<a id="id-1.5.4.2.1" class="indexterm"></a><a id="id-1.5.4.2.2" class="indexterm"></a><a id="id-1.5.4.2.3" class="indexterm"></a><a id="id-1.5.4.2.4" class="indexterm"></a><a id="id-1.5.4.2.5" class="indexterm"></a><a id="id-1.5.4.2.6" class="indexterm"></a><a id="id-1.5.4.2.7" class="indexterm"></a><a id="id-1.5.4.2.8" class="indexterm"></a>The first group of Lojban words discussed in this chapter are the cmavo. They are the structure words that hold the Lojban language together. They often have no semantic meaning in themselves, though they may affect the semantics of brivla to which they are attached. The cmavo include the equivalent of English articles, conjunctions, prepositions, numbers, and punctuation marks. There are over a hundred subcategories of cmavo, known as _<a id="id-1.5.4.2.9.1" class="indexterm"></a>[_selma'o_](../go01#valsi-selmaho)_ , each having a specifically defined grammatical usage. The various selma'o are discussed throughout [Chapter 5](../chapter-selbri) to [Chapter 19](../chapter-structure) and summarized in [Chapter 20](../chapter-catalogue).

<a id="id-1.5.4.3.1" class="indexterm"></a>Standard cmavo occur in four forms defined by their word structure. Here are some examples of the various forms:

<table><tbody><tr><td>V-form</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.1.2.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-a"><em class="glossterm">.a</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.1.3.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-e"><em class="glossterm">.e</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.1.4.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-i"><em class="glossterm">.i</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.1.5.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-o"><em class="glossterm">.o</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.1.6.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-u"><em class="glossterm">.u</em></a></em></span></td></tr><tr><td>CV-form</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.2.2.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ba"><em class="glossterm">ba</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.2.3.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ce"><em class="glossterm">ce</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.2.4.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-di"><em class="glossterm">di</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.2.5.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-fo"><em class="glossterm">fo</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.2.6.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-gu"><em class="glossterm">gu</em></a></em></span></td></tr><tr><td>VV-form</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.3.2.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-au"><em class="glossterm">.au</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.3.3.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ei"><em class="glossterm">.ei</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.3.4.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ia"><em class="glossterm">.ia</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.3.5.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ohu"><em class="glossterm">.o'u</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.3.6.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-uhe"><em class="glossterm">.u'e</em></a></em></span></td></tr><tr><td>CVV-form</td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.4.2.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-kiha"><em class="glossterm">ki'a</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.4.3.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-pei"><em class="glossterm">pei</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.4.4.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-miho"><em class="glossterm">mi'o</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.4.5.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-coi"><em class="glossterm">coi</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.4.4.6.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-cuhu"><em class="glossterm">cu'u</em></a></em></span></td></tr></tbody></table>

In addition, there is the cmavo _<a id="id-1.5.4.5.1.1" class="indexterm"></a>[_.y._](../go01#valsi-y)_ (remember that _y_ is not a V), which must have pauses before and after it.

<a id="id-1.5.4.6.1" class="indexterm"></a><a id="id-1.5.4.6.2" class="indexterm"></a><a id="id-1.5.4.6.3" class="indexterm"></a><a id="id-1.5.4.6.4" class="indexterm"></a>A simple cmavo thus has the property of having only one or two vowels, or of having a single consonant followed by one or two vowels. Words consisting of three or more vowels in a row, or a single consonant followed by three or more vowels, are also of cmavo form, but are reserved for experimental use: a few examples are _<a id="id-1.5.4.6.5.1" class="indexterm"></a>ku'a'e_ , _<a id="id-1.5.4.6.6.1" class="indexterm"></a>sau'e_ , and _<a id="id-1.5.4.6.7.1" class="indexterm"></a>bai'ai_. All CVV cmavo beginning with the letter _x_ are also reserved for experimental use. In general, though, the form of a cmavo tells you little or nothing about its grammatical use.

<a id="id-1.5.4.7.1" class="indexterm"></a><a id="id-1.5.4.7.2" class="indexterm"></a>“Experimental use” means that the language designers will not assign any standard meaning or usage to these words, and words and usages coined by Lojban speakers will not appear in official dictionaries for the indefinite future. Experimental-use words provide an escape hatch for adding grammatical mechanisms (as opposed to semantic concepts) the need for which was not foreseen.

<a id="id-1.5.4.8.1" class="indexterm"></a>The cmavo of VV-form include not only the diphthongs and vowel pairs listed in [Section 4.1](../chapter-morphology#section-morphology-introduction) , but also the following ten additional diphthongs:

<table border="0" summary="Simple list" class="simplelist"><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.9.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ia"><em class="glossterm">.ia</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.9.2.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ie"><em class="glossterm">.ie</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.9.3.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ii"><em class="glossterm">.ii</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.9.4.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-io"><em class="glossterm">.io</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.9.5.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-iu"><em class="glossterm">.iu</em></a></em></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.9.6.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ua"><em class="glossterm">.ua</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.9.7.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ue"><em class="glossterm">.ue</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.9.8.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-ui"><em class="glossterm">.ui</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.9.9.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-uo"><em class="glossterm">.uo</em></a></em></span></td><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.5.4.9.10.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-uu"><em class="glossterm">.uu</em></a></em></span></td></tr></tbody></table>

In addition, cmavo can have the form _Cy_ , a consonant followed by the letter _y_. These cmavo represent letters of the Lojban alphabet, and are discussed in detail in [Chapter 17](../chapter-letterals).

<a id="id-1.5.4.11.1" class="indexterm"></a><a id="id-1.5.4.11.2" class="indexterm"></a><a id="id-1.5.4.11.3" class="indexterm"></a>Compound cmavo are sequences of cmavo attached together to form a single written word. A compound cmavo is always identical in meaning and in grammatical use to the separated sequence of simple cmavo from which it is composed. These words are written in compound form merely to save visual space, and to ease the reader's burden in identifying when the component cmavo are acting together.

<a id="id-1.5.4.12.1" class="indexterm"></a>Compound cmavo, while not visually short like their components, can be readily identified by two characteristics:

1.  They have no consonant pairs or clusters, and

2.  They end in a vowel.

For example:

<div class="compound-cmavo-example example">
<a id="example-random-id-qiXV"></a>

**Example 4.1. <a id="c4e2d1"></a>** 

*   .iseci'i

*   .i se ci'i

</div>  
<div class="compound-cmavo-example example">
<a id="example-random-id-qIYK"></a>

**Example 4.2. <a id="c4e2d2"></a>** 

*   punaijecanai

*   pu nai je ca nai

</div>  
<div class="compound-cmavo-example example">
<a id="example-random-id-qiz6"></a>

**Example 4.3. <a id="c4e2d3"></a>** 

*   ki'e.u'e

*   ki'e .u'e

</div>  

<a id="id-1.5.4.18.1" class="indexterm"></a>The cmavo _<a id="id-1.5.4.18.2.1" class="indexterm"></a>[_.u'e_](../go01#valsi-uhe)_ begins with a vowel, and like all words beginning with a vowel, requires a pause (represented by _._) before it. This pause cannot be omitted simply because the cmavo is incorporated into a compound cmavo. On the other hand,

<div class="interlinear-gloss-example example">
<a id="example-random-id-FDhH"></a>

**Example 4.4. <a id="c4e2d4"></a>** 

<a id="id-1.5.4.19.2.1" class="indexterm"></a>ki'e'u'e

</div>  

is a single cmavo reserved for experimental purposes: it has four vowels.

<div class="compound-cmavo-example example">
<a id="example-random-id-CtnR"></a>

**Example 4.5. <a id="c4e2d5"></a>** 

*   cy.ibu.abu

*   cy. .ibu .abu

</div>  

Again the pauses are required (see [Section 4.9](../section-pauses)); the pause after _<a id="id-1.5.4.22.2.1" class="indexterm"></a>[_cy._](../go01#valsi-cy)_ merges with the pause before _<a id="id-1.5.4.22.3.1" class="indexterm"></a>[_.ibu_](../go01#valsi-ibu)_.

<a id="id-1.5.4.23.1" class="indexterm"></a><a id="id-1.5.4.23.2" class="indexterm"></a>There is no particular stress required in cmavo or their compounds. Some conventions do exist that are not mandatory. For two-syllable cmavo, for example, stress is typically placed on the first vowel; an example is

<div class="pronunciation-example example">
<a id="example-random-id-pdGY"></a>

**Example 4.6. <a id="c4e2d6"></a>** 

*   .e'o ko ko kurji

*   .E'o ko ko KURji

</div>  

This convention results in a consistent rhythm to the language, since brivla are required to have penultimate stress; some find this esthetically pleasing.

<a id="id-1.5.4.26.1" class="indexterm"></a>If the final syllable of one word is stressed, and the first syllable of the next word is stressed, you must insert a pause or glottal stop between the two stressed syllables. Thus

<div class="interlinear-gloss-example example">
<a id="example-random-id-uqDz"></a>

**Example 4.7. <a id="c4e2d7"></a>** 

<a id="id-1.5.4.27.2.1" class="indexterm"></a>le re nanmu

</div>  

can be optionally pronounced

<div class="pronunciation-example example">
<a id="example-random-id-dfzc"></a>

**Example 4.8. <a id="c4e2d8"></a>** 

*   le RE. NANmu

</div>  

since there are no rules forcing stress on either of the first two words; the stress on _<a id="id-1.5.4.30.1.1" class="indexterm"></a>[_re_](../go01#valsi-re)_ , though, demands that a pause separate _<a id="id-1.5.4.30.2.1" class="indexterm"></a>[_re_](../go01#valsi-re)_ from the following syllable _<a id="id-1.5.4.30.3.1" class="indexterm"></a>nan_ to ensure that the stress on _<a id="id-1.5.4.30.4.1" class="indexterm"></a>nan_ is properly heard as a stressed syllable. The alternative pronunciation

<div class="pronunciation-example example">
<a id="example-random-id-bLbf"></a>

**Example 4.9. <a id="c4e2d9"></a>** 

*   LE re NANmu

</div>  

is also valid; this would apply secondary stress (used for purposes of emphasis, contrast or sentence rhythm) to _<a id="id-1.5.4.32.1.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ , comparable in rhythmical effect to the English phrase “THE two men”. In [Example 4.8](../section-cmavo#example-random-id-dfzc) , the secondary stress on _<a id="id-1.5.4.32.4.1" class="indexterm"></a>[_re_](../go01#valsi-re)_ would be similar to that in the English phrase “the TWO men”.

Both cmavo may also be left unstressed, thus:

<div class="pronunciation-example example">
<a id="example-random-id-sg0p"></a>

**Example 4.10. <a id="c4e2d10"></a>** 

*   le re NANmu

</div>  

This would probably be the most common usage.