<a id="section-clusters"></a>3.6. <a id="c3s6"></a>Consonant clusters
---------------------------------------------------------------------

<a id="id-1.4.8.2.1" class="indexterm"></a><a id="id-1.4.8.2.2" class="indexterm"></a>A consonant sound is a relatively brief speech-sound that precedes or follows a vowel sound in a syllable; its presence either preceding or following does not add to the count of syllables, nor is a consonant required in either position for any syllable. Lojban has seventeen consonants: for the purposes of this section, the apostrophe is not counted as a consonant.

<a id="id-1.4.8.3.1" class="indexterm"></a><a id="id-1.4.8.3.2" class="indexterm"></a>An important distinction dividing Lojban consonants is that of voicing. The following table shows the unvoiced consonants and the corresponding voiced ones:

| UNVOICED | VOICED |
| --- | --- |
| _p_ | _b_ |
| _t_ | _d_ |
| _k_ | _g_ |
| _f_ | _v_ |
| _c_ | _j_ |
| _s_ | _z_ |
| _x_ | \- |

The consonant _x_ has no voiced counterpart in Lojban. The remaining consonants, _l_ , _m_ , _n_ , and _r_ , are typically pronounced with voice, but can be pronounced unvoiced.

<a id="id-1.4.8.6.1" class="indexterm"></a><a id="id-1.4.8.6.2" class="indexterm"></a><a id="id-1.4.8.6.3" class="indexterm"></a><a id="id-1.4.8.6.4" class="indexterm"></a><a id="id-1.4.8.6.5" class="indexterm"></a><a id="id-1.4.8.6.6" class="indexterm"></a><a id="id-1.4.8.6.7" class="indexterm"></a>Consonant sounds occur in languages as single consonants, or as doubled, or as clustered combinations. Single consonant sounds are isolated by word boundaries or by intervening vowel sounds from other consonant sounds. Doubled consonant sounds are either lengthened like \[s\] in English “hiss” , or repeated like \[k\] in English “backcourt”. Consonant clusters consist of two or more single or doubled consonant sounds in a group, each of which is different from its immediate neighbor. In Lojban, doubled consonants are excluded altogether, and clusters are limited to two or three members, except in Lojbanized names.

<a id="id-1.4.8.7.1" class="indexterm"></a>Consonants can occur in three positions in words: initial (at the beginning), medial (in the middle), and final (at the end). In many languages, the sound of a consonant varies depending upon its position in the word. In Lojban, as much as possible, the sound of a consonant is unrelated to its position. In particular, the common American English trait of changing a “t” between vowels into a “d” or even an alveolar tap (IPA \[ɾ\]) is unacceptable in Lojban.

<a id="id-1.4.8.8.1" class="indexterm"></a><a id="id-1.4.8.8.2" class="indexterm"></a>Lojban imposes no restrictions on the appearance of single consonants in any valid consonant position; however, no consonant (including syllabic consonants) occurs final in a word except in Lojbanized names.

<a id="id-1.4.8.9.1" class="indexterm"></a>Pairs of consonants can also appear freely, with the following restrictions:

1.  It is forbidden for both consonants to be the same, as this would violate the rule against double consonants.

2.  <a id="id-1.4.8.10.2.1.1" class="indexterm"></a>It is forbidden for one consonant to be voiced and the other unvoiced. The consonants _l_ , _m_ , _n_ , and _r_ are exempt from this restriction. As a result, _bf_ is forbidden, and so is _sd_ , but both _fl_ and _vl_ , and both _ls_ and _lz_ , are permitted.

3.  It is forbidden for both consonants to be drawn from the set _c_ , _j_ , _s_ , _z_.

4.  The specific pairs _cx_ , _kx_ , _xc_ , _xk_ , and _mz_ are forbidden.

<a id="id-1.4.8.11.1" class="indexterm"></a>These rules apply to all kinds of words, even Lojbanized names. If a name would normally contain a forbidden consonant pair, a _y_ can be inserted to break up the pair:

<div class="pronunciation-example example">
<a id="example-random-id-k2cK"></a>

**Example 3.8. <a id="id-1.4.8.12.1.1" class="indexterm"></a><a id="c3e6d1"></a>** 

*   .djeimyz.

*   \[dʒɛj məzʔ\]

*   James

</div>  

The regular English pronunciation of “James” , which is \[dʒɛjmz\] , would Lojbanize as _.djeimz._ , which contains a forbidden consonant pair.