<a id="section-causals"></a>9.7. <a id="c9s7"></a>Modal sentence connection: the causals
----------------------------------------------------------------------------------------

<a id="id-1.10.9.2.1" class="indexterm"></a><a id="id-1.10.9.2.2" class="indexterm"></a><a id="id-1.10.9.2.3" class="indexterm"></a><a id="id-1.10.9.2.4" class="indexterm"></a><a id="id-1.10.9.2.5" class="indexterm"></a><a id="id-1.10.9.2.6" class="indexterm"></a><a id="id-1.10.9.2.7" class="indexterm"></a><a id="id-1.10.9.2.8" class="indexterm"></a><a id="id-1.10.9.2.9" class="indexterm"></a><a id="id-1.10.9.2.10" class="indexterm"></a><a id="id-1.10.9.2.11" class="indexterm"></a><a id="id-1.10.9.2.12" class="indexterm"></a><a id="id-1.10.9.2.13" class="indexterm"></a><a id="id-1.10.9.2.14" class="indexterm"></a><a id="id-1.10.9.2.15" class="indexterm"></a><a id="id-1.10.9.2.16" class="indexterm"></a><a id="id-1.10.9.2.17" class="indexterm"></a><a id="id-1.10.9.2.18" class="indexterm"></a><a id="id-1.10.9.2.19" class="indexterm"></a><a id="id-1.10.9.2.20" class="indexterm"></a><a id="id-1.10.9.2.21" class="indexterm"></a><a id="id-1.10.9.2.22" class="indexterm"></a><a id="id-1.10.9.2.23" class="indexterm"></a><a id="id-1.10.9.2.24" class="indexterm"></a><a id="id-1.10.9.2.25" class="indexterm"></a><a id="id-1.10.9.2.26" class="indexterm"></a><a id="id-1.10.9.2.27" class="indexterm"></a><a id="id-1.10.9.2.28" class="indexterm"></a><a id="id-1.10.9.2.29" class="indexterm"></a><a id="id-1.10.9.2.30" class="indexterm"></a><a id="id-1.10.9.2.31" class="indexterm"></a><a id="id-1.10.9.2.32" class="indexterm"></a><a id="id-1.10.9.2.33" class="indexterm"></a><a id="id-1.10.9.2.34" class="indexterm"></a><a id="id-1.10.9.2.35" class="indexterm"></a><a id="id-1.10.9.2.36" class="indexterm"></a><a id="id-1.10.9.2.37" class="indexterm"></a><a id="id-1.10.9.2.38" class="indexterm"></a><a id="id-1.10.9.2.39" class="indexterm"></a><a id="id-1.10.9.2.40" class="indexterm"></a><a id="id-1.10.9.2.41" class="indexterm"></a><a id="id-1.10.9.2.42" class="indexterm"></a><a id="id-1.10.9.2.43" class="indexterm"></a><a id="id-1.10.9.2.44" class="indexterm"></a><a id="id-1.10.9.2.45" class="indexterm"></a><a id="id-1.10.9.2.46" class="indexterm"></a><a id="id-1.10.9.2.47" class="indexterm"></a><a id="id-1.10.9.2.48" class="indexterm"></a><a id="id-1.10.9.2.49" class="indexterm"></a><a id="id-1.10.9.2.50" class="indexterm"></a><a id="id-1.10.9.2.51" class="indexterm"></a><a id="id-1.10.9.2.52" class="indexterm"></a><a id="id-1.10.9.2.53" class="indexterm"></a><a id="id-1.10.9.2.54" class="indexterm"></a><a id="id-1.10.9.2.55" class="indexterm"></a><a id="id-1.10.9.2.56" class="indexterm"></a><a id="id-1.10.9.2.57" class="indexterm"></a><a id="id-1.10.9.2.58" class="indexterm"></a><a id="id-1.10.9.2.59" class="indexterm"></a><a id="id-1.10.9.2.60" class="indexterm"></a><a id="id-1.10.9.2.61" class="indexterm"></a><a id="id-1.10.9.2.62" class="indexterm"></a><a id="id-1.10.9.2.63" class="indexterm"></a><a id="id-1.10.9.2.64" class="indexterm"></a><a id="id-1.10.9.2.65" class="indexterm"></a><a id="id-1.10.9.2.66" class="indexterm"></a><a id="id-1.10.9.2.67" class="indexterm"></a><a id="id-1.10.9.2.68" class="indexterm"></a><a id="id-1.10.9.2.69" class="indexterm"></a>The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ri'a</p></td><td class="selmaho"><p class="selmaho">BAI</p></td><td class="description"><p class="description">rinka modal: physical cause</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ki'u</p></td><td class="selmaho"><p class="selmaho">BAI</p></td><td class="description"><p class="description">krinu modal: justification</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">mu'i</p></td><td class="selmaho"><p class="selmaho">BAI</p></td><td class="description"><p class="description">mukti modal: motivation</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ni'i</p></td><td class="selmaho"><p class="selmaho">BAI</p></td><td class="description"><p class="description">nibli modal: logical entailment</p></td></tr></tbody></table>

This section has two purposes. On the one hand, it explains the grammatical construct called “modal sentence connection”. On the other, it exemplifies some of the more useful BAI cmavo: the causals. (There are other BAI cmavo which have causal implications: _<a id="id-1.10.9.4.2.1" class="indexterm"></a>[_ja'e_](../go01#valsi-jahe)_ means “with result” , and so _<a id="id-1.10.9.4.4.1" class="indexterm"></a>[_seja'e_](../go01#valsi-sejahe)_ means “with cause of unspecified nature” ; likewise, _<a id="id-1.10.9.4.6.1" class="indexterm"></a>[_gau_](../go01#valsi-gau)_ means “with agent” and _<a id="id-1.10.9.4.8.1" class="indexterm"></a>[_tezu'e_](../go01#valsi-tezuhe)_ means “with purpose”. These other modal cmavo will not be further discussed here, as my purpose is to explain modal sentence connection rather than Lojbanic views of causation.)

<a id="id-1.10.9.5.1" class="indexterm"></a>There are four causal gismu in Lojban, distinguishing different versions of the relationships lumped in English as “causal” :

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.9.6.2.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-rinka"><em class="glossterm">rinka</em></a></em></span></td><td><span class="definition"><span class="definition-content">event x<sub>1</sub> physically causes event x<sub>2</sub></span></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.9.6.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-krinu"><em class="glossterm">krinu</em></a></em></span></td><td><span class="definition"><span class="definition-content">event x<sub>1</sub> is the justification for event x<sub>2</sub></span></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.9.6.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-mukti"><em class="glossterm">mukti</em></a></em></span></td><td><span class="definition"><span class="definition-content">event x<sub>1</sub> is the (human) motive for event x<sub>2</sub></span></span></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.10.9.6.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-nibli"><em class="glossterm">nibli</em></a></em></span></td><td><span class="definition"><span class="definition-content">event x<sub>1</sub> logically entails event x<sub>2</sub></span></span></td></tr></tbody></table>

<a id="id-1.10.9.7.1" class="indexterm"></a><a id="id-1.10.9.7.2" class="indexterm"></a><a id="id-1.10.9.7.3" class="indexterm"></a>Each of these gismu has a related modal: _<a id="id-1.10.9.7.4.1" class="indexterm"></a>[_ri'a_](../go01#valsi-riha)_ , _<a id="id-1.10.9.7.5.1" class="indexterm"></a>[_ki'u_](../go01#valsi-kihu)_ , _<a id="id-1.10.9.7.6.1" class="indexterm"></a>[_mu'i_](../go01#valsi-muhi)_ , and _<a id="id-1.10.9.7.7.1" class="indexterm"></a>[_ni'i_](../go01#valsi-nihi)_ respectively. Using these gismu and these modals, we can create various causal sentences with different implications:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qmMz"></a>

**Example 9.35. <a id="c9e7d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>spati</td><td>cu</td><td>banro</td><td>ri'a</td><td>le</td><td>nu</td></tr><tr class="gloss"><td>The</td><td>plant</td><td></td><td>grows</td><td>with-physical-cause</td><td>the</td><td>event-of</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>djacu</td><td>dunda</td><td>fi</td><td>le</td><td>spati</td></tr><tr class="gloss"><td>you</td><td>water</td><td>give</td><td>to</td><td>the</td><td>plant.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The plant grows because you water it.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qmN2"></a>

**Example 9.36. <a id="c9e7d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>cpacu</td><td>le</td><td>pamoi</td><td>se&nbsp;jinga</td></tr><tr class="gloss"><td></td><td>John</td><td>gets</td><td>the</td><td>first</td><td>prize</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ki'u</td><td>le</td><td>nu</td><td>la</td><td>.djan.</td><td>jinga</td></tr><tr class="gloss"><td>with-justification</td><td>the</td><td>event-of</td><td>that-named</td><td>John</td><td>wins.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John got the first prize because he won.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qMN7"></a>

**Example 9.37. <a id="c9e7d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>lebna</td><td>le</td><td>cukta</td><td>mu'i</td></tr><tr class="gloss"><td>I</td><td>took</td><td>the</td><td>book</td><td>with-motivation</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nu</td><td>mi</td><td>viska</td><td>le</td><td>cukta</td></tr><tr class="gloss"><td>the</td><td>event-of</td><td>I</td><td>saw</td><td>the</td><td>book.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I took the book because I saw it.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qMNc"></a>

**Example 9.38. <a id="id-1.10.9.11.1.1" class="indexterm"></a><a id="c9e7d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.sokrates.</td><td>morsi</td><td>binxo</td><td>ni'i</td></tr><tr class="gloss"><td></td><td>Socrates</td><td>dead</td><td>became</td><td>with-logical-justification</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nu</td><td>la</td><td>.sokrates.</td><td>remna</td></tr><tr class="gloss"><td>the</td><td>event-of</td><td>that-named</td><td>Socrates</td><td>is-human.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Socrates died because Socrates is human.</p></td></tr></tbody></table>

</div>  

<a id="id-1.10.9.12.1" class="indexterm"></a>In [Example 9.35](../section-causals#example-random-id-qmMz) through [Example 9.38](../section-causals#example-random-id-qMNc) , the same English word “because” is used to translate all four modals, but the types of cause being expressed are quite different. Let us now focus on [Example 9.35](../section-causals#example-random-id-qmMz) , and explore some variations on it.

<a id="id-1.10.9.13.1" class="indexterm"></a><a id="id-1.10.9.13.2" class="indexterm"></a>As written, [Example 9.35](../section-causals#example-random-id-qmMz) claims that the plant grows, but only refers to the event of watering it in an abstraction bridi (abstractions are explained in [Chapter 11](../chapter-abstractions)) without actually making a claim. If I express [Example 9.35](../section-causals#example-random-id-qmMz) , I have said that the plant in fact grows, but I have not said that you actually water it, merely that there is a causal relationship between watering and growing. This is semantically asymmetrical. Suppose I wanted to claim that the plant was being watered, and only mention its growth as ancillary information? Then we could reverse the main bridi and the abstraction bridi, saying:

<div class="interlinear-gloss-example example">
<a id="example-random-id-ibro"></a>

**Example 9.39. <a id="id-1.10.9.14.1.1" class="indexterm"></a><a id="c9e7d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>djacu</td><td>dunda</td><td>fi</td><td>le</td><td>spati</td></tr><tr class="gloss"><td>You</td><td>water</td><td>give</td><td>to</td><td>the</td><td>plant</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>seri'a</td><td>le</td><td>nu</td><td>ri</td><td>banro</td></tr><tr class="gloss"><td>with-physical-effect</td><td>the</td><td>event-of</td><td>it</td><td>grows.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">You water the plant; therefore, it grows.</p></td></tr></tbody></table>

</div>  

with the _<a id="id-1.10.9.15.1.1" class="indexterm"></a>[_ri'a_](../go01#valsi-riha)_ changed to _<a id="id-1.10.9.15.2.1" class="indexterm"></a>[_seri'a_](../go01#valsi-seriha)_. In addition, there are also symmetrical forms:

<div class="interlinear-gloss-example example">
<a id="example-random-id-1YHv"></a>

**Example 9.40. <a id="id-1.10.9.16.1.1" class="indexterm"></a><a id="c9e7d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nu</td><td>do</td><td>djacu</td><td>dunda</td><td>fi</td><td>le</td><td>spati</td><td>cu</td></tr><tr class="gloss"><td>The</td><td>event-of</td><td>(you</td><td>water</td><td>give</td><td>to</td><td>the</td><td>plant)</td><td></td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>rinka</td><td>le</td><td>nu</td><td>le</td><td>spati</td><td>cu</td><td>banro</td></tr><tr class="gloss"><td>causes</td><td>the</td><td>event-of</td><td>(the</td><td>plant</td><td></td><td>grows).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Your watering the plant causes its growth.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">If you water the plant, then it grows.</p></td></tr></tbody></table>

</div>  

does not claim either event, but asserts only the causal relationship between them. So in [Example 9.40](../section-causals#example-random-id-1YHv) , I am not saying that the plant grows nor that you have in fact watered it. The second colloquial translation shows a form of “if-then” in English quite distinct from the logical connective “if-then” explained in [Chapter 14](../chapter-connectives).

Suppose we wish to claim both events as well as their causal relationship? We can use one of two methods:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qMnX"></a>

**Example 9.41. <a id="id-1.10.9.19.1.1" class="indexterm"></a><a id="c9e7d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>spati</td><td>cu</td><td>banro</td><td>.iri'abo</td><td>do</td></tr><tr class="gloss"><td>The</td><td>plant</td><td></td><td>grows.</td><td>Because</td><td>you</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>djacu</td><td>dunda</td><td>fi</td><td>le</td><td>spati</td></tr><tr class="gloss"><td>water</td><td>give</td><td>to</td><td>the</td><td>plant.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The plant grows because you water it.</p></td></tr></tbody></table>

</div>  

<div class="interlinear-gloss-example example">
<a id="example-random-id-qMPn"></a>

**Example 9.42. <a id="id-1.10.9.20.1.1.1" class="indexterm"></a><a id="id-1.10.9.20.1.1.2" class="indexterm"></a><a id="c9e7d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>do</td><td>djacu</td><td>dunda</td><td>fi</td><td>le</td><td>spati</td></tr><tr class="gloss"><td>You</td><td>water</td><td>give</td><td>to</td><td>the</td><td>plant.</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>.iseri'abo</td><td>le</td><td>spati</td><td>cu</td><td>banro</td></tr><tr class="gloss"><td>Therefore</td><td>the</td><td>plant</td><td></td><td>grows.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">You water the plant; therefore, it grows.</p></td></tr></tbody></table>

</div>

The compound cmavo _<a id="id-1.10.9.21.1.1" class="indexterm"></a>.iri'abo_ and _<a id="id-1.10.9.21.2.1" class="indexterm"></a>.iseri'abo_ serve to connect two bridi, as the initial _<a id="id-1.10.9.21.3.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ indicates. The final _<a id="id-1.10.9.21.4.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ is necessary to prevent the modal from “taking over” the following sumti. If the _<a id="id-1.10.9.21.6.1" class="indexterm"></a>[_bo_](../go01#valsi-bo)_ were omitted from [Example 9.41](../section-causals#example-random-id-qMnX) we would have:

<div class="interlinear-gloss-example example">
<a id="example-random-id-Wo6K"></a>

**Example 9.43. <a id="id-1.10.9.22.1.1" class="indexterm"></a><a id="c9e7d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>spati</td><td>cu</td><td>banro</td><td>.i</td><td>ri'a</td><td>do</td></tr><tr class="gloss"><td>The</td><td>plant</td><td></td><td>grows.</td><td></td><td>Because-of</td><td>you,</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td></td><td>djacu</td><td>dunda</td><td>fi</td><td>le</td><td>spati</td></tr><tr class="gloss"><td>[something]</td><td>water</td><td>gives</td><td>to</td><td>the</td><td>plant.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The plant grows. Because of you, water is given to the plant.</p></td></tr></tbody></table>

</div>  

Because _<a id="id-1.10.9.23.1.1" class="indexterm"></a>ri'a do_ is a modal sumti in [Example 9.43](../section-causals#example-random-id-Wo6K) , there is no longer an explicit sumti in the x1 place of _<a id="id-1.10.9.23.4.1" class="indexterm"></a>djacu dunda_ , and the translation must be changed.

<a id="id-1.10.9.24.1" class="indexterm"></a><a id="id-1.10.9.24.2" class="indexterm"></a><a id="id-1.10.9.24.3" class="indexterm"></a>The effect of sentences like [Example 9.41](../section-causals#example-random-id-qMnX) and [Example 9.42](../section-causals#example-random-id-qMPn) is that the modal, _<a id="id-1.10.9.24.6.1" class="indexterm"></a>[_ri'a_](../go01#valsi-riha)_ in this example, no longer modifies an explicit sumti. Instead, the sumti is implicit, the event given by a full bridi. Furthermore, there is a second implication: that the first bridi fills the x2 place of the gismu _<a id="id-1.10.9.24.8.1" class="indexterm"></a>[_rinka_](../go01#valsi-rinka)_ ; it specifies an event which is the effect. I am therefore claiming three things: that the plant grows, that you have watered it, and that there is a cause-and-effect relationship between the two.

<a id="id-1.10.9.25.1" class="indexterm"></a>In principle, any modal tag can appear in a sentence connective of the type exemplified by [Example 9.41](../section-causals#example-random-id-qMnX) and [Example 9.42](../section-causals#example-random-id-qMPn). However, it makes little sense to use any modals which do not expect events or other abstractions to fill the places of the corresponding gismu. The sentence connective _<a id="id-1.10.9.25.4.1" class="indexterm"></a>.ibaubo_ is perfectly grammatical, but it is hard to imagine any two sentences which could be connected by an “in-language” modal. This is because a sentence describes an event, and an event can be a cause or an effect, but not a language.