<a id="section-categories"></a>13.6. <a id="c13s6"></a>Emotional categories
---------------------------------------------------------------------------

<a id="id-1.14.8.2.1" class="indexterm"></a><a id="id-1.14.8.2.2" class="indexterm"></a><a id="id-1.14.8.2.3" class="indexterm"></a>The Lojban attitudinal system was designed by starting with a long list of English emotion words, far too many to fit into the 39 available VV-form cmavo. To keep the number of cmavo limited, the emotion words in the list were grouped together by common features: each group was then assigned a separate cmavo. This was like making tanru in reverse, and the result is a collection of indicators that can be combined, like tanru, to express very complex emotions. Some examples in a moment.

The most significant “common feature” we identified was that the emotional words on the list could easily be broken down into six major groups, each of which was assigned its own cmavo:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ro'a</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">social</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">asocial</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">antisocial</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ro'e</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">mental</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">mindless</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ro'i</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">emotional</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">denying emotion</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ro'o</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">physical</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">denying physical</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ro'u</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">sexual</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi"></p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">sexual abstinence</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">re'e</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">spiritual</p></td><td class="attitudinal-scale-cuhi"><p class="attitudinal-scale-cuhi">secular</p></td><td class="attitudinal-scale-nai"><p class="attitudinal-scale-nai">sacrilegious</p></td></tr></tbody></table>

Using these, we were able to assign _<a id="id-1.14.8.5.1.1" class="indexterm"></a>[_.o'u_](../go01#valsi-ohu)_ to mark a scale of what we might call “generalized comfort”. When you are comfortable, relaxed, satisfied, you express comfort with _<a id="id-1.14.8.5.3.1" class="indexterm"></a>[_.o'u_](../go01#valsi-ohu)_ , possibly followed by a scale indicator to indicate how comfortable you are. The six cmavo given above allow you to turn this scale into six separate ones, should you wish.

<a id="id-1.14.8.6.1" class="indexterm"></a><a id="id-1.14.8.6.2" class="indexterm"></a><a id="id-1.14.8.6.3" class="indexterm"></a><a id="id-1.14.8.6.4" class="indexterm"></a><a id="id-1.14.8.6.5" class="indexterm"></a><a id="id-1.14.8.6.6" class="indexterm"></a><a id="id-1.14.8.6.7" class="indexterm"></a>For example, embarrassment is a social discomfort, expressible as _<a id="id-1.14.8.6.8.1" class="indexterm"></a>.o'unairo'a_. Some emotions that we label “stress” in English are expressed in Lojban with _<a id="id-1.14.8.6.10.1" class="indexterm"></a>.o'unairo'i_. Physical distress can be expressed with _<a id="id-1.14.8.6.11.1" class="indexterm"></a>.o'unairo'o_ , which makes a nice groan if you say it with feeling. Mental discomfort might be what you feel when you don't know the answer to the test question, but feel that you should. Most adults can recall some instance where we felt sexual discomfort, _<a id="id-1.14.8.6.12.1" class="indexterm"></a>o'unairo'u_. Spiritual discomfort, _<a id="id-1.14.8.6.13.1" class="indexterm"></a>o'unaire'e_ , might be felt by a church-goer who has wandered into the wrong kind of religious building.

Most of the time when expressing an emotion, you won't categorize it with these words. Emotional expressions should be quickly expressible without having to think about them. However, we sometimes have mixed emotions within this set, as for example emotional discomfort coupled with physical comfort or vice versa.

Coupling these six words with our 39 attitude scales, each of which has a positive and negative side, already gives you far more emotional expression words than we have emotional labels in English. Thus, you'll never see a Lojban-English emotional dictionary that covers all the Lojban possibilities. Some may be useless, but others convey emotions that probably never had a word for them before, though many have felt them ( _<a id="id-1.14.8.8.1.1" class="indexterm"></a>.eiro'u_ , for example – look it up).

<a id="id-1.14.8.9.1" class="indexterm"></a><a id="id-1.14.8.9.2" class="indexterm"></a><a id="id-1.14.8.9.3" class="indexterm"></a><a id="id-1.14.8.9.4" class="indexterm"></a>You can use scale markers and _<a id="id-1.14.8.9.5.1" class="indexterm"></a>[_nai_](../go01#valsi-nai)_ on these six category words, and you can also use category words without specifying the emotion. Thus, “I'm trying to concentrate” could be expressed simply as _<a id="id-1.14.8.9.7.1" class="indexterm"></a>[_ro'e_](../go01#valsi-rohe)_ , and if you are feeling anti-social in some non-specific way, _<a id="id-1.14.8.9.8.1" class="indexterm"></a>[_ro'anai_](../go01#valsi-rohanai)_ will express it.

<a id="id-1.14.8.10.1" class="indexterm"></a>There is a mnemonic device for the six emotion categories, based on moving your arms about. In the following table, your hands begin above your head and move down your body in sequence.

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ro'a</p></td><td class="description"><p class="description">hands above head</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">social</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ro'e</p></td><td class="description"><p class="description">hands on head</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">intellectual</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ro'i</p></td><td class="description"><p class="description">hands on heart</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">emotional</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ro'o</p></td><td class="description"><p class="description">hands on belly</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">physical</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ro'u</p></td><td class="description"><p class="description">hands on groin</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">sexual</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">re'e</p></td><td class="description"><p class="description">hands moving around</p></td><td class="attitudinal-scale-sai"><p class="attitudinal-scale-sai">spiritual</p></td></tr></tbody></table>

The implicit metaphors “heart” for emotional and “belly” for physical are not really Lojbanic, but they work fine for English-speakers.