<a id="section-buffer-vowels"></a>3.8. <a id="c3s8"></a>Buffering of consonant clusters
---------------------------------------------------------------------------------------

<a id="id-1.4.10.2.1" class="indexterm"></a><a id="id-1.4.10.2.2" class="indexterm"></a><a id="id-1.4.10.2.3" class="indexterm"></a>Many languages do not have consonant clusters at all, and even those languages that do have them often allow only a subset of the full Lojban set. As a result, the Lojban design allows the use of a buffer sound between consonant combinations which a speaker finds unpronounceable. This sound may be any non-Lojbanic vowel which is clearly separable by the listener from the Lojban vowels. Some possibilities are IPA \[ɪ\] , \[ɨ\] , \[ʊ\] , or even \[ʏ\] , but there probably is no universally acceptable buffer sound. When using a consonant buffer, the sound should be made as short as possible. Two examples showing such buffering (we will use \[ɪ\] in this chapter) are:

<div class="pronunciation-example example">
<a id="example-random-id-k2dg"></a>

**Example 3.9. <a id="c3e8d1"></a>** 

*   vrusi

*   \[ˈvru si\]

*   or

*   \[vɪ ˈru si\]

</div>  
<div class="pronunciation-example example">
<a id="example-random-id-k2dI"></a>

**Example 3.10. <a id="c3e8d2"></a><a id="id-1.4.10.4.1.2" class="indexterm"></a>** 

*   .AMsterdam.

*   \[ʔam ster damʔ\]

*   or

*   \[ˈʔa mɪ sɪ tɛ rɪ da mɪʔ\]

</div>  

<a id="id-1.4.10.5.1" class="indexterm"></a><a id="id-1.4.10.5.2" class="indexterm"></a>When a buffer vowel is used, it splits each buffered consonant into its own syllable. However, the buffering syllables are never stressed, and are not counted in determining stress. They are, in effect, not really syllables to a Lojban listener, and thus their impact is ignored.

Here are more examples of unbuffered and buffered pronunciations:

<div class="pronunciation-example example">
<a id="example-random-id-k2DT"></a>

**Example 3.11. <a id="c3e8d3"></a>** 

*   klama

*   \[ˈkla ma\]

*   \[kɪ ˈla ma\]

</div>  
<div class="pronunciation-example example">
<a id="example-random-id-k2Gg"></a>

**Example 3.12. <a id="c3e8d4"></a>** 

*   xapcke

*   \[ˈxap ʃkɛ\]

*   \[ˈxa pɪ ʃkɛ\]

*   \[ˈxa pɪ ʃɪ kɛ\]

</div>  

In [Example 3.12](../section-buffer-vowels#example-random-id-k2Gg) , we see that buffering vowels can be used in just some, rather than all, of the possible places: the second pronunciation buffers the _pc_ consonant pair but not the _ck_. The third pronunciation buffers both.

<div class="pronunciation-example example">
<a id="example-random-id-k2hN"></a>

**Example 3.13. <a id="c3e8d5"></a>** 

*   ponyni'u

*   \[po nə 'ni hu\]

</div>  

<a id="id-1.4.10.11.1" class="indexterm"></a><a id="id-1.4.10.11.2" class="indexterm"></a>[Example 3.13](../section-buffer-vowels#example-random-id-k2hN) cannot contain any buffering vowel. It is important not to confuse the vowel _y_ , which is pronounced \[ə\] , with the buffer, which has a variety of possible pronunciations and is never written. Consider the contrast between

<div class="pronunciation-example example">
<a id="example-random-id-k2jU"></a>

**Example 3.14. <a id="id-1.4.10.12.1.1" class="indexterm"></a><a id="c3e8d6"></a>** 

*   bongynanba

*   \[boŋ gə ˈnan ba\]

</div>  

an unlikely Lojban compound word meaning “bone bread” (note the use of \[ŋ\] as a representative of _n_ before _g_) and

<div class="pronunciation-example example">
<a id="example-random-id-k2jv"></a>

**Example 3.15. <a id="c3e8d7"></a>** 

*   bongnanba

*   \[boŋ ˈgnan ba\]

</div>  

a possible borrowing from another language (Lojban borrowings can only take a limited form). If [Example 3.15](../section-buffer-vowels#example-random-id-k2jv) were pronounced with buffering, as

<div class="pronunciation-example example">
<a id="example-random-id-k2Kb"></a>

**Example 3.16. <a id="c3e8d8"></a>** 

*   \[boŋ gɪ ˈnan ba\]

</div>  

it would be very similar to [Example 3.14](../section-buffer-vowels#example-random-id-k2jU). Only a clear distinction between _y_ and any buffering vowel would keep the two words distinct.

<a id="id-1.4.10.18.1" class="indexterm"></a><a id="id-1.4.10.18.2" class="indexterm"></a>Since buffering is done for the benefit of the speaker in order to aid pronounceability, there is no guarantee that the listener will not mistake a buffer vowel for one of the six regular Lojban vowels. The buffer vowel should be as laxly pronounced as possible, as central as possible, and as short as possible. Furthermore, it is worthwhile for speakers who use buffers to pronounce their regular vowels a bit longer than usual, to avoid confusion with buffer vowels. The speakers of many languages will have trouble correctly hearing any of the suggested buffer vowels otherwise. By this guideline, [Example 3.16](../section-buffer-vowels#example-random-id-k2Kb) would be pronounced

<div class="pronunciation-example example">
<a id="example-random-id-k2oF"></a>

**Example 3.17. <a id="c3e8d9"></a>** 

*   \[boːŋ gɪ ˈnaːn baː\]

</div>  

with lengthened vowels.