<a id="section-bridi-negation"></a>15.2. <a id="c15s2"></a>bridi negation
-------------------------------------------------------------------------

In discussing Lojban negation, we will call the form of logical negation that simply denies the truth of a statement “bridi negation”. Using bridi negation, we can say the equivalent of “I haven't stopped beating my wife” without implying that I ever started, nor even that I have a wife, meaning simply “It isn't true that I have stopped beating my wife.” Since Lojban uses bridi as smaller components of complex sentences, bridi negation is permitted in these components as well at the sentence level.

For the bridi negation of a sentence to be true, the sentence being negated must be false. A major use of bridi negation is in making a negative response to a yes/no question; such responses are usually contradictory, denying the truth of the entire sentence. A negative answer to

<div class="example">
<a id="example-random-id-sCNE"></a>

**Example 15.11. <a id="c15e2d1"></a>** 

Did you go to the store?

</div>  

is taken as a negation of the entire sentence, equivalent to

<div class="example">
<a id="example-random-id-vFYC"></a>

**Example 15.12. <a id="c15e2d2"></a>** 

No, I didn't go to the store.

</div>  

The most important rule about bridi negation is that if a bridi is true, its negation is false, and vice versa.

The simplest way to express a bridi negation is to use the cmavo _<a id="id-1.16.4.8.1.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ of selma'o NA before the selbri of the affirmative form of the bridi (but after the _<a id="id-1.16.4.8.2.1" class="indexterm"></a>[_cu_](../go01#valsi-cu)_ , if there is one):

<div class="interlinear-gloss-example example">
<a id="example-random-id-7nrv"></a>

**Example 15.13. <a id="c15e2d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>go-to</td><td>the</td><td>store.</td></tr></tbody></table>

</div>  

when negated becomes:

<div class="interlinear-gloss-example example">
<a id="example-random-id-bV3b"></a>

**Example 15.14. <a id="c15e2d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>na</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td>[false]</td><td>go-to</td><td>the</td><td>store.</td></tr></tbody></table>

</div>  

Note that we have used a special convention to show in the English that a bridi negation is present. We would like to use the word “not” , because this highlights the naturalness of putting the negation marker just before the selbri, and makes the form easier to learn. But there is a major difference between Lojban's bridi negation with _<a id="id-1.16.4.12.2.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ and natural language negation with “not”. In English, the word “not” can apply to a single word, to a phrase, to an English predicate, or to the entire sentence. In addition, “not” may indicate either contradictory negation or another form of negation, depending on the sentence. Lojban's internal bridi negation, on the other hand, always applies to an entire bridi, and is always a contradictory negation; that is, it contradicts the claim of the whole bridi.

Because of the ambiguity of English “not” , we will use “\[false\]” in the translation of Lojban examples to remind the reader that we are expressing a contradictory negation. Here are more examples of bridi negation:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qgzz"></a>

**Example 15.15. <a id="c15e2d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>[cu]</td><td>na</td><td>ca</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td></td><td>[false]</td><td>now</td><td>am-a-go-er-to</td><td>the</td><td>market.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am not going to the market now.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qh10"></a>

**Example 15.16. <a id="c15e2d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>ca</td><td>nolraitru</td><td>be</td></tr><tr class="gloss"><td>The-actual</td><td>present</td><td>noblest-governor</td><td>of</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>fasygu'e</td><td>cu</td><td>na</td><td>krecau</td></tr><tr class="gloss"><td>the</td><td>French-country</td><td></td><td>[false]</td><td>is-hair-without.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The current king of France isn't bald.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qh2i"></a>

**Example 15.17. <a id="c15e2d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ti</td><td>na</td><td>barda</td><td>prenu</td><td>co</td><td>melbi</td><td>mi</td></tr><tr class="gloss"><td>This</td><td>[false]</td><td>is-a-big</td><td>person</td><td>of-type</td><td>(beautiful-to</td><td>me).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">This isn't a big person who is beautiful to me.</p></td></tr></tbody></table>

</div>  

Although there is this fundamental difference between Lojban's internal bridi negation and English negation, we note that in many cases, especially when there are no existential or quantified variables (the cmavo _<a id="id-1.16.4.17.1.1" class="indexterm"></a>[_da_](../go01#valsi-da)_ , _<a id="id-1.16.4.17.2.1" class="indexterm"></a>[_de_](../go01#valsi-de)_ , and _<a id="id-1.16.4.17.3.1" class="indexterm"></a>[_di_](../go01#valsi-di)_ of selma'o KOhA, explained in [Chapter 16](../chapter-quantifiers)) in the bridi, you can indeed translate Lojban _<a id="id-1.16.4.17.5.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ as “not” (or “isn't” or “doesn't” , as appropriate).

The most important rule about bridi negation is that if a bridi is true, its negation is false, and vice versa.

In Lojban, there are several structures that implicitly contain bridi, so that Lojban sentences may contain more than one occurrence of _<a id="id-1.16.4.19.1.1" class="indexterm"></a>[_na_](../go01#valsi-na)_. For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-WU9u"></a>

**Example 15.18. <a id="c15e2d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>na</td><td>gleki</td><td>le</td><td>nu</td></tr><tr class="gloss"><td>I</td><td>[false]</td><td>am-happy-about</td><td>the</td><td>event-of</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>na</td><td>klama</td><td>le</td><td>nu</td><td>dansu</td></tr><tr class="gloss"><td>([false]</td><td>going-to</td><td>the</td><td>event-of</td><td>dancing).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">It is not the case that I am happy about it not being the case that I am going to the dance.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">I am not happy about not going to the dance.</p></td></tr></tbody></table>

</div>  

In the previous example, we used internal negations in abstraction bridi; bridi negation may also be found in descriptions within sumti. For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-N65f"></a>

**Example 15.19. <a id="c15e2d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nelci</td><td>le</td><td>na</td><td>melbi</td></tr><tr class="gloss"><td>I</td><td>am-fond-of</td><td>the-one-described-as</td><td>([false]</td><td>beautiful).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am fond of the one who isn't beautiful.</p></td></tr></tbody></table>

</div>  

A more extreme (and more indefinite) example is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-eQaI"></a>

**Example 15.20. <a id="c15e2d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>nelci</td><td>lo</td><td>na</td></tr><tr class="gloss"><td>I</td><td>am-fond-of</td><td>one-who-is</td><td>([false]</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ca</td><td>nolraitru</td><td>be</td><td>le</td><td>fasygu'e</td></tr><tr class="gloss"><td>the-current</td><td>king</td><td>of</td><td>the</td><td>French-country).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am fond of one who isn't the current king of France.</p></td></tr></tbody></table>

</div>  

The claim of [Example 15.20](../section-bridi-negation#example-random-id-eQaI) could apply to anyone except a person who is fond of no one at all, since the relation within the description is false for everyone. You cannot readily express these situations in colloquial English.

Negation with _<a id="id-1.16.4.26.1.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ applies to an entire bridi, and not to just part of a selbri. Therefore, you won't likely have reason to put _<a id="id-1.16.4.26.2.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ inside a tanru. In fact, the grammar currently does not allow you to do so (except in a lujvo and in elaborate constructs involving GUhA, the forethought connector for selbri). Any situation where you might want to do so can be expressed in a less-compressed non-tanru form. This grammatical restriction helps ensure that bridi negation is kept separate from other forms of negation.

The grammar of _<a id="id-1.16.4.27.1.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ allows multiple adjacent negations, which cancel out, as in normal logic:

<div class="interlinear-gloss-example example">
<a id="example-random-id-RJKu"></a>

**Example 15.21. <a id="c15e2d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ti</td><td>na</td><td>na</td><td>barda</td><td>prenu</td><td>co</td><td>melbi</td><td>mi</td></tr><tr class="gloss"><td>This</td><td>[false]</td><td>[false]</td><td>is-a-big</td><td>person</td><td>that</td><td>is-(beautiful-to</td><td>me).</td></tr></tbody></table>

</div>  

which is the same as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-2UpW"></a>

**Example 15.22. <a id="c15e2d12"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>ti</td><td>barda</td><td>prenu</td><td>co</td><td>melbi</td><td>mi</td></tr><tr class="gloss"><td>This</td><td>is-a-big</td><td>person</td><td>that</td><td>is-(beautiful-to</td><td>me).</td></tr></tbody></table>

</div>  

When a selbri is tagged with a tense or a modal, negation with _<a id="id-1.16.4.31.1.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ is permitted in two positions: before or after the tag. No semantic difference between these forms has yet been defined, but this is not finally determined, since the interactions between tenses/modals and bridi negation have not been fully explored. In particular, it remains to be seen whether sentences using less familiar tenses, such as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-fgmv"></a>

**Example 15.23. <a id="c15e2d13"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>[cu]</td><td>ta'e</td><td>klama</td><td>le</td><td>zarci</td></tr><tr class="gloss"><td>I</td><td></td><td>habitually</td><td>go-to</td><td>the</td><td>market.</td></tr></tbody></table>

</div>  

mean the same thing with _<a id="id-1.16.4.33.1.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ before the _<a id="id-1.16.4.33.2.1" class="indexterm"></a>[_ta'e_](../go01#valsi-tahe)_ , as when the negation occurs afterwards; we'll let future, Lojban-speaking, logicians decide on how they relate to each other.

A final caution on translating English negations into Lojban: if you translate the English literally, you'll get the wrong one. With English causal statements, and other statements with auxiliary clauses, this problem is more likely.

Thus, if you translate the English:

<div class="example">
<a id="example-random-id-hEa7"></a>

**Example 15.24. <a id="c15e2d14"></a>** 

I do not go to the market because the car is broken.

</div>  

as:

<div class="interlinear-gloss-example example">
<a id="example-random-id-q8su"></a>

**Example 15.25. <a id="c15e2d15"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>mi</td><td>na</td><td>klama</td><td>le</td><td>zarci</td><td>ki'u</td></tr><tr class="gloss"><td>I</td><td>[false]</td><td>go-to</td><td>the</td><td>market</td><td>because-of</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lenu</td><td>le</td><td>karce</td><td>cu</td><td>spofu</td></tr><tr class="gloss"><td>the-event-of</td><td>the</td><td>car</td><td></td><td>is-broken.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">It is false that: I go to the market because the car is broken.</p></td></tr></tbody></table>

</div>  

you end up negating too much.

Such mistranslations result from the ambiguity of English compounded by the messiness of natural language negation. A correct translation of the normal interpretation of [Example 15.24](../section-bridi-negation#example-random-id-hEa7) is:

<div class="interlinear-gloss-example example">
<a id="example-random-id-R3GU"></a>

**Example 15.26. <a id="c15e2d16"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nu</td><td>mi</td><td>na</td><td>klama</td><td>le</td><td>zarci</td><td>cu</td><td>se</td><td>krinu</td></tr><tr class="gloss"><td>The</td><td>event-of</td><td>(my</td><td>[false]</td><td>going-to</td><td>the</td><td>market)</td><td></td><td></td><td>is-justified-by</td></tr></tbody></table>

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nu</td><td>le</td><td>karce</td><td>cu</td><td>spofu</td></tr><tr class="gloss"><td>the</td><td>event-of</td><td>(the</td><td>car</td><td></td><td>being-broken).</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">My not going to the market is because the car is broken.</p></td></tr></tbody></table>

</div>  

In [Example 15.26](../section-bridi-negation#example-random-id-R3GU) , the negation is clearly confined to the event abstraction in the x1 sumti, and does not extend to the whole sentence. The English could also have been expressed by two separate sentences joined by a causal connective (which we'll not go into here).

The problem is not confined to obvious causals. In the English:

<div class="example">
<a id="example-random-id-MGvB"></a>

**Example 15.27. <a id="c15e2d17"></a>** 

I was not conscripted into the Army with the help of my uncle the Senator.

</div>  

we do not intend the uncle's help to be part of the negation. We must thus move the negation into an event clause or use two separate sentences. The event-clause version would look like:

<div class="interlinear-gloss-example example">
<a id="example-random-id-NILi"></a>

**Example 15.28. <a id="c15e2d18"></a>** 

The event-of (my \[false\] being-conscripted-into the Army) was aided by my uncle the Senator.

</div>  

It is possible that someone will want to incorporate bridi negations into lujvo. For this reason, the rafsi _\-nar-_ has been reserved for _<a id="id-1.16.4.47.2.1" class="indexterm"></a>[_na_](../go01#valsi-na)_. However, before using this rafsi, make sure that you intend the contradictory bridi negation, and not the scalar negation described in [Section 15.3](../section-scalar-negation) , which will be much more common in tanru and lujvo.