<a id="section-bridi-connection"></a>14.4. <a id="c14s4"></a>Logical connection of bridi
----------------------------------------------------------------------------------------

<a id="id-1.15.6.2.1" class="indexterm"></a><a id="id-1.15.6.2.2" class="indexterm"></a>Now we are ready to express [Example 14.1](../chapter-connectives#example-random-id-mJ6y) in Lojban! The kind of logical connective which is placed between two Lojban bridi to connect them logically is an ijek:

<div class="interlinear-gloss-example example">
<a id="example-random-id-h2hN"></a>

**Example 14.3. <a id="c14e4d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>nanmu</td><td>.ija</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>is-a-man</td><td>or</td><td>that-named</td><td>James</td><td>is-a-woman.</td></tr></tbody></table>

</div>  

Here we have two separate Lojban bridi, _<a id="id-1.15.6.4.1.1" class="indexterm"></a>la .djan. nanmu_ and _<a id="id-1.15.6.4.2.1" class="indexterm"></a>la .djeimyz. ninmu_. These bridi are connected by _<a id="id-1.15.6.4.3.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ _<a id="id-1.15.6.4.4.1" class="indexterm"></a>[_ja_](../go01#valsi-ja)_ , the ijek for the truth function A. The _<a id="id-1.15.6.4.6.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_ portion of the ijek tells us that we are dealing with separate sentences here. Similarly, we can now say:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qGiu"></a>

**Example 14.4. <a id="c14e4d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>nanmu</td><td>.ije</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>is-a-man</td><td>and</td><td>that-named</td><td>James</td><td>is-a-woman.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qGIu"></a>

**Example 14.5. <a id="c14e4d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>nanmu</td><td>.ijo</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>is-a-man</td><td>if-and-only-if</td><td>that-named</td><td>James</td><td>is-a-woman.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qgJC"></a>

**Example 14.6. <a id="c14e4d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>nanmu</td><td>.iju</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>is-a-man</td><td>whether-or-not</td><td>that-named</td><td>James</td><td>is-a-woman.</td></tr></tbody></table>

</div>  

<a id="id-1.15.6.8.1" class="indexterm"></a>To obtain the other truth tables listed in [Section 14.2](../section-four-basics) , we need to know how to negate the two bridi which represent the component sentences. We could negate them directly by inserting _<a id="id-1.15.6.8.3.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ before the selbri, but Lojban also allows us to place the negation within the connective itself.

<a id="id-1.15.6.9.1" class="indexterm"></a>To negate the first or left-hand bridi, prefix _<a id="id-1.15.6.9.2.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ to the JA cmavo but after the _<a id="id-1.15.6.9.3.1" class="indexterm"></a>[_.i_](../go01#valsi-i)_. To negate the second or right-hand bridi, suffix _<a id="id-1.15.6.9.4.1" class="indexterm"></a>\-nai_ to the JA cmavo. In either case, the negating word is placed on the side of the connective that is closest to the bridi being negated.

So to express the truth table FTTF, which requires O with either of the two bridi negated (not both), we can say either:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qgKB"></a>

**Example 14.7. <a id="c14e4d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>nanmu</td><td>.inajo</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>is-not-a-man</td><td>if-and-only-if</td><td>that-named</td><td>James</td><td>is-a-woman.</td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qgLH"></a>

**Example 14.8. <a id="c14e4d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>nanmu</td><td>.ijonai</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>is-a-man</td><td>if-and-only-if</td><td>that-named</td><td>James</td><td>is-not-a-woman.</td></tr></tbody></table>

</div>  

The meaning of both [Example 14.7](../section-bridi-connection#example-random-id-qgKB) and [Example 14.8](../section-bridi-connection#example-random-id-qgLH) is the same as that of:

<div class="example">
<a id="example-random-id-1Kp9"></a>

**Example 14.9. <a id="c14e4d7"></a>** 

John is a man or James is a woman, but not both.

</div>  

Here is another example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-FXSC"></a>

**Example 14.10. <a id="c14e4d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>nanmu</td><td>.ijanai</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>is-a-man</td><td>or</td><td>that-named</td><td>James</td><td>is-not-a-woman.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John is a man if James is a woman.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.6.17.1" class="indexterm"></a><a id="id-1.15.6.17.2" class="indexterm"></a>How's that again? Are those two English sentences in [Example 14.10](../section-bridi-connection#example-random-id-FXSC) really equivalent? In English, no. The Lojban TTFT truth function can be glossed “A if B” , but the “if” does not quite have its English sense. [Example 14.10](../section-bridi-connection#example-random-id-FXSC) is true so long as John is a man, even if James is not a woman; likewise, it is true just because James is not a woman, regardless of John's gender. This kind of “if-then” is technically known as a “material conditional”.

Since James is not a woman (by our assertions in [Section 14.1](../chapter-connectives#section-connectives-introduction)), the English sentence “John is a man if James is a woman” seems to be neither true nor false, since it assumes something which is not true. It turns out to be most convenient to treat this “if” as TTFT, which on investigation means that [Example 14.10](../section-bridi-connection#example-random-id-FXSC) is true. [Example 14.11](../section-bridi-connection#example-random-id-EdY5) , however, is equally true:

<div class="interlinear-gloss-example example">
<a id="example-random-id-EdY5"></a>

**Example 14.11. <a id="c14e4d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>ninmu</td><td>.ijanai</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>is-a-woman</td><td>if</td><td>that-named</td><td>James</td><td>is-a-woman.</td></tr></tbody></table>

</div>  

<a id="id-1.15.6.20.1" class="indexterm"></a><a id="id-1.15.6.20.2" class="indexterm"></a>This can be thought of as a principle of consistency, and may be paraphrased as follows: “If a false statement is true, any statement follows from it.” All uses of English “if” must be considered very carefully when translating into Lojban to see if they really fit this Lojban mold.

<a id="id-1.15.6.21.1" class="indexterm"></a><a id="id-1.15.6.21.2" class="indexterm"></a>[Example 14.12](../section-bridi-connection#example-random-id-9CCS) , which uses the TFTT truth function, is subject to the same rules: the stated gloss of TFTT as “only if” works naturally only when the right-hand bridi is false; if it is true, the left-hand bridi may be either true or false. The last gloss of [Example 14.12](../section-bridi-connection#example-random-id-9CCS) illustrates the use of “if ... then” as a more natural substitute for “only if”.

<div class="interlinear-gloss-example example">
<a id="example-random-id-9CCS"></a>

**Example 14.12. <a id="c14e4d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>nanmu</td><td>.inaja</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr><tr class="gloss"><td>That-named</td><td>John</td><td>is-not-a-man</td><td>or</td><td>that-named</td><td>James</td><td>is-a-woman.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John is a man only if James is a woman.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">If John is a man, then James is a woman.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.6.23.1" class="indexterm"></a>The following example illustrates the use of _<a id="id-1.15.6.23.2.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ to, in effect, exchange the two sentences. The normal use of _<a id="id-1.15.6.23.3.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ is to (in effect) transpose places of a bridi, as explained in [Section 5.11](../section-place-conversion).

<div class="interlinear-gloss-example example">
<a id="example-random-id-z43X"></a>

**Example 14.13. <a id="c14e4d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>.djan.</td><td>nanmu</td><td>.iseju</td><td>la</td><td>.djeimyz.</td><td>ninmu</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Whether or not John is a man, James is a woman.</p></td></tr></tbody></table>

</div>  

<a id="id-1.15.6.25.1" class="indexterm"></a><a id="id-1.15.6.25.2" class="indexterm"></a><a id="id-1.15.6.25.3" class="indexterm"></a>If both _<a id="id-1.15.6.25.4.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ and _<a id="id-1.15.6.25.5.1" class="indexterm"></a>[_se_](../go01#valsi-se)_ are present, which is legal but never necessary, _<a id="id-1.15.6.25.6.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ would come before _<a id="id-1.15.6.25.7.1" class="indexterm"></a>[_se_](../go01#valsi-se)_.

<a id="id-1.15.6.26.1" class="indexterm"></a><a id="id-1.15.6.26.2" class="indexterm"></a><a id="id-1.15.6.26.3" class="indexterm"></a>The full syntax of ijeks, therefore, is:

> .i \[na\] \[se\] JA \[nai\]

where the cmavo in brackets are optional.