<a id="section-basic-questions"></a>2.15. <a id="c2s15"></a>Questions
---------------------------------------------------------------------

<a id="id-1.3.17.2.1" class="indexterm"></a>There are many kinds of questions in Lojban: full explanations appear in [Section 19.5](../section-questions-and-answers) and in various other chapters throughout the book. In this chapter, we will introduce three kinds: sumti questions, selbri questions, and yes/no questions.

<a id="id-1.3.17.3.1" class="indexterm"></a><a id="id-1.3.17.3.2" class="indexterm"></a>The cmavo _<a id="id-1.3.17.3.3.1" class="indexterm"></a>[_ma_](../go01#valsi-ma)_ is used to create a sumti question: it indicates that the speaker wishes to know the sumti which should be placed at the location of the _<a id="id-1.3.17.3.4.1" class="indexterm"></a>[_ma_](../go01#valsi-ma)_ to make the bridi true. It can be translated as “Who?” or “What?” in most cases, but also serves for “When?”, “Where?”, and “Why?” when used in sumti places that express time, location, or cause. For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-k161"></a>

**Example 2.64. <a id="c2e15d1"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">ma</p></td><td><p class="selbri">tavla</p></td><td><p class="sumti">do</p></td><td><p class="sumti">mi</p></td></tr><tr class="gloss"><td><p class="sumti">Who?</p></td><td><p class="selbri">talks</p></td><td><p class="sumti">to-you</p></td><td><p class="sumti">about-me.</p></td></tr></tbody></table>

<table class="interlinear-gloss-itemized"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Who is talking to you about me?</p></td></tr></tbody></table>

</div>  

The listener can reply by simply stating a sumti:

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1Aa"></a>

**Example 2.65. <a id="c2e15d2"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">la djan.</p></td></tr></tbody></table>

<table class="interlinear-gloss-itemized"><tbody><tr class="para"><td colspan="12321"><p class="natlang">John (is talking to you about me).</p></td></tr></tbody></table>

</div>  

Like _<a id="id-1.3.17.7.1.1" class="indexterm"></a>[_ko_](../go01#valsi-ko)_, _<a id="id-1.3.17.7.2.1" class="indexterm"></a>[_ma_](../go01#valsi-ma)_ can occur in any position where a sumti is allowed, not just in the first position:

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1aE"></a>

**Example 2.66. <a id="c2e15d3"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">do</p></td><td><p class="elidable">[cu]</p></td><td><p class="selbri">tavla</p></td><td><p class="sumti">ma</p></td></tr><tr class="gloss"><td><p class="sumti">You</p></td><td><p class="elidable">-</p></td><td><p class="selbri">talk</p></td><td><p class="sumti">to what/whom?</p></td></tr></tbody></table>

</div>  

A _<a id="id-1.3.17.9.1.1" class="indexterm"></a>[_ma_](../go01#valsi-ma)_ can also appear in multiple sumti positions in one sentence, in effect asking several questions at once.

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1dc"></a>

**Example 2.67. <a id="c2e15d4"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">ma</p></td><td><p class="elidable">[cu]</p></td><td><p class="selbri">tavla</p></td><td><p class="sumti">ma</p></td></tr><tr class="gloss"><td><p class="sumti">What/Who</p></td><td><p class="elidable">-</p></td><td><p class="selbri">talks</p></td><td><p class="sumti">to what/whom?</p></td></tr></tbody></table>

</div>  

<a id="id-1.3.17.11.1" class="indexterm"></a>The two separate _<a id="id-1.3.17.11.2.1" class="indexterm"></a>[_ma_](../go01#valsi-ma)_ positions ask two separate questions, and can therefore be answered with different values in each sumti place.

<a id="id-1.3.17.12.1" class="indexterm"></a><a id="id-1.3.17.12.2" class="indexterm"></a>The cmavo _<a id="id-1.3.17.12.3.1" class="indexterm"></a>[_mo_](../go01#valsi-mo)_ is the selbri analogue of _<a id="id-1.3.17.12.4.1" class="indexterm"></a>[_ma_](../go01#valsi-ma)_. It asks the respondent to provide a selbri that would be a true relation if inserted in place of the _<a id="id-1.3.17.12.5.1" class="indexterm"></a>[_mo_](../go01#valsi-mo)_:

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1DE"></a>

**Example 2.68. <a id="c2e15d5"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">do</p></td><td><p class="elidable">[cu]</p></td><td><p class="selbri">mo</p></td></tr><tr class="gloss"><td><p class="sumti">You</p></td><td><p class="elidable">-</p></td><td><p class="selbri">are-what/do-what?</p></td></tr></tbody></table>

</div>  

A _<a id="id-1.3.17.14.1.1" class="indexterm"></a>[_mo_](../go01#valsi-mo)_ may be used anywhere a brivla or other selbri might. Keep this in mind for later examples. Unfortunately, by itself, _<a id="id-1.3.17.14.2.1" class="indexterm"></a>[_mo_](../go01#valsi-mo)_ is a very non-specific question. The response to the question in [Example 2.68](../section-basic-questions#example-random-id-k1DE) could be:

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1DR"></a>

**Example 2.69. <a id="c2e15d6"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">mi</p></td><td><p class="elidable">[cu]</p></td><td><p class="selbri">melbi</p></td></tr></tbody></table>

<table class="interlinear-gloss-itemized"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am beautiful.</p></td></tr></tbody></table>

</div>  

or:

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1gh"></a>

**Example 2.70. <a id="c2e15d7"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">mi</p></td><td><p class="elidable">[cu]</p></td><td><p class="selbri">tavla</p></td></tr></tbody></table>

<table class="interlinear-gloss-itemized"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I talk.</p></td></tr></tbody></table>

</div>  

<a id="id-1.3.17.18.1" class="indexterm"></a>Clearly, _<a id="id-1.3.17.18.2.1" class="indexterm"></a>[_mo_](../go01#valsi-mo)_ requires some cooperation between the speaker and the respondent to ensure that the right question is being answered. If context doesn't make the question specific enough, the speaker must ask the question more specifically using a more complex construction such as a tanru (see [Section 2.9](../section-basic-tanru)).

It is perfectly permissible for the respondent to fill in other unspecified places in responding to a _<a id="id-1.3.17.19.1.1" class="indexterm"></a>[_mo_](../go01#valsi-mo)_ question. Thus, the respondent in [Example 2.70](../section-basic-questions#example-random-id-k1gh) could have also specified an audience, a topic, and/or a language in the response.

<a id="id-1.3.17.20.1" class="indexterm"></a>Finally, we must consider questions that can be answered “Yes” or “No”, such as

<div class="example">
<a id="example-random-id-fVMN"></a>

**Example 2.71. <a id="c2e15d8"></a>** 

Are you talking to me?

</div>  

Like all yes-or-no questions in English, [Example 2.71](../section-basic-questions#example-random-id-fVMN) may be reformulated as

<div class="example">
<a id="example-random-id-648w"></a>

**Example 2.72. <a id="c2e15d9"></a>** 

Is it true that you are talking to me?

</div>  

In Lojban we have a word that asks precisely that question in precisely the same way. The cmavo _<a id="id-1.3.17.24.1.1" class="indexterm"></a>[_xu_](../go01#valsi-xu)_, when placed in front of a bridi, asks whether that bridi is true as stated. So

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1gp"></a>

**Example 2.73. <a id="c2e15d10"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="cmavo">xu</p></td><td><p class="sumti">do</p></td><td><p class="selbri">tavla</p></td><td><p class="sumti">mi</p></td></tr><tr class="gloss"><td><p class="cmavo">Is-it-true-that</p></td><td><p class="sumti">you</p></td><td><p class="selbri">are-talking</p></td><td><p class="sumti">to-me?</p></td></tr></tbody></table>

</div>  

is the Lojban translation of [Example 2.71](../section-basic-questions#example-random-id-fVMN).

<a id="id-1.3.17.27.1" class="indexterm"></a><a id="id-1.3.17.27.2" class="indexterm"></a><a id="id-1.3.17.27.3" class="indexterm"></a>The answer “Yes” may be given by simply restating the bridi without the _<a id="id-1.3.17.27.5.1" class="indexterm"></a>[_xu_](../go01#valsi-xu)_ question word. Lojban has a shorthand for doing this with the word _<a id="id-1.3.17.27.6.1" class="indexterm"></a>[_go'i_](../go01#valsi-gohi)_, mentioned in [Section 2.11](../section-some-brivla). Instead of a negative answer, the bridi may be restated in such a way as to make it true. If this can be done by substituting sumti, it may be done with _<a id="id-1.3.17.27.8.1" class="indexterm"></a>[_go'i_](../go01#valsi-gohi)_ as well. For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1gU"></a>

**Example 2.74. <a id="id-1.3.17.28.1.1" class="indexterm"></a><a id="c2e15d11"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="cmavo">xu</p></td><td><p class="sumti">do</p></td><td><p class="selbri">kanro</p></td></tr></tbody></table>

<table class="interlinear-gloss-itemized"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Are you healthy?</p></td></tr></tbody></table>

</div>  

can be answered with

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1iE"></a>

**Example 2.75. <a id="id-1.3.17.30.1.1" class="indexterm"></a><a id="c2e15d12"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">mi</p></td><td><p class="selbri">kanro</p></td></tr></tbody></table>

<table class="interlinear-gloss-itemized"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am healthy.</p></td></tr></tbody></table>

</div>  

or

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1JT"></a>

**Example 2.76. <a id="id-1.3.17.32.1.1" class="indexterm"></a><a id="c2e15d13"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="selbri">go'i</p></td></tr></tbody></table>

<table class="interlinear-gloss-itemized"><tbody><tr class="para"><td colspan="12321"><p class="natlang">I am healthy.</p></td></tr></tbody></table>

</div>  

(Note that _<a id="id-1.3.17.33.1.1" class="indexterm"></a>[_do_](../go01#valsi-do)_ to the questioner is _<a id="id-1.3.17.33.2.1" class="indexterm"></a>[_mi_](../go01#valsi-mi)_ to the respondent.)

or

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1jY"></a>

**Example 2.77. <a id="id-1.3.17.35.1.1" class="indexterm"></a><a id="c2e15d14"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">le tavla</p></td><td><p class="elidable">cu</p></td><td><p class="selbri">kanro</p></td></tr></tbody></table>

<table class="interlinear-gloss-itemized"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The talker is healthy.</p></td></tr></tbody></table>

</div>  

or

<div class="interlinear-gloss-example example">
<a id="example-random-id-k1LE"></a>

**Example 2.78. <a id="id-1.3.17.37.1.1" class="indexterm"></a><a id="c2e15d15"></a>** 

<table class="interlinear-gloss-itemized"><colgroup></colgroup><tbody><tr class="jbo"><td><p class="sumti">le tavla</p></td><td><p class="elidable">cu</p></td><td><p class="selbri">go'i</p></td></tr></tbody></table>

<table class="interlinear-gloss-itemized"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The talker is healthy.</p></td></tr></tbody></table>

</div>  

<a id="id-1.3.17.38.1" class="indexterm"></a>A general negative answer may be given by _<a id="id-1.3.17.38.2.1" class="indexterm"></a>na go'i_. _<a id="id-1.3.17.38.3.1" class="indexterm"></a>[_na_](../go01#valsi-na)_ may be placed before any selbri (but after the _<a id="id-1.3.17.38.4.1" class="indexterm"></a>[_cu_](../go01#valsi-cu)_). It is equivalent to stating “It is not true that ...” before the bridi. It does not imply that anything else is true or untrue, only that that specific bridi is not true. More details on negative statements are available in [Chapter 15](../chapter-negation).