<a id="section-basic-phonetics"></a>3.2. <a id="c3s2"></a>Basic phonetics
-------------------------------------------------------------------------

<a id="id-1.4.4.2.1" class="indexterm"></a><a id="id-1.4.4.2.2" class="indexterm"></a><a id="id-1.4.4.2.3" class="indexterm"></a><a id="id-1.4.4.2.4" class="indexterm"></a>Lojban pronunciations are defined using the International Phonetic Alphabet, or IPA, a standard method of transcribing pronunciations. By convention, IPA transcriptions are always within square brackets: for example, the word “cat” is pronounced (in General American pronunciation) \[kæt\]. [Section 3.10](../section-anglophone-phonetics) contains a brief explanation of the IPA characters used in this chapter, with their nearest analogues in English, and will be especially useful to those not familiar with the technical terms used in describing speech sounds.

<a id="id-1.4.4.3.1" class="indexterm"></a><a id="id-1.4.4.3.2" class="indexterm"></a>The standard pronunciations and permitted variants of the Lojban letters are listed in the table below. The descriptions have deliberately been made a bit ambiguous to cover variations in pronunciation by speakers of different native languages and dialects. In all cases except _r_ the first IPA symbol shown represents the preferred pronunciation; for _r_ , all of the variations (and any other rhotic sound) are equally acceptable.

| Letter | IPA | X-SAMPA | Description |
| --- | --- | --- | --- |
| _'_ | \[h\] | \[h\] | an unvoiced glottal spirant |
| _,_ | . | . | the syllable separator |
| _._ | \[ʔ\] | \[?\] | a glottal stop or a pause |
| _a_ | \[a\] , \[ɑ\] | \[a\] , \[A\] | an open vowel |
| _b_ | \[b\] | \[b\] | a voiced bilabial stop |
| _c_ | \[ʃ\] , \[ʂ\] | \[S\] , \[s\`\] | a voiceless postalveolar fricative |
| _d_ | \[d\] | \[d\] | a voiced dental/alveolar stop |
| _e_ | \[ɛ\] , \[e\] | \[E\] , \[e\] | a front mid vowel |
| _f_ | \[f\] , \[ɸ\] | \[f\] , \[p\\\] | an unvoiced labial fricative |
| _g_ | \[ɡ\] | \[g\] | a voiced velar stop |
| _i_ | \[i\] | \[i\] | a front close vowel |
| _j_ | \[ʒ\] , \[ʐ\] | \[Z\] , \[z\`\] | a voiced postalveolar fricative |
| _k_ | \[k\] | \[k\] | an unvoiced velar stop |
| _l_ | \[l\] , \[l̩\] | \[l\] , \[l=\] | a voiced lateral approximant (may be syllabic) |
| _m_ | \[m\] , \[m̩\] | \[m\] , \[m=\] | a voiced bilabial nasal (may be syllabic) |
| _n_ | \[n\] , \[n̩\] , \[ŋ\] , \[ŋ̍\] | \[n\] , \[n=\] , \[N\] , \[N=\] | a voiced dental or velar nasal (may be syllabic) |
| _o_ | \[o\] , \[ɔ\] | \[o\] , \[O\] | a back mid vowel |
| _p_ | \[p\] | \[p\] | an unvoiced bilabial stop |
| _r_ | \[r\] , \[ɹ\] , \[ɾ\] , \[ʀ\] , \[r̩\] , \[ɹ̩\] , \[ʀ̩\] | \[r\] , \[r\\\] , \[4\] , \[R\\\] , \[r=\] , \[r\\=\] , \[R\\=\] | a rhotic sound |
| _s_ | \[s\] | \[s\] | an unvoiced alveolar sibilant |
| _t_ | \[t\] | \[t\] | an unvoiced dental/alveolar stop |
| _u_ | \[u\] | \[u\] | a back close vowel |
| _v_ | \[v\] , \[β\] | \[v\] , \[B\] | a voiced labial fricative |
| _x_ | \[x\] | \[x\] | an unvoiced velar fricative |
| _y_ | \[ə\] | \[@\] | a central mid vowel |
| _z_ | \[z\] | \[z\] | a voiced alveolar sibilant |

<a id="id-1.4.4.5.1" class="indexterm"></a><a id="id-1.4.4.5.2" class="indexterm"></a><a id="id-1.4.4.5.3" class="indexterm"></a><a id="id-1.4.4.5.4" class="indexterm"></a><a id="id-1.4.4.5.5" class="indexterm"></a>The Lojban sounds must be clearly pronounced so that they are not mistaken for each other. Voicing and placement of the tongue are the key factors in correct pronunciation, but other subtle differences will develop between consonants in a Lojban-speaking community. At this point these are the only mandatory rules on the range of sounds.

<a id="id-1.4.4.6.1" class="indexterm"></a>Note in particular that Lojban vowels can be pronounced with either rounded or unrounded lips; typically _o_ and _u_ are rounded and the others are not, as in English, but this is not a requirement; some people round _y_ as well. Lojban consonants can be aspirated or unaspirated. Palatalizing of consonants, as found in Russian and other languages, is not generally acceptable in pronunciation, though a following _i_ may cause it.

<a id="id-1.4.4.7.1" class="indexterm"></a><a id="id-1.4.4.7.2" class="indexterm"></a>The sounds represented by the letters _c_ , _g_ , _j_ , _s_ , and _x_ require special attention for speakers of English, either because they are ambiguous in the orthography of English ( _c_ , _g_ , _s_), or because they are strikingly different in Lojban ( _c_ , _j_ , _x_). The English “c” represents three different sounds, \[k\] in “cat” and \[s\] in “cent” , as well as the \[ʃ\] of “ocean”. Similarly, English “g” can represent \[ɡ\] as in “go” , \[dʒ\] as in “gentle” , and \[ʒ\] as in the second "g" in “garage” (in some pronunciations). English “s” can be either \[s\] as in “cats” , \[z\] as in “cards” , \[ʃ\] as in “tension” , or \[ʒ\] as in “measure”. The sound of Lojban _x_ doesn't appear in most English dialects at all.

<a id="id-1.4.4.8.1" class="indexterm"></a><a id="id-1.4.4.8.2" class="indexterm"></a><a id="id-1.4.4.8.3" class="indexterm"></a><a id="id-1.4.4.8.4" class="indexterm"></a>There are two common English sounds that are found in Lojban but are not Lojban consonants: the “ch” of “church” and the “j” of “judge”. In Lojban, these are considered two consonant sounds spoken together without an intervening vowel sound, and so are represented in Lojban by the two separate consonants: _tc_ (IPA \[tʃ\]) and _dj_ (IPA \[dʒ\]). In general, whether a complex sound is considered one sound or two depends on the language: Russian views “ts” as a single sound, whereas English, French, and Lojban consider it to be a consonant cluster.