<a id="section-basic-descriptors"></a>6.2. <a id="c6s2"></a>The three basic description types
---------------------------------------------------------------------------------------------

<a id="id-1.7.4.2.1" class="indexterm"></a>The following cmavo are discussed in this section:

<table class="cmavo-list"><colgroup></colgroup><tbody><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">le</p></td><td class="selmaho"><p class="selmaho">LE</p></td><td class="description"><p class="description">the, the one(s) described as</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">lo</p></td><td class="selmaho"><p class="selmaho">LE</p></td><td class="description"><p class="description">some, some of those which really are</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">la</p></td><td class="selmaho"><p class="selmaho">LA</p></td><td class="description"><p class="description">the one(s) named</p></td></tr><tr class="cmavo-entry"><td class="cmavo"><p class="cmavo">ku</p></td><td class="selmaho"><p class="selmaho">KU</p></td><td class="description"><p class="description">elidable terminator for LE, LA</p></td></tr></tbody></table>

<a id="id-1.7.4.4.1" class="indexterm"></a><a id="id-1.7.4.4.2" class="indexterm"></a><a id="id-1.7.4.4.3" class="indexterm"></a><a id="id-1.7.4.4.4" class="indexterm"></a>The syntax of descriptions is fairly complex, and not all of it can be explained within the confines of this chapter: relative clauses, in particular, are discussed in [Chapter 8](../chapter-relative-clauses). However, most descriptions have just two components: a descriptor belonging to selma'o LE or LA, and a selbri. (The difference between selma'o LE and selma'o LA is not important until [Section 6.12](../section-names).) Furthermore, the selbri is often just a single brivla. Here is an elementary example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-rBuQ"></a>

**Example 6.5. <a id="c6e2d1"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>zarci</td></tr><tr class="gloss"><td>one-or-more-specific-things-each-of-which-I-describe-as</td><td>being-a-market</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">the market</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.4.6.1" class="indexterm"></a>The long gloss for _<a id="id-1.7.4.6.2.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ is of course far too long to use most of the time, and in fact _<a id="id-1.7.4.6.3.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ is quite close in meaning to English “the”. It has particular implications, however, which “the” does not have.

<a id="id-1.7.4.7.1" class="indexterm"></a><a id="id-1.7.4.7.2" class="indexterm"></a>The general purpose of all descriptors is to create a sumti which might occur in the x1 place of the selbri belonging to the description. Thus _<a id="id-1.7.4.7.4.1" class="indexterm"></a>le zarci_ conveys something which might be found in the x1 place of _<a id="id-1.7.4.7.6.1" class="indexterm"></a>[_zarci_](../go01#valsi-zarci)_ , namely a market.

<a id="id-1.7.4.8.1" class="indexterm"></a><a id="id-1.7.4.8.2" class="indexterm"></a><a id="id-1.7.4.8.3" class="indexterm"></a>The specific purpose of _<a id="id-1.7.4.8.4.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ is twofold. First, it indicates that the speaker has one or more specific markets in mind (whether or not the listener knows which ones they are). Second, it also indicates that the speaker is merely describing the things he or she has in mind as markets, without being committed to the truth of that description.

<div class="interlinear-gloss-example example">
<a id="example-random-id-ULGC"></a>

**Example 6.6. <a id="c6e2d2"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>zarci</td><td>cu</td><td>barda</td></tr><tr class="gloss"><td>One-or-more-specific-things-which-I-describe-as</td><td><span class="quote">“<span class="quote">markets</span>”</span></td><td></td><td>is/are-big.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The market is big.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">The markets are big.</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.4.10.1" class="indexterm"></a>Note that English-speakers must state whether a reference to markets is to just one ( “the market”) or to more than one ( “the markets”). Lojban requires no such forced choice, so both colloquial translations of [Example 6.6](../section-basic-descriptors#example-random-id-ULGC) are valid. Only the context can specify which is meant. (This rule does not mean that Lojban has no way of specifying the number of markets in such a case: that mechanism is explained in [Section 6.7](../section-quantified-descriptions).)

Now consider the following strange-looking example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-PutX"></a>

**Example 6.7. <a id="id-1.7.4.12.1.1" class="indexterm"></a><a id="c6e2d3"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>nanmu</td><td>cu</td><td>ninmu</td></tr><tr class="gloss"><td>One-or-more-specific-things-which-I-describe-as</td><td><span class="quote">“<span class="quote">men</span>”</span></td><td></td><td>is/are-women.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The man is a woman.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">The men are women.</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.4.13.1" class="indexterm"></a>[Example 6.7](../section-basic-descriptors#example-random-id-PutX) is not self-contradictory in Lojban, because _<a id="id-1.7.4.13.3.1" class="indexterm"></a>le nanmu_ merely means something or other which, for my present purposes, I choose to describe as a man, whether or not it really is a man. A plausible instance would be: someone we had assumed to be a man at a distance turned out to be actually a woman on closer observation. [Example 6.7](../section-basic-descriptors#example-random-id-PutX) is what I would say to point out my observation to you.

<a id="id-1.7.4.14.1" class="indexterm"></a><a id="id-1.7.4.14.2" class="indexterm"></a>In all descriptions with _<a id="id-1.7.4.14.3.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ , the listener is presumed to either know what I have in mind or else not to be concerned at present (perhaps I will give more identifying details later). In particular, I might be pointing at the supposed man or men: [Example 6.7](../section-basic-descriptors#example-random-id-PutX) would then be perfectly intelligible, since _<a id="id-1.7.4.14.5.1" class="indexterm"></a>le nanmu_ merely clarifies that I am pointing at the supposed man, not at a landscape, or a nose, which happens to lie in the same direction.

<a id="id-1.7.4.15.1" class="indexterm"></a><a id="id-1.7.4.15.2" class="indexterm"></a><a id="id-1.7.4.15.3" class="indexterm"></a>The second descriptor dealt with in this section is _<a id="id-1.7.4.15.4.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_. Unlike _<a id="id-1.7.4.15.5.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ , _<a id="id-1.7.4.15.6.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ is nonspecific:

<div class="interlinear-gloss-example example">
<a id="example-random-id-t11z"></a>

**Example 6.8. <a id="c6e2d4"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>zarci</td></tr><tr class="gloss"><td>one-or-more-of-all-the-things-which-really</td><td>are-markets</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">a market</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">some markets</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.4.17.1" class="indexterm"></a><a id="id-1.7.4.17.2" class="indexterm"></a><a id="id-1.7.4.17.3" class="indexterm"></a><a id="id-1.7.4.17.4" class="indexterm"></a><a id="id-1.7.4.17.5" class="indexterm"></a>Again, there are two colloquial English translations. The effect of using _<a id="id-1.7.4.17.6.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ in [Example 6.8](../section-basic-descriptors#example-random-id-t11z) is to refer generally to one or more markets, without being specific about which. Unlike _<a id="id-1.7.4.17.8.1" class="indexterm"></a>le zarci_ , _<a id="id-1.7.4.17.9.1" class="indexterm"></a>lo zarci_ must refer to something which actually is a market (that is, which can appear in the x1 place of a truthful bridi whose selbri is _<a id="id-1.7.4.17.11.1" class="indexterm"></a>[_zarci_](../go01#valsi-zarci)_). Thus

<div class="interlinear-gloss-example example">
<a id="example-random-id-fSxN"></a>

**Example 6.9. <a id="c6e2d5"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>nanmu</td><td>cu</td><td>ninmu</td></tr><tr class="gloss"><td>That-which-really-is</td><td>a-man</td><td></td><td>is-a-woman.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Some man is a woman.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">Some men are women.</p></td></tr></tbody></table>

</div>  

must be false in Lojban, given that there are no objects in the real world which are both men and women. Pointing at some specific men or women would not make [Example 6.9](../section-basic-descriptors#example-random-id-fSxN) true, because those specific individuals are no more both-men-and-women than any others. In general, _<a id="id-1.7.4.19.2.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_ refers to whatever individuals meet its description.

<a id="id-1.7.4.20.1" class="indexterm"></a><a id="id-1.7.4.20.2" class="indexterm"></a><a id="id-1.7.4.20.3" class="indexterm"></a><a id="id-1.7.4.20.4" class="indexterm"></a>The last descriptor of this section is _<a id="id-1.7.4.20.5.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ , which indicates that the selbri which follows it has been dissociated from its normal meaning and is being used as a name. Like _<a id="id-1.7.4.20.6.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ descriptions, _<a id="id-1.7.4.20.7.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ descriptions are implicitly restricted to those I have in mind. (Do not confuse this use of _<a id="id-1.7.4.20.8.1" class="indexterm"></a>[_la_](../go01#valsi-la)_ with its use before regular Lojbanized names, which is discussed in [Section 6.12](../section-names).) For example:

<div class="interlinear-gloss-example example">
<a id="example-random-id-PrGp"></a>

**Example 6.10. <a id="id-1.7.4.21.1.1" class="indexterm"></a><a id="c6e2d6"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>cribe</td><td>pu</td><td>finti</td><td>le</td><td>lisri</td></tr><tr class="gloss"><td>That-named</td><td><span class="quote">“<span class="quote">bear</span>”</span></td><td>[past]</td><td>creates</td><td>the</td><td>story.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">Bear wrote the story.</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.4.22.1" class="indexterm"></a>In [Example 6.10](../section-basic-descriptors#example-random-id-PrGp) , _<a id="id-1.7.4.22.3.1" class="indexterm"></a>la cribe_ refers to someone whose naming predicate is _<a id="id-1.7.4.22.4.1" class="indexterm"></a>[_cribe_](../go01#valsi-cribe)_ , i.e. “Bear”. In English, most names don't mean anything, or at least not anything obvious. The name “Frank” coincides with the English word “frank” , meaning “honest” , and so one way of translating “Frank ate some cheese” into Lojban would be:

<div class="interlinear-gloss-example example">
<a id="example-random-id-yyBX"></a>

**Example 6.11. <a id="c6e2d7"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>la</td><td>stace</td><td>pu</td><td>citka</td><td>lo</td><td>cirla</td></tr><tr class="gloss"><td>That-named</td><td><span class="quote">“<span class="quote">Honest/Frank</span>”</span></td><td>[past]</td><td>eats</td><td>some</td><td>cheese.</td></tr></tbody></table>

</div>  

English-speakers typically would not do this, as we tend to be more attached to the sound of our names than their meaning, even if the meaning (etymological or current) is known. Speakers of other languages may feel differently. (In point of fact, “Frank” originally meant “the free one” rather than “the honest one”.)

<a id="id-1.7.4.25.1" class="indexterm"></a>It is important to note the differences between [Example 6.10](../section-basic-descriptors#example-random-id-PrGp) and the following:

<div class="interlinear-gloss-example example">
<a id="example-random-id-nXyo"></a>

**Example 6.12. <a id="c6e2d8"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>cribe</td><td>pu</td><td>finti</td><td>le</td><td>lisri</td></tr><tr class="gloss"><td>One-or-more-specific-things-which-I-describe-as</td><td>bears</td><td>[past]</td><td>creates</td><td>the</td><td>story.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The bear(s) wrote the story.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-93Yv"></a>

**Example 6.13. <a id="c6e2d9"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>cribe</td><td>pu</td><td>finti</td><td>le</td><td>lisri</td></tr><tr class="gloss"><td>One-or-more-of-the-things-which-really</td><td>are-bears</td><td>[past]</td><td>creates</td><td>the</td><td>story.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">A bear wrote the story.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">Some bears wrote the story.</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.4.28.1" class="indexterm"></a>[Example 6.12](../section-basic-descriptors#example-random-id-nXyo) is about a specific bear or bearlike thing(s), or thing(s) which the speaker (perhaps whimsically or metaphorically) describes as a bear (or more than one); [Example 6.13](../section-basic-descriptors#example-random-id-93Yv) is about one or more of the really existing, objectively defined bears. In either case, though, each of them must have contributed to the writing of the story, if more than one bear (or “bear”) is meant.

<a id="id-1.7.4.29.1" class="indexterm"></a>(The notion of a “really existing, objectively defined bear” raises certain difficulties. Is a panda bear a “real bear” ? How about a teddy bear? In general, the answer is “yes”. Lojban gismu are defined as broadly as possible, allowing tanru and lujvo to narrow down the definition. There probably are no necessary and sufficient conditions for defining what is and what is not a bear that can be pinned down with complete precision: the real world is fuzzy. In borderline cases, _<a id="id-1.7.4.29.5.1" class="indexterm"></a>[_le_](../go01#valsi-le)_ may communicate better than _<a id="id-1.7.4.29.6.1" class="indexterm"></a>[_lo_](../go01#valsi-lo)_.)

So while [Example 6.10](../section-basic-descriptors#example-random-id-PrGp) could easily be true (there is a real writer named “Greg Bear”), and [Example 6.12](../section-basic-descriptors#example-random-id-nXyo) could be true if the speaker is sufficiently peculiar in what he or she describes as a bear, [Example 6.13](../section-basic-descriptors#example-random-id-93Yv) is certainly false.

Similarly, compare the following two examples, which are analogous to [Example 6.12](../section-basic-descriptors#example-random-id-nXyo) and [Example 6.13](../section-basic-descriptors#example-random-id-93Yv) respectively:

<div class="interlinear-gloss-example example">
<a id="example-random-id-qKw7"></a>

**Example 6.14. <a id="c6e2d10"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>le</td><td>remna</td><td>pu</td><td>finti</td><td>le</td><td>lisri</td></tr><tr class="gloss"><td>Those-described-as</td><td>a-human</td><td>[past]</td><td>writes</td><td>that-described-as</td><td>a-story.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">The human being(s) wrote the story.</p></td></tr></tbody></table>

</div>  
<div class="interlinear-gloss-example example">
<a id="example-random-id-qKYf"></a>

**Example 6.15. <a id="c6e2d11"></a>** 

<table class="interlinear-gloss"><colgroup></colgroup><tbody><tr class="jbo"><td>lo</td><td>remna</td><td>pu</td><td>finti</td><td>le</td><td>lisri</td></tr><tr class="gloss"><td>That-which-really-is</td><td>a-human</td><td>[past]</td><td>writes</td><td>that-described-as</td><td>a-story.</td></tr></tbody></table>

<table class="interlinear-gloss"><tbody><tr class="para"><td colspan="12321"><p class="natlang">A human being wrote the story.</p></td></tr><tr class="para"><td colspan="12321"><p class="natlang">Some human beings wrote the story.</p></td></tr></tbody></table>

</div>  

<a id="id-1.7.4.34.1" class="indexterm"></a><a id="id-1.7.4.34.2" class="indexterm"></a>[Example 6.14](../section-basic-descriptors#example-random-id-qKw7) says who the author of the story is: one or more particular human beings that the speaker has in mind. If the topic of conversation is the story, then [Example 6.14](../section-basic-descriptors#example-random-id-qKw7) identifies the author as someone who can be pointed out or who has been previously mentioned; whereas if the topic is a person, then _<a id="id-1.7.4.34.5.1" class="indexterm"></a>le remna_ is in effect a shorthand reference to that person. [Example 6.15](../section-basic-descriptors#example-random-id-qKYf) merely says that the author is human.

<a id="id-1.7.4.35.1" class="indexterm"></a><a id="id-1.7.4.35.2" class="indexterm"></a><a id="id-1.7.4.35.3" class="indexterm"></a><a id="id-1.7.4.35.4" class="indexterm"></a>The elidable terminator for all descriptions is _<a id="id-1.7.4.35.5.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_. It can almost always be omitted with no danger of ambiguity. The main exceptions are in certain uses of relative clauses, which are discussed in [Section 8.6](../section-descriptors) , and in the case of a description immediately preceding the selbri. In this latter case, using an explicit _<a id="id-1.7.4.35.7.1" class="indexterm"></a>[_cu_](../go01#valsi-cu)_ before the selbri makes the _<a id="id-1.7.4.35.8.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ unnecessary. There are also a few other uses of _<a id="id-1.7.4.35.9.1" class="indexterm"></a>[_ku_](../go01#valsi-ku)_ : in the compound negator _<a id="id-1.7.4.35.10.1" class="indexterm"></a>naku_ (discussed in [Chapter 16](../chapter-quantifiers)) and to terminate place-structure, tense, and modal tags that do not have associated sumti (discussed in [Chapter 9](../chapter-sumti-tcita) and [Chapter 10](../chapter-tenses)).