<a id="section-attitudinals-conclusion"></a>13.16. <a id="c13s16"></a>Tentative conclusion
------------------------------------------------------------------------------------------

<a id="id-1.14.18.2.1" class="indexterm"></a><a id="id-1.14.18.2.2" class="indexterm"></a><a id="id-1.14.18.2.3" class="indexterm"></a>The exact ramifications of the indicator system in actual usage are unknown. There has never been anything like it in natural language before. The system provides great potential for emotional expression and transcription, from which significant Sapir-Whorf effects can be anticipated. When communicating across cultural boundaries, where different indicators are often used for the same emotion, accidental offense can be avoided. If we ever ran into an alien race, a culturally neutral language of emotion could be vital. (A classic example, taken from the science fiction of Larry Niven, is to imagine speaking Lojban to the carnivorous warriors called Kzinti, noting that a human smile bares the teeth, and could be seen as an intent to attack.) And for communicating emotions to computers, when we cannot identify all of the signals involved in subliminal human communication (things like body language are also cultural), a system like this is needed.

<a id="id-1.14.18.3.1" class="indexterm"></a>We have tried to err on the side of overkill. There are distinctions possible in this system that no one may care to make in any culture. But it was deemed more neutral to overspecify and let usage decide, than to choose a limited set and constrain emotional expression. For circumstances in which even the current indicator set is not enough, it is possible using the cmavo _<a id="id-1.14.18.3.2.1" class="indexterm"></a>[_sei_](../go01#valsi-sei)_ , explained in [Section 19.12](../section-parentheses) , to create metalinguistic comments that act like indicators.

<a id="id-1.14.18.4.1" class="indexterm"></a>We envision an evolutionary development. At this point, the system is little more than a mental toy. Many of you who read this will try playing around with various combinations of indicators, trying to figure out what emotions they express and when the expressions might be useful. You may even find an expression for which there currently is no good English word and start using it. Why not, if it helps you express your feelings?

There will be a couple dozen of these used pretty much universally – mostly just simple attitudinals with, at most, intensity markers. These are the ones that will quickly be expressed at the subconscious level. But every Lojbanist who plays with the list will bring in a couple of new words. Poets will paint emotional pictures, and people who identify with those pictures will use the words so created for their own experiences.

Just as a library of tanru is built up, so will a library of attitudes be built. Unlike the tanru, though, the emotional expressions are built on some fairly nebulous root emotions – words that cannot be defined with the precision of the gismu. The emotion words of Lojban will very quickly take on a life of their own, and the outline given here will evolve into a true system of emotions.

<a id="id-1.14.18.7.1" class="indexterm"></a><a id="id-1.14.18.7.2" class="indexterm"></a>There are several theories as to the nature of emotion, and they change from year to year as we learn more about ourselves. Whether or not Lojban's additive/scalar emotional model is an accurate model for human emotions, it does support the linguistic needs for expressing those emotions. Researchers may learn more about the nature of human emotions by exploring the use of the system by Lojban speakers. They also may be able to use the Lojban system as a means for more clearly recording emotions.

<a id="id-1.14.18.8.1" class="indexterm"></a>The full list of scales and attitudes will probably not be used until someone speaks the language from birth. Until then, people will use the attitudes that are important to them. In this way, we counter cultural bias – if a culture is prone to recognizing and/or expressing certain emotions more than others, its members will use only those out of the enormous set available. If a culture hides certain emotions, its members simply won't express them.

<a id="id-1.14.18.9.1" class="indexterm"></a>Perhaps native Lojban speakers will be more expressively clear about their emotions than others. Perhaps they will feel some emotions more strongly than others in ways that can be correlated with the word choices; any difference from the norms of other cultures could be significant. Psychologists have devised elaborate tests for measuring attitudes and personality; this may be the easiest area in which to detect any systematic cultural effect of the type sought to confirm Sapir-Whorf, simply because we already have tools in existence to test it. Because Lojban is unique among languages in having such extensive and expressive indicators, it is likely that a Sapir-Whorf effect will occur and will be recognized.

It is unlikely that we will know the true potential of a system like this one until and unless we have children raised entirely in a multi-cultural Lojban-speaking environment. We learn too many cultural habits in the realm of emotional communication “at our mother's knee”. Such children will have a Lojban system that has stronger reinforcement than any typical culture system. The second generation of such children, then, could be said to be the start of a true Lojbanic culture.

<a id="id-1.14.18.11.1" class="indexterm"></a>We shouldn't need to wait that long to detect significant effects. Emotion is so basic to our lives that even a small change or improvement in emotional communication would have immediately noticeable effects. Perhaps it will be the case that the most important contribution of our “logical language” will be in the non-logical realm of emotion!