<a id="section-asymmetric-tanru"></a>5.14. <a id="c5s14"></a>Some types of asymmetrical tanru
---------------------------------------------------------------------------------------------

<a id="id-1.6.16.2.1" class="indexterm"></a><a id="id-1.6.16.2.2" class="indexterm"></a>This section and [Section 5.15](../section-symmetric-tanru) contain some example tanru classified into groups based on the type of relationship between the modifying seltau and the modified tertau. All the examples are paralleled by compounds actually observed in various natural languages. In the tables which follow, each group is preceded by a brief explanation of the relationship. The tables themselves contain a tanru, a literal gloss, the languages which exhibit a compound analogous to this tanru, and (for those tanru with no English parallel) a translation.

<a id="id-1.6.16.3.1" class="indexterm"></a>The tanru discussed in this section are asymmetrical tanru; that is, ones in which the order of the terms is fundamental to the meaning of the tanru. For example, _<a id="id-1.6.16.3.2.1" class="indexterm"></a>junla dadysli_, or “clock pendulum”, is the kind of pendulum used in a clock, whereas _<a id="id-1.6.16.3.4.1" class="indexterm"></a>dadysli junla_, or “pendulum clock”, is the kind of clock that employs a pendulum. Most tanru are asymmetrical in this sense. Symmetrical tanru are discussed in [Section 5.15](../section-symmetric-tanru).

<a id="id-1.6.16.4.1" class="indexterm"></a>The tertau represents an action, and the seltau then represents the object of that action:

<a id="id-1.6.16.5"></a>

**Table 5.1. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.5.2.1.1.1" class="indexterm"></a>pinsi nunkilca'a</em></span></td><td>pencil sharpener</td><td>Hungarian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.5.3.1.1.1" class="indexterm"></a>zgike nunctu</em></span></td><td>music instruction</td><td>Hungarian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.5.4.1.1.1" class="indexterm"></a>mirli nunkalte</em></span></td><td>deer hunting</td><td>Hungarian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.5.5.1.1.1" class="indexterm"></a>finpe nunkalte</em></span></td><td>fish hunting</td><td>Turkish,Korean,Udmurt,Abazin</td><td>fishing</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.5.6.1.1.1" class="indexterm"></a>smacu terkavbu</em></span></td><td>mousetrap</td><td>Turkish,Korean,Hungarian,Udmurt,Abazin</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.5.7.1.1.1" class="indexterm"></a>zdani turni</em></span></td><td>house ruler</td><td>Karaitic</td><td>host</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.5.8.1.1.1" class="indexterm"></a>zerle'a nunte'a</em></span></td><td>thief fear</td><td>Sanskrit</td><td>fear of thieves</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.5.9.1.1.1" class="indexterm"></a>cevni zekri</em></span></td><td>god crime</td><td>Sanskrit</td><td>offense against the gods</td></tr></tbody></table>

<a id="id-1.6.16.6"></a>

**Table 5.2. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nunkilca'a</em></span></td><td><p>sharpness-apparatus</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.6.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-nunctu"><em class="glossterm">nunctu</em></a></em></span></td><td><p>event-of-teaching</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nunkalte</em></span></td><td><p>event-of-hunting</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.6.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-terkavbu"><em class="glossterm">terkavbu</em></a></em></span></td><td><p>trap</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.6.7.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-zerleha"><em class="glossterm">zerle'a</em></a></em></span></td><td><p>crime-taker</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">nunte'a</em></span></td><td><p>event-of-fearing</p></td></tr></tbody></table>

<a id="id-1.6.16.7.1" class="indexterm"></a>The tertau represents a set, and the seltau the type of the elements contained in that set:

<a id="id-1.6.16.8"></a>

**Table 5.3. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.8.2.1.1.1" class="indexterm"></a>zdani lijgri</em></span></td><td>house row</td><td></td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.8.3.1.1.1" class="indexterm"></a>selci lamgri</em></span></td><td>cell block</td><td></td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.8.4.1.1.1" class="indexterm"></a>karda mulgri</em></span></td><td>card pack</td><td>Swedish</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.8.5.1.1.1" class="indexterm"></a>rokci derxi</em></span></td><td>stone heap</td><td>Swedish</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.8.6.1.1.1" class="indexterm"></a>tadni girzu</em></span></td><td>student group</td><td>Hungarian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.8.7.1.1.1" class="indexterm"></a>remna girzu</em></span></td><td>human-being group</td><td>Qabardian</td><td>group of people</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.8.8.1.1.1" class="indexterm"></a>cpumi'i lijgri</em></span></td><td>tractor column</td><td>Qabardian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.8.9.1.1.1" class="indexterm"></a>cevni jenmi</em></span></td><td>god army</td><td>Sanskrit</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.8.10.1.1.1" class="indexterm"></a>cevni prenu</em></span></td><td>god folk</td><td>Sanskrit</td><td></td></tr></tbody></table>

<a id="id-1.6.16.9"></a>

**Table 5.4. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.9.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-lijgri"><em class="glossterm">lijgri</em></a></em></span></td><td><p>line-group</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">lamgri</em></span></td><td><p>adjacent-group</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.9.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-mulgri"><em class="glossterm">mulgri</em></a></em></span></td><td><p>complete-group</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.9.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-cpumihi"><em class="glossterm">cpumi'i</em></a></em></span></td><td><p>pull-machine</p></td></tr></tbody></table>

<a id="id-1.6.16.10.1" class="indexterm"></a>Conversely: the tertau is an element, and the seltau represents a set in which that element is contained. Implicitly, the meaning of the tertau is restricted from its usual general meaning to the specific meaning appropriate for elements in the given set. Note the opposition between _<a id="id-1.6.16.10.2.1" class="indexterm"></a>zdani lijgri_ in the previous group, and _<a id="id-1.6.16.10.3.1" class="indexterm"></a>lijgri zdani_ in this one, which shows why this kind of tanru is called “asymmetrical”.

<a id="id-1.6.16.11"></a>

**Table 5.5. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.11.2.1.1.1" class="indexterm"></a>carvi dirgo</em></span></td><td>raindrop</td><td>Turkish,Korean,Hungarian,Udmurt,Abazin</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.11.3.1.1.1" class="indexterm"></a>linji zdani</em></span></td><td>row house</td><td></td><td></td></tr></tbody></table>

<a id="id-1.6.16.12.1" class="indexterm"></a>The seltau specifies an object and the tertau a component or detail of that object; the tanru as a whole refers to the detail, specifying that it is a detail of that whole and not some other.

<a id="id-1.6.16.13"></a>

**Table 5.6. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.13.2.1.1.1" class="indexterm"></a>junla dadysli</em></span></td><td>clock pendulum</td><td>Hungarian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.13.3.1.1.1" class="indexterm"></a>purdi vorme</em></span></td><td>garden door</td><td>Qabardian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.13.4.1.1.1" class="indexterm"></a>purdi bitmu</em></span></td><td>garden wall</td><td>Quechua</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.13.5.1.1.1" class="indexterm"></a>moklu skapi</em></span></td><td>mouth skin</td><td>Imbabura Quechua</td><td>lips</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.13.6.1.1.1" class="indexterm"></a>nazbi kevna</em></span></td><td>nose hole</td><td>Imbabura Quechua</td><td>nostril</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.13.7.1.1.1" class="indexterm"></a>karce xislu</em></span></td><td>automobile wheel</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.13.8.1.1.1" class="indexterm"></a>jipci pimlu</em></span></td><td>chicken feather</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.13.9.1.1.1" class="indexterm"></a>vinji rebla</em></span></td><td>airplane tail</td><td>Chinese</td><td></td></tr></tbody></table>

<a id="id-1.6.16.14"></a>

**Table 5.7. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.14.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-dadysli"><em class="glossterm">dadysli</em></a></em></span></td><td><p>hang-oscillator</p></td></tr></tbody></table>

<a id="id-1.6.16.15.1" class="indexterm"></a>Conversely: the seltau specifies a characteristic or important detail of the object described by the tertau; objects described by the tanru as a whole are differentiated from other similar objects by this detail.

<a id="id-1.6.16.16"></a>

**Table 5.8. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.16.2.1.1.1" class="indexterm"></a>pixra cukta</em></span></td><td>picture book</td><td></td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.16.3.1.1.1" class="indexterm"></a>kerfa silka</em></span></td><td>hair silk</td><td>Karaitic</td><td>velvet</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.16.4.1.1.1" class="indexterm"></a>plise tapla</em></span></td><td>apple cake</td><td>Turkish</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.16.5.1.1.1" class="indexterm"></a>dadysli junla</em></span></td><td>pendulum clock</td><td>Hungarian</td><td></td></tr></tbody></table>

<a id="id-1.6.16.17"></a>

**Table 5.9. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.17.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-dadysli"><em class="glossterm">dadysli</em></a></em></span></td><td><p>hang-oscillator</p></td></tr></tbody></table>

<a id="id-1.6.16.18.1" class="indexterm"></a>The tertau specifies a general class of object (a genus), and the seltau specifies a sub-class of that class (a species):

<a id="id-1.6.16.19"></a>

**Table 5.10. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.19.2.1.1.1" class="indexterm"></a>ckunu tricu</em></span></td><td>pine tree</td><td>Hungarian,Turkish,Hopi</td><td></td></tr></tbody></table>

<a id="id-1.6.16.20.1" class="indexterm"></a>The tertau specifies an object of possession, and the seltau may specify the possessor (the possession may be intrinsic or otherwise). In English, these compounds have an explicit possessive element in them: “lion's mane”, “child's foot”, “noble's cow”.

<a id="id-1.6.16.21"></a>

**Table 5.11. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.21.2.1.1.1" class="indexterm"></a>cinfo kerfa</em></span></td><td>lion mane</td><td>Korean,Turkish,Hungarian,Udmurt,Qabardian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.21.3.1.1.1" class="indexterm"></a>verba jamfu</em></span></td><td>child foot</td><td>Swedish</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.21.4.1.1.1" class="indexterm"></a>nixli tuple</em></span></td><td>girl leg</td><td>Swedish</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.21.5.1.1.1" class="indexterm"></a>cinfo jamfu</em></span></td><td>lion foot</td><td>Quechua</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.21.6.1.1.1" class="indexterm"></a>danlu skapi</em></span></td><td>animal skin</td><td>Ewe</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.21.7.1.1.1" class="indexterm"></a>ralju zdani</em></span></td><td>chief house</td><td>Ewe</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.21.8.1.1.1" class="indexterm"></a>jmive munje</em></span></td><td>living world</td><td>Sanskrit</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.21.9.1.1.1" class="indexterm"></a>nobli bakni</em></span></td><td>noble cow</td><td>Sanskrit</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.21.10.1.1.1" class="indexterm"></a>nolraitru ralju</em></span></td><td>king chief</td><td>Sanskrit</td><td>emperor</td></tr></tbody></table>

<a id="id-1.6.16.22"></a>

**Table 5.12. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.22.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-nolraitru"><em class="glossterm">nolraitru</em></a></em></span></td><td><p>nobly-superlative-ruler</p></td></tr></tbody></table>

<a id="id-1.6.16.23.1" class="indexterm"></a>The tertau specifies a habitat, and the seltau specifies the inhabitant:

<a id="id-1.6.16.24"></a>

**Table 5.13. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.24.2.1.1.1" class="indexterm"></a>lanzu tumla</em></span></td><td>family land</td><td></td><td></td></tr></tbody></table>

<a id="id-1.6.16.25.1" class="indexterm"></a>The tertau specifies a causative agent, and the seltau specifies the effect of that cause:

<a id="id-1.6.16.26"></a>

**Table 5.14. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.26.2.1.1.1" class="indexterm"></a>kalselvi'i gapci</em></span></td><td>tear gas</td><td>Hungarian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.26.3.1.1.1" class="indexterm"></a>terbi'a jurme</em></span></td><td>disease germ</td><td>Turkish</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.26.4.1.1.1" class="indexterm"></a>fenki litki</em></span></td><td>crazy liquid</td><td>Hopi</td><td>whisky</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.26.5.1.1.1" class="indexterm"></a>pinca litki</em></span></td><td>urine liquid</td><td>Hopi</td><td>beer</td></tr></tbody></table>

<a id="id-1.6.16.27"></a>

**Table 5.15. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.27.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-kalselvihi"><em class="glossterm">kalselvi'i</em></a></em></span></td><td><p>eye-excreted-thing</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.27.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-terbiha"><em class="glossterm">terbi'a</em></a></em></span></td><td><p>disease</p></td></tr></tbody></table>

<a id="id-1.6.16.28.1" class="indexterm"></a>Conversely: the tertau specifies an effect, and the seltau specifies its cause.

<a id="id-1.6.16.29"></a>

**Table 5.16. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.29.2.1.1.1" class="indexterm"></a>djacu barna</em></span></td><td>water mark</td><td>Chinese</td><td></td></tr></tbody></table>

<a id="id-1.6.16.30.1" class="indexterm"></a>The tertau specifies an instrument, and the seltau specifies the purpose of that instrument:

<a id="id-1.6.16.31"></a>

**Table 5.17. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.31.2.1.1.1" class="indexterm"></a>taxfu dadgreku</em></span></td><td>garment rack</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.31.3.1.1.1" class="indexterm"></a>tergu'i ti'otci</em></span></td><td>lamp shade</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.31.4.1.1.1" class="indexterm"></a>xirma zdani</em></span></td><td>horse house</td><td>Chinese</td><td>stall</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.31.5.1.1.1" class="indexterm"></a>nuzba tanbo</em></span></td><td>news board</td><td>Chinese</td><td>bulletin board</td></tr></tbody></table>

<a id="id-1.6.16.32"></a>

**Table 5.18. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.32.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-dadgreku"><em class="glossterm">dadgreku</em></a></em></span></td><td><p>hang-frame</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.32.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-terguhi"><em class="glossterm">tergu'i</em></a></em></span></td><td><p>source of illumination</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.32.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-tihotci"><em class="glossterm">ti'otci</em></a></em></span></td><td><p>shadow-tool</p></td></tr></tbody></table>

<a id="id-1.6.16.33.1" class="indexterm"></a>More vaguely: the tertau specifies an instrument, and the seltau specifies the object of the purpose for which that instrument is used:

<a id="id-1.6.16.34"></a>

**Table 5.19. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.34.2.1.1.1" class="indexterm"></a>cpina rokci</em></span></td><td>pepper stone</td><td>Quechua</td><td>stone for grinding pepper</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.34.3.1.1.1" class="indexterm"></a>jamfu djacu</em></span></td><td>foot water</td><td>Sanskrit</td><td>water for washing the feet</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.34.4.1.1.1" class="indexterm"></a>grana mudri</em></span></td><td>post wood</td><td>Sanskrit</td><td>wood for making a post</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.34.5.1.1.1" class="indexterm"></a>moklu djacu</em></span></td><td>mouth water</td><td>Hungarian</td><td>water for washing the mouth</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.34.6.1.1.1" class="indexterm"></a>lanme gerku</em></span></td><td>sheep dog</td><td></td><td>dog for working sheep</td></tr></tbody></table>

<a id="id-1.6.16.35.1" class="indexterm"></a>The tertau specifies a product from some source, and the seltau specifies the source of the product:

<a id="id-1.6.16.36"></a>

**Table 5.20. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.36.2.1.1.1" class="indexterm"></a>moklu djacu</em></span></td><td>mouth water</td><td>Abazin,Qabardian</td><td>saliva</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.36.3.1.1.1" class="indexterm"></a>ractu mapku</em></span></td><td>rabbit hat</td><td>Russian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.36.4.1.1.1" class="indexterm"></a>jipci sovda</em></span></td><td>chicken egg</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.36.5.1.1.1" class="indexterm"></a>sikcurnu silka</em></span></td><td>silkworm silk</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.36.6.1.1.1" class="indexterm"></a>mlatu kalci</em></span></td><td>cat feces</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.36.7.1.1.1" class="indexterm"></a>bifce lakse</em></span></td><td>bee wax</td><td>Chinese</td><td>beeswax</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.36.8.1.1.1" class="indexterm"></a>cribe rectu</em></span></td><td>bear meat</td><td>Turkish,Korean,Hungarian,Udmurt,Abazin</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.36.9.1.1.1" class="indexterm"></a>solxrula grasu</em></span></td><td>sunflower oil</td><td>Turkish,Korean,Hungarian,Udmurt,Abazin</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.36.10.1.1.1" class="indexterm"></a>bifce jisra</em></span></td><td>bee juice</td><td>Hopi</td><td>honey</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.36.11.1.1.1" class="indexterm"></a>tatru litki</em></span></td><td>breast liquid</td><td>Hopi</td><td>milk</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.36.12.1.1.1" class="indexterm"></a>kanla djacu</em></span></td><td>eye water</td><td>Korean</td><td>tear</td></tr></tbody></table>

<a id="id-1.6.16.37"></a>

**Table 5.21. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">sikcurnu</em></span></td><td><p>silk-worm</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.37.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-solxrula"><em class="glossterm">solxrula</em></a></em></span></td><td><p>solar-flower</p></td></tr></tbody></table>

<a id="id-1.6.16.38.1" class="indexterm"></a>Conversely: the tertau specifies the source of a product, and the seltau specifies the product:

<a id="id-1.6.16.39"></a>

**Table 5.22. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.39.2.1.1.1" class="indexterm"></a>silna jinto</em></span></td><td>salt well</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.39.3.1.1.1" class="indexterm"></a>kolme terkakpa</em></span></td><td>coal mine</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.39.4.1.1.1" class="indexterm"></a>ctile jinto</em></span></td><td>oil well</td><td>Chinese</td><td></td></tr></tbody></table>

<a id="id-1.6.16.40"></a>

**Table 5.23. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">terkakpa</em></span></td><td><p>source of digging</p></td></tr></tbody></table>

<a id="id-1.6.16.41.1" class="indexterm"></a>The tertau specifies an object, and the seltau specifies the material from which the object is made. This case is especially interesting, because the referent of the tertau may normally be made from just one kind of material, which is then overridden in the tanru.

<a id="id-1.6.16.42"></a>

**Table 5.24. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.2.1.1.1" class="indexterm"></a>rokci cinfo</em></span></td><td>stone lion</td><td></td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.3.1.1.1" class="indexterm"></a>snime nanmu</em></span></td><td>snow man</td><td>Hungarian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.4.1.1.1" class="indexterm"></a>kliti cipni</em></span></td><td>clay bird</td><td></td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.5.1.1.1" class="indexterm"></a>blaci kanla</em></span></td><td>glass eye</td><td>Hungarian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.6.1.1.1" class="indexterm"></a>blaci kanla</em></span></td><td>glass eye</td><td>Quechua</td><td>spectacles</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.7.1.1.1" class="indexterm"></a>solji sicni</em></span></td><td>gold coin</td><td>Turkish</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.8.1.1.1" class="indexterm"></a>solji junla</em></span></td><td>gold watch</td><td>Turkish,Korean,Hungarian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.9.1.1.1" class="indexterm"></a>solji djine</em></span></td><td>gold ring</td><td>Udmurt,Abazin,Quechua</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.10.1.1.1" class="indexterm"></a>rokci zdani</em></span></td><td>stone house</td><td>Imbabura Quechua</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.11.1.1.1" class="indexterm"></a>mudri zdani</em></span></td><td>wood house</td><td>Ewe</td><td>wooden house</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.12.1.1.1" class="indexterm"></a>rokci bitmu</em></span></td><td>stone wall</td><td>Ewe</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.13.1.1.1" class="indexterm"></a>solji carce</em></span></td><td>gold chariot</td><td>Sanskrit</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.14.1.1.1" class="indexterm"></a>mudri xarci</em></span></td><td>wood weapon</td><td>Sanskrit</td><td>wooden weapon</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.15.1.1.1" class="indexterm"></a>cmaro'i dargu</em></span></td><td>pebble road</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.42.16.1.1.1" class="indexterm"></a>sudysrasu cutci</em></span></td><td>straw shoe</td><td>Chinese</td><td></td></tr></tbody></table>

<a id="id-1.6.16.43"></a>

**Table 5.25. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.43.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-cmarohi"><em class="glossterm">cmaro'i</em></a></em></span></td><td><p>small-rock</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.43.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-sudysrasu"><em class="glossterm">sudysrasu</em></a></em></span></td><td><p>dry-grass</p></td></tr></tbody></table>

Note: the two senses of _<a id="id-1.6.16.44.1.1" class="indexterm"></a>blaci kanla_ can be discriminated as:

<a id="id-1.6.16.45"></a>

**Table 5.26. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.45.2.1.1.1" class="indexterm"></a>blaci kanla bo tarmi</em></span></td><td>glass (eye shape)</td><td>glass eye</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.45.3.1.1.1" class="indexterm"></a>blaci kanla bo sidju</em></span></td><td>glass (eye helper)</td><td>spectacles</td><td></td></tr></tbody></table>

<a id="id-1.6.16.46.1" class="indexterm"></a>The tertau specifies a typical object used to measure a quantity and the seltau specifies something measured. The tanru as a whole refers to a given quantity of the thing being measured. English does not have compounds of this form, as a rule.

<a id="id-1.6.16.47"></a>

**Table 5.27. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.47.2.1.1.1" class="indexterm"></a>tumla spisa</em></span></td><td>land piece</td><td>Turkish</td><td>piece of land</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.47.3.1.1.1" class="indexterm"></a>tcati kabri</em></span></td><td>tea cup</td><td>Korean,Abazin</td><td>cup of tea</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.47.4.1.1.1" class="indexterm"></a>nanba spisa</em></span></td><td>bread piece</td><td>Korean</td><td>piece of bread</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.47.5.1.1.1" class="indexterm"></a>bukpu spisa</em></span></td><td>cloth piece</td><td>Udmurt,Abazin</td><td>piece of cloth</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.47.6.1.1.1" class="indexterm"></a>djacu calkyguzme</em></span></td><td>water calabash</td><td>Ewe</td><td>calabash of water</td></tr></tbody></table>

<a id="id-1.6.16.48"></a>

**Table 5.28. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">calkyguzme</em></span></td><td><p>shell-fruit, calabash</p></td></tr></tbody></table>

<a id="id-1.6.16.49.1" class="indexterm"></a>The tertau specifies an object with certain implicit properties, and the seltau overrides one of those implicit properties:

<a id="id-1.6.16.50"></a>

**Table 5.29. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.50.2.1.1.1" class="indexterm"></a>kensa bloti</em></span></td><td>spaceship</td><td></td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.50.3.1.1.1" class="indexterm"></a>bakni verba</em></span></td><td>cattle child</td><td>Ewe</td><td>calf</td></tr></tbody></table>

<a id="id-1.6.16.51.1" class="indexterm"></a>The seltau specifies a whole, and the tertau specifies a part which normally is associated with a different whole. The tanru then refers to a part of the seltau which stands in the same relationship to the whole seltau as the tertau stands to its typical whole.

<a id="id-1.6.16.52"></a>

**Table 5.30. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.52.2.1.1.1" class="indexterm"></a>kosta degji</em></span></td><td>coat finger</td><td>Hungarian</td><td>coat sleeve</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.52.3.1.1.1" class="indexterm"></a>denci genja</em></span></td><td>tooth root</td><td>Imbabura Quechua</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.52.4.1.1.1" class="indexterm"></a>tricu stedu</em></span></td><td>tree head</td><td>Imbabura Quechua</td><td>treetop</td></tr></tbody></table>

<a id="id-1.6.16.53.1" class="indexterm"></a>The tertau specifies the producer of a certain product, and the seltau specifies the product. In this way, the tanru as a whole distinguishes its referents from other referents of the tertau which do not produce the product.

<a id="id-1.6.16.54"></a>

**Table 5.31. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.54.2.1.1.1" class="indexterm"></a>silka curnu</em></span></td><td>silkworm</td><td>Turkish,Hungarian,Abazin</td><td></td></tr></tbody></table>

<a id="id-1.6.16.55.1" class="indexterm"></a>The tertau specifies an object, and the seltau specifies another object which has a characteristic property. The tanru as a whole refers to those referents of the tertau which possess the property.

<a id="id-1.6.16.56"></a>

**Table 5.32. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.56.2.1.1.1" class="indexterm"></a>sonci manti</em></span></td><td>soldier ant</td><td></td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.56.3.1.1.1" class="indexterm"></a>ninmu bakni</em></span></td><td>woman cattle</td><td>Imbabura Quechua</td><td>cow</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.56.4.1.1.1" class="indexterm"></a>mamta degji</em></span></td><td>mother finger</td><td>Imbabura Quechua</td><td>thumb</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.56.5.1.1.1" class="indexterm"></a>cifnu degji</em></span></td><td>baby finger</td><td>Imbabura Quechua</td><td>pinky</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.56.6.1.1.1" class="indexterm"></a>pacraistu zdani</em></span></td><td>hell house</td><td>Sanskrit</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.56.7.1.1.1" class="indexterm"></a>fagri dapma</em></span></td><td>fire curse</td><td>Sanskrit</td><td>curse destructive as fire</td></tr></tbody></table>

<a id="id-1.6.16.57"></a>

**Table 5.33. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">pacraistu</em></span></td><td><p>evil-superlative-site</p></td></tr></tbody></table>

<a id="id-1.6.16.58.1" class="indexterm"></a>As a particular case (when the property is that of resemblance): the seltau specifies an object which the referent of the tanru resembles.

<a id="id-1.6.16.59"></a>

**Table 5.34. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.59.2.1.1.1" class="indexterm"></a>grutrceraso jbama</em></span></td><td>cherry bomb</td><td></td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.59.3.1.1.1" class="indexterm"></a>solji kerfa</em></span></td><td>gold hair</td><td>Hungarian</td><td>golden hair</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.59.4.1.1.1" class="indexterm"></a>kanla djacu</em></span></td><td>eye water</td><td>Karaitic</td><td>spring</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.59.5.1.1.1" class="indexterm"></a>bakni rokci</em></span></td><td>bull stone</td><td>Mongolian</td><td>boulder</td></tr></tbody></table>

<a id="id-1.6.16.60"></a>

**Table 5.35. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">grutrceraso</em></span></td><td><p>fu'ivla for <span class="quote">“<span class="quote">cherry</span>”</span> based on Linnean name</p></td></tr></tbody></table>

<a id="id-1.6.16.61.1" class="indexterm"></a>The seltau specifies a place, and the tertau an object characteristically located in or at that place.

<a id="id-1.6.16.62"></a>

**Table 5.36. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.62.2.1.1.1" class="indexterm"></a>ckana boxfo</em></span></td><td>bed sheet</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.62.3.1.1.1" class="indexterm"></a>mrostu mojysu'a</em></span></td><td>tomb monument</td><td>Chinese</td><td>tombstone</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.62.4.1.1.1" class="indexterm"></a>jubme tergusni</em></span></td><td>table lamp</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.62.5.1.1.1" class="indexterm"></a>foldi smacu</em></span></td><td>field mouse</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.62.6.1.1.1" class="indexterm"></a>briju ci'ajbu</em></span></td><td>office desk</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.62.7.1.1.1" class="indexterm"></a>rirxe xirma</em></span></td><td>river horse</td><td>Chinese</td><td>hippopotamus</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.62.8.1.1.1" class="indexterm"></a>xamsi gerku</em></span></td><td>sea dog</td><td>Chinese</td><td>seal</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.62.9.1.1.1" class="indexterm"></a>cagyce'u zdani</em></span></td><td>village house</td><td>Sanskrit</td><td></td></tr></tbody></table>

<a id="id-1.6.16.63"></a>

**Table 5.37. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.63.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-mrostu"><em class="glossterm">mrostu</em></a></em></span></td><td><p>dead-site</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.63.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-mojysuha"><em class="glossterm">mojysu'a</em></a></em></span></td><td><p>remember-structure</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.63.5.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-cihajbu"><em class="glossterm">ci'ajbu</em></a></em></span></td><td><p>write-table</p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.63.6.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-cagycehu"><em class="glossterm">cagyce'u</em></a></em></span></td><td><p>farm-community</p></td></tr></tbody></table>

<a id="id-1.6.16.64.1" class="indexterm"></a>Specifically: the tertau is a place where the seltau is sold or made available to the public.

<a id="id-1.6.16.65"></a>

**Table 5.38. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.65.2.1.1.1" class="indexterm"></a>cidja barja</em></span></td><td>food bar</td><td>Chinese</td><td>restaurant</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.65.3.1.1.1" class="indexterm"></a>cukta barja</em></span></td><td>book bar</td><td>Chinese</td><td>library</td></tr></tbody></table>

<a id="id-1.6.16.66.1" class="indexterm"></a>The seltau specifies the locus of application of the tertau.

<a id="id-1.6.16.67"></a>

**Table 5.39. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.67.2.1.1.1" class="indexterm"></a>kanla velmikce</em></span></td><td>eye medicine</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.67.3.1.1.1" class="indexterm"></a>jgalu grasu</em></span></td><td>nail oil</td><td>Chinese</td><td>nail polish</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.67.4.1.1.1" class="indexterm"></a>denci pesxu</em></span></td><td>tooth paste</td><td>Chinese</td><td></td></tr></tbody></table>

<a id="id-1.6.16.68"></a>

**Table 5.40. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">velmikce</em></span></td><td><p>treatment used by doctor</p></td></tr></tbody></table>

<a id="id-1.6.16.69.1" class="indexterm"></a>The tertau specifies an implement used in the activity denoted by the seltau.

<a id="id-1.6.16.70"></a>

**Table 5.41. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.70.2.1.1.1" class="indexterm"></a>me la .pinpan. bolci</em></span></td><td>Ping-Pong ball</td><td>Chinese</td><td></td></tr></tbody></table>

<a id="id-1.6.16.71.1" class="indexterm"></a>The tertau specifies a protective device against the undesirable features of the referent of the seltau.

<a id="id-1.6.16.72"></a>

**Table 5.42. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.72.2.1.1.1" class="indexterm"></a>carvi mapku</em></span></td><td>rain cap</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.72.3.1.1.1" class="indexterm"></a>carvi taxfu</em></span></td><td>rain garment</td><td>Chinese</td><td>raincoat</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.72.4.1.1.1" class="indexterm"></a>vindu firgai</em></span></td><td>poison mask</td><td>Chinese</td><td>gas mask</td></tr></tbody></table>

<a id="id-1.6.16.73"></a>

**Table 5.43. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.73.3.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-firgai"><em class="glossterm">firgai</em></a></em></span></td><td><p>face-cover</p></td></tr></tbody></table>

<a id="id-1.6.16.74.1" class="indexterm"></a>The tertau specifies a container characteristically used to hold the referent of the seltau.

<a id="id-1.6.16.75"></a>

**Table 5.44. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.75.2.1.1.1" class="indexterm"></a>cukta vasru</em></span></td><td>book vessel</td><td>Chinese</td><td>satchel</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.75.3.1.1.1" class="indexterm"></a>vanju kabri</em></span></td><td>wine cup</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.75.4.1.1.1" class="indexterm"></a>spatrkoka lanka</em></span></td><td>coca basket</td><td>Quechua</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.75.5.1.1.1" class="indexterm"></a>rismi dakli</em></span></td><td>rice bag</td><td>Ewe,Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.75.6.1.1.1" class="indexterm"></a>tcati kabri</em></span></td><td>tea cup</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.75.7.1.1.1" class="indexterm"></a>ladru botpi</em></span></td><td>milk bottle</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.75.8.1.1.1" class="indexterm"></a>rismi patxu</em></span></td><td>rice pot</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.75.9.1.1.1" class="indexterm"></a>festi lante</em></span></td><td>trash can</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.75.10.1.1.1" class="indexterm"></a>bifce zdani</em></span></td><td>bee house</td><td>Korean</td><td>beehive</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.75.11.1.1.1" class="indexterm"></a>cladakyxa'i zdani</em></span></td><td>sword house</td><td>Korean</td><td>sheath</td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.75.12.1.1.1" class="indexterm"></a>manti zdani</em></span></td><td>ant nest</td><td>Guarani</td><td>anthill</td></tr></tbody></table>

<a id="id-1.6.16.76"></a>

**Table 5.45. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">spatrkoka</em></span></td><td><p>fu'ivla for <span class="quote">“<span class="quote">coca</span>”</span></p></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.76.4.1.1.1" class="indexterm"></a><a class="glossterm" href="go01.html#valsi-cladakyxahi"><em class="glossterm">cladakyxa'i</em></a></em></span></td><td><p>(long-knife)-weapon</p></td></tr></tbody></table>

<a id="id-1.6.16.77.1" class="indexterm"></a>The seltau specifies the characteristic time of the event specified by the tertau.

<a id="id-1.6.16.78"></a>

**Table 5.46. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.78.2.1.1.1" class="indexterm"></a>vensa djedi</em></span></td><td>spring day</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.78.3.1.1.1" class="indexterm"></a>crisa citsi</em></span></td><td>summer season</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.78.4.1.1.1" class="indexterm"></a>cerni bumru</em></span></td><td>morning fog</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.78.5.1.1.1" class="indexterm"></a>critu lunra</em></span></td><td>autumn moon</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.78.6.1.1.1" class="indexterm"></a>dunra nicte</em></span></td><td>winter night</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.78.7.1.1.1" class="indexterm"></a>nicte ckule</em></span></td><td>night school</td><td>Chinese</td><td></td></tr></tbody></table>

<a id="id-1.6.16.79.1" class="indexterm"></a>The seltau specifies a source of energy for the referent of the tertau.

<a id="id-1.6.16.80"></a>

**Table 5.47. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.80.2.1.1.1" class="indexterm"></a>dikca tergusni</em></span></td><td>electric lamp</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.80.3.1.1.1" class="indexterm"></a>ratni nejni</em></span></td><td>atom energy</td><td>Chinese</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.80.4.1.1.1" class="indexterm"></a>brife molki</em></span></td><td>windmill</td><td>Turkish,Korean,Hungarian,Udmurt,Abazin</td><td></td></tr></tbody></table>

<a id="id-1.6.16.81"></a>

**Table 5.48. Mini-Glossary**

<table><colgroup></colgroup><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo">tergusni</em></span></td><td><p>illumination-source</p></td></tr></tbody></table>

<a id="id-1.6.16.82.1" class="indexterm"></a>Finally, some tanru which don't fall into any of the above categories.

<a id="id-1.6.16.83"></a>

**Table 5.49. Example tanru**

<table><tbody><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.83.2.1.1.1" class="indexterm"></a>ladru denci</em></span></td><td>milk tooth</td><td>Turkish,Hungarian,Udmurt,Qabardian</td><td></td></tr><tr><td><span xml:lang="jbo" class="foreignphrase" lang="jbo"><em xml:lang="jbo" class="foreignphrase" lang="jbo"><a id="id-1.6.16.83.3.1.1.1" class="indexterm"></a>kanla denci</em></span></td><td>eye tooth</td><td></td><td></td></tr></tbody></table>

It is clear that “tooth” is being specified, and that “milk” and “eye” act as modifiers. However, the relationship between _<a id="id-1.6.16.84.4.1" class="indexterm"></a>[_ladru_](../go01#valsi-ladru)_ and _<a id="id-1.6.16.84.5.1" class="indexterm"></a>[_denci_](../go01#valsi-denci)_ is something like “tooth which one has when one is drinking milk from one's mother”, a relationship certainly present nowhere except in this particular concept. As for _<a id="id-1.6.16.84.7.1" class="indexterm"></a>kanla denci_, the relationship is not only not present on the surface, it is hardly possible to formulate it at all.